<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Examples:
|	$route['products/shoes'] = 'catalog/product_lookup';
|	$route['products/(:any)'] = 'catalog/product_lookup/$1';
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
*/

/*
| -------------------------------------------------------------------------
| DEFAULT ROUTES
| -------------------------------------------------------------------------
*/
$route['default_controller'] = 'home';
$route['404_override'] = 'errors/error_404';
$route['translate_uri_dashes'] = TRUE;

/*
| -------------------------------------------------------------------------
| FRONTEND ROUTES
| -------------------------------------------------------------------------
*/

// Home
$route['home'] = 'home/index';

// About
$route['about'] = 'pages/about';
$route['about-us'] = 'pages/about';

// Workshop Programmes
$route['workshops'] = 'workshops/index';
$route['workshop-programmes'] = 'workshops/index';
$route['our-workshops'] = 'workshops/index';
$route['workshops/(:any)'] = 'workshops/view/$1';

// Register/Consultation
$route['register'] = 'consultation/index';
$route['consultation'] = 'consultation/index';
$route['register-with-us'] = 'consultation/index';
$route['consultation/submit'] = 'consultation/submit';

// Volunteers
$route['volunteers'] = 'volunteers/index';
$route['our-volunteers'] = 'volunteers/index';
$route['volunteer-with-us'] = 'volunteers/apply';
$route['volunteer/apply'] = 'volunteers/apply';
$route['volunteer/submit'] = 'volunteers/submit';

// Partners
$route['partners'] = 'partners/index';
$route['our-partners'] = 'partners/index';

// Blog
$route['blog'] = 'blog/index';
$route['blog/page/(:num)'] = 'blog/index/$1';
$route['blog/category/(:any)'] = 'blog/category/$1';
$route['blog/category/(:any)/page/(:num)'] = 'blog/category/$1/$2';
$route['blog/(:any)'] = 'blog/view/$1';

// Contact
$route['contact'] = 'contact/index';
$route['contact-us'] = 'contact/index';
$route['contact/submit'] = 'contact/submit';

// Donate
$route['donate'] = 'pages/donate';
$route['support'] = 'pages/donate';
$route['support-us'] = 'pages/donate';

// Privacy & Terms
$route['privacy'] = 'pages/privacy';
$route['privacy-policy'] = 'pages/privacy';
$route['terms'] = 'pages/terms';
$route['terms-and-conditions'] = 'pages/terms';
$route['terms-conditions'] = 'pages/terms';

/*
| -------------------------------------------------------------------------
| ADMIN ROUTES
| -------------------------------------------------------------------------
*/

// Admin Login/Logout
$route['admin'] = 'admin/auth/login';
$route['admin/login'] = 'admin/auth/login';
$route['admin/logout'] = 'admin/auth/logout';
$route['admin/forgot-password'] = 'admin/auth/forgot_password';

// Admin Dashboard
$route['admin/dashboard'] = 'admin/dashboard/index';

// Admin Blog Management
// Admin Blog Management - SPECIFIC ROUTES FIRST (More specific routes must come before generic ones)
$route['admin/blog'] = 'admin/blog/index';
$route['admin/blog/page/(:num)'] = 'admin/blog/index/$1';

$route['admin/blog/categories'] = 'admin/blog/categories';
$route['admin/blog/add'] = 'admin/blog/add';
$route['admin/blog/edit/(:num)'] = 'admin/blog/edit/$1';

$route['admin/blog/archive/(:num)'] = 'admin/blog/archive/$1';
$route['admin/blog/unarchive/(:num)'] = 'admin/blog/unarchive/$1';
$route['admin/blog/delete/(:num)'] = 'admin/blog/delete/$1';


// Admin Volunteers Management
$route['admin/volunteers'] = 'admin/volunteers/index';
$route['admin/volunteers/view/(:num)'] = 'admin/volunteers/view/$1';
$route['admin/volunteers/approve/(:num)'] = 'admin/volunteers/approve/$1';
$route['admin/volunteers/reject/(:num)'] = 'admin/volunteers/reject/$1';
$route['admin/volunteers/delete/(:num)'] = 'admin/volunteers/delete/$1';

// Admin Consultation Management
$route['admin/consultations'] = 'admin/consultations/index';
$route['admin/consultations/view/(:num)'] = 'admin/consultations/view/$1';
$route['admin/consultations/update/(:num)'] = 'admin/consultations/update/$1';
$route['admin/consultations/delete/(:num)'] = 'admin/consultations/delete/$1';

// Admin Contact Messages
$route['admin/messages'] = 'admin/messages/index';
$route['admin/messages/view/(:num)'] = 'admin/messages/view/$1';
$route['admin/messages/reply/(:num)'] = 'admin/messages/reply/$1';
$route['admin/messages/delete/(:num)'] = 'admin/messages/delete/$1';

// Admin Workshops Management
$route['admin/workshops'] = 'admin/workshops/index';
$route['admin/workshops/add'] = 'admin/workshops/add';
$route['admin/workshops/edit/(:num)'] = 'admin/workshops/edit/$1';
$route['admin/workshops/delete/(:num)'] = 'admin/workshops/delete/$1';

// Admin Partners Management
$route['admin/partners'] = 'admin/partners/index';
$route['admin/partners/add'] = 'admin/partners/add';
$route['admin/partners/edit/(:num)'] = 'admin/partners/edit/$1';
$route['admin/partners/delete/(:num)'] = 'admin/partners/delete/$1';

// Admin Carousel Management
$route['admin/carousel'] = 'admin/carousel/index';
$route['admin/carousel/add'] = 'admin/carousel/add';
$route['admin/carousel/edit/(:num)'] = 'admin/carousel/edit/$1';
$route['admin/carousel/delete/(:num)'] = 'admin/carousel/delete/$1';

// Admin Settings
$route['admin/settings'] = 'admin/settings/index';
$route['admin/settings/update'] = 'admin/settings/update';

// Admin Profile
$route['admin/profile'] = 'admin/profile/index';
$route['admin/profile/update'] = 'admin/profile/update';
$route['admin/profile/change-password'] = 'admin/profile/change_password';

// Admin Data Export
$route['admin/export/volunteers'] = 'admin/export/volunteers';
$route['admin/export/consultations'] = 'admin/export/consultations';
$route['admin/export/messages'] = 'admin/export/messages';


// Frontend Adult French Registration Routes
$route['french-registration/adult'] = 'Adult_registration';
$route['french-registration/adult/submit'] = 'Adult_registration/submit';

// Frontend Kid French Registration Routes
$route['french-registration/kid'] = 'Kid_registration';
$route['french-registration/kid/submit'] = 'Kid_registration/submit';

// Admin French Registration Routes - Adult
$route['admin/french-registrations/adults'] = 'admin/French_registrations/adult_registrations';
$route['admin/french-registrations/view-adult/(:num)'] = 'admin/French_registrations/view_adult_registration/$1';
$route['admin/french-registrations/update-adult-status'] = 'admin/French_registrations/update_adult_registration_status';
$route['admin/french-registrations/export-adults'] = 'admin/French_registrations/export_adult_registrations';

// Admin French Registration Routes - Kids
$route['admin/french-registrations/kids'] = 'admin/French_registrations/kid_registrations';
$route['admin/french-registrations/view-kid/(:num)'] = 'admin/French_registrations/view_kid_registration/$1';
$route['admin/french-registrations/update-kid-status'] = 'admin/French_registrations/update_kid_registration_status';
$route['admin/french-registrations/export-kids'] = 'admin/French_registrations/export_kid_registrations';

$route['admin/french_registrations/update_adult_registration_status'] = 'admin/French_registrations/update_adult_registration_status';
$route['admin/french_registrations/adult_registrations'] = 'admin/French_registrations/adult_registrations';

$route['admin/french_registrations/update_kid_registration_status'] = 'admin/French_registrations/update_kid_registration_status';
$route['admin/french_registrations/kid_registrations'] = 'admin/French_registrations/kid_registrations';


// Frontend Media Routes
$route['media'] = 'media/index';
$route['media/view/(:num)'] = 'media/view/$1';

// Admin Media Management Routes
$route['admin/media_management'] = 'admin/Media_management/index';
$route['admin/media_management/upload'] = 'admin/Media_management/upload';
$route['admin/media_management/do_upload'] = 'admin/Media_management/do_upload';
$route['admin/media_management/edit/(:num)'] = 'admin/Media_management/edit/$1';
$route['admin/media_management/update'] = 'admin/Media_management/update';
$route['admin/media_management/delete/(:num)'] = 'admin/Media_management/delete/$1';

// Media Category Management Routes (Optional)
$route['admin/media_categories'] = 'admin/Media_categories/index';
$route['admin/media_categories/create'] = 'admin/Media_categories/create';
$route['admin/media_categories/edit/(:num)'] = 'admin/Media_categories/edit/$1';
$route['admin/media_categories/delete/(:num)'] = 'admin/Media_categories/delete/$1';

// Additional Flexible Routes
$route['media/category/(:any)'] = 'media/category/$1';
$route['media/type/(:any)'] = 'media/type/$1';

