<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// Manually load Frontend_Controller if not autoloaded
if (!class_exists('Frontend_Controller')) {
    require_once APPPATH . 'core/Frontend_Controller.php';
}

/**
 * Contact Controller
 * Handles contact form and submission
 * Location: application/controllers/Contact.php
 */

class Contact extends Frontend_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Contact_model');
    }

    /**
     * Contact page with form
     */
    public function index() {
        // Set meta tags
        $this->set_meta(
            'Contact Us',
            'Get in touch with us. We would love to hear from you and answer any questions you may have.',
            'contact, contact us, get in touch, reach us'
        );

        // Set page heading
        $this->set_heading('Contact Us', 'We\'d Love to Hear From You');

        // Breadcrumbs
        $this->add_breadcrumb('Home', base_url());
        $this->add_breadcrumb('Contact Us', null);

        // Render view
        $this->render('contact/index');
    }

    /**
     * Submit contact form
     */
    public function submit() {
        // Check if form is submitted via POST
        if ($this->input->method() !== 'post') {
            redirect('contact');
        }

        // Check for spam
        if ($this->is_spam_submission()) {
            set_flash_message('error', 'Your submission was flagged as spam. Please try again.');
            redirect('contact');
        }

        // Validate form
        $rules = $this->contact_form_rules();
        
        if (!$this->validate_form($rules)) {
            // Validation failed
            $this->index();
            return;
        }

        // Prepare data
        $data = array(
            'name' => $this->input->post('name', TRUE),
            'email' => $this->input->post('email', TRUE),
            'phone' => $this->input->post('phone', TRUE),
            'subject' => $this->input->post('subject', TRUE),
            'message' => $this->input->post('message', TRUE)
        );

        // Save to database
        if ($this->Contact_model->create_message($data)) {
            $message_id = $this->Contact_model->get_last_insert_id();
            
            // Get message data
            $contact_message = $this->Contact_model->get_message($message_id);
            
            // Send confirmation email to user
            send_contact_confirmation($contact_message);
            
            // Send notification email to admin
            $site_name = $this->data['site_settings']['site_name'];
            $admin_email = $this->data['site_settings']['site_email'];
            
            $subject = "New Contact Message - $site_name";
            $message_body = "
            <h3>New Contact Message</h3>
            <p><strong>Name:</strong> {$data['name']}</p>
            <p><strong>Email:</strong> {$data['email']}</p>
            <p><strong>Phone:</strong> {$data['phone']}</p>
            <p><strong>Subject:</strong> {$data['subject']}</p>
            <p><strong>Message:</strong><br>" . nl2br($data['message']) . "</p>
            <p><a href='" . base_url('admin/messages/view/' . $message_id) . "'>View in Admin Panel</a></p>
            ";
            send_email($admin_email, $subject, $message_body);
            
            // Set success message
            set_flash_message('success', 'Thank you for contacting us! We will get back to you within 24-48 hours.');
            redirect('contact');
        } else {
            set_flash_message('error', 'An error occurred while sending your message. Please try again.');
            redirect('contact');
        }
    }

}