<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// Manually load Frontend_Controller if not autoloaded
if (!class_exists('Frontend_Controller')) {
    require_once APPPATH . 'core/Frontend_Controller.php';
}

/**
 * Partners Controller
 * Handles partners/sponsors display page
 * Location: application/controllers/Partners.php
 */

class Partners extends Frontend_Controller {

    public function __construct() {
        parent::__construct();
    }

    /**
     * Partners listing page
     */
    public function index() {
        // Get active partners grouped by type
        $all_partners = $this->Common_model->get_partners('active');
        
        $data['partners_by_type'] = array(
            'corporate' => array(),
            'ngo' => array(),
            'government' => array(),
            'academic' => array(),
            'individual' => array()
        );

        foreach ($all_partners as $partner) {
            $data['partners_by_type'][$partner->partnership_type][] = $partner;
        }

        $data['total_partners'] = count($all_partners);

        // Set meta tags
        $this->set_meta(
            'Our Partners',
            'Meet our valued partners and sponsors who support our mission to make a positive impact in the community',
            'partners, sponsors, supporters, collaborators, corporate partners'
        );

        // Set page heading
        $this->set_heading('Our Partners', 'Working Together for a Better Community');

        // Breadcrumbs
        $this->add_breadcrumb('Home', base_url());
        $this->add_breadcrumb('Our Partners', null);

        // Render view
        $this->render('partners/index', $data);
    }
}