<?php
defined('BASEPATH') OR exit('No direct script access allowed');
// Manually load Admin_Controller if not autoloaded
if (!class_exists('Admin_Controller')) {
    require_once APPPATH . 'core/Admin_Controller.php';
}

class French_registrations extends Admin_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->model([
            'Adult_registration_model', 
            'Kid_registration_model'
        ]);
        $this->load->helper('url');
    }

    // Adult Registrations
    public function adult_registrations() {
        // Set page title and metadata
        $this->set_title('Adult French Learner Registrations', 'Manage Adult Registrations');
        
        // Add breadcrumbs
        $this->add_breadcrumb('Dashboard', 'dashboard');
        $this->add_breadcrumb('Adult Registrations', null);

        // Prepare data
        $data = [
            'registrations' => $this->Adult_registration_model->get_all_registrations()
        ];

        // Render view with layout
        $this->render('french_registration/adult_list', $data);
    }

    public function view_adult_registration($id) {
        // Validate ID
        if (!is_numeric($id)) {
            show_error('Invalid registration ID');
        }

        // Fetch registration
        $registration = $this->Adult_registration_model->get_registration($id);
        
        if (empty($registration)) {
            show_404();
        }

        // Set page title and metadata
        $this->set_title('Adult Learner Registration Details', $registration->first_name . ' ' . $registration->surname);
        
        // Add breadcrumbs
        $this->add_breadcrumb('Dashboard', 'dashboard');
        $this->add_breadcrumb('Adult Registrations', 'french_registrations/adult_registrations');
        $this->add_breadcrumb('Registration Details', null);

        // Prepare data
        $data = [
            'registration' => $registration
        ];

        // Render view with layout
        $this->render('french_registration/adult_view', $data);
    }

  public function update_adult_registration_status() {
    // Check if it's a POST request
    if ($this->input->method(TRUE) !== 'POST') {
        show_error('Invalid request method');
    }

    $id = $this->input->post('id');
    $status = $this->input->post('status');
    $result = $this->Adult_registration_model->update_status($id, $status);
    if ($result) {
        $this->session->set_flashdata('success', 'Registration status updated successfully');
    } else {
        $this->session->set_flashdata('error', 'Failed to update registration status');
    }
    redirect('admin/french_registrations/adult_registrations');
}

    // Kid Registrations
    public function kid_registrations() {
        // Set page title and metadata
        $this->set_title('Kid French Learner Registrations', 'Manage Kid Registrations');
        
        // Add breadcrumbs
        $this->add_breadcrumb('Dashboard', 'dashboard');
        $this->add_breadcrumb('Kid Registrations', null);

        // Prepare data
        $data = [
            'registrations' => $this->Kid_registration_model->get_all_registrations()
        ];

        // Render view with layout
        $this->render('french_registration/kid_list', $data);
    }

    public function view_kid_registration($id) {
        // Validate ID
        if (!is_numeric($id)) {
            show_error('Invalid registration ID');
        }

        // Fetch registration
        $registration = $this->Kid_registration_model->get_registration($id);
        
        if (empty($registration)) {
            show_404();
        }

        // Set page title and metadata
        $this->set_title('Kid Learner Registration Details', $registration->first_name . ' ' . $registration->surname);
        
        // Add breadcrumbs
        $this->add_breadcrumb('Dashboard', 'dashboard');
        $this->add_breadcrumb('Kid Registrations', 'french_registrations/kid_registrations');
        $this->add_breadcrumb('Registration Details', null);

        // Prepare data
        $data = [
            'registration' => $registration
        ];

        // Render view with layout
        $this->render('french_registration/kid_view', $data);
    }

		public function update_kid_registration_status() {
			// Check if it's a POST request
			if ($this->input->method(TRUE) !== 'POST') {
				show_error('Invalid request method');
			}

			$id = $this->input->post('id');
			$status = $this->input->post('status');
			$result = $this->Kid_registration_model->update_status($id, $status);
			if ($result) {
				$this->session->set_flashdata('success', 'Registration status updated successfully');
			} else {
				$this->session->set_flashdata('error', 'Failed to update registration status');
			}
			redirect('admin/french_registrations/kid_registrations');
		}

    // Optional: Export functionality
    public function export_adult_registrations() {
        $this->load->helper('csv');
        $registrations = $this->Adult_registration_model->get_all_registrations();
        array_to_csv($registrations, 'adult_french_registrations.csv');
    }

    public function export_kid_registrations() {
        $this->load->helper('csv');
        $registrations = $this->Kid_registration_model->get_all_registrations();
        array_to_csv($registrations, 'kid_french_registrations.csv');
    }
}