<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?> - Admin</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --primary-color: #f26124;
            --secondary-color: #231f20;
        }
        
        body {
            background: linear-gradient(135deg, var(--secondary-color) 0%, var(--secondary-color) 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .login-container {
            width: 100%;
            max-width: 450px;
            padding: 20px;
        }
        
        .login-card {
            background: #fff;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            overflow: hidden;
        }
        
        .login-header {
            background: var(--primary-color);
            color: #fff;
            padding: 40px 30px;
            text-align: center;
        }
        
        .login-header h1 {
            font-size: 28px;
            margin: 0 0 5px;
            font-weight: bold;
        }
        
        .login-header p {
            margin: 0;
            opacity: 0.9;
        }
        
        .login-body {
            padding: 40px 30px;
        }
        
        .form-floating {
            margin-bottom: 20px;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(242, 97, 36, 0.25);
        }
        
        .btn-login {
            width: 100%;
            padding: 12px;
            background: var(--primary-color);
            border: none;
            color: #fff;
            font-weight: bold;
            border-radius: 8px;
            transition: all 0.3s;
        }
        
        .btn-login:hover {
            background: #d95520;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(242, 97, 36, 0.3);
        }
        
        .login-footer {
            text-align: center;
            margin-top: 20px;
        }
        
        .login-footer a {
            color: var(--primary-color);
            text-decoration: none;
        }
        
        .login-footer a:hover {
            text-decoration: underline;
        }
        
        .alert {
            border-radius: 8px;
            margin-bottom: 20px;
        }
        
        .input-group-text {
            background: transparent;
            border-right: 0;
        }
        
        .form-control {
            border-left: 0;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-card">
            <div class="login-header">
                <a class="navbar-brand" href="<?php echo base_url(); ?>">
			<img src="<?php echo base_url('assets/images/logo2.png'); ?>" alt="Logo" height="40">
		    </a>
                <h1>Admin Login</h1>
               <!--  <p>NGO Platform Administration</p> -->
            </div>
            
            <div class="login-body">
                <!-- Flash Messages -->
                <?php if($this->session->flashdata('message')): ?>
                    <div class="alert alert-<?php echo $this->session->flashdata('message_type'); ?> alert-dismissible fade show" role="alert">
                        <?php echo $this->session->flashdata('message'); ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <!-- Login Form -->
                <?php echo form_open('admin/login', array('id' => 'loginForm')); ?>
                    
                    <div class="form-floating mb-3">
                        <input type="text" 
                               class="form-control <?php echo form_error('username') ? 'is-invalid' : ''; ?>" 
                               id="username" 
                               name="username" 
                               placeholder="Username or Email"
                               value="<?php echo set_value('username'); ?>"
                               required
                               autofocus>
                        <label for="username"><i class="fas fa-user"></i> Username or Email</label>
                        <?php if(form_error('username')): ?>
                            <div class="invalid-feedback"><?php echo form_error('username'); ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="form-floating mb-3">
                        <input type="password" 
                               class="form-control <?php echo form_error('password') ? 'is-invalid' : ''; ?>" 
                               id="password" 
                               name="password" 
                               placeholder="Password"
                               required>
                        <label for="password"><i class="fas fa-lock"></i> Password</label>
                        <?php if(form_error('password')): ?>
                            <div class="invalid-feedback"><?php echo form_error('password'); ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" id="remember" name="remember">
                        <label class="form-check-label" for="remember">
                            Remember me
                        </label>
                    </div>
                    
                    <button type="submit" class="btn btn-login">
                        <i class="fas fa-sign-in-alt"></i> Login to Dashboard
                    </button>
                    
                <?php echo form_close(); ?>
                
                <div class="login-footer">
                    <a href="<?php echo base_url('admin/forgot-password'); ?>">
                        <i class="fas fa-question-circle"></i> Forgot Password?
                    </a>
                    <br><br>
                    <a href="<?php echo base_url(); ?>">
                        <i class="fas fa-arrow-left"></i> Back to Website
                    </a>
                </div>
            </div>
        </div>
        
        <div class="text-center mt-4">
            <small class="text-white-50">
                &copy; <?php echo date('Y'); ?> Atelier. All rights reserved.
            </small>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Auto-hide alerts after 5 seconds
        setTimeout(function() {
            $('.alert').fadeOut('slow');
        }, 5000);
    </script>
</body>
</html>