<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?> - Admin</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --primary-color: #f26124;
            --secondary-color: #231f20;
        }
        
        body {
            background: linear-gradient(135deg, var(--secondary-color) 0%, var(--primary-color) 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .reset-container {
            width: 100%;
            max-width: 450px;
            padding: 20px;
        }
        
        .reset-card {
            background: #fff;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            overflow: hidden;
        }
        
        .reset-header {
            background: var(--primary-color);
            color: #fff;
            padding: 40px 30px;
            text-align: center;
        }
        
        .reset-header h1 {
            font-size: 24px;
            margin: 0 0 10px;
            font-weight: bold;
        }
        
        .reset-header p {
            margin: 0;
            opacity: 0.9;
            font-size: 14px;
        }
        
        .reset-body {
            padding: 40px 30px;
        }
        
        .form-floating {
            margin-bottom: 20px;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(242, 97, 36, 0.25);
        }
        
        .btn-submit {
            width: 100%;
            padding: 12px;
            background: var(--primary-color);
            border: none;
            color: #fff;
            font-weight: bold;
            border-radius: 8px;
            transition: all 0.3s;
        }
        
        .btn-submit:hover {
            background: #d95520;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(242, 97, 36, 0.3);
        }
        
        .alert {
            border-radius: 8px;
            margin-bottom: 20px;
        }
        
        .password-strength {
            height: 5px;
            border-radius: 3px;
            transition: all 0.3s;
            margin-top: 5px;
        }
        
        .password-strength.weak {
            background: #dc3545;
            width: 33%;
        }
        
        .password-strength.medium {
            background: #ffc107;
            width: 66%;
        }
        
        .password-strength.strong {
            background: #28a745;
            width: 100%;
        }
    </style>
</head>
<body>
    <div class="reset-container">
        <div class="reset-card">
            <div class="reset-header">
                <a class="navbar-brand" href="<?php echo base_url(); ?>">
			<img src="<?php echo base_url('assets/images/logo2.png'); ?>" alt="Logo" height="40">
		    </a>
                <h1>Reset Password</h1>
                <p>Enter your new password</p>
            </div>
            
            <div class="reset-body">
                <!-- Flash Messages -->
                <?php if($this->session->flashdata('message')): ?>
                    <div class="alert alert-<?php echo $this->session->flashdata('message_type'); ?> alert-dismissible fade show" role="alert">
                        <?php echo $this->session->flashdata('message'); ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <!-- Password Requirements -->
                <div class="alert alert-info">
                    <strong><i class="fas fa-info-circle"></i> Password Requirements:</strong>
                    <ul class="mb-0 mt-2">
                        <li>At least 6 characters long</li>
                        <li>Mix of letters and numbers recommended</li>
                    </ul>
                </div>
                
                <!-- Reset Password Form -->
                <?php echo form_open('admin/reset-password/' . $admin_id . '/' . $token); ?>
                    
                    <div class="form-floating mb-3">
                        <input type="password" 
                               class="form-control <?php echo form_error('password') ? 'is-invalid' : ''; ?>" 
                               id="password" 
                               name="password" 
                               placeholder="New Password"
                               required
                               autofocus>
                        <label for="password"><i class="fas fa-key"></i> New Password</label>
                        <div class="password-strength" id="passwordStrength"></div>
                        <?php if(form_error('password')): ?>
                            <div class="invalid-feedback"><?php echo form_error('password'); ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="form-floating mb-3">
                        <input type="password" 
                               class="form-control <?php echo form_error('confirm_password') ? 'is-invalid' : ''; ?>" 
                               id="confirm_password" 
                               name="confirm_password" 
                               placeholder="Confirm Password"
                               required>
                        <label for="confirm_password"><i class="fas fa-lock"></i> Confirm Password</label>
                        <?php if(form_error('confirm_password')): ?>
                            <div class="invalid-feedback"><?php echo form_error('confirm_password'); ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <button type="submit" class="btn btn-submit">
                        <i class="fas fa-check"></i> Reset Password
                    </button>
                    
                <?php echo form_close(); ?>
            </div>
        </div>
        
        <div class="text-center mt-4">
            <small class="text-white-50">
                &copy; <?php echo date('Y'); ?> NGO Platform. All rights reserved.
            </small>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Password strength indicator
        const passwordInput = document.getElementById('password');
        const strengthBar = document.getElementById('passwordStrength');
        
        passwordInput.addEventListener('input', function() {
            const password = this.value;
            let strength = 0;
            
            if (password.length >= 6) strength++;
            if (password.length >= 10) strength++;
            if (/[a-z]/.test(password) && /[A-Z]/.test(password)) strength++;
            if (/[0-9]/.test(password)) strength++;
            if (/[^a-zA-Z0-9]/.test(password)) strength++;
            
            strengthBar.className = 'password-strength';
            
            if (strength <= 2) {
                strengthBar.classList.add('weak');
            } else if (strength <= 4) {
                strengthBar.classList.add('medium');
            } else {
                strengthBar.classList.add('strong');
            }
        });
        
        // Password match validation
        const confirmPassword = document.getElementById('confirm_password');
        
        confirmPassword.addEventListener('input', function() {
            if (this.value !== passwordInput.value) {
                this.setCustomValidity('Passwords do not match');
            } else {
                this.setCustomValidity('');
            }
        });
    </script>
</body>
</html>