<style>
    :root {
        --primary-color: #f26124;
        --secondary-color: #231f20;
        --success-green: #28a745;
        --info-blue: #17a2b8;
        --danger-red: #dc3545;
        --warning-yellow: #ffc107;
    }

    body {
        background: #f4f6f9;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    /* Spacing Utilities */
    .mb-0 {
        margin-bottom: 0 !important;
    }

    .mb-2 {
        margin-bottom: 0.5rem !important;
    }

    .mb-3 {
        margin-bottom: 1rem !important;
    }

    .mb-4 {
        margin-bottom: 1.5rem !important;
    }

    .me-2 {
        margin-right: 0.5rem !important;
    }

    .mt-3 {
        margin-top: 1rem !important;
    }

    .py-5 {
        padding-top: 3rem !important;
        padding-bottom: 3rem !important;
    }

    /* Text Utilities */
    .d-flex {
        display: flex;
    }

    .justify-content-between {
        justify-content: space-between;
    }

    .align-items-center {
        align-items: center;
    }

    .text-muted {
        color: #6c757d !important;
    }

    .text-center {
        text-align: center;
    }

    .text-danger {
        color: var(--danger-red) !important;
    }

    h2 {
        font-size: 28px;
        font-weight: 700;
        color: #231f20;
        margin: 0;
    }

    h4 {
        font-size: 20px;
        font-weight: 700;
        color: #231f20;
        margin-bottom: 8px;
    }

    h5 {
        font-size: 16px;
        font-weight: 700;
        color: #231f20;
        margin: 0;
    }

    p {
        font-size: 14px;
        color: #6c757d;
        margin: 4px 0 0 0;
    }

    strong {
        font-weight: 700;
    }

    small {
        font-size: 12px;
    }

    code {
        background: #f8f9fa;
        padding: 2px 6px;
        border-radius: 4px;
        color: #495057;
        font-family: 'Courier New', monospace;
        font-size: 12px;
    }

    /* Card Styling */
    .table-card {
        background: #fff;
        border-radius: 12px;
        padding: 28px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid #e9ecef;
        transition: all 0.3s ease;
        margin-bottom: 24px;
    }

    .table-card:hover {
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.12);
    }

    /* Table */
    .table-responsive {
        overflow-x: auto;
    }

    .table {
        width: 100%;
        margin-bottom: 0;
        border-collapse: collapse;
    }

    .table thead th {
        font-size: 13px;
        font-weight: 700;
        color: #231f20;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        border: none;
        border-bottom: 2px solid #e9ecef;
        padding: 14px 12px;
        background: transparent;
        text-align: left;
    }

    .table tbody td {
        font-size: 14px;
        color: #495057;
        padding: 12px;
        border: none;
        border-bottom: 1px solid #f0f0f0;
        vertical-align: middle;
    }

    .table tbody tr:hover {
        background: #f8f9fa;
    }

    .table tbody tr:last-child td {
        border-bottom: 1px solid #e9ecef;
    }

    .table-hover tbody tr:hover {
        background-color: #f8f9fa;
    }

    /* Badges */
    .badge {
        font-size: 11px;
        font-weight: 700;
        padding: 6px 10px;
        border-radius: 12px;
        display: inline-block;
        white-space: nowrap;
    }

    .bg-primary {
        background-color: var(--primary-color) !important;
        color: #fff;
    }

    /* Buttons */
    .btn {
        font-size: 14px;
        font-weight: 600;
        padding: 10px 16px;
        border-radius: 6px;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-primary {
        background: var(--primary-color);
        color: #fff;
    }

    .btn-primary:hover {
        background: #d95520;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(242, 97, 36, 0.3);
    }

    .btn-secondary {
        background: #6c757d;
        color: #fff;
    }

    .btn-secondary:hover {
        background: #5a6268;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(108, 117, 125, 0.3);
    }

    .btn-outline-secondary {
        background: transparent;
        color: #231f20;
        border: 1px solid #dee2e6;
    }

    .btn-outline-secondary:hover {
        background: #f8f9fa;
        border-color: #231f20;
        transform: translateY(-1px);
    }

    .btn-outline-primary {
        background: transparent;
        color: var(--primary-color);
        border: 1px solid var(--primary-color);
    }

    .btn-outline-primary:hover {
        background: var(--primary-color);
        color: #fff;
        transform: translateY(-1px);
    }

    .btn-outline-danger {
        background: transparent;
        color: var(--danger-red);
        border: 1px solid var(--danger-red);
    }

    .btn-outline-danger:hover {
        background: var(--danger-red);
        color: #fff;
        transform: translateY(-1px);
    }

    .btn-outline-secondary:disabled {
        opacity: 0.6;
        cursor: not-allowed;
    }

    .btn-sm {
        padding: 6px 12px;
        font-size: 12px;
    }

    /* Form Elements */
    .form-label {
        font-size: 14px;
        font-weight: 600;
        color: #231f20;
        margin-bottom: 8px;
        display: block;
    }

    .form-control,
    .form-select {
        display: block;
        width: 100%;
        padding: 10px 12px;
        font-size: 14px;
        color: #495057;
        background-color: #fff;
        border: 1px solid #dee2e6;
        border-radius: 6px;
        transition: all 0.3s ease;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .form-control:focus,
    .form-select:focus {
        color: #495057;
        background-color: #fff;
        border-color: var(--primary-color);
        outline: 0;
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
    }

    .form-control::placeholder {
        color: #adb5bd;
    }

    textarea.form-control {
        resize: vertical;
        min-height: 100px;
    }

    /* Modal */
    .modal-content {
        border: 1px solid #e9ecef;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
    }

    .modal-header {
        background: var(--primary-color);
        color: #fff;
        border-radius: 12px 12px 0 0;
        border: none;
    }

    .modal-header.dark-header {
        background: #231f20;
    }

    .modal-title {
        font-size: 16px;
        font-weight: 700;
    }

    .modal-body {
        padding: 24px;
    }

    .modal-footer {
        padding: 16px 24px;
        border-top: 1px solid #e9ecef;
    }

    .btn-close {
        opacity: 0.7;
        transition: opacity 0.2s;
    }

    .btn-close:hover {
        opacity: 1;
    }

    .btn-close-white {
        filter: brightness(0) invert(1);
    }

    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 60px 40px;
    }

    .empty-state i {
        font-size: 64px;
        color: #dee2e6;
        margin-bottom: 20px;
        display: block;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .d-flex {
            flex-direction: column;
            align-items: flex-start;
            gap: 16px;
        }

        .d-flex > div:last-child {
            width: 100%;
            display: flex;
            gap: 12px;
            flex-wrap: wrap;
        }

        .table-card {
            padding: 18px;
        }

        .table thead th,
        .table tbody td {
            padding: 10px 8px;
            font-size: 12px;
        }

        h2 {
            font-size: 24px;
        }

        .btn {
            width: 100%;
            justify-content: center;
        }

        .btn-sm {
            width: auto;
        }
    }

    @media (max-width: 576px) {
        .table-card {
            padding: 16px;
        }

        .table thead th {
            font-size: 11px;
        }

        .table tbody td {
            font-size: 12px;
            padding: 8px;
        }

        h2 {
            font-size: 20px;
        }

        h5 {
            font-size: 14px;
        }

        .modal-body {
            padding: 16px;
        }

        .modal-footer {
            padding: 12px 16px;
        }

        .form-control,
        .form-select {
            padding: 8px 10px;
            font-size: 13px;
        }

        .empty-state {
            padding: 40px 20px;
        }

        .empty-state i {
            font-size: 48px;
        }
    }
</style>

<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-0">Blog Categories</h2>
        <p class="text-muted mb-0">Organize your blog posts</p>
    </div>
    <div>
        <a href="<?php echo base_url('admin/blog'); ?>" class="btn btn-outline-secondary me-2">
            <i class="fas fa-arrow-left"></i> Back to Posts
        </a>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addCategoryModal">
            <i class="fas fa-plus"></i> Add Category
        </button>
    </div>
</div>

<!-- Categories Table -->
<div class="table-card">
    <?php if(!empty($categories)): ?>
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th style="width: 50px;">ID</th>
                    <th>Name</th>
                    <th>Slug</th>
                    <th>Description</th>
                    <th>Posts</th>
                    <th>Status</th>
                    <th style="width: 150px;">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($categories as $category): ?>
                <tr>
                    <td><?php echo $category->id; ?></td>
                    <td><strong><?php echo $category->name; ?></strong></td>
                    <td><code><?php echo $category->slug; ?></code></td>
                    <td><?php echo character_limiter($category->description, 50); ?></td>
                    <td>
                        <span class="badge bg-primary"><?php echo $category->post_count; ?> posts</span>
                    </td>
                    <td><?php echo get_status_badge($category->status); ?></td>
                    <td>
                        <button type="button" 
                                class="btn btn-sm btn-outline-primary btn-edit-category"
                                data-id="<?php echo $category->id; ?>"
                                data-name="<?php echo htmlspecialchars($category->name); ?>"
                                data-description="<?php echo htmlspecialchars($category->description); ?>"
                                data-status="<?php echo $category->status; ?>">
                            <i class="fas fa-edit"></i>
                        </button>
                        <?php if($category->post_count == 0): ?>
                        <form method="post" style="display:inline;" onsubmit="return confirm('Delete this category?');">
                            <input type="hidden" name="action" value="delete">
                            <input type="hidden" name="category_id" value="<?php echo $category->id; ?>">
                            <button type="submit" class="btn btn-sm btn-outline-danger">
                                <i class="fas fa-trash"></i>
                            </button>
                        </form>
                        <?php else: ?>
                        <button type="button" class="btn btn-sm btn-outline-secondary" disabled title="Cannot delete category with posts">
                            <i class="fas fa-lock"></i>
                        </button>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php else: ?>
    <div class="text-center py-5">
        <i class="fas fa-folder fa-4x text-muted mb-3"></i>
        <h4>No categories yet</h4>
        <p class="text-muted">Create categories to organize your blog posts</p>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addCategoryModal">
            <i class="fas fa-plus"></i> Create First Category
        </button>
    </div>
    <?php endif; ?>
</div>

<!-- Add Category Modal -->
<div class="modal fade" id="addCategoryModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fas fa-plus"></i> Add New Category</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <?php echo form_open('', array('id' => 'addCategoryForm')); ?>
            <div class="modal-body">
                <input type="hidden" name="action" value="add">
                
                <div class="mb-3">
                    <label for="add_name" class="form-label">Category Name <span class="text-danger">*</span></label>
                    <input type="text" 
                           class="form-control" 
                           id="add_name" 
                           name="name" 
                           placeholder="e.g., Community Impact"
                           required>
                </div>
                
                <div class="mb-3">
                    <label for="add_description" class="form-label">Description</label>
                    <textarea class="form-control" 
                              id="add_description" 
                              name="description" 
                              rows="3"
                              placeholder="Brief description of this category..."></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Add Category
                </button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<!-- Edit Category Modal -->
<div class="modal fade" id="editCategoryModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header dark-header">
                <h5 class="modal-title"><i class="fas fa-edit"></i> Edit Category</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <?php echo form_open('', array('id' => 'editCategoryForm')); ?>
            <div class="modal-body">
                <input type="hidden" name="action" value="edit">
                <input type="hidden" name="category_id" id="edit_category_id">
                
                <div class="mb-3">
                    <label for="edit_name" class="form-label">Category Name <span class="text-danger">*</span></label>
                    <input type="text" 
                           class="form-control" 
                           id="edit_name" 
                           name="name" 
                           required>
                </div>
                
                <div class="mb-3">
                    <label for="edit_description" class="form-label">Description</label>
                    <textarea class="form-control" 
                              id="edit_description" 
                              name="description" 
                              rows="3"></textarea>
                </div>
                
                <div class="mb-3">
                    <label for="edit_status" class="form-label">Status</label>
                    <select class="form-select" id="edit_status" name="status">
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Update Category
                </button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<script>
    // Edit category button click
    document.querySelectorAll('.btn-edit-category').forEach(button => {
        button.addEventListener('click', function() {
            const id = this.getAttribute('data-id');
            const name = this.getAttribute('data-name');
            const description = this.getAttribute('data-description');
            const status = this.getAttribute('data-status');
            
            document.getElementById('edit_category_id').value = id;
            document.getElementById('edit_name').value = name;
            document.getElementById('edit_description').value = description;
            document.getElementById('edit_status').value = status;
            
            const modal = new bootstrap.Modal(document.getElementById('editCategoryModal'));
            modal.show();
        });
    });
</script>