<style>
    :root {
        --primary-color: #f26124;
        --secondary-color: #231f20;
        --success-green: #28a745;
        --info-blue: #17a2b8;
        --danger-red: #dc3545;
        --warning-yellow: #ffc107;
    }

    body {
        background: #f4f6f9;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    /* Page Header */
    .d-flex {
        display: flex;
    }

    .justify-content-between {
        justify-content: space-between;
    }

    .align-items-center {
        align-items: center;
    }

    .mb-4 {
        margin-bottom: 1.5rem !important;
    }

    .mb-3 {
        margin-bottom: 1rem !important;
    }

    .mb-0 {
        margin-bottom: 0 !important;
    }

    .me-2 {
        margin-right: 0.5rem !important;
    }

    .mt-3 {
        margin-top: 1rem !important;
    }

    .py-5 {
        padding-top: 3rem !important;
        padding-bottom: 3rem !important;
    }

    h2 {
        font-size: 28px;
        font-weight: 700;
        color: #231f20;
        margin: 0;
    }

    h4 {
        font-size: 20px;
        font-weight: 700;
        color: #231f20;
        margin-bottom: 8px;
    }

    p {
        font-size: 14px;
        color: #6c757d;
        margin: 4px 0 0 0;
    }

    .text-muted {
        color: #6c757d !important;
    }

    .text-center {
        text-align: center;
    }

    strong {
        font-weight: 700;
    }

    small {
        font-size: 12px;
    }

    /* Table Card */
    .table-card {
        background: #fff;
        border-radius: 12px;
        padding: 28px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid #e9ecef;
        transition: all 0.3s ease;
        margin-bottom: 24px;
    }

    .table-card:hover {
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.12);
    }

    /* Tabs */
    .nav {
        display: flex;
        flex-wrap: wrap;
        padding-left: 0;
        margin-bottom: 0;
        list-style: none;
    }

    .nav-tabs {
        border-bottom: 2px solid #e9ecef;
        display: flex;
        gap: 8px;
        flex-wrap: wrap;
    }

    .nav-item {
        margin: 0;
    }

    .nav-link {
        color: #6c757d;
        border: none;
        padding: 12px 16px;
        font-size: 14px;
        font-weight: 600;
        border-bottom: 3px solid transparent;
        transition: all 0.3s ease;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        text-decoration: none;
    }

    .nav-link:hover {
        color: var(--primary-color);
        border-bottom-color: var(--primary-color);
    }

    .nav-link.active {
        color: var(--primary-color);
        border-bottom-color: var(--primary-color);
        background: transparent;
    }

    /* Badges */
    .badge {
        font-size: 11px;
        font-weight: 700;
        padding: 6px 10px;
        border-radius: 12px;
        display: inline-block;
        white-space: nowrap;
        margin-left: 4px;
    }

    .bg-secondary {
        background-color: #6c757d !important;
        color: #fff;
    }

    .bg-success {
        background-color: var(--success-green) !important;
        color: #fff;
    }

    .bg-info {
        background-color: var(--info-blue) !important;
        color: #fff;
    }

    .bg-warning {
        background-color: var(--warning-yellow) !important;
        color: #231f20;
    }

    /* Buttons */
    .btn {
        font-size: 14px;
        font-weight: 600;
        padding: 8px 16px;
        border-radius: 6px;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-primary {
        background: var(--primary-color);
        color: #fff;
    }

    .btn-primary:hover {
        background: #d95520;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(242, 97, 36, 0.3);
    }

    .btn-outline-secondary {
        background: transparent;
        color: #231f20;
        border: 1px solid #dee2e6;
    }

    .btn-outline-secondary:hover {
        background: #f8f9fa;
        border-color: #231f20;
        transform: translateY(-2px);
    }

    .btn-outline-info {
        background: transparent;
        color: var(--info-blue);
        border: 1px solid var(--info-blue);
    }

    .btn-outline-info:hover {
        background: var(--info-blue);
        color: #fff;
        transform: translateY(-1px);
    }

    .btn-outline-primary {
        background: transparent;
        color: var(--primary-color);
        border: 1px solid var(--primary-color);
    }

    .btn-outline-primary:hover {
        background: var(--primary-color);
        color: #fff;
        transform: translateY(-1px);
    }

    .btn-outline-success {
        background: transparent;
        color: var(--success-green);
        border: 1px solid var(--success-green);
    }

    .btn-outline-success:hover {
        background: var(--success-green);
        color: #fff;
        transform: translateY(-1px);
    }

    .btn-outline-warning {
        background: transparent;
        color: var(--warning-yellow);
        border: 1px solid var(--warning-yellow);
    }

    .btn-outline-warning:hover {
        background: var(--warning-yellow);
        color: #231f20;
        transform: translateY(-1px);
    }

    .btn-outline-danger {
        background: transparent;
        color: var(--danger-red);
        border: 1px solid var(--danger-red);
    }

    .btn-outline-danger:hover {
        background: var(--danger-red);
        color: #fff;
        transform: translateY(-1px);
    }

    .btn-sm {
        padding: 6px 12px;
        font-size: 12px;
    }

    .btn-group-sm {
        display: flex;
        gap: 4px;
    }

    .btn-group-sm .btn {
        padding: 6px 10px;
        font-size: 12px;
    }

    /* Table */
    .table-responsive {
        overflow-x: auto;
    }

    .table {
        width: 100%;
        margin-bottom: 0;
        border-collapse: collapse;
    }

    .table thead th {
        font-size: 13px;
        font-weight: 700;
        color: #231f20;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        border: none;
        border-bottom: 2px solid #e9ecef;
        padding: 14px 12px;
        background: transparent;
        text-align: left;
    }

    .table tbody td {
        font-size: 14px;
        color: #495057;
        padding: 12px;
        border: none;
        border-bottom: 1px solid #f0f0f0;
        vertical-align: middle;
    }

    .table tbody tr:hover {
        background: #f8f9fa;
    }

    .table tbody tr:last-child td {
        border-bottom: 1px solid #e9ecef;
    }

    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 60px 40px;
    }

    .empty-state i {
        font-size: 64px;
        color: #dee2e6;
        margin-bottom: 20px;
        display: block;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .d-flex {
            flex-direction: column;
            align-items: flex-start;
        }

        .d-flex > div:last-child {
            width: 100%;
            justify-content: flex-start;
            display: flex;
            gap: 12px;
            flex-wrap: wrap;
        }

        .table-card {
            padding: 18px;
        }

        .table thead th,
        .table tbody td {
            padding: 10px 8px;
            font-size: 12px;
        }

        .nav-link {
            padding: 10px 12px;
            font-size: 12px;
        }

        .btn-group-sm {
            flex-wrap: wrap;
        }
    }

    @media (max-width: 576px) {
        .table-card {
            padding: 16px;
        }

        .table thead th {
            font-size: 11px;
        }

        .table tbody td {
            font-size: 12px;
            padding: 8px;
        }

        h2 {
            font-size: 24px;
        }

        .empty-state {
            padding: 40px 20px;
        }

        .empty-state i {
            font-size: 48px;
        }

        .btn {
            padding: 8px 12px;
            font-size: 12px;
        }
    }
</style>

<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-0">Blog Posts</h2>
        <p class="text-muted mb-0">Manage your blog content</p>
    </div>
    <div>
        <a href="<?php echo base_url('admin/blog/categories'); ?>" class="btn btn-outline-secondary me-2">
            <i class="fas fa-folder"></i> Categories
        </a>
        <a href="<?php echo base_url('admin/blog/add'); ?>" class="btn btn-primary">
            <i class="fas fa-plus"></i> Add New Post
        </a>
    </div>
</div>

<!-- Filter Tabs -->
<div class="table-card mb-4">
    <ul class="nav nav-tabs" role="tablist">
        <li class="nav-item">
            <a class="nav-link <?php echo empty($current_status) ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/blog'); ?>">
                All Posts <span class="badge bg-secondary"><?php echo $statistics['total'] ?? 0; ?></span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo ($current_status == 'published') ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/blog?status=published'); ?>">
                Published <span class="badge bg-success"><?php echo $statistics['published'] ?? 0; ?></span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo ($current_status == 'draft') ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/blog?status=draft'); ?>">
                Drafts <span class="badge bg-info"><?php echo $statistics['draft'] ?? 0; ?></span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo ($current_status == 'archived') ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/blog?status=archived'); ?>">
                Archived <span class="badge bg-warning"><?php echo $statistics['archived'] ?? 0; ?></span>
            </a>
        </li>
    </ul>
</div>

<!-- Blog Posts Table -->
<div class="table-card">
    <?php if(!empty($posts)): ?>
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th style="width: 50px;">ID</th>
                    <th>Title</th>
                    <th>Category</th>
                    <th>Author</th>
                    <th>Status</th>
                    <th>Views</th>
                    <th>Date</th>
                    <th style="width: 200px;">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($posts as $post): ?>
                <tr>
                    <td><?php echo $post->id; ?></td>
                    <td>
                        <strong><?php echo character_limiter($post->title, 50); ?></strong>
                        <?php if($post->featured_image): ?>
                            <br><small class="text-muted"><i class="fas fa-image"></i> Has image</small>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if($post->category_name): ?>
                            <span class="badge bg-secondary"><?php echo $post->category_name; ?></span>
                        <?php else: ?>
                            <span class="text-muted">Uncategorized</span>
                        <?php endif; ?>
                    </td>
                    <td><?php echo $post->author_name; ?></td>
                    <td><?php echo get_status_badge($post->status); ?></td>
                    <td><i class="fas fa-eye"></i> <?php echo $post->views_count; ?></td>
                    <td>
                        <?php if($post->published_at): ?>
                            <?php echo format_date($post->published_at); ?>
                        <?php else: ?>
                            <?php echo format_date($post->created_at); ?>
                        <?php endif; ?>
                    </td>
                    <td>
                        <div class="btn-group btn-group-sm" role="group">
                            <?php if($post->status != 'archived'): ?>
                                <a href="<?php echo base_url('blog/' . $post->slug); ?>" 
                                   class="btn btn-outline-info" 
                                   target="_blank" 
                                   title="View Post">
                                    <i class="fas fa-eye"></i>
                                </a>
                            <?php endif; ?>
                            
                            <a href="<?php echo base_url('admin/blog/edit/' . $post->id); ?>" 
                               class="btn btn-outline-primary" 
                               title="Edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            
                            <?php if($post->status == 'archived'): ?>
                                <!-- Unarchive button for archived posts -->
                                <a href="<?php echo base_url('admin/blog/unarchive/' . $post->id); ?>" 
                                   class="btn btn-outline-success" 
                                   title="Restore to Draft"
                                   onclick="return confirm('Restore this post to draft?');">
                                    <i class="fas fa-undo"></i>
                                </a>
                                <!-- Permanent delete for archived posts -->
                                <a href="<?php echo base_url('admin/blog/delete/' . $post->id); ?>" 
                                   class="btn btn-outline-danger btn-delete" 
                                   title="Delete Permanently"
                                   onclick="return confirm('Permanently delete this post? This cannot be undone!');">
                                    <i class="fas fa-trash"></i>
                                </a>
                            <?php else: ?>
                                <!-- Archive button for non-archived posts -->
                                <a href="<?php echo base_url('admin/blog/archive/' . $post->id); ?>" 
                                   class="btn btn-outline-warning" 
                                   title="Archive"
                                   onclick="return confirm('Archive this post?');">
                                    <i class="fas fa-archive"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    
    <!-- Pagination -->
    <?php if(!empty($pagination)): ?>
    <div class="mt-3">
        <?php echo $pagination; ?>
    </div>
    <?php endif; ?>
    
    <?php else: ?>
    <!-- Empty State -->
    <div class="text-center py-5">
        <i class="fas fa-newspaper fa-4x text-muted mb-3"></i>
        <h4>No blog posts found</h4>
        <p class="text-muted">Start creating amazing content for your audience!</p>
        <a href="<?php echo base_url('admin/blog/add'); ?>" class="btn btn-primary">
            <i class="fas fa-plus"></i> Create Your First Post
        </a>
    </div>
    <?php endif; ?>
</div>