<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Custom Carousel Management Styles -->
<style>
    :root {
        --primary-color: #f26124;
        --primary-hover: #d95520;
        --success-color: #1cc88a;
        --info-color: #36b9cc;
        --warning-color: #f6c23e;
        --danger-color: #dc3545;
        --dark-text: #231f20;
        --muted-text: #6c757d;
        --border-color: #e9ecef;
        --bg-light: #f8f9fa;
    }

    .carousel-container {
        background: #f4f6f9;
        min-height: 100vh;
        padding: 20px 0;
    }

    /* Statistics Cards */
    .stats-row {
        margin-bottom: 32px;
    }

    .stat-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: none;
        border-left: 4px solid;
        overflow: hidden;
        transition: all 0.3s ease;
        height: 100%;
    }

    .stat-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
    }

    .stat-card.stat-primary {
        border-left-color: var(--primary-color);
    }

    .stat-card.stat-success {
        border-left-color: var(--success-color);
    }

    .stat-card.stat-info {
        border-left-color: var(--info-color);
    }

    .stat-card.stat-warning {
        border-left-color: var(--warning-color);
    }

    .stat-card .card-body {
        padding: 24px;
    }

    .stat-label {
        font-size: 11px;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 8px;
        color: var(--muted-text);
    }

    .stat-value {
        font-size: 32px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0;
        line-height: 1;
    }

    .stat-icon {
        font-size: 36px;
        opacity: 0.15;
    }

    .stat-card.stat-primary .stat-icon {
        color: var(--primary-color);
    }

    .stat-card.stat-success .stat-icon {
        color: var(--success-color);
    }

    .stat-card.stat-info .stat-icon {
        color: var(--info-color);
    }

    .stat-card.stat-warning .stat-icon {
        color: var(--warning-color);
    }

    /* Main Card */
    .carousel-main-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
        overflow: hidden;
        margin-bottom: 32px;
    }

    .carousel-main-card .card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border: none;
        border-bottom: 2px solid var(--border-color);
        padding: 24px 28px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .carousel-main-card .card-header h3 {
        font-size: 20px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .carousel-main-card .card-header h3 i {
        color: var(--primary-color);
        font-size: 22px;
    }

    .carousel-main-card .card-body {
        padding: 32px;
    }

    /* Alert */
    .alert {
        border-radius: 8px;
        border: 1px solid;
        padding: 14px 20px;
        margin-bottom: 24px;
        font-size: 14px;
    }

    .alert-info {
        background-color: #d1ecf1;
        border-color: #bee5eb;
        color: #0c5460;
    }

    .alert i {
        margin-right: 8px;
    }

    /* Buttons */
    .btn {
        border-radius: 8px;
        padding: 10px 20px;
        font-size: 14px;
        font-weight: 600;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-primary {
        background: var(--primary-color);
        color: #fff;
    }

    .btn-primary:hover {
        background: var(--primary-hover);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(242, 97, 36, 0.3);
        color: #fff;
    }

    .btn-danger {
        background: var(--danger-color);
        color: #fff;
    }

    .btn-danger:hover {
        background: #c82333;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(220, 53, 69, 0.3);
        color: #fff;
    }

    .btn-sm {
        padding: 8px 16px;
        font-size: 13px;
    }

    .btn i {
        font-size: 14px;
    }

    /* Carousel Item Cards */
    .carousel-item-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
        overflow: hidden;
        transition: all 0.3s ease;
        height: 100%;
        margin-bottom: 24px;
    }

    .carousel-item-card:hover {
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
    }

    .carousel-item-card .card-body {
        padding: 24px;
    }

    /* Drag Handle */
    .drag-handle {
        cursor: move;
        padding: 8px;
        border-radius: 8px;
        transition: all 0.3s ease;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }

    .drag-handle:hover {
        background: rgba(242, 97, 36, 0.1);
    }

    .drag-handle i {
        color: #adb5bd;
        transition: color 0.3s ease;
    }

    .drag-handle:hover i {
        color: var(--primary-color);
    }

    /* Media Preview */
    .media-preview {
        border-radius: 8px;
        overflow: hidden;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    .media-preview img {
        max-height: 140px;
        width: 100%;
        object-fit: cover;
        border-radius: 8px;
    }

    .media-preview .video-placeholder,
    .media-preview .image-placeholder {
        height: 140px;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .media-preview .video-placeholder {
        background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
        color: #fff;
    }

    .media-preview .image-placeholder {
        background: var(--bg-light);
        color: #adb5bd;
    }

    /* Badges */
    .badge {
        padding: 6px 12px;
        font-size: 11px;
        font-weight: 600;
        border-radius: 6px;
        text-transform: uppercase;
        letter-spacing: 0.3px;
    }

    .badge-success {
        background: var(--success-color);
        color: #fff;
    }

    .badge-secondary {
        background: #6c757d;
        color: #fff;
    }

    .badge-info {
        background: var(--info-color);
        color: #fff;
    }

    .badge-warning {
        background: var(--warning-color);
        color: #fff;
    }

    .badge-light {
        background: var(--bg-light);
        color: var(--muted-text);
        border: 1px solid var(--border-color);
    }

    /* Slide Details */
    .slide-details {
        padding: 0 16px;
    }

    .slide-title {
        font-size: 18px;
        font-weight: 700;
        color: var(--dark-text);
        margin-bottom: 12px;
        line-height: 1.3;
    }

    .slide-subtitle {
        font-size: 14px;
        font-weight: 600;
        color: var(--muted-text);
        margin-bottom: 10px;
    }

    .slide-description {
        font-size: 13px;
        color: var(--muted-text);
        line-height: 1.5;
        margin-bottom: 10px;
    }

    .slide-link {
        font-size: 13px;
        margin: 0;
    }

    .slide-link i {
        color: var(--primary-color);
        margin-right: 6px;
    }

    .slide-link code {
        background: var(--bg-light);
        padding: 2px 8px;
        border-radius: 4px;
        color: var(--dark-text);
        font-size: 12px;
    }

    /* Action Buttons */
    .action-buttons {
        display: flex;
        flex-direction: column;
        gap: 10px;
    }

    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 80px 20px;
    }

    .empty-state i {
        color: #dee2e6;
        margin-bottom: 24px;
    }

    .empty-state h5 {
        font-size: 20px;
        font-weight: 700;
        color: var(--muted-text);
        margin-bottom: 12px;
    }

    .empty-state p {
        font-size: 14px;
        color: var(--muted-text);
        margin-bottom: 24px;
    }

    /* Sortable Placeholder */
    .sortable-placeholder {
        border: 2px dashed var(--border-color);
        background: var(--bg-light);
        border-radius: 12px;
        height: 180px;
        margin-bottom: 24px;
    }

    .ui-sortable-helper {
        opacity: 0.9;
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15);
        transform: scale(1.02);
    }

    /* Notification */
    .notification-toast {
        position: fixed;
        top: 20px;
        right: 20px;
        z-index: 9999;
        min-width: 320px;
        border-radius: 8px;
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.15);
        animation: slideInRight 0.3s ease;
    }

    @keyframes slideInRight {
        from {
            transform: translateX(400px);
            opacity: 0;
        }
        to {
            transform: translateX(0);
            opacity: 1;
        }
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .carousel-container {
            padding: 16px 0;
        }

        .stats-row {
            margin-bottom: 24px;
        }

        .stat-card .card-body {
            padding: 20px;
        }

        .stat-value {
            font-size: 28px;
        }

        .carousel-main-card .card-header {
            padding: 20px;
            flex-direction: column;
            gap: 16px;
            align-items: flex-start;
        }

        .carousel-main-card .card-header h3 {
            font-size: 18px;
        }

        .carousel-main-card .card-body {
            padding: 20px;
        }

        .carousel-item-card .card-body {
            padding: 20px;
        }

        .slide-details {
            padding: 16px 0;
        }

        .action-buttons {
            width: 100%;
        }

        .action-buttons .btn {
            width: 100%;
            justify-content: center;
        }

        .media-preview img,
        .media-preview .video-placeholder,
        .media-preview .image-placeholder {
            max-height: 120px;
        }

        .notification-toast {
            min-width: 280px;
            right: 16px;
            left: 16px;
        }
    }
</style>

<div class="carousel-container">
    <div class="container-fluid">
        <!-- Statistics Cards -->
        <div class="row stats-row">
            <?php
            // Calculate statistics from carousel items
            $total = count($carousel_items);
            $active = count(array_filter($carousel_items, function($c) { return $c->status === 'active'; }));
            $inactive = count(array_filter($carousel_items, function($c) { return $c->status === 'inactive'; }));
            $images = count(array_filter($carousel_items, function($c) { return $c->media_type === 'image'; }));
            $videos = count(array_filter($carousel_items, function($c) { return $c->media_type === 'video'; }));
            ?>
            
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="stat-card stat-primary">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col">
                                <div class="stat-label">Total Slides</div>
                                <div class="stat-value"><?php echo $total; ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-images stat-icon"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3 col-sm-6 mb-3">
                <div class="stat-card stat-success">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col">
                                <div class="stat-label">Active</div>
                                <div class="stat-value"><?php echo $active; ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-check-circle stat-icon"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3 col-sm-6 mb-3">
                <div class="stat-card stat-info">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col">
                                <div class="stat-label">Images</div>
                                <div class="stat-value"><?php echo $images; ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-image stat-icon"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3 col-sm-6 mb-3">
                <div class="stat-card stat-warning">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col">
                                <div class="stat-label">Videos</div>
                                <div class="stat-value"><?php echo $videos; ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-video stat-icon"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Card -->
        <div class="carousel-main-card">
            <div class="card-header">
                <h3>
                    <i class="fas fa-images"></i>
                    Homepage Carousel
                </h3>
                <div>
                    <a href="<?php echo base_url('admin/carousel/add'); ?>" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus"></i> Add New Slide
                    </a>
                </div>
            </div>

            <div class="card-body">
                <?php if (!empty($carousel_items)): ?>
                    
                    <!-- Drag & Drop Info -->
                    <div class="alert alert-info alert-dismissible fade show" role="alert">
                        <i class="fas fa-info-circle"></i>
                        <strong>Tip:</strong> Drag and drop slides to reorder them. The order shown here is the order they'll appear on your homepage.
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>

                    <!-- Carousel Items List (Sortable) -->
                    <div id="sortable-carousel">
                        <?php foreach ($carousel_items as $item): ?>
                            <div class="sortable-item" data-id="<?php echo $item->id; ?>">
                                <div class="carousel-item-card">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <!-- Drag Handle -->
                                            <div class="col-auto">
                                                <div class="drag-handle">
                                                    <i class="fas fa-grip-vertical fa-2x"></i>
                                                </div>
                                            </div>

                                            <!-- Media Preview -->
                                            <div class="col-md-3 col-sm-4">
                                                <div class="media-preview">
                                                    <?php if ($item->media_type === 'image' && !empty($item->media_path)): ?>
                                                        <img src="<?php echo base_url('uploads/carousel/' . $item->media_path); ?>" 
                                                             alt="<?php echo htmlspecialchars($item->title); ?>">
                                                    <?php elseif ($item->media_type === 'video' && !empty($item->media_path)): ?>
                                                        <div class="video-placeholder">
                                                            <i class="fas fa-play-circle fa-3x"></i>
                                                        </div>
                                                    <?php else: ?>
                                                        <div class="image-placeholder">
                                                            <i class="fas fa-image fa-3x"></i>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                            <!-- Slide Details -->
                                            <div class="col-md-6 col-sm-12">
                                                <div class="slide-details">
                                                    <!-- Status & Type Badges -->
                                                    <div class="mb-3">
                                                        <?php
                                                        $status_badge = $item->status === 'active' 
                                                            ? '<span class="badge badge-success">Active</span>' 
                                                            : '<span class="badge badge-secondary">Inactive</span>';
                                                        echo $status_badge;
                                                        ?>

                                                        <?php
                                                        $type_badge = $item->media_type === 'image' 
                                                            ? '<span class="badge badge-info ml-1"><i class="fas fa-image"></i> Image</span>' 
                                                            : '<span class="badge badge-warning ml-1"><i class="fas fa-video"></i> Video</span>';
                                                        echo $type_badge;
                                                        ?>

                                                        <span class="badge badge-light ml-1">
                                                            <i class="fas fa-sort"></i> Order: <?php echo $item->display_order; ?>
                                                        </span>
                                                    </div>

                                                    <!-- Title -->
                                                    <h5 class="slide-title">
                                                        <?php echo htmlspecialchars($item->title); ?>
                                                    </h5>

                                                    <!-- Subtitle -->
                                                    <?php if (!empty($item->subtitle)): ?>
                                                        <p class="slide-subtitle">
                                                            <?php echo htmlspecialchars($item->subtitle); ?>
                                                        </p>
                                                    <?php endif; ?>

                                                    <!-- Description -->
                                                    <?php if (!empty($item->description)): ?>
                                                        <p class="slide-description">
                                                            <?php echo htmlspecialchars(character_limiter($item->description, 100)); ?>
                                                        </p>
                                                    <?php endif; ?>

                                                    <!-- Link -->
                                                    <?php if (!empty($item->link_url)): ?>
                                                        <p class="slide-link">
                                                            <i class="fas fa-link"></i>
                                                            <strong>Button:</strong> 
                                                            <?php echo htmlspecialchars($item->link_text ?: 'Learn More'); ?> →
                                                            <code><?php echo htmlspecialchars(character_limiter($item->link_url, 40)); ?></code>
                                                        </p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                            <!-- Actions -->
                                            <div class="col-md-2 col-sm-12">
                                                <div class="action-buttons">
                                                    <a href="<?php echo base_url('admin/carousel/edit/' . $item->id); ?>" 
                                                       class="btn btn-sm btn-primary">
                                                        <i class="fas fa-edit"></i> Edit
                                                    </a>
                                                    <a href="<?php echo base_url('admin/carousel/delete/' . $item->id); ?>" 
                                                       class="btn btn-sm btn-danger"
                                                       onclick="return confirm('Are you sure you want to delete this slide? This will also delete the media file.');">
                                                        <i class="fas fa-trash"></i> Delete
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>

                <?php else: ?>
                    <!-- Empty State -->
                    <div class="empty-state">
                        <i class="fas fa-images fa-4x"></i>
                        <h5>No Carousel Slides Yet</h5>
                        <p>Your homepage carousel is empty. Add your first slide to get started!</p>
                        <a href="<?php echo base_url('admin/carousel/add'); ?>" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Add Your First Slide
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- jQuery UI for Drag & Drop (if not already loaded) -->
<link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>

<!-- JavaScript for Drag & Drop Ordering -->
<script>
$(document).ready(function() {
    // Make carousel items sortable
    $('#sortable-carousel').sortable({
        handle: '.drag-handle',
        placeholder: 'sortable-placeholder',
        tolerance: 'pointer',
        cursor: 'move',
        update: function(event, ui) {
            // Get new order
            var order = [];
            $('.sortable-item').each(function(index) {
                order.push($(this).data('id'));
            });

            // Send AJAX request to update order
            $.ajax({
                url: '<?php echo base_url("admin/carousel/update_order"); ?>',
                method: 'POST',
                data: { order: order },
                success: function(response) {
                    showNotification('success', 'Slide order updated successfully!');
                },
                error: function() {
                    showNotification('error', 'Failed to update slide order.');
                }
            });
        }
    });

    // Disable text selection while dragging
    $('#sortable-carousel').disableSelection();
});

// Notification function
function showNotification(type, message) {
    var alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
    var icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';
    
    var notification = $('<div class="alert ' + alertClass + ' alert-dismissible fade show notification-toast" role="alert">' +
        '<i class="fas ' + icon + '"></i> ' + message +
        '<button type="button" class="close" data-dismiss="alert">' +
        '<span>&times;</span>' +
        '</button>' +
        '</div>');
    
    $('body').append(notification);
    
    setTimeout(function() {
        notification.fadeOut(function() {
            $(this).remove();
        });
    }, 3000);
}
</script>