<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-0">Consultation Calendar</h2>
        <p class="text-muted mb-0">View scheduled appointments</p>
    </div>
    <div>
        <a href="<?php echo base_url('admin/consultations'); ?>" class="btn btn-outline-secondary">
            <i class="fas fa-list"></i> List View
        </a>
    </div>
</div>

<!-- Calendar Info -->
<div class="alert alert-info mb-4">
    <i class="fas fa-info-circle"></i> Showing all consultations with status: <strong>Scheduled</strong> and future dates.
</div>

<!-- Upcoming Scheduled Consultations -->
<?php if(!empty($scheduled_consultations)): ?>
<div class="table-card">
    <h5 class="mb-3">
        <i class="fas fa-calendar-alt"></i> Upcoming Scheduled Consultations
        <span class="badge bg-primary"><?php echo count($scheduled_consultations); ?></span>
    </h5>
    
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Date & Time</th>
                    <th>Client</th>
                    <th>Contact</th>
                    <th>Subject</th>
                    <th>Type</th>
                    <th>Assigned To</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $current_date = '';
                foreach($scheduled_consultations as $consultation): 
                    $consultation_date = date('Y-m-d', strtotime($consultation->scheduled_date));
                    
                    // Add date separator
                    if($consultation_date != $current_date):
                        $current_date = $consultation_date;
                ?>
                <tr class="table-light">
                    <td colspan="7">
                        <strong>
                            <i class="fas fa-calendar-day"></i> 
                            <?php echo date('l, F j, Y', strtotime($consultation->scheduled_date)); ?>
                        </strong>
                    </td>
                </tr>
                <?php endif; ?>
                
                <tr>
                    <td>
                        <strong><?php echo date('g:i A', strtotime($consultation->scheduled_date)); ?></strong>
                        <br>
                        <small class="text-muted">
                            <?php 
                            $days_until = floor((strtotime($consultation->scheduled_date) - time()) / 86400);
                            if($days_until == 0) {
                                echo '<span class="badge bg-danger">Today</span>';
                            } elseif($days_until == 1) {
                                echo '<span class="badge bg-warning">Tomorrow</span>';
                            } else {
                                echo "In $days_until days";
                            }
                            ?>
                        </small>
                    </td>
                    <td>
                        <strong><?php echo $consultation->full_name; ?></strong>
                        <?php if($consultation->organization): ?>
                            <br><small class="text-muted"><?php echo $consultation->organization; ?></small>
                        <?php endif; ?>
                    </td>
                    <td>
                        <small>
                            <i class="fas fa-envelope"></i> <?php echo character_limiter($consultation->email, 20); ?><br>
                            <i class="fas fa-phone"></i> <?php echo $consultation->phone; ?>
                        </small>
                    </td>
                    <td><?php echo character_limiter($consultation->subject, 40); ?></td>
                    <td>
                        <span class="badge bg-secondary">
                            <?php echo ucfirst($consultation->consultation_type); ?>
                        </span>
                    </td>
                    <td>
                        <?php if($consultation->assigned_to_name): ?>
                            <span class="badge bg-primary"><?php echo $consultation->assigned_to_name; ?></span>
                        <?php else: ?>
                            <span class="text-muted">Unassigned</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="<?php echo base_url('admin/consultations/view/' . $consultation->id); ?>" 
                           class="btn btn-sm btn-outline-primary">
                            <i class="fas fa-eye"></i> View
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php else: ?>
<!-- Empty State -->
<div class="table-card">
    <div class="text-center py-5">
        <i class="fas fa-calendar-times fa-4x text-muted mb-3"></i>
        <h4>No Scheduled Consultations</h4>
        <p class="text-muted">Schedule consultations to see them appear here</p>
        <a href="<?php echo base_url('admin/consultations?status=new'); ?>" class="btn btn-primary">
            <i class="fas fa-list"></i> View New Requests
        </a>
    </div>
</div>
<?php endif; ?>

<!-- Quick Stats -->
<div class="row mt-4">
    <div class="col-md-4 mb-3">
        <div class="table-card text-center">
            <h3 class="mb-2 text-danger">
                <?php 
                $today_count = 0;
                if(!empty($scheduled_consultations)) {
                    foreach($scheduled_consultations as $c) {
                        if(date('Y-m-d', strtotime($c->scheduled_date)) == date('Y-m-d')) {
                            $today_count++;
                        }
                    }
                }
                echo $today_count;
                ?>
            </h3>
            <p class="mb-0 text-muted">Today's Appointments</p>
        </div>
    </div>
    <div class="col-md-4 mb-3">
        <div class="table-card text-center">
            <h3 class="mb-2 text-warning">
                <?php 
                $week_count = 0;
                if(!empty($scheduled_consultations)) {
                    $week_end = strtotime('+7 days');
                    foreach($scheduled_consultations as $c) {
                        if(strtotime($c->scheduled_date) <= $week_end) {
                            $week_count++;
                        }
                    }
                }
                echo $week_count;
                ?>
            </h3>
            <p class="mb-0 text-muted">This Week</p>
        </div>
    </div>
    <div class="col-md-4 mb-3">
        <div class="table-card text-center">
            <h3 class="mb-2 text-info">
                <?php echo !empty($scheduled_consultations) ? count($scheduled_consultations) : 0; ?>
            </h3>
            <p class="mb-0 text-muted">All Upcoming</p>
        </div>
    </div>
</div>