<style>
    :root {
        --primary-color: #f26124;
        --secondary-color: #231f20;
        --success-green: #28a745;
        --info-blue: #17a2b8;
        --danger-red: #dc3545;
        --warning-yellow: #ffc107;
    }

    body {
        background: #f4f6f9;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    /* Spacing Utilities */
    .mb-0 {
        margin-bottom: 0 !important;
    }

    .mb-2 {
        margin-bottom: 0.5rem !important;
    }

    .mb-3 {
        margin-bottom: 1rem !important;
    }

    .mb-4 {
        margin-bottom: 1.5rem !important;
    }

    .ps-0 {
        padding-left: 0 !important;
    }

    .p-3 {
        padding: 1rem !important;
    }

    /* Grid */
    .row {
        display: flex;
        flex-wrap: wrap;
        gap: 24px;
    }

    .col-lg-4 {
        flex: 0 0 calc(33.333% - 16px);
    }

    .col-lg-8 {
        flex: 0 0 calc(66.666% - 16px);
    }

    .col-md-6 {
        flex: 0 0 calc(50% - 12px);
    }

    /* Text Utilities */
    .text-muted {
        color: #6c757d !important;
    }

    .d-grid {
        display: grid;
    }

    .gap-2 {
        gap: 0.5rem;
    }

    h2 {
        font-size: 28px;
        font-weight: 700;
        color: #231f20;
        margin: 8px 0;
    }

    h5 {
        font-size: 16px;
        font-weight: 700;
        color: #231f20;
        margin: 0;
    }

    p {
        font-size: 14px;
        color: #495057;
        margin: 4px 0 0 0;
    }

    small {
        font-size: 12px;
    }

    strong {
        font-weight: 700;
    }

    label {
        display: block;
        font-size: 12px;
        color: #6c757d;
        font-weight: 600;
        margin-bottom: 4px;
    }

    /* Links */
    a {
        color: var(--primary-color);
        text-decoration: none;
        transition: all 0.2s ease;
    }

    a:hover {
        color: #d95520;
    }

    /* Card Styling */
    .table-card {
        background: #fff;
        border-radius: 12px;
        padding: 28px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid #e9ecef;
        transition: all 0.3s ease;
    }

    .table-card:hover {
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.12);
    }

    /* Badges */
    .badge {
        font-size: 11px;
        font-weight: 700;
        padding: 6px 10px;
        border-radius: 12px;
        display: inline-block;
        white-space: nowrap;
    }

    .bg-secondary {
        background-color: #6c757d !important;
        color: #fff;
    }

    .bg-primary {
        background-color: var(--primary-color) !important;
        color: #fff;
    }

    /* Horizontal Rule */
    hr {
        border: none;
        border-top: 1px solid #e9ecef;
        margin: 1.5rem 0;
    }

    /* Alerts */
    .alert {
        padding: 16px;
        border-radius: 6px;
        border: 1px solid;
        margin-bottom: 1rem;
        display: flex;
        align-items: flex-start;
        gap: 12px;
    }

    .alert-success {
        background: #d4edda;
        border-color: #c3e6cb;
        color: #155724;
    }

    .alert-danger {
        background: #f8d7da;
        border-color: #f5c6cb;
        color: #721c24;
    }

    .alert-warning {
        background: #fff3cd;
        border-color: #ffeaa7;
        color: #856404;
    }

    .alert-info {
        background: #d1ecf1;
        border-color: #bee5eb;
        color: #0c5460;
    }

    .alert-light {
        background: #f8f9fa;
        border-color: #e9ecef;
        color: #495057;
    }

    .alert-dismissible {
        position: relative;
    }

    .btn-close {
        position: absolute;
        top: 16px;
        right: 16px;
        background: transparent;
        border: none;
        font-size: 20px;
        color: inherit;
        opacity: 0.7;
        cursor: pointer;
        transition: opacity 0.2s;
    }

    .btn-close:hover {
        opacity: 1;
    }

    .alert i {
        margin-right: 4px;
    }

    /* Tabs */
    .nav-tabs {
        border-bottom: 2px solid #e9ecef;
        display: flex;
        gap: 8px;
        flex-wrap: wrap;
    }

    .nav-item {
        margin: 0;
    }

    .nav-link {
        color: #6c757d;
        border: none;
        padding: 12px 16px;
        font-size: 14px;
        font-weight: 600;
        border-bottom: 3px solid transparent;
        transition: all 0.3s ease;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        text-decoration: none;
        background: none;
    }

    .nav-link:hover {
        color: var(--primary-color);
        border-bottom-color: var(--primary-color);
    }

    .nav-link.active {
        color: var(--primary-color);
        border-bottom-color: var(--primary-color);
        background: transparent;
    }

    .tab-content {
        border-top: 1px solid #e9ecef;
    }

    .tab-pane {
        display: none;
    }

    .tab-pane.show.active {
        display: block;
    }

    /* Form Controls */
    .form-label {
        font-size: 14px;
        font-weight: 600;
        color: #231f20;
        margin-bottom: 8px;
        display: block;
    }

    .form-control,
    .form-select {
        display: block;
        width: 100%;
        padding: 10px 12px;
        font-size: 14px;
        color: #495057;
        background-color: #fff;
        border: 1px solid #dee2e6;
        border-radius: 6px;
        transition: all 0.3s ease;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .form-control:focus,
    .form-select:focus {
        color: #495057;
        background-color: #fff;
        border-color: var(--primary-color);
        outline: 0;
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
    }

    .form-control::placeholder {
        color: #adb5bd;
    }

    textarea.form-control {
        resize: vertical;
        min-height: 100px;
    }

    /* Buttons */
    .btn {
        font-size: 14px;
        font-weight: 600;
        padding: 10px 16px;
        border-radius: 6px;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-primary {
        background: var(--primary-color);
        color: #fff;
    }

    .btn-primary:hover {
        background: #d95520;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(242, 97, 36, 0.3);
    }

    .btn-outline-secondary {
        background: transparent;
        color: #231f20;
        border: 1px solid #dee2e6;
    }

    .btn-outline-secondary:hover {
        background: #f8f9fa;
        border-color: #231f20;
        transform: translateY(-1px);
    }

    .btn-outline-danger {
        background: transparent;
        color: var(--danger-red);
        border: 1px solid var(--danger-red);
    }

    .btn-outline-danger:hover {
        background: var(--danger-red);
        color: #fff;
        transform: translateY(-1px);
    }

    .btn-link {
        color: var(--primary-color);
        text-decoration: none;
        font-weight: 600;
        font-size: 14px;
        background: none;
        border: none;
        padding: 0;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-link:hover {
        color: #d95520;
        text-decoration: underline;
    }

    .btn-sm {
        padding: 6px 12px;
        font-size: 12px;
    }

    /* Icons */
    i {
        margin-right: 4px;
    }

    /* Responsive */
    @media (max-width: 992px) {
        .row {
            gap: 16px;
        }

        .col-lg-4 {
            flex: 0 0 100%;
        }

        .col-lg-8 {
            flex: 0 0 100%;
        }
    }

    @media (max-width: 768px) {
        .row {
            gap: 12px;
        }

        .col-md-6 {
            flex: 0 0 100%;
        }

        .table-card {
            padding: 18px;
        }

        h2 {
            font-size: 24px;
        }

        h5 {
            font-size: 14px;
        }

        .d-grid {
            grid-template-columns: 1fr;
        }

        .btn {
            width: 100%;
            justify-content: center;
        }

        .form-control,
        .form-select {
            font-size: 14px;
            padding: 10px;
        }

        .nav-link {
            padding: 10px 12px;
            font-size: 12px;
        }

        .btn-sm {
            width: auto;
        }

        .alert {
            font-size: 13px;
        }

        .btn-close {
            top: 12px;
            right: 12px;
        }
    }

    @media (max-width: 576px) {
        .table-card {
            padding: 16px;
        }

        h2 {
            font-size: 20px;
        }

        h5 {
            font-size: 13px;
        }

        p {
            font-size: 13px;
        }

        small {
            font-size: 11px;
        }

        .form-control,
        .form-select {
            padding: 8px 10px;
            font-size: 13px;
        }

        .btn {
            padding: 8px 12px;
            font-size: 12px;
        }

        label {
            font-size: 11px;
        }

        .nav-link {
            padding: 8px 10px;
            font-size: 11px;
        }

        .p-3 {
            padding: 0.75rem !important;
        }
    }
</style>

<!-- Page Header -->
<div class="mb-4">
    <a href="<?php echo base_url('admin/consultations'); ?>" class="btn btn-link ps-0">
        <i class="fas fa-arrow-left"></i> Back to Consultations
    </a>
    <h2>Consultation Request #<?php echo $consultation->id; ?></h2>
    <p class="text-muted mb-0"><?php echo $consultation->full_name; ?></p>
</div>

<!-- Flash Messages -->
<?php if ($this->session->flashdata('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle"></i> <?php echo $this->session->flashdata('success'); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if ($this->session->flashdata('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle"></i> <?php echo $this->session->flashdata('error'); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if ($this->session->flashdata('warning')): ?>
    <div class="alert alert-warning alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-triangle"></i> <?php echo $this->session->flashdata('warning'); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="row">
    <!-- Left Column - Contact & Actions -->
    <div class="col-lg-4 mb-4">
        <!-- Contact Card -->
        <div class="table-card mb-3">
            <h5 class="mb-3"><i class="fas fa-user"></i> Contact Information</h5>
            
            <div class="mb-3">
                <label>Full Name</label>
                <p class="mb-0"><strong><?php echo $consultation->full_name; ?></strong></p>
            </div>
            
            <div class="mb-3">
                <label>Email</label>
                <p class="mb-0">
                    <a href="mailto:<?php echo $consultation->email; ?>">
                        <?php echo $consultation->email; ?>
                    </a>
                </p>
            </div>
            
            <div class="mb-3">
                <label>Phone</label>
                <p class="mb-0">
                    <a href="tel:<?php echo $consultation->phone; ?>">
                        <?php echo $consultation->phone; ?>
                    </a>
                </p>
            </div>
            
            <?php if($consultation->organization): ?>
            <div class="mb-3">
                <label>Organization</label>
                <p class="mb-0"><?php echo $consultation->organization; ?></p>
            </div>
            <?php endif; ?>
            
            <div class="mb-3">
                <label>Type</label>
                <p class="mb-0">
                    <span class="badge bg-secondary"><?php echo ucfirst($consultation->consultation_type); ?></span>
                </p>
            </div>
            
            <hr>
            
            <div class="d-grid gap-2">
                <a href="mailto:<?php echo $consultation->email; ?>" class="btn btn-primary">
                    <i class="fas fa-envelope"></i> Send Email
                </a>
                <a href="tel:<?php echo $consultation->phone; ?>" class="btn btn-outline-secondary">
                    <i class="fas fa-phone"></i> Call
                </a>
            </div>
        </div>
        
        <!-- Status Card -->
        <div class="table-card mb-3">
            <h5 class="mb-3"><i class="fas fa-info-circle"></i> Status & Timeline</h5>
            
            <div class="mb-3">
                <label>Current Status</label>
                <p class="mb-0"><?php echo get_status_badge($consultation->status); ?></p>
            </div>
            
            <div class="mb-3">
                <label>Submitted</label>
                <p class="mb-0">
                    <?php echo format_datetime($consultation->created_at); ?><br>
                    <small class="text-muted">(<?php echo time_ago($consultation->created_at); ?>)</small>
                </p>
            </div>
            
            <?php if($consultation->scheduled_date): ?>
            <div class="mb-3">
                <label>Scheduled For</label>
                <p class="mb-0">
                    <strong><?php echo format_datetime($consultation->scheduled_date); ?></strong>
                </p>
            </div>
            <?php endif; ?>
            
            <?php if($consultation->assigned_to_name): ?>
            <div class="mb-3">
                <label>Assigned To</label>
                <p class="mb-0">
                    <span class="badge bg-primary"><?php echo $consultation->assigned_to_name; ?></span>
                </p>
            </div>
            <?php endif; ?>
        </div>
        
        <!-- Quick Actions -->
        <div class="table-card">
            <h5 class="mb-3"><i class="fas fa-bolt"></i> Quick Actions</h5>
            
            <div class="d-grid gap-2">
                <a href="<?php echo base_url('admin/consultations/delete/' . $consultation->id); ?>" 
                   class="btn btn-sm btn-outline-danger"
                   onclick="return confirm('Delete this consultation request?');">
                    <i class="fas fa-trash"></i> Delete Request
                </a>
            </div>
        </div>
    </div>
    
    <!-- Right Column - Details & Actions -->
    <div class="col-lg-8">
        <!-- Consultation Details -->
        <div class="table-card mb-3">
            <h5 class="mb-3"><i class="fas fa-file-alt"></i> Consultation Details</h5>
            
            <div class="mb-3">
                <label>Subject</label>
                <p class="mb-0"><strong><?php echo $consultation->subject; ?></strong></p>
            </div>
            
            <div class="mb-3">
                <label>Message</label>
                <div class="alert alert-light">
                    <?php echo nl2br($consultation->message); ?>
                </div>
            </div>
            
            <div class="row">
                <?php if($consultation->preferred_date): ?>
                <div class="col-md-6 mb-3">
                    <label>Preferred Date</label>
                    <p class="mb-0">
                        <i class="fas fa-calendar"></i> <?php echo format_date($consultation->preferred_date); ?>
                    </p>
                </div>
                <?php endif; ?>
                
                <?php if($consultation->preferred_time): ?>
                <div class="col-md-6 mb-3">
                    <label>Preferred Time</label>
                    <p class="mb-0">
                        <i class="fas fa-clock"></i> <?php echo date('g:i A', strtotime($consultation->preferred_time)); ?>
                    </p>
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Update Status & Schedule -->
        <div class="table-card mb-3">
            <h5 class="mb-3"><i class="fas fa-tasks"></i> Manage Consultation</h5>
            
            <!-- Tabs -->
            <ul class="nav nav-tabs" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" data-bs-toggle="tab" href="#updateStatus">
                        <i class="fas fa-edit"></i> Update Status
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="tab" href="#scheduleTab">
                        <i class="fas fa-calendar-plus"></i> Schedule Appointment
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="tab" href="#assignTab">
                        <i class="fas fa-user-plus"></i> Assign Admin
                    </a>
                </li>
            </ul>
            
            <div class="tab-content p-3">
                <!-- Update Status Tab -->
                <div class="tab-pane fade show active" id="updateStatus">
                    <?php echo form_open('admin/consultations/update/' . $consultation->id); ?>
                    <input type="hidden" name="action" value="update_status">
                        
                        <div class="mb-3">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-select" id="status" name="status" required>
                                <option value="new" <?php echo ($consultation->status == 'new') ? 'selected' : ''; ?>>New</option>
                                <option value="contacted" <?php echo ($consultation->status == 'contacted') ? 'selected' : ''; ?>>Contacted</option>
                                <option value="scheduled" <?php echo ($consultation->status == 'scheduled') ? 'selected' : ''; ?>>Scheduled</option>
                                <option value="completed" <?php echo ($consultation->status == 'completed') ? 'selected' : ''; ?>>Completed</option>
                                <option value="cancelled" <?php echo ($consultation->status == 'cancelled') ? 'selected' : ''; ?>>Cancelled</option>
                            </select>
                        </div>
                        
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Update Status
                        </button>
                    </form>
                </div>
                
                <!-- Schedule Appointment Tab -->
                <div class="tab-pane fade" id="scheduleTab">
                    <?php echo form_open('admin/consultations/update/' . $consultation->id); ?>
                   <input type="hidden" name="action" value="schedule">
                        
                        <div class="mb-3">
                            <label for="scheduled_date" class="form-label">Scheduled Date & Time</label>
                            <input type="datetime-local" 
                                   class="form-control" 
                                   id="scheduled_date" 
                                   name="scheduled_date" 
                                   value="<?php echo $consultation->scheduled_date ? date('Y-m-d\TH:i', strtotime($consultation->scheduled_date)) : ''; ?>"
                                   required>
                        </div>
                        
                        <div class="mb-3">
                            <label for="assigned_to_schedule" class="form-label">Assign To (Optional)</label>
                            <select class="form-select" id="assigned_to_schedule" name="assigned_to">
                                <option value="">Select Admin</option>
                                <?php foreach($admins as $admin): ?>
                                    <option value="<?php echo $admin->id; ?>" 
                                            <?php echo ($consultation->assigned_to == $admin->id) ? 'selected' : ''; ?>>
                                        <?php echo $admin->full_name; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i> An email will be sent to the client with the scheduled date and time.
                        </div>
                        
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-calendar-check"></i> Schedule Consultation
                        </button>
                    </form>
                </div>
                
                <!-- Assign Admin Tab -->
                <div class="tab-pane fade" id="assignTab">
                    <?php echo form_open('admin/consultations/update/' . $consultation->id); ?>
                     <input type="hidden" name="action" value="assign">
                        
                        <div class="mb-3">
                            <label for="assigned_to" class="form-label">Assign To</label>
                            <select class="form-select" id="assigned_to" name="assigned_to" required>
                                <option value="">Select Admin</option>
                                <?php foreach($admins as $admin): ?>
                                    <option value="<?php echo $admin->id; ?>" 
                                            <?php echo ($consultation->assigned_to == $admin->id) ? 'selected' : ''; ?>>
                                        <?php echo $admin->full_name; ?> (<?php echo $admin->role; ?>)
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-user-check"></i> Assign Consultation
                        </button>
                    </form>
                </div>
            </div>
        </div>
        
        <!-- Admin Notes -->
        <div class="table-card">
            <h5 class="mb-3"><i class="fas fa-sticky-note"></i> Admin Notes</h5>
            
           <?php echo form_open('admin/consultations/update/' . $consultation->id); ?>
                <input type="hidden" name="action" value="update_notes">
                
                <div class="mb-3">
                    <textarea class="form-control" 
                              name="notes" 
                              rows="4"
                              placeholder="Add internal notes about this consultation (not visible to client)..."><?php echo $consultation->notes; ?></textarea>
                </div>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Save Notes
                </button>
            </form>
        </div>
    </div>
</div>