<style>
    :root {
        --primary-color: #f26124;
        --secondary-color: #231f20;
        --success-green: #28a745;
        --info-blue: #17a2b8;
        --danger-red: #dc3545;
        --warning-yellow: #ffc107;
    }

    body {
        background: #f4f6f9;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    /* Dashboard Container */
    .dashboard-container {
        background: #f4f6f9;
    }

    /* Stats Card - Keep Original Size */
    .stats-card {
        background: linear-gradient(135deg, #fff 0%, #f8f9fa 100%);
        border-radius: 12px;
        padding: 24px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid #e9ecef;
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
        height: 100%;
    }

    .stats-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: var(--primary-color);
    }

    .stats-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.12);
        border-color: var(--primary-color);
    }

    .stats-card p {
        font-size: 13px;
        font-weight: 600;
        color: #6c757d;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 8px;
    }

    .stats-card h3 {
        font-size: 36px;
        font-weight: 700;
        color: #231f20;
        margin: 10px 0;
    }

    .stats-card small {
        font-size: 12px;
        color: #adb5bd;
    }

    .stats-card .btn {
        margin-top: 16px;
        font-size: 12px;
        font-weight: 600;
        transition: all 0.3s ease;
    }

    .stats-card .btn:hover {
        transform: translateX(2px);
    }

    .stats-card i {
        font-size: 48px;
        opacity: 0.25;
        transition: all 0.3s ease;
    }

    .stats-card:hover i {
        opacity: 0.35;
        transform: scale(1.1);
    }

    /* Table Card */
    .table-card {
        background: #fff;
        border-radius: 12px;
        padding: 28px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid #e9ecef;
        transition: all 0.3s ease;
    }

    .table-card:hover {
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.12);
    }

    .table-card h5 {
        font-size: 16px;
        font-weight: 700;
        color: #231f20;
        margin-bottom: 20px;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .table-card h5 i {
        color: var(--primary-color);
    }

    /* List Group */
    .list-group-item {
        border: none;
        border-bottom: 1px solid #f0f0f0;
        padding: 14px 0;
        background: transparent;
        font-size: 14px;
        color: #495057;
    }

    .list-group-item:last-child {
        border-bottom: none;
    }

    .list-group-item-action {
        color: #495057;
        transition: all 0.3s ease;
        padding: 12px;
        border-radius: 6px;
        margin-bottom: 6px;
    }

    .list-group-item-action:hover {
        background: #f8f9fa;
        color: var(--primary-color);
        transform: translateX(2px);
    }

    .list-group-item-action h6 {
        font-size: 14px;
        font-weight: 700;
        color: #231f20;
        margin-bottom: 4px;
    }

    .list-group-item-action small {
        font-size: 11px;
        color: #adb5bd;
    }

    /* Badges */
    .badge {
        font-size: 12px;
        font-weight: 700;
        padding: 6px 12px;
        border-radius: 20px;
    }

    /* Table */
    .table {
        margin-bottom: 0;
    }

    .table thead th {
        font-size: 13px;
        font-weight: 700;
        color: #231f20;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        border: none;
        border-bottom: 2px solid #e9ecef;
        padding: 14px 12px;
        background: transparent;
    }

    .table tbody td {
        font-size: 14px;
        color: #495057;
        padding: 12px;
        border: none;
        border-bottom: 1px solid #f0f0f0;
        vertical-align: middle;
    }

    .table tbody tr:hover {
        background: #f8f9fa;
    }

    /* Buttons */
    .btn-sm {
        font-size: 12px;
        font-weight: 600;
        transition: all 0.3s ease;
    }

    .btn-outline-primary:hover {
        transform: translateY(-1px);
    }

    .btn-outline-success:hover {
        transform: translateY(-1px);
    }

    .btn-outline-secondary:hover {
        transform: translateY(-1px);
    }

    .btn-outline-danger:hover {
        transform: translateY(-1px);
    }

    .btn-link {
        color: var(--primary-color);
        text-decoration: none;
        font-weight: 600;
        font-size: 12px;
    }

    .btn-link:hover {
        color: #d95520;
    }

    /* Quick Stats List */
    .quick-stats-list .list-group-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 12px 0;
    }

    .quick-stats-list .list-group-item i {
        margin-right: 8px;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .stats-card {
            padding: 18px;
        }

        .stats-card h3 {
            font-size: 28px;
        }

        .stats-card i {
            font-size: 36px;
        }

        .table-card {
            padding: 18px;
        }

        .table-card h5 {
            font-size: 14px;
            margin-bottom: 16px;
        }

        .table thead th {
            font-size: 11px;
            padding: 10px 8px;
        }

        .table tbody td {
            font-size: 12px;
            padding: 10px 8px;
        }
    }

    @media (max-width: 576px) {
        .stats-card {
            padding: 16px;
        }

        .stats-card h3 {
            font-size: 24px;
        }

        .stats-card i {
            font-size: 32px;
        }

        .table-card {
            padding: 16px;
        }

        .table-responsive {
            font-size: 12px;
        }
    }
</style>

<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/4.4.0/chart.umd.js"></script>

<div class="dashboard-container py-2">
    <!-- Statistics Cards Row -->
    <div class="row mb-4">
        <!-- Blog Posts Card -->
        <div class="col-xl-3 col-md-6 mb-3">
            <div class="stats-card">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="mb-1">Blog Posts</p>
                        <h3 class="mb-2"><?php echo $stats['published_posts']; ?></h3>
                        <small><?php echo $stats['draft_posts']; ?> drafts</small>
                        <div>
                            <a href="<?php echo base_url('admin/blog'); ?>" class="btn btn-sm btn-outline-primary mt-3">Manage Posts</a>
                        </div>
                    </div>
                    <i class="fas fa-newspaper" style="color: #f26124;"></i>
                </div>
            </div>
        </div>

        <!-- Volunteers Card -->
        <div class="col-xl-3 col-md-6 mb-3">
            <div class="stats-card" style="border-top-color: #28a745;">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="mb-1">Volunteers</p>
                        <h3 class="mb-2"><?php echo $stats['active_volunteers']; ?></h3>
                        <?php if($stats['pending_volunteers'] > 0): ?>
                            <small class="text-warning"><i class="fas fa-clock"></i> <?php echo $stats['pending_volunteers']; ?> pending</small>
                        <?php else: ?>
                            <small>All reviewed</small>
                        <?php endif; ?>
                        <div>
                            <a href="<?php echo base_url('admin/volunteers'); ?>" class="btn btn-sm btn-outline-success mt-3">View Applications</a>
                        </div>
                    </div>
                    <i class="fas fa-users" style="color: #28a745;"></i>
                </div>
            </div>
        </div>

        <!-- Consultations Card -->
        <div class="col-xl-3 col-md-6 mb-3">
            <div class="stats-card" style="border-top-color: #8105bf;">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="mb-1">Consultations</p>
                        <h3 class="mb-2"><?php echo $stats['scheduled_consultations']; ?></h3>
                        <?php if($stats['new_consultations'] > 0): ?>
                            <small class="text-info"><i class="fas fa-star"></i> <?php echo $stats['new_consultations']; ?> new</small>
                        <?php else: ?>
                            <small>Up to date</small>
                        <?php endif; ?>
                        <div>
                            <a href="<?php echo base_url('admin/consultations'); ?>" class="btn btn-sm btn-outline-secondary mt-3">Manage Bookings</a>
                        </div>
                    </div>
                    <i class="fas fa-calendar-check" style="color: #8105bf;"></i>
                </div>
            </div>
        </div>

        <!-- Messages Card -->
        <div class="col-xl-3 col-md-6 mb-3">
            <div class="stats-card" style="border-top-color: #dc3545;">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="mb-1">Messages</p>
                        <h3 class="mb-2"><?php echo $stats['total_messages']; ?></h3>
                        <?php if($stats['unread_messages'] > 0): ?>
                            <small class="text-danger"><i class="fas fa-envelope"></i> <?php echo $stats['unread_messages']; ?> unread</small>
                        <?php else: ?>
                            <small>All read</small>
                        <?php endif; ?>
                        <div>
                            <a href="<?php echo base_url('admin/messages'); ?>" class="btn btn-sm btn-outline-danger mt-3">View Messages</a>
                        </div>
                    </div>
                    <i class="fas fa-envelope" style="color: #dc3545;"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts and Quick Stats Row -->
    <div class="row mb-4">
        <!-- Monthly Statistics Chart -->
        <div class="col-lg-8 mb-3">
            <div class="table-card">
                <h5><i class="fas fa-chart-line"></i> Monthly Statistics (Last 6 Months)</h5>
                <canvas id="monthlyStatsChart" height="100"></canvas>
            </div>
        </div>

        <!-- Quick Stats -->
        <div class="col-lg-4 mb-3">
            <div class="table-card">
                <h5><i class="fas fa-info-circle"></i> Quick Stats</h5>
                <div class="list-group list-group-flush quick-stats-list">
                    <div class="list-group-item">
                        <span><i class="fas fa-chalkboard-teacher text-primary"></i> Workshops</span>
                        <span class="badge bg-primary"><?php echo $stats['upcoming_workshops']; ?></span>
                    </div>
                    <div class="list-group-item">
                        <span><i class="fas fa-handshake text-success"></i> Partners</span>
                        <span class="badge bg-success"><?php echo $stats['active_partners']; ?></span>
                    </div>
                    <div class="list-group-item">
                        <span><i class="fas fa-check-circle text-info"></i> Completed Consultations</span>
                        <span class="badge bg-info"><?php echo $stats['completed_consultations']; ?></span>
                    </div>
                    <div class="list-group-item">
                        <span><i class="fas fa-reply text-warning"></i> Replied Messages</span>
                        <span class="badge bg-warning"><?php echo $stats['replied_messages']; ?></span>
                    </div>
                </div>
                <div class="mt-3">
                    <a href="<?php echo base_url('admin/settings'); ?>" class="btn btn-sm btn-outline-secondary w-100">
                        <i class="fas fa-cog"></i> System Settings
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Activities Row -->
    <div class="row">
        <!-- Recent Consultations -->
        <div class="col-lg-4 mb-3">
            <div class="table-card">
                <h5><i class="fas fa-calendar"></i> Recent Consultations</h5>
                <?php if(!empty($recent_consultations)): ?>
                    <div class="list-group list-group-flush">
                        <?php foreach($recent_consultations as $consultation): ?>
                            <a href="<?php echo base_url('admin/consultations/view/' . $consultation->id); ?>" class="list-group-item list-group-item-action">
                                <div class="d-flex w-100 justify-content-between">
                                    <h6 class="mb-1"><?php echo character_limiter($consultation->full_name, 20); ?></h6>
                                    <small><?php echo time_ago($consultation->created_at); ?></small>
                                </div>
                                <p class="mb-1 small"><?php echo character_limiter($consultation->subject, 40); ?></p>
                                <small><?php echo get_status_badge($consultation->status); ?></small>
                            </a>
                        <?php endforeach; ?>
                    </div>
                    <div class="mt-2">
                        <a href="<?php echo base_url('admin/consultations'); ?>" class="btn btn-sm btn-link">View All →</a>
                    </div>
                <?php else: ?>
                    <p class="text-muted text-center py-3">No recent consultations</p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Recent Volunteers -->
        <div class="col-lg-4 mb-3">
            <div class="table-card">
                <h5><i class="fas fa-user-plus"></i> Recent Volunteers</h5>
                <?php if(!empty($recent_volunteers)): ?>
                    <div class="list-group list-group-flush">
                        <?php foreach($recent_volunteers as $volunteer): ?>
                            <a href="<?php echo base_url('admin/volunteers/view/' . $volunteer->id); ?>" class="list-group-item list-group-item-action">
                                <div class="d-flex w-100 justify-content-between">
                                    <h6 class="mb-1"><?php echo character_limiter($volunteer->full_name, 20); ?></h6>
                                    <small><?php echo time_ago($volunteer->application_date); ?></small>
                                </div>
                                <p class="mb-1 small"><?php echo $volunteer->occupation; ?></p>
                                <small><?php echo get_status_badge($volunteer->status); ?></small>
                            </a>
                        <?php endforeach; ?>
                    </div>
                    <div class="mt-2">
                        <a href="<?php echo base_url('admin/volunteers'); ?>" class="btn btn-sm btn-link">View All →</a>
                    </div>
                <?php else: ?>
                    <p class="text-muted text-center py-3">No recent applications</p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Recent Messages -->
        <div class="col-lg-4 mb-3">
            <div class="table-card">
                <h5><i class="fas fa-comments"></i> Recent Messages</h5>
                <?php if(!empty($recent_messages)): ?>
                    <div class="list-group list-group-flush">
                        <?php foreach($recent_messages as $message): ?>
                            <a href="<?php echo base_url('admin/messages/view/' . $message->id); ?>" class="list-group-item list-group-item-action">
                                <div class="d-flex w-100 justify-content-between">
                                    <h6 class="mb-1"><?php echo character_limiter($message->name, 20); ?></h6>
                                    <small><?php echo time_ago($message->created_at); ?></small>
                                </div>
                                <p class="mb-1 small"><?php echo character_limiter($message->subject, 40); ?></p>
                                <small><?php echo get_status_badge($message->status); ?></small>
                            </a>
                        <?php endforeach; ?>
                    </div>
                    <div class="mt-2">
                        <a href="<?php echo base_url('admin/messages'); ?>" class="btn btn-sm btn-link">View All →</a>
                    </div>
                <?php else: ?>
                    <p class="text-muted text-center py-3">No recent messages</p>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Upcoming Scheduled Consultations -->
    <?php if(!empty($upcoming_scheduled)): ?>
        <div class="row mt-4">
            <div class="col-12">
                <div class="table-card">
                    <h5><i class="fas fa-clock"></i> Upcoming Scheduled Consultations</h5>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Subject</th>
                                    <th>Scheduled Date</th>
                                    <th>Assigned To</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($upcoming_scheduled as $scheduled): ?>
                                    <tr>
                                        <td><?php echo $scheduled->full_name; ?></td>
                                        <td><?php echo character_limiter($scheduled->subject, 30); ?></td>
                                        <td><i class="fas fa-calendar"></i> <?php echo format_datetime($scheduled->scheduled_date); ?></td>
                                        <td><?php echo $scheduled->assigned_to_name ?? 'Unassigned'; ?></td>
                                        <td>
                                            <a href="<?php echo base_url('admin/consultations/view/' . $scheduled->id); ?>" class="btn btn-sm btn-outline-primary">
                                                <i class="fas fa-eye"></i> View
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<script>
    // Monthly Statistics Chart
    const ctx = document.getElementById('monthlyStatsChart');
    const monthlyData = <?php echo json_encode($monthly_stats); ?>;

    if (ctx && monthlyData && monthlyData.length > 0) {
        new Chart(ctx, {
            type: 'line',
            data: {
                labels: monthlyData.map(item => item.month),
                datasets: [
                    {
                        label: 'Volunteers',
                        data: monthlyData.map(item => item.volunteers),
                        borderColor: '#28a745',
                        backgroundColor: 'rgba(40, 167, 69, 0.1)',
                        borderWidth: 2,
                        tension: 0.4,
                        pointBackgroundColor: '#28a745',
                        pointBorderColor: '#fff',
                        pointBorderWidth: 2,
                        pointRadius: 5,
                        pointHoverRadius: 7,
                        fill: true
                    },
                    {
                        label: 'Consultations',
                        data: monthlyData.map(item => item.consultations),
                        borderColor: '#8105bf',
                        backgroundColor: 'rgba(129, 5, 191, 0.1)',
                        borderWidth: 2,
                        tension: 0.4,
                        pointBackgroundColor: '#8105bf',
                        pointBorderColor: '#fff',
                        pointBorderWidth: 2,
                        pointRadius: 5,
                        pointHoverRadius: 7,
                        fill: true
                    },
                    {
                        label: 'Messages',
                        data: monthlyData.map(item => item.messages),
                        borderColor: '#dc3545',
                        backgroundColor: 'rgba(220, 53, 69, 0.1)',
                        borderWidth: 2,
                        tension: 0.4,
                        pointBackgroundColor: '#dc3545',
                        pointBorderColor: '#fff',
                        pointBorderWidth: 2,
                        pointRadius: 5,
                        pointHoverRadius: 7,
                        fill: true
                    },
                    {
                        label: 'Blog Posts',
                        data: monthlyData.map(item => item.blog_posts),
                        borderColor: '#f26124',
                        backgroundColor: 'rgba(242, 97, 36, 0.1)',
                        borderWidth: 2,
                        tension: 0.4,
                        pointBackgroundColor: '#f26124',
                        pointBorderColor: '#fff',
                        pointBorderWidth: 2,
                        pointRadius: 5,
                        pointHoverRadius: 7,
                        fill: true
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        position: 'bottom',
                        labels: {
                            font: { size: 13, weight: '600' },
                            padding: 15,
                            usePointStyle: true
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: { precision: 0 }
                    }
                }
            }
        });
    }
</script>