<!-- Custom Kid Registration Details Styles -->
<style>
    :root {
        --primary-color: #f26124;
        --primary-hover: #d95520;
        --success-color: #1cc88a;
        --info-color: #36b9cc;
        --warning-color: #f6c23e;
        --danger-color: #dc3545;
        --dark-text: #231f20;
        --muted-text: #6c757d;
        --border-color: #e9ecef;
        --bg-light: #f8f9fa;
    }

    .registration-details-container {
        background: #f4f6f9;
        min-height: 100vh;
        padding: 20px 0;
    }

    /* Breadcrumb */
    .breadcrumb-section {
        background: #fff;
        border-radius: 8px;
        padding: 16px 24px;
        margin-bottom: 24px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
    }

    .breadcrumb-section h1 {
        font-size: 24px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0 0 12px 0;
    }

    .breadcrumb {
        background: transparent;
        padding: 0;
        margin: 0;
        font-size: 13px;
    }

    .breadcrumb li {
        display: inline;
        color: var(--muted-text);
    }

    .breadcrumb li + li:before {
        content: "›";
        padding: 0 8px;
        color: var(--muted-text);
    }

    .breadcrumb a {
        color: var(--primary-color);
        text-decoration: none;
        transition: color 0.3s ease;
    }

    .breadcrumb a:hover {
        color: var(--primary-hover);
    }

    .breadcrumb .active {
        color: var(--muted-text);
    }

    /* Details Card */
    .details-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
        overflow: hidden;
        margin-bottom: 24px;
    }

    .details-card .card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border: none;
        border-bottom: 2px solid var(--border-color);
        padding: 24px 28px;
    }

    .details-card .card-header h3 {
        font-size: 18px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .details-card .card-header h3 i {
        color: var(--primary-color);
        font-size: 20px;
    }

    .details-card .card-body {
        padding: 32px;
    }

    .details-card .card-footer {
        background: var(--bg-light);
        border-top: 2px solid var(--border-color);
        padding: 24px 28px;
    }

    /* Info Sections */
    .info-section {
        margin-bottom: 28px;
    }

    .info-section:last-child {
        margin-bottom: 0;
    }

    .section-title {
        font-size: 15px;
        font-weight: 700;
        color: var(--dark-text);
        margin-bottom: 12px;
        display: flex;
        align-items: center;
        gap: 8px;
        padding-bottom: 8px;
        border-bottom: 2px solid var(--border-color);
    }

    .section-title i {
        color: var(--primary-color);
        font-size: 16px;
    }

    .info-content {
        background: var(--bg-light);
        border-radius: 8px;
        padding: 16px 20px;
        margin-top: 12px;
    }

    .info-content p {
        margin: 0;
        line-height: 2;
        font-size: 14px;
        color: var(--dark-text);
    }

    .info-content b {
        font-weight: 700;
        color: var(--dark-text);
        min-width: 180px;
        display: inline-block;
    }

    /* Divider */
    .section-divider {
        border: 0;
        border-top: 1px solid var(--border-color);
        margin: 24px 0;
    }

    /* Status Update Form */
    .status-update-form {
        display: flex;
        align-items: center;
        gap: 12px;
        flex-wrap: wrap;
    }

    .status-update-form .form-control {
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 10px 14px;
        font-size: 14px;
        transition: all 0.3s ease;
        background: #fff;
        appearance: none;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 12px center;
        background-size: 16px 12px;
        padding-right: 36px;
        min-width: 200px;
    }

    .status-update-form .form-control:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
        outline: none;
    }

    /* Buttons */
    .btn {
        border-radius: 8px;
        padding: 11px 24px;
        font-size: 14px;
        font-weight: 600;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        text-decoration: none;
    }

    .btn-primary {
        background: var(--primary-color);
        color: #fff;
    }

    .btn-primary:hover {
        background: var(--primary-hover);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(242, 97, 36, 0.3);
        color: #fff;
        text-decoration: none;
    }

    .btn-default {
        background: #fff;
        color: var(--dark-text);
        border: 2px solid var(--border-color);
    }

    .btn-default:hover {
        background: var(--bg-light);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        color: var(--dark-text);
        text-decoration: none;
    }

    .btn i {
        font-size: 15px;
    }

    /* Info Badge */
    .info-badge {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 8px 16px;
        background: linear-gradient(135deg, rgba(54, 185, 204, 0.1) 0%, rgba(54, 185, 204, 0.05) 100%);
        border: 1px solid rgba(54, 185, 204, 0.3);
        border-radius: 8px;
        font-size: 13px;
        color: var(--info-color);
        font-weight: 600;
        margin-bottom: 16px;
    }

    .info-badge i {
        font-size: 16px;
    }

    /* Column Cards */
    .column-card {
        background: #fff;
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 20px;
        height: 100%;
    }

    /* Responsive Design */
    @media (max-width: 992px) {
        .registration-details-container {
            padding: 16px 0;
        }

        .details-card .card-header {
            padding: 20px;
        }

        .details-card .card-body {
            padding: 20px;
        }

        .details-card .card-footer {
            padding: 20px;
        }

        .breadcrumb-section h1 {
            font-size: 20px;
        }

        .status-update-form {
            flex-direction: column;
            align-items: stretch;
        }

        .status-update-form .form-control {
            width: 100%;
        }

        .status-update-form .btn {
            width: 100%;
            justify-content: center;
        }
    }

    @media (max-width: 768px) {
        .details-card .card-header h3 {
            font-size: 16px;
        }

        .column-card {
            margin-bottom: 20px;
        }

        .info-content b {
            display: block;
            margin-bottom: 4px;
        }
    }
</style>

<div class="registration-details-container">
    <div class="container-fluid">
        <!-- Breadcrumb -->
       

        <div class="row">
            <div class="col-md-12">
                <div class="details-card">
                    <div class="card-header">
                        <h3>
                            <i class="fas fa-user-circle"></i>
                            <?= htmlspecialchars($registration->first_name . ' ' . $registration->surname) ?> - Registration Details
                        </h3>
                    </div>

                    <div class="card-body">
                        <div class="info-badge">
                            <i class="fas fa-info-circle"></i>
                            <span>Registration ID: #<?= $registration->id ?> | Submitted on <?= date('d M Y', strtotime($registration->created_at)) ?></span>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="column-card">
                                    <!-- Personal Information -->
                                    <div class="info-section">
                                        <div class="section-title">
                                            <i class="fa fa-user"></i>
                                            Personal Information
                                        </div>
                                        <div class="info-content">
                                            <p>
                                                <b>Name:</b> <?= htmlspecialchars($registration->first_name . ' ' . $registration->surname) ?><br>
                                                <b>Age:</b> <?= htmlspecialchars($registration->age) ?> years old<br>
                                                <b>Gender:</b> <?= htmlspecialchars($registration->gender) ?><br>
                                                <b>Parent Name:</b> <?= htmlspecialchars($registration->parent_name) ?><br>
                                                <b>Email:</b> <?= htmlspecialchars($registration->email) ?><br>
                                                <b>Contact Number:</b> <?= htmlspecialchars($registration->contact_number) ?>
                                            </p>
                                        </div>
                                    </div>

                                    <hr class="section-divider">

                                    <!-- Location -->
                                    <div class="info-section">
                                        <div class="section-title">
                                            <i class="fa fa-map-marker"></i>
                                            Location
                                        </div>
                                        <div class="info-content">
                                            <p><?= htmlspecialchars($registration->home_location) ?></p>
                                        </div>
                                    </div>

                                    <hr class="section-divider">

                                    <!-- School Details -->
                                    <div class="info-section">
                                        <div class="section-title">
                                            <i class="fa fa-graduation-cap"></i>
                                            School Details
                                        </div>
                                        <div class="info-content">
                                            <p>
                                                <b>Current School:</b> <?= htmlspecialchars($registration->current_school ?? 'Not Provided') ?><br>
                                                <b>Current Grade/Level:</b> <?= htmlspecialchars($registration->current_grade ?? 'Not Provided') ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="column-card">
                                    <!-- French Learning Details -->
                                    <div class="info-section">
                                        <div class="section-title">
                                            <i class="fa fa-language"></i>
                                            French Learning Details
                                        </div>
                                        <div class="info-content">
                                            <p>
                                                <b>French Level:</b> <?= htmlspecialchars($registration->french_level) ?><br>
                                                <b>Favorite French Activity:</b> <?= htmlspecialchars($registration->favorite_french_activity ?? 'Not Specified') ?><br>
                                                <b>Area of Improvement:</b> <?= htmlspecialchars($registration->area_of_improvement ?? 'Not Specified') ?>
                                            </p>
                                        </div>
                                    </div>

                                    <hr class="section-divider">

                                    <!-- Additional Information -->
                                    <div class="info-section">
                                        <div class="section-title">
                                            <i class="fa fa-info-circle"></i>
                                            Additional Information
                                        </div>
                                        <div class="info-content">
                                            <p>
                                                <b>Learning/Behavioral Difficulties:</b><br>
                                                <?= htmlspecialchars($registration->learning_behavioral_difficulties ?? 'None Reported') ?>
                                            </p>
                                        </div>
                                        <div class="info-content" style="margin-top: 12px;">
                                            <p>
                                                <b>Allergies:</b><br>
                                                <?= htmlspecialchars($registration->allergies ?? 'None Reported') ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer">
                        <?= form_open('admin/french_registrations/update_kid_registration_status') ?>
                            <!-- CSRF Token -->
                            <?php echo form_hidden($this->security->get_csrf_token_name(), $this->security->get_csrf_hash()); ?>
                            
                            <input type="hidden" name="id" value="<?= $registration->id ?>">
                            
                            <div class="status-update-form">
                                <select name="status" class="form-control">
                                    <option value="Pending" <?= $registration->status == 'Pending' ? 'selected' : '' ?>>Pending</option>
                                    <option value="Approved" <?= $registration->status == 'Approved' ? 'selected' : '' ?>>Approved</option>
                                    <option value="Rejected" <?= $registration->status == 'Rejected' ? 'selected' : '' ?>>Rejected</option>
                                </select>
                                
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> Update Status
                                </button>
                                
                                <a href="<?= site_url('admin/french_registrations/kid_registrations') ?>" class="btn btn-default">
                                    <i class="fas fa-arrow-left"></i> Back to List
                                </a>
                            </div>
                        <?= form_close() ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>