<!-- Custom Media Edit Styles -->
<style>
    :root {
        --primary-color: #f26124;
        --primary-hover: #d95520;
        --success-color: #1cc88a;
        --info-color: #36b9cc;
        --warning-color: #f6c23e;
        --danger-color: #dc3545;
        --dark-text: #231f20;
        --muted-text: #6c757d;
        --border-color: #e9ecef;
        --bg-light: #f8f9fa;
    }

    .media-edit-container {
        background: #f4f6f9;
        min-height: 100vh;
        padding: 20px 0;
    }

    /* Breadcrumb */
    .breadcrumb-section {
        background: #fff;
        border-radius: 8px;
        padding: 16px 24px;
        margin-bottom: 24px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
    }

    .breadcrumb-section h1 {
        font-size: 24px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0 0 12px 0;
    }

    .breadcrumb {
        background: transparent;
        padding: 0;
        margin: 0;
        font-size: 13px;
    }

    .breadcrumb li {
        display: inline;
        color: var(--muted-text);
    }

    .breadcrumb li + li:before {
        content: "›";
        padding: 0 8px;
        color: var(--muted-text);
    }

    .breadcrumb a {
        color: var(--primary-color);
        text-decoration: none;
        transition: color 0.3s ease;
    }

    .breadcrumb a:hover {
        color: var(--primary-hover);
    }

    .breadcrumb .active {
        color: var(--muted-text);
    }

    /* Edit Card */
    .edit-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
        overflow: hidden;
        margin-bottom: 24px;
    }

    .edit-card .card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border: none;
        border-bottom: 2px solid var(--border-color);
        padding: 24px 28px;
    }

    .edit-card .card-header h3 {
        font-size: 18px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .edit-card .card-header h3 i {
        color: var(--primary-color);
        font-size: 20px;
    }

    .edit-card .card-body {
        padding: 32px;
    }

    .edit-card .card-footer {
        background: var(--bg-light);
        border-top: 2px solid var(--border-color);
        padding: 20px 28px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    /* Alert */
    .alert {
        border-radius: 8px;
        border: 1px solid;
        padding: 16px 20px;
        margin-bottom: 24px;
        font-size: 14px;
        display: flex;
        align-items: flex-start;
        gap: 12px;
    }

    .alert-danger {
        background-color: #f8d7da;
        border-color: #f5c6cb;
        color: #721c24;
    }

    .alert i {
        font-size: 18px;
        margin-top: 2px;
        flex-shrink: 0;
    }

    /* Current Media Section */
    .current-media-section {
        background: var(--bg-light);
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 24px;
        margin-bottom: 28px;
    }

    .current-media-section .section-label {
        font-size: 14px;
        font-weight: 700;
        color: var(--dark-text);
        margin-bottom: 16px;
        display: block;
    }

    .current-media-wrapper {
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .current-media-wrapper img,
    .current-media-wrapper video {
        max-width: 100%;
        max-height: 300px;
        border-radius: 8px;
        border: 2px solid var(--border-color);
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        object-fit: contain;
        background: #fff;
    }

    .current-media-placeholder {
        text-align: center;
        padding: 40px;
    }

    .current-media-placeholder i {
        font-size: 80px;
        color: #dee2e6;
        margin-bottom: 16px;
        display: block;
    }

    .current-media-placeholder p {
        font-size: 14px;
        color: var(--muted-text);
        margin: 0;
        word-break: break-all;
    }

    /* Form Groups */
    .form-group {
        margin-bottom: 28px;
        display: flex;
        align-items: flex-start;
    }

    .form-group label {
        font-size: 14px;
        font-weight: 700;
        color: var(--dark-text);
        padding-top: 12px;
        width: 200px;
        flex-shrink: 0;
    }

    .form-group label .text-danger {
        color: var(--danger-color);
        margin-left: 4px;
    }

    .form-group .form-control-wrapper {
        flex: 1;
    }

    /* Form Controls */
    .form-control {
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 12px 16px;
        font-size: 14px;
        color: #495057;
        background: #fff;
        transition: all 0.3s ease;
        width: 100%;
    }

    .form-control:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
        outline: none;
    }

    .form-control::placeholder {
        color: #adb5bd;
    }

    /* Textarea */
    textarea.form-control {
        resize: vertical;
        min-height: 100px;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    /* Select */
    select.form-control {
        cursor: pointer;
        appearance: none;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 12px center;
        background-size: 16px 12px;
        padding-right: 36px;
    }

    /* File Input */
    input[type="file"].form-control {
        padding: 40px 16px;
        border: 2px dashed var(--border-color);
        background: var(--bg-light);
        cursor: pointer;
        transition: all 0.3s ease;
        text-align: center;
    }

    input[type="file"].form-control:hover {
        border-color: var(--primary-color);
        background: rgba(242, 97, 36, 0.05);
    }

    input[type="file"].form-control:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
        background: rgba(242, 97, 36, 0.05);
    }

    /* Form Text */
    .form-text {
        display: block;
        margin-top: 8px;
        font-size: 13px;
        color: var(--muted-text);
        line-height: 1.5;
    }

    /* Upload Info Box */
    .upload-info-box {
        background: linear-gradient(135deg, rgba(54, 185, 204, 0.05) 0%, rgba(54, 185, 204, 0.02) 100%);
        border: 1px solid rgba(54, 185, 204, 0.2);
        border-radius: 8px;
        padding: 16px;
        margin-top: 12px;
        display: flex;
        align-items: flex-start;
        gap: 12px;
    }

    .upload-info-box i {
        color: var(--info-color);
        font-size: 20px;
        margin-top: 2px;
    }

    .upload-info-box .info-content {
        flex: 1;
    }

    .upload-info-box .info-title {
        font-size: 13px;
        font-weight: 700;
        color: var(--dark-text);
        margin-bottom: 4px;
    }

    .upload-info-box .info-text {
        font-size: 13px;
        color: var(--muted-text);
        margin: 0;
        line-height: 1.6;
    }

    /* Buttons */
    .btn {
        border-radius: 8px;
        padding: 11px 24px;
        font-size: 14px;
        font-weight: 600;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        text-decoration: none;
    }

    .btn-primary {
        background: var(--primary-color);
        color: #fff;
    }

    .btn-primary:hover {
        background: var(--primary-hover);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(242, 97, 36, 0.3);
        color: #fff;
        text-decoration: none;
    }

    .btn-default {
        background: #fff;
        color: var(--dark-text);
        border: 2px solid var(--border-color);
    }

    .btn-default:hover {
        background: var(--bg-light);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        color: var(--dark-text);
        text-decoration: none;
    }

    .btn i {
        font-size: 15px;
    }

    /* Responsive Design */
    @media (max-width: 992px) {
        .media-edit-container {
            padding: 16px 0;
        }

        .edit-card .card-header {
            padding: 20px;
        }

        .edit-card .card-body {
            padding: 20px;
        }

        .edit-card .card-footer {
            padding: 16px 20px;
            flex-direction: column;
            gap: 12px;
        }

        .edit-card .card-footer .btn {
            width: 100%;
            justify-content: center;
        }

        .breadcrumb-section h1 {
            font-size: 20px;
        }

        .current-media-section {
            padding: 20px;
        }
    }

    @media (max-width: 768px) {
        .form-group {
            flex-direction: column;
        }

        .form-group label {
            width: 100%;
            padding-top: 0;
            margin-bottom: 10px;
        }

        .edit-card .card-header h3 {
            font-size: 16px;
        }

        input[type="file"].form-control {
            padding: 30px 16px;
        }

        .current-media-wrapper img,
        .current-media-wrapper video {
            max-height: 200px;
        }
    }
</style>

<div class="media-edit-container">
    <div class="container-fluid">
        <!-- Breadcrumb -->
       

        <div class="row">
            <div class="col-md-8 offset-md-2">
                <div class="edit-card">
                    <div class="card-header">
                        <h3>
                            <i class="fas fa-edit"></i>
                            Edit Media Item
                        </h3>
                    </div>

                    <?= form_open_multipart('admin/media_management/update', ['class' => 'edit-form']) ?>
                        <input type="hidden" name="id" value="<?= $media_item->id ?>">
                        
                        <div class="card-body">
                            <?php if(validation_errors()): ?>
                                <div class="alert alert-danger">
                                    <i class="fas fa-exclamation-circle"></i>
                                    <div>
                                        <?= validation_errors() ?>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <!-- Current Media -->
                            <div class="current-media-section">
                                <span class="section-label">
                                    <i class="fas fa-image"></i> Current Media
                                </span>
                                <div class="current-media-wrapper">
                                    <?php 
                                    $file_path = base_url('uploads/media/' . $media_item->file_path);
                                    ?>
                                    <?php if($media_item->file_type == 'image'): ?>
                                        <img src="<?= $file_path ?>" 
                                             alt="<?= htmlspecialchars($media_item->title) ?>">
                                    <?php elseif($media_item->file_type == 'video'): ?>
                                        <video controls>
                                            <source src="<?= $file_path ?>" type="video/mp4">
                                            Your browser does not support the video tag.
                                        </video>
                                    <?php else: ?>
                                        <div class="current-media-placeholder">
                                            <i class="fa fa-file"></i>
                                            <p><?= $media_item->file_path ?></p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <!-- Title -->
                            <div class="form-group">
                                <label>
                                    Title <span class="text-danger">*</span>
                                </label>
                                <div class="form-control-wrapper">
                                    <input type="text" 
                                           name="title" 
                                           class="form-control" 
                                           value="<?= htmlspecialchars($media_item->title) ?>" 
                                           placeholder="Enter media title"
                                           required>
                                </div>
                            </div>

                            <!-- Description -->
                            <div class="form-group">
                                <label>Description</label>
                                <div class="form-control-wrapper">
                                    <textarea name="description" 
                                              class="form-control" 
                                              rows="3"
                                              placeholder="Enter media description (optional)"><?= htmlspecialchars($media_item->description) ?></textarea>
                                </div>
                            </div>

                            <!-- Category -->
                            <div class="form-group">
                                <label>
                                    Category <span class="text-danger">*</span>
                                </label>
                                <div class="form-control-wrapper">
                                    <select name="category_id" class="form-control" required>
                                        <option value="">Select Category</option>
                                        <?php foreach($categories as $category): ?>
                                            <option value="<?= $category->id ?>" 
                                                <?= $media_item->category_id == $category->id ? 'selected' : '' ?>>
                                                <?= htmlspecialchars($category->name) ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>

                            <!-- New Media File -->
                            <div class="form-group">
                                <label>Replace Media File</label>
                                <div class="form-control-wrapper">
                                    <input type="file" 
                                           name="media_file" 
                                           id="media_file"
                                           class="form-control">
                                    
                                    <div class="upload-info-box">
                                        <i class="fas fa-info-circle"></i>
                                        <div class="info-content">
                                            <div class="info-title">Optional: Upload Replacement File</div>
                                            <p class="info-text">
                                                Leave blank to keep existing file<br>
                                                <strong>Allowed types:</strong> gif, jpg, png, jpeg, mp4, pdf, doc, docx<br>
                                                <strong>Maximum size:</strong> 10MB
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Tags -->
                            <div class="form-group">
                                <label>Tags</label>
                                <div class="form-control-wrapper">
                                    <input type="text" 
                                           name="tags" 
                                           class="form-control" 
                                           value="<?= htmlspecialchars($media_item->tags) ?>" 
                                           placeholder="e.g., event, community, education">
                                    <small class="form-text">Separate tags with commas</small>
                                </div>
                            </div>

                            <!-- Status -->
                            <div class="form-group">
                                <label>
                                    Status <span class="text-danger">*</span>
                                </label>
                                <div class="form-control-wrapper">
                                    <select name="status" class="form-control" required>
                                        <option value="draft" <?= $media_item->status == 'draft' ? 'selected' : '' ?>>Draft</option>
                                        <option value="published" <?= $media_item->status == 'published' ? 'selected' : '' ?>>Published</option>
                                        <option value="archived" <?= $media_item->status == 'archived' ? 'selected' : '' ?>>Archived</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="card-footer">
                            <a href="<?= site_url('admin/media_management') ?>" class="btn btn-default">
                                <i class="fas fa-times"></i> Cancel
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Media
                            </button>
                        </div>
                    <?= form_close() ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // File input change handler
    $('#media_file').on('change', function() {
        const fileName = this.files[0]?.name;
        if (fileName) {
            console.log('Replacement file selected:', fileName);
        }
    });

    // Form validation
    $('.edit-form').on('submit', function(e) {
        const fileInput = $('#media_file')[0];
        const file = fileInput.files[0];
        
        if (file) {
            // Check file size (10MB = 10 * 1024 * 1024 bytes)
            const maxSize = 10 * 1024 * 1024;
            if (file.size > maxSize) {
                e.preventDefault();
                alert('File size exceeds 10MB limit. Please choose a smaller file.');
                return false;
            }
        }
    });
});
</script>