<!-- Custom Media Management Styles -->
<style>
    :root {
        --primary-color: #f26124;
        --primary-hover: #d95520;
        --success-color: #1cc88a;
        --info-color: #36b9cc;
        --warning-color: #f6c23e;
        --danger-color: #dc3545;
        --dark-text: #231f20;
        --muted-text: #6c757d;
        --border-color: #e9ecef;
        --bg-light: #f8f9fa;
    }

    .media-management-container {
        background: #f4f6f9;
        min-height: 100vh;
        padding: 20px 0;
    }

    /* Breadcrumb */
    .breadcrumb-section {
        background: #fff;
        border-radius: 8px;
        padding: 16px 24px;
        margin-bottom: 24px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
    }

    .breadcrumb-section h1 {
        font-size: 24px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0 0 12px 0;
    }

    .breadcrumb {
        background: transparent;
        padding: 0;
        margin: 0;
        font-size: 13px;
    }

    .breadcrumb li {
        display: inline;
        color: var(--muted-text);
    }

    .breadcrumb li + li:before {
        content: "›";
        padding: 0 8px;
        color: var(--muted-text);
    }

    .breadcrumb a {
        color: var(--primary-color);
        text-decoration: none;
        transition: color 0.3s ease;
    }

    .breadcrumb a:hover {
        color: var(--primary-hover);
    }

    .breadcrumb .active {
        color: var(--muted-text);
    }

    /* Alert Styles */
    .alert {
        border-radius: 8px;
        border: 1px solid;
        padding: 16px 20px;
        margin-bottom: 24px;
        font-size: 14px;
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .alert-success {
        background-color: #d4edda;
        border-color: #c3e6cb;
        color: #155724;
    }

    .alert-danger {
        background-color: #f8d7da;
        border-color: #f5c6cb;
        color: #721c24;
    }

    /* Main Card */
    .media-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
        overflow: hidden;
        margin-bottom: 24px;
    }

    .media-card .card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border: none;
        border-bottom: 2px solid var(--border-color);
        padding: 24px 28px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .media-card .card-header h3 {
        font-size: 18px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0;
    }

    .media-card .card-body {
        padding: 32px;
    }

    /* Filter Section */
    .filter-section {
        background: var(--bg-light);
        padding: 20px;
        border-radius: 8px;
        margin-bottom: 24px;
        border: 1px solid var(--border-color);
    }

    .filter-section .form-control {
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 10px 14px;
        font-size: 14px;
        transition: all 0.3s ease;
        background: #fff;
    }

    .filter-section .form-control:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
        outline: none;
    }

    .filter-section select.form-control {
        appearance: none;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 12px center;
        background-size: 16px 12px;
        padding-right: 36px;
    }

    /* Buttons */
    .btn {
        border-radius: 8px;
        padding: 10px 20px;
        font-size: 14px;
        font-weight: 600;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        text-decoration: none;
    }

    .btn-success {
        background: var(--success-color);
        color: #fff;
    }

    .btn-success:hover {
        background: #17a673;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(28, 200, 138, 0.3);
        color: #fff;
    }

    .btn-primary {
        background: var(--primary-color);
        color: #fff;
    }

    .btn-primary:hover {
        background: var(--primary-hover);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(242, 97, 36, 0.3);
        color: #fff;
    }

    .btn-info {
        background: var(--info-color);
        color: #fff;
    }

    .btn-info:hover {
        background: #2a9faf;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(54, 185, 204, 0.3);
        color: #fff;
    }

    .btn-danger {
        background: var(--danger-color);
        color: #fff;
    }

    .btn-danger:hover {
        background: #c82333;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(220, 53, 69, 0.3);
        color: #fff;
    }

    .btn-sm {
        padding: 8px 16px;
        font-size: 13px;
    }

    .btn-xs {
        padding: 6px 12px;
        font-size: 12px;
    }

    .btn i {
        font-size: 14px;
    }

    /* Table Styles */
    .table-container {
        overflow-x: auto;
        border-radius: 8px;
        border: 1px solid var(--border-color);
    }

    .table {
        width: 100%;
        margin: 0;
        border-collapse: separate;
        border-spacing: 0;
    }

    .table thead th {
        background: var(--bg-light);
        color: var(--dark-text);
        font-weight: 700;
        font-size: 13px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        padding: 16px;
        border-bottom: 2px solid var(--border-color);
        white-space: nowrap;
    }

    .table tbody td {
        padding: 16px;
        border-bottom: 1px solid var(--border-color);
        font-size: 14px;
        color: var(--dark-text);
        vertical-align: middle;
    }

    .table tbody tr:last-child td {
        border-bottom: none;
    }

    .table tbody tr {
        transition: background-color 0.2s ease;
    }

    .table tbody tr:hover {
        background-color: var(--bg-light);
    }

    /* Thumbnail Styles */
    .media-thumbnail {
        width: 100px;
        height: 100px;
        border-radius: 8px;
        object-fit: cover;
        border: 2px solid var(--border-color);
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    .media-thumbnail-placeholder {
        width: 100px;
        height: 100px;
        border-radius: 8px;
        background: var(--bg-light);
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        border: 2px dashed var(--border-color);
    }

    .media-thumbnail-placeholder i {
        font-size: 36px;
        color: #adb5bd;
        margin-bottom: 8px;
    }

    .media-thumbnail-placeholder small {
        font-size: 11px;
        color: var(--muted-text);
        text-align: center;
        padding: 0 8px;
        word-break: break-all;
    }

    /* Status Labels */
    .status-badge {
        padding: 6px 12px;
        font-size: 11px;
        font-weight: 600;
        border-radius: 6px;
        text-transform: uppercase;
        letter-spacing: 0.3px;
        display: inline-block;
    }

    .status-badge.badge-warning {
        background: var(--warning-color);
        color: #fff;
    }

    .status-badge.badge-success {
        background: var(--success-color);
        color: #fff;
    }

    .status-badge.badge-danger {
        background: var(--danger-color);
        color: #fff;
    }

    /* Button Group */
    .btn-group {
        display: flex;
        gap: 4px;
    }

    /* DataTables Custom Styling */
    .dataTables_wrapper {
        padding: 0;
    }

    .dataTables_wrapper .dataTables_length,
    .dataTables_wrapper .dataTables_filter {
        margin-bottom: 16px;
    }

    .dataTables_wrapper .dataTables_length select {
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 6px 32px 6px 12px;
        margin: 0 8px;
        appearance: none;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 8px center;
        background-size: 12px 8px;
    }

    .dataTables_wrapper .dataTables_filter input {
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 8px 12px;
        margin-left: 8px;
    }

    .dataTables_wrapper .dataTables_filter input:focus {
        border-color: var(--primary-color);
        outline: none;
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
    }

    .dataTables_wrapper .dataTables_info {
        font-size: 13px;
        color: var(--muted-text);
        padding-top: 16px;
    }

    .dataTables_wrapper .dataTables_paginate {
        padding-top: 16px;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 6px 12px;
        margin: 0 2px;
        border-radius: 6px;
        border: 1px solid var(--border-color);
        background: #fff;
        color: var(--dark-text) !important;
        font-size: 13px;
        transition: all 0.3s ease;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
        background: var(--primary-color);
        color: #fff !important;
        border-color: var(--primary-color);
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button.current {
        background: var(--primary-color);
        color: #fff !important;
        border-color: var(--primary-color);
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button.disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }

    /* Responsive Design */
    @media (max-width: 992px) {
        .media-management-container {
            padding: 16px 0;
        }

        .media-card .card-header {
            padding: 20px;
            flex-direction: column;
            gap: 16px;
            align-items: flex-start;
        }

        .media-card .card-body {
            padding: 20px;
        }

        .filter-section {
            padding: 16px;
        }

        .breadcrumb-section h1 {
            font-size: 20px;
        }
    }

    @media (max-width: 768px) {
        .media-thumbnail,
        .media-thumbnail-placeholder {
            width: 80px;
            height: 80px;
        }

        .table thead th,
        .table tbody td {
            padding: 12px 8px;
            font-size: 13px;
        }

        .btn-group {
            flex-direction: column;
            gap: 4px;
        }

        .filter-section .col-md-3 {
            margin-bottom: 12px;
        }
    }
</style>

<div class="media-management-container">
    <div class="container-fluid">
       
        <div class="row">
            <div class="col-xs-12">
                <?php if($this->session->flashdata('success')): ?>
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle"></i>
                        <?= $this->session->flashdata('success') ?>
                    </div>
                <?php endif; ?>

                <?php if($this->session->flashdata('error')): ?>
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-circle"></i>
                        <?= $this->session->flashdata('error') ?>
                    </div>
                <?php endif; ?>

                <div class="media-card">
                    <div class="card-header">
                        <h3><i class="fas fa-photo-video"></i> Media Library</h3>
                        <div>
                            <a href="<?= site_url('admin/media_management/upload') ?>" class="btn btn-success btn-sm">
                                <i class="fa fa-plus"></i> Upload New Media
                            </a>
                        </div>
                    </div>
                    
                    <div class="card-body">
                        <!-- Filter Section -->
                        <div class="filter-section">
                            <form method="get" action="<?= site_url('admin/media_management') ?>">
                                <div class="row">
                                    <div class="col-md-3">
                                        <select name="category" class="form-control">
                                            <option value="">All Categories</option>
                                            <?php foreach($categories as $category): ?>
                                                <option value="<?= $category->id ?>" 
                                                    <?= $selected_category == $category->id ? 'selected' : '' ?>>
                                                    <?= $category->name ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <select name="type" class="form-control">
                                            <option value="">All Types</option>
                                            <option value="image" <?= $selected_type == 'image' ? 'selected' : '' ?>>Images</option>
                                            <option value="video" <?= $selected_type == 'video' ? 'selected' : '' ?>>Videos</option>
                                            <option value="document" <?= $selected_type == 'document' ? 'selected' : '' ?>>Documents</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <select name="status" class="form-control">
                                            <option value="">All Statuses</option>
                                            <option value="draft" <?= $selected_status == 'draft' ? 'selected' : '' ?>>Draft</option>
                                            <option value="published" <?= $selected_status == 'published' ? 'selected' : '' ?>>Published</option>
                                            <option value="archived" <?= $selected_status == 'archived' ? 'selected' : '' ?>>Archived</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fa fa-filter"></i> Filter
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>

                        <!-- Table -->
                        <div class="table-container">
                            <table class="table table-bordered table-striped" id="media-table">
                                <thead>
                                    <tr>
                                        <th>Thumbnail</th>
                                        <th>Title</th>
                                        <th>Category</th>
                                        <th>Type</th>
                                        <th>Status</th>
                                        <th>Uploaded</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($media_items as $media): ?>
                                    <tr>
                                        <td>
                                            <?php 
                                            $file_path = base_url('uploads/media/' . $media->file_path);
                                            ?>
                                            <?php if($media->file_type == 'image'): ?>
                                                <img src="<?= $file_path ?>" 
                                                     class="media-thumbnail"
                                                     alt="<?= htmlspecialchars($media->title) ?>">
                                            <?php elseif($media->file_type == 'video'): ?>
                                                <video class="media-thumbnail">
                                                    <source src="<?= $file_path ?>" type="video/mp4">
                                                </video>
                                            <?php else: ?>
                                                <div class="media-thumbnail-placeholder">
                                                    <i class="fa fa-file"></i>
                                                    <small><?= $media->file_path ?></small>
                                                </div>
                                            <?php endif; ?>
                                        </td>
                                        <td><strong><?= htmlspecialchars($media->title) ?></strong></td>
                                        <td><?= htmlspecialchars($media->category_name) ?></td>
                                        <td><?= ucfirst($media->file_type) ?></td>
                                        <td>
                                            <?php 
                                            $status_class = [
                                                'draft' => 'warning',
                                                'published' => 'success',
                                                'archived' => 'danger'
                                            ];
                                            ?>
                                            <span class="status-badge badge-<?= $status_class[$media->status] ?>">
                                                <?= ucfirst($media->status) ?>
                                            </span>
                                        </td>
                                        <td><?= date('M d, Y', strtotime($media->created_at)) ?></td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="<?= site_url('admin/media_management/edit/' . $media->id) ?>" 
                                                   class="btn btn-info btn-xs"
                                                   title="Edit">
                                                    <i class="fa fa-edit"></i>
                                                </a>
                                                <a href="<?= site_url('admin/media_management/delete/' . $media->id) ?>" 
                                                   class="btn btn-danger btn-xs"
                                                   title="Delete"
                                                   onclick="return confirm('Are you sure you want to delete this media?')">
                                                    <i class="fa fa-trash"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    $('#media-table').DataTable({
        'paging'      : true,
        'lengthChange': true,
        'searching'   : true,
        'ordering'    : true,
        'info'        : true,
        'autoWidth'   : false,
        'pageLength'  : 25,
        'order'       : [[5, 'desc']], // Sort by uploaded date
        'language': {
            'search': 'Search:',
            'lengthMenu': 'Show _MENU_ entries',
            'info': 'Showing _START_ to _END_ of _TOTAL_ entries',
            'infoEmpty': 'No entries available',
            'infoFiltered': '(filtered from _MAX_ total entries)',
            'paginate': {
                'first': 'First',
                'last': 'Last',
                'next': 'Next',
                'previous': 'Prev'
            }
        }
    });
});
</script>