<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<style>
    :root {
        --primary-color: #f26124;
        --secondary-color: #231f20;
    }

    /* Statistics Cards */
    .stats-container {
        margin-bottom: 32px;
    }
    
    .stat-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid #e9ecef;
        border-left: 4px solid;
        padding: 24px;
        height: 100%;
        transition: all 0.3s ease;
    }
    
    .stat-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.12);
    }
    
    .stat-card.primary {
        border-left-color: var(--primary-color);
    }
    
    .stat-card.info {
        border-left-color: #17a2b8;
    }
    
    .stat-card.success {
        border-left-color: #28a745;
    }
    
    .stat-card.secondary {
        border-left-color: #6c757d;
    }
    
    .stat-card-content {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    
    .stat-card-info {
        flex: 1;
    }
    
    .stat-card-label {
        font-size: 11px;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 8px;
        color: #6c757d;
    }
    
    .stat-card.primary .stat-card-label {
        color: var(--primary-color);
    }
    
    .stat-card.info .stat-card-label {
        color: #17a2b8;
    }
    
    .stat-card.success .stat-card-label {
        color: #28a745;
    }
    
    .stat-card-value {
        font-size: 2rem;
        font-weight: 800;
        color: var(--secondary-color);
    }
    
    .stat-card-icon {
        font-size: 3rem;
        color: #e9ecef;
    }
    
    /* Main Card */
    .messages-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid #e9ecef;
        overflow: hidden;
    }
    
    .messages-card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border-bottom: 2px solid #e9ecef;
        padding: 24px 28px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 16px;
    }
    
    .messages-card-title {
        font-size: 20px;
        font-weight: 700;
        color: var(--secondary-color);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .messages-card-title i {
        color: var(--primary-color);
        font-size: 22px;
    }
    
    .messages-card-body {
        padding: 28px;
    }
    
    /* Search Form */
    .search-form {
        margin-bottom: 24px;
    }
    
    .search-input-group {
        display: flex;
        gap: 0;
    }
    
    .search-input-group input {
        flex: 1;
        border: 1px solid #e9ecef;
        border-radius: 8px 0 0 8px;
        padding: 12px 16px;
        font-size: 14px;
        transition: all 0.3s ease;
    }
    
    .search-input-group input:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
        outline: none;
    }
    
    .search-input-group button {
        border-radius: 0 8px 8px 0;
        border: none;
        background: var(--primary-color);
        color: #fff;
        padding: 12px 24px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
    }
    
    .search-input-group button:hover {
        background: #d95520;
    }
    
    .status-select {
        border: 1px solid #e9ecef;
        border-radius: 8px;
        padding: 12px 16px;
        font-size: 14px;
        width: 100%;
        cursor: pointer;
        transition: all 0.3s ease;
        appearance: none;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 12px center;
        background-size: 16px 12px;
        padding-right: 36px;
    }
    
    .status-select:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
        outline: none;
    }
    
    /* Tabs */
    .custom-tabs {
        display: flex;
        gap: 8px;
        margin-bottom: 24px;
        border-bottom: 2px solid #e9ecef;
        flex-wrap: wrap;
    }
    
    .custom-tab {
        padding: 12px 20px;
        text-decoration: none;
        color: #6c757d;
        font-weight: 600;
        font-size: 14px;
        border-bottom: 3px solid transparent;
        margin-bottom: -2px;
        transition: all 0.3s ease;
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .custom-tab:hover {
        color: var(--primary-color);
        background: rgba(242, 97, 36, 0.05);
    }
    
    .custom-tab.active {
        color: var(--primary-color);
        border-bottom-color: var(--primary-color);
    }
    
    .custom-tab .badge {
        padding: 4px 8px;
        border-radius: 4px;
        font-size: 11px;
        font-weight: 700;
    }
    
    .badge.bg-secondary {
        background: #6c757d !important;
        color: #fff;
    }
    
    .badge.bg-danger {
        background: #dc3545 !important;
        color: #fff;
    }
    
    .badge.bg-primary {
        background: #17a2b8 !important;
        color: #fff;
    }
    
    .badge.bg-success {
        background: #28a745 !important;
        color: #fff;
    }
    
    .badge.bg-warning {
        background: #ffc107 !important;
        color: #000;
    }
    
    /* Bulk Actions */
    .bulk-actions {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
        flex-wrap: wrap;
        gap: 12px;
    }
    
    .bulk-actions-group {
        display: flex;
        gap: 0;
    }
    
    .bulk-actions-select {
        border: 1px solid #e9ecef;
        border-radius: 8px 0 0 8px;
        padding: 10px 16px;
        font-size: 14px;
        cursor: pointer;
        min-width: 200px;
    }
    
    .bulk-actions-btn {
        border: none;
        border-radius: 0 8px 8px 0;
        background: var(--primary-color);
        color: #fff;
        padding: 10px 20px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
    }
    
    .bulk-actions-btn:hover {
        background: #d95520;
    }
    
    .selected-count {
        font-size: 13px;
        color: #6c757d;
    }
    
    /* Table */
    .messages-table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0;
        overflow: hidden;
        border-radius: 8px;
        border: 1px solid #e9ecef;
    }
    
    .messages-table thead {
        background: #f8f9fa;
    }
    
    .messages-table thead th {
        padding: 16px 20px;
        font-size: 12px;
        font-weight: 700;
        color: var(--secondary-color);
        text-transform: uppercase;
        letter-spacing: 0.5px;
        border-bottom: 2px solid #e9ecef;
        white-space: nowrap;
    }
    
    .messages-table tbody tr {
        transition: all 0.2s ease;
        border-bottom: 1px solid #e9ecef;
    }
    
    .messages-table tbody tr:hover {
        background-color: rgba(242, 97, 36, 0.03);
    }
    
    .messages-table tbody tr.unread {
        background-color: #fff3cd;
    }
    
    .messages-table tbody tr.unread:hover {
        background-color: #ffe9a6;
    }
    
    .messages-table tbody td {
        padding: 16px 20px;
        font-size: 14px;
        color: #495057;
        vertical-align: middle;
    }
    
    .messages-table tbody tr:last-child {
        border-bottom: none;
    }
    
    /* Status Badges in Table */
    .status-badge {
        display: inline-block;
        padding: 6px 12px;
        border-radius: 6px;
        font-size: 11px;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    /* Action Buttons */
    .btn {
        border-radius: 6px;
        padding: 8px 14px;
        font-size: 13px;
        font-weight: 600;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 6px;
        text-decoration: none;
    }
    
    .btn-sm {
        padding: 6px 12px;
        font-size: 12px;
    }
    
    .btn-info {
        background: #17a2b8;
        color: #fff;
    }
    
    .btn-info:hover {
        background: #138496;
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(23, 162, 184, 0.3);
    }
    
    .btn-success {
        background: #28a745;
        color: #fff;
    }
    
    .btn-success:hover {
        background: #218838;
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(40, 167, 69, 0.3);
    }
    
    .btn-danger {
        background: #dc3545;
        color: #fff;
    }
    
    .btn-danger:hover {
        background: #c82333;
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(220, 53, 69, 0.3);
    }
    
    .btn-primary {
        background: var(--primary-color);
        color: #fff;
    }
    
    .btn-primary:hover {
        background: #d95520;
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(242, 97, 36, 0.3);
    }
    
    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 60px 20px;
    }
    
    .empty-state i {
        font-size: 4rem;
        color: #dee2e6;
        margin-bottom: 20px;
    }
    
    .empty-state h5 {
        font-size: 1.5rem;
        font-weight: 700;
        color: var(--secondary-color);
        margin-bottom: 12px;
    }
    
    .empty-state p {
        font-size: 1rem;
        color: #6c757d;
        margin-bottom: 24px;
    }
    
    /* Pagination */
    .pagination-container {
        display: flex;
        justify-content: center;
        margin-top: 24px;
    }
    
    .pagination {
        display: flex;
        list-style: none;
        padding: 0;
        margin: 0;
        gap: 6px;
    }
    
    .pagination li a {
        display: flex;
        align-items: center;
        justify-content: center;
        min-width: 40px;
        height: 40px;
        padding: 8px 12px;
        border: 1px solid #e9ecef;
        border-radius: 6px;
        background: #fff;
        color: #495057;
        font-size: 14px;
        font-weight: 600;
        text-decoration: none;
        transition: all 0.3s ease;
    }
    
    .pagination li a:hover {
        background: var(--primary-color);
        border-color: var(--primary-color);
        color: #fff;
    }
    
    .pagination li.active a {
        background: var(--primary-color);
        border-color: var(--primary-color);
        color: #fff;
    }
    
    /* Responsive */
    @media (max-width: 768px) {
        .messages-card-header {
            padding: 20px;
        }
        
        .messages-card-body {
            padding: 20px;
        }
        
        .stat-card {
            margin-bottom: 16px;
        }
        
        .custom-tabs {
            overflow-x: auto;
            flex-wrap: nowrap;
        }
        
        .bulk-actions {
            flex-direction: column;
            align-items: stretch;
        }
        
        .bulk-actions-select {
            min-width: auto;
            border-radius: 8px 8px 0 0;
        }
        
        .bulk-actions-btn {
            border-radius: 0 0 8px 8px;
        }
        
        .messages-table {
            font-size: 12px;
        }
        
        .messages-table thead th,
        .messages-table tbody td {
            padding: 12px 10px;
        }
    }
</style>

<!-- Statistics Cards -->
<div class="stats-container">
    <div class="row">
        <div class="col-md-3 col-sm-6 mb-3">
            <div class="stat-card primary">
                <div class="stat-card-content">
                    <div class="stat-card-info">
                        <div class="stat-card-label">New Messages</div>
                        <div class="stat-card-value">
                            <?php echo isset($statistics['new']) ? $statistics['new'] : 0; ?>
                        </div>
                    </div>
                    <div class="stat-card-icon">
                        <i class="fas fa-envelope"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6 mb-3">
            <div class="stat-card info">
                <div class="stat-card-content">
                    <div class="stat-card-info">
                        <div class="stat-card-label">Read</div>
                        <div class="stat-card-value">
                            <?php echo isset($statistics['read']) ? $statistics['read'] : 0; ?>
                        </div>
                    </div>
                    <div class="stat-card-icon">
                        <i class="fas fa-envelope-open"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6 mb-3">
            <div class="stat-card success">
                <div class="stat-card-content">
                    <div class="stat-card-info">
                        <div class="stat-card-label">Replied</div>
                        <div class="stat-card-value">
                            <?php echo isset($statistics['replied']) ? $statistics['replied'] : 0; ?>
                        </div>
                    </div>
                    <div class="stat-card-icon">
                        <i class="fas fa-reply"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6 mb-3">
            <div class="stat-card secondary">
                <div class="stat-card-content">
                    <div class="stat-card-info">
                        <div class="stat-card-label">Total Messages</div>
                        <div class="stat-card-value">
                            <?php echo isset($statistics['total']) ? $statistics['total'] : 0; ?>
                        </div>
                    </div>
                    <div class="stat-card-icon">
                        <i class="fas fa-comments"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Main Card -->
<div class="messages-card">
    <div class="messages-card-header">
        <h6 class="messages-card-title">
            <i class="fas fa-inbox"></i> Contact Messages
        </h6>
        <div>
            <a href="<?php echo base_url('admin/messages/export' . ($current_status ? '?status=' . $current_status : '')); ?>" 
               class="btn btn-success">
                <i class="fas fa-file-csv"></i> Export CSV
            </a>
        </div>
    </div>

    <div class="messages-card-body">
        <!-- Search & Filter Form -->
        <form method="get" action="<?php echo base_url('admin/messages/search'); ?>" class="search-form">
            <div class="row">
                <div class="col-md-8 mb-3">
                    <div class="search-input-group">
                        <input type="text" 
                               name="keyword" 
                               placeholder="Search by name, email, subject, or message..." 
                               value="<?php echo isset($search_keyword) ? htmlspecialchars($search_keyword) : ''; ?>">
                        <button type="submit">
                            <i class="fas fa-search"></i> Search
                        </button>
                    </div>
                </div>
                <div class="col-md-4 mb-3">
                    <select name="status" class="status-select" onchange="this.form.submit()">
                        <option value="">All Status</option>
                        <option value="new" <?php echo ($current_status === 'new') ? 'selected' : ''; ?>>New</option>
                        <option value="read" <?php echo ($current_status === 'read') ? 'selected' : ''; ?>>Read</option>
                        <option value="replied" <?php echo ($current_status === 'replied') ? 'selected' : ''; ?>>Replied</option>
                        <option value="archived" <?php echo ($current_status === 'archived') ? 'selected' : ''; ?>>Archived</option>
                    </select>
                </div>
            </div>
        </form>

        <!-- Status Filter Tabs -->
        <div class="custom-tabs">
            <a class="custom-tab <?php echo empty($current_status) ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/messages'); ?>">
                All Messages <span class="badge bg-secondary"><?php echo $statistics['total'] ?? 0; ?></span>
            </a>
            <a class="custom-tab <?php echo ($current_status === 'new') ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/messages?status=new'); ?>">
                New <span class="badge bg-danger"><?php echo $statistics['new'] ?? 0; ?></span>
            </a>
            <a class="custom-tab <?php echo ($current_status === 'read') ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/messages?status=read'); ?>">
                Read <span class="badge bg-primary"><?php echo $statistics['read'] ?? 0; ?></span>
            </a>
            <a class="custom-tab <?php echo ($current_status === 'replied') ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/messages?status=replied'); ?>">
                Replied <span class="badge bg-success"><?php echo $statistics['replied'] ?? 0; ?></span>
            </a>
            <a class="custom-tab <?php echo ($current_status === 'archived') ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/messages?status=archived'); ?>">
                Archived <span class="badge bg-warning"><?php echo $statistics['archived'] ?? 0; ?></span>
            </a>
        </div>

        <?php if (!empty($messages)): ?>
            <!-- Bulk Actions Form -->
            <?php echo form_open('admin/messages/bulk_action', ['id' => 'bulkForm']); ?>

                <div class="bulk-actions">
                    <div class="bulk-actions-group">
                        <select name="bulk_action" class="bulk-actions-select">
                            <option value="">-- Bulk Actions --</option>
                            <option value="mark_read">Mark as Read</option>
                            <option value="archive">Archive</option>
                            <option value="delete">Delete</option>
                        </select>
                        <button type="submit" class="bulk-actions-btn" onclick="return confirmBulkAction();">
                            Apply
                        </button>
                    </div>
                    <div class="selected-count">
                        <span id="selectedCount">0</span> message(s) selected
                    </div>
                </div>

                <!-- Messages Table -->
                <div class="table-responsive">
                    <table class="messages-table">
                        <thead>
                            <tr>
                                <th width="30">
                                    <input type="checkbox" id="selectAll">
                                </th>
                                <th width="80">Status</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Subject</th>
                                <th width="120">Received</th>
                                <th width="150">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($messages as $msg): ?>
                                <tr class="<?php echo ($msg->status === 'new') ? 'unread' : ''; ?>">
                                    <td>
                                        <input type="checkbox" name="message_ids[]" value="<?php echo $msg->id; ?>" class="message-checkbox">
                                    </td>
                                    <td>
                                       <?php
                                        $status_badges = [
                                            'new' => '<span class="badge bg-danger">New</span>',
                                            'read' => '<span class="badge bg-primary">Read</span>',
                                            'replied' => '<span class="badge bg-success">Replied</span>',
                                            'archived' => '<span class="badge bg-secondary">Archived</span>'
                                        ];
                                        echo isset($status_badges[$msg->status]) ? $status_badges[$msg->status] : '<span class="badge bg-secondary">' . ucfirst($msg->status) . '</span>';
                                        ?>
                                    </td>
                                    <td>
                                        <strong><?php echo htmlspecialchars($msg->name); ?></strong>
                                        <?php if ($msg->phone): ?>
                                            <br><small style="color: #6c757d;">
                                                <i class="fas fa-phone"></i> <?php echo htmlspecialchars($msg->phone); ?>
                                            </small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="mailto:<?php echo htmlspecialchars($msg->email); ?>">
                                            <?php echo htmlspecialchars($msg->email); ?>
                                        </a>
                                    </td>
                                    <td>
                                        <?php echo htmlspecialchars(character_limiter($msg->subject, 50)); ?>
                                        <br><small style="color: #6c757d;">
                                            <?php echo htmlspecialchars(character_limiter($msg->message, 80)); ?>
                                        </small>
                                    </td>
                                    <td>
                                        <small>
                                            <?php echo date('M d, Y', strtotime($msg->created_at)); ?>
                                            <br><?php echo date('h:i A', strtotime($msg->created_at)); ?>
                                        </small>
                                    </td>
                                    <td>
                                        <a href="<?php echo base_url('admin/messages/view/' . $msg->id); ?>" 
                                           class="btn btn-sm btn-info" title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        
                                        <?php if ($msg->status !== 'replied'): ?>
                                            <a href="<?php echo base_url('admin/messages/reply/' . $msg->id); ?>" 
                                               class="btn btn-sm btn-success" title="Reply">
                                                <i class="fas fa-reply"></i>
                                            </a>
                                        <?php endif; ?>
                                        
                                        <a href="<?php echo base_url('admin/messages/delete/' . $msg->id); ?>" 
                                           class="btn btn-sm btn-danger" 
                                           onclick="return confirm('Are you sure you want to delete this message?');"
                                           title="Delete">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </form>

            <!-- Pagination -->
            <?php if (!empty($pagination)): ?>
                <div class="pagination-container">
                    <?php echo $pagination; ?>
                </div>
            <?php endif; ?>

        <?php else: ?>
            <!-- Empty State -->
            <div class="empty-state">
                <i class="fas fa-inbox"></i>
                <h5>No Messages Found</h5>
                <p>
                    <?php if (isset($search_keyword)): ?>
                        No messages match your search criteria.
                    <?php elseif ($current_status): ?>
                        No messages with status "<?php echo ucfirst($current_status); ?>".
                    <?php else: ?>
                        You haven't received any contact messages yet.
                    <?php endif; ?>
                </p>
                <?php if (isset($search_keyword) || $current_status): ?>
                    <a href="<?php echo base_url('admin/messages'); ?>" class="btn btn-primary">
                        <i class="fas fa-list"></i> View All Messages
                    </a>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- JavaScript -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Select All Checkbox
    const selectAll = document.getElementById('selectAll');
    const checkboxes = document.querySelectorAll('.message-checkbox');
    const selectedCount = document.getElementById('selectedCount');

    if (selectAll) {
        selectAll.addEventListener('change', function() {
            checkboxes.forEach(cb => cb.checked = this.checked);
            updateSelectedCount();
        });
    }

    checkboxes.forEach(cb => {
        cb.addEventListener('change', updateSelectedCount);
    });

    function updateSelectedCount() {
        const checked = document.querySelectorAll('.message-checkbox:checked').length;
        selectedCount.textContent = checked;
        
        if (selectAll) {
            selectAll.checked = (checked === checkboxes.length && checked > 0);
        }
    }
});

function confirmBulkAction() {
    const action = document.querySelector('select[name="bulk_action"]').value;
    const checked = document.querySelectorAll('.message-checkbox:checked').length;

    if (!action) {
        alert('Please select a bulk action.');
        return false;
    }

    if (checked === 0) {
        alert('Please select at least one message.');
        return false;
    }

    if (action === 'delete') {
        return confirm('Are you sure you want to delete ' + checked + ' message(s)? This action cannot be undone.');
    }

    return confirm('Apply this action to ' + checked + ' message(s)?');
}
</script>