<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<style>
    :root {
        --primary-color: #f26124;
        --secondary-color: #231f20;
    }

    /* Main Card Styles */
    .message-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid #e9ecef;
        overflow: hidden;
        margin-bottom: 24px;
    }
    
    .message-card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border-bottom: 2px solid #e9ecef;
        padding: 24px 28px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 12px;
    }
    
    .message-card-title {
        font-size: 18px;
        font-weight: 700;
        color: var(--secondary-color);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .message-card-title i {
        color: var(--primary-color);
        font-size: 20px;
    }
    
    .message-card-body {
        padding: 32px;
    }
    
    /* Subject Section */
    .message-subject {
        margin-bottom: 32px;
    }
    
    .message-subject h4 {
        font-size: 1.75rem;
        font-weight: 700;
        color: var(--secondary-color);
        margin-bottom: 12px;
        line-height: 1.3;
    }
    
    .message-meta {
        display: flex;
        align-items: center;
        gap: 8px;
        color: #6c757d;
        font-size: 14px;
    }
    
    .message-meta i {
        color: var(--primary-color);
    }
    
    /* Sender Info Box */
    .sender-info {
        background: #f8f9fa;
        border: 1px solid #e9ecef;
        border-radius: 8px;
        padding: 24px;
        margin-bottom: 32px;
    }
    
    .sender-info-item {
        margin-bottom: 16px;
    }
    
    .sender-info-item:last-child {
        margin-bottom: 0;
    }
    
    .sender-info-label {
        display: flex;
        align-items: center;
        gap: 8px;
        font-weight: 700;
        color: var(--secondary-color);
        font-size: 13px;
        margin-bottom: 6px;
    }
    
    .sender-info-label i {
        color: var(--primary-color);
        font-size: 14px;
    }
    
    .sender-info-value {
        font-size: 15px;
        color: #495057;
    }
    
    .sender-info-value a {
        color: var(--primary-color);
        text-decoration: none;
        font-weight: 600;
        transition: color 0.3s ease;
    }
    
    .sender-info-value a:hover {
        color: #d95520;
        text-decoration: underline;
    }
    
    /* Message Content */
    .message-content-section {
        margin-bottom: 32px;
    }
    
    .message-content-title {
        font-size: 16px;
        font-weight: 700;
        color: var(--secondary-color);
        margin-bottom: 16px;
    }
    
    .message-content-box {
        border-left: 4px solid var(--primary-color);
        padding-left: 24px;
        padding-top: 12px;
        padding-bottom: 12px;
        background: rgba(242, 97, 36, 0.02);
        border-radius: 0 8px 8px 0;
    }
    
    .message-content-box p {
        font-size: 15px;
        line-height: 1.8;
        color: #495057;
        margin: 0;
    }
    
    /* Reply Alert Box */
    .reply-alert {
        background: #d4edda;
        border: 1px solid #c3e6cb;
        border-left: 4px solid #28a745;
        border-radius: 8px;
        padding: 24px;
        margin-bottom: 32px;
    }
    
    .reply-alert-heading {
        font-size: 16px;
        font-weight: 700;
        color: #155724;
        margin-bottom: 16px;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .reply-alert-heading i {
        font-size: 18px;
    }
    
    .reply-alert hr {
        border: none;
        border-top: 1px solid rgba(0, 0, 0, 0.1);
        margin: 16px 0;
    }
    
    .reply-meta {
        font-size: 14px;
        color: #155724;
        margin-bottom: 16px;
    }
    
    .reply-meta strong {
        font-weight: 700;
    }
    
    .reply-content {
        background: #fff;
        border: 1px solid #c3e6cb;
        border-radius: 8px;
        padding: 20px;
        font-size: 15px;
        line-height: 1.7;
        color: #495057;
    }
    
    /* Action Buttons Section */
    .actions-section {
        margin-top: 32px;
        padding-top: 24px;
        border-top: 2px solid #e9ecef;
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        justify-content: space-between;
    }
    
    .actions-left {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
    }
    
    /* Buttons */
    .btn {
        border-radius: 8px;
        padding: 11px 24px;
        font-size: 14px;
        font-weight: 600;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        text-decoration: none;
    }
    
    .btn-success {
        background: #28a745;
        color: #fff;
    }
    
    .btn-success:hover {
        background: #218838;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(40, 167, 69, 0.3);
        color: #fff;
    }
    
    .btn-secondary {
        background: #6c757d;
        color: #fff;
    }
    
    .btn-secondary:hover {
        background: #5a6268;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(108, 117, 125, 0.3);
        color: #fff;
    }
    
    .btn-outline-secondary {
        background: transparent;
        border: 2px solid #6c757d;
        color: #6c757d;
    }
    
    .btn-outline-secondary:hover {
        background: #6c757d;
        color: #fff;
        transform: translateY(-2px);
    }
    
    .btn-danger {
        background: #dc3545;
        color: #fff;
    }
    
    .btn-danger:hover {
        background: #c82333;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(220, 53, 69, 0.3);
        color: #fff;
    }
    
    .btn-primary {
        background: var(--primary-color);
        color: #fff;
    }
    
    .btn-primary:hover {
        background: #d95520;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(242, 97, 36, 0.3);
        color: #fff;
    }
    
    .btn-info {
        background: #17a2b8;
        color: #fff;
    }
    
    .btn-info:hover {
        background: #138496;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(23, 162, 184, 0.3);
        color: #fff;
    }
    
    .btn-block {
        width: 100%;
        justify-content: center;
    }
    
    /* Status Badges */
    .status-badge {
        display: inline-block;
        padding: 8px 16px;
        border-radius: 6px;
        font-size: 12px;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .status-badge.badge-danger {
        background: #dc3545;
        color: #fff;
    }
    
    .status-badge.badge-info {
        background: #17a2b8;
        color: #fff;
    }
    
    .status-badge.badge-success {
        background: #28a745;
        color: #fff;
    }
    
    .status-badge.badge-secondary {
        background: #6c757d;
        color: #fff;
    }
    
    /* Timeline Styles */
    .timeline {
        position: relative;
        padding-left: 40px;
    }
    
    .timeline-item {
        position: relative;
        padding-bottom: 24px;
    }
    
    .timeline-item:not(:last-child):before {
        content: '';
        position: absolute;
        left: -25px;
        top: 30px;
        width: 2px;
        height: calc(100% - 10px);
        background: #dee2e6;
    }
    
    .timeline-badge {
        position: absolute;
        left: -35px;
        top: 0;
        width: 30px;
        height: 30px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #fff;
        font-size: 12px;
    }
    
    .timeline-badge.bg-primary {
        background: var(--primary-color);
    }
    
    .timeline-badge.bg-info {
        background: #17a2b8;
    }
    
    .timeline-badge.bg-success {
        background: #28a745;
    }
    
    .timeline-badge.bg-secondary {
        background: #6c757d;
    }
    
    .timeline-content {
        padding-left: 10px;
    }
    
    .timeline-content strong {
        font-size: 14px;
        font-weight: 700;
        color: var(--secondary-color);
        display: block;
        margin-bottom: 4px;
    }
    
    .timeline-content p {
        font-size: 12px;
        color: #6c757d;
        margin: 0;
    }
    
    /* Info Table */
    .info-table {
        width: 100%;
    }
    
    .info-table tr {
        border-bottom: 1px solid #e9ecef;
    }
    
    .info-table tr:last-child {
        border-bottom: none;
    }
    
    .info-table td {
        padding: 12px 0;
        font-size: 14px;
    }
    
    .info-table td:first-child {
        color: #6c757d;
        font-weight: 600;
    }
    
    .info-table td:last-child {
        text-align: right;
        font-weight: 600;
        color: var(--secondary-color);
    }
    
    /* Responsive */
    @media (max-width: 768px) {
        .message-card-header {
            padding: 20px;
        }
        
        .message-card-body {
            padding: 24px 20px;
        }
        
        .message-subject h4 {
            font-size: 1.5rem;
        }
        
        .sender-info {
            padding: 20px;
        }
        
        .message-content-box {
            padding-left: 16px;
        }
        
        .actions-section {
            flex-direction: column;
        }
        
        .actions-left {
            flex-direction: column;
            width: 100%;
        }
        
        .actions-left .btn {
            width: 100%;
            justify-content: center;
        }
        
        .btn-danger {
            width: 100%;
            justify-content: center;
        }
    }
</style>

<div class="row">
    <!-- Message Details -->
    <div class="col-lg-8 mb-4">
        <div class="message-card">
            <div class="message-card-header">
                <h6 class="message-card-title">
                    <i class="fas fa-envelope-open"></i> Message Details
                </h6>
                <div>
                    <?php
                    $status_badges = [
                        'new' => '<span class="status-badge badge-danger">New</span>',
                        'read' => '<span class="status-badge badge-info">Read</span>',
                        'replied' => '<span class="status-badge badge-success">Replied</span>',
                        'archived' => '<span class="status-badge badge-secondary">Archived</span>'
                    ];
                    echo isset($status_badges[$message->status]) ? $status_badges[$message->status] : '<span class="status-badge badge-secondary">' . ucfirst($message->status) . '</span>';
                    ?>
                </div>
            </div>

            <div class="message-card-body">
                <!-- Subject -->
                <div class="message-subject">
                    <h4><?php echo htmlspecialchars($message->subject); ?></h4>
                    <div class="message-meta">
                        <i class="far fa-clock"></i>
                        <span>Received on <?php echo date('F d, Y \a\t h:i A', strtotime($message->created_at)); ?></span>
                    </div>
                </div>

                <!-- Sender Information -->
                <div class="sender-info">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="sender-info-item">
                                <div class="sender-info-label">
                                    <i class="fas fa-user"></i>
                                    <span>Name</span>
                                </div>
                                <div class="sender-info-value">
                                    <?php echo htmlspecialchars($message->name); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="sender-info-item">
                                <div class="sender-info-label">
                                    <i class="fas fa-envelope"></i>
                                    <span>Email</span>
                                </div>
                                <div class="sender-info-value">
                                    <a href="mailto:<?php echo htmlspecialchars($message->email); ?>">
                                        <?php echo htmlspecialchars($message->email); ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <?php if ($message->phone): ?>
                            <div class="col-md-6">
                                <div class="sender-info-item">
                                    <div class="sender-info-label">
                                        <i class="fas fa-phone"></i>
                                        <span>Phone</span>
                                    </div>
                                    <div class="sender-info-value">
                                        <a href="tel:<?php echo htmlspecialchars($message->phone); ?>">
                                            <?php echo htmlspecialchars($message->phone); ?>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="col-md-6">
                            <div class="sender-info-item">
                                <div class="sender-info-label">
                                    <i class="fas fa-network-wired"></i>
                                    <span>IP Address</span>
                                </div>
                                <div class="sender-info-value">
                                    <?php echo htmlspecialchars($message->ip_address); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Message Content -->
                <div class="message-content-section">
                    <h6 class="message-content-title">Message:</h6>
                    <div class="message-content-box">
                        <p><?php echo nl2br(htmlspecialchars($message->message)); ?></p>
                    </div>
                </div>

                <!-- Reply Section (if replied) -->
                <?php if ($message->status === 'replied' && $message->reply_message): ?>
                    <div class="reply-alert">
                        <h6 class="reply-alert-heading">
                            <i class="fas fa-reply"></i> Reply Sent
                        </h6>
                        <hr>
                        <div class="reply-meta">
                            <strong>Replied by:</strong> <?php echo htmlspecialchars($message->replied_by_name); ?><br>
                            <strong>Replied on:</strong> <?php echo date('F d, Y \a\t h:i A', strtotime($message->replied_at)); ?>
                        </div>
                        <div class="reply-content">
                            <?php echo nl2br(htmlspecialchars($message->reply_message)); ?>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Action Buttons -->
                <div class="actions-section">
                    <div class="actions-left">
                        <?php if ($message->status !== 'replied'): ?>
                            <a href="<?php echo base_url('admin/messages/reply/' . $message->id); ?>" 
                               class="btn btn-success">
                                <i class="fas fa-reply"></i> Reply to Message
                            </a>
                        <?php endif; ?>

                        <?php if ($message->status !== 'archived'): ?>
                            <a href="<?php echo base_url('admin/messages/archive/' . $message->id); ?>" 
                               class="btn btn-secondary"
                               onclick="return confirm('Archive this message?');">
                                <i class="fas fa-archive"></i> Archive
                            </a>
                        <?php endif; ?>

                        <a href="<?php echo base_url('admin/messages'); ?>" class="btn btn-outline-secondary">
                            <i class="fas fa-arrow-left"></i> Back to Messages
                        </a>
                    </div>
                    
                    <a href="<?php echo base_url('admin/messages/delete/' . $message->id); ?>" 
                       class="btn btn-danger"
                       onclick="return confirm('Are you sure you want to delete this message? This action cannot be undone.');">
                        <i class="fas fa-trash"></i> Delete
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Sidebar -->
    <div class="col-lg-4">
        <!-- Quick Actions -->
        <div class="message-card">
            <div class="message-card-header">
                <h6 class="message-card-title">
                    <i class="fas fa-bolt"></i> Quick Actions
                </h6>
            </div>
            <div class="message-card-body">
                <a href="mailto:<?php echo htmlspecialchars($message->email); ?>" 
                   class="btn btn-primary btn-block mb-2">
                    <i class="fas fa-envelope"></i> Send Email
                </a>

                <?php if ($message->phone): ?>
                    <a href="tel:<?php echo htmlspecialchars($message->phone); ?>" 
                       class="btn btn-info btn-block mb-2">
                        <i class="fas fa-phone"></i> Call
                    </a>
                <?php endif; ?>

                <?php if ($message->status !== 'replied'): ?>
                    <a href="<?php echo base_url('admin/messages/reply/' . $message->id); ?>" 
                       class="btn btn-success btn-block mb-2">
                        <i class="fas fa-reply"></i> Reply via System
                    </a>
                <?php endif; ?>

                <button type="button" class="btn btn-secondary btn-block" 
                        onclick="copyToClipboard('<?php echo htmlspecialchars($message->email); ?>')">
                    <i class="fas fa-copy"></i> Copy Email
                </button>
            </div>
        </div>

        <!-- Message Status Timeline -->
        <div class="message-card">
            <div class="message-card-header">
                <h6 class="message-card-title">
                    <i class="fas fa-history"></i> Status Timeline
                </h6>
            </div>
            <div class="message-card-body">
                <div class="timeline">
                    <!-- Received -->
                    <div class="timeline-item">
                        <div class="timeline-badge bg-primary">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <div class="timeline-content">
                            <strong>Message Received</strong>
                            <p><?php echo date('M d, Y h:i A', strtotime($message->created_at)); ?></p>
                        </div>
                    </div>

                    <!-- Read -->
                    <?php if (in_array($message->status, ['read', 'replied', 'archived'])): ?>
                        <div class="timeline-item">
                            <div class="timeline-badge bg-info">
                                <i class="fas fa-eye"></i>
                            </div>
                            <div class="timeline-content">
                                <strong>Marked as Read</strong>
                                <p><?php echo date('M d, Y h:i A', strtotime($message->created_at)); ?></p>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Replied -->
                    <?php if ($message->status === 'replied' && $message->replied_at): ?>
                        <div class="timeline-item">
                            <div class="timeline-badge bg-success">
                                <i class="fas fa-reply"></i>
                            </div>
                            <div class="timeline-content">
                                <strong>Reply Sent</strong>
                                <p>By: <?php echo htmlspecialchars($message->replied_by_name); ?></p>
                                <p><?php echo date('M d, Y h:i A', strtotime($message->replied_at)); ?></p>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Archived -->
                    <?php if ($message->status === 'archived'): ?>
                        <div class="timeline-item">
                            <div class="timeline-badge bg-secondary">
                                <i class="fas fa-archive"></i>
                            </div>
                            <div class="timeline-content">
                                <strong>Archived</strong>
                                <p><?php echo date('M d, Y h:i A'); ?></p>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Message Info -->
        <div class="message-card">
            <div class="message-card-header">
                <h6 class="message-card-title">
                    <i class="fas fa-info-circle"></i> Message Info
                </h6>
            </div>
            <div class="message-card-body">
                <table class="info-table">
                    <tr>
                        <td>Message ID:</td>
                        <td>#<?php echo $message->id; ?></td>
                    </tr>
                    <tr>
                        <td>Status:</td>
                        <td>
                            <?php
                            $status_text = [
                                'new' => '<span class="status-badge badge-danger">New</span>',
                                'read' => '<span class="status-badge badge-info">Read</span>',
                                'replied' => '<span class="status-badge badge-success">Replied</span>',
                                'archived' => '<span class="status-badge badge-secondary">Archived</span>'
                            ];
                            echo $status_text[$message->status] ?? ucfirst($message->status);
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td>Received:</td>
                        <td><?php echo time_ago($message->created_at); ?></td>
                    </tr>
                    <?php if ($message->replied_at): ?>
                        <tr>
                            <td>Replied:</td>
                            <td><?php echo time_ago($message->replied_at); ?></td>
                        </tr>
                    <?php endif; ?>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript -->
<script>
function copyToClipboard(text) {
    // Create temporary input
    const temp = document.createElement('input');
    temp.value = text;
    document.body.appendChild(temp);
    temp.select();
    document.execCommand('copy');
    document.body.removeChild(temp);
    
    // Show feedback
    alert('Email copied to clipboard: ' + text);
}
</script>