<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Custom Activity Log Styles -->
<style>
    :root {
        --primary-color: #f26124;
        --primary-hover: #d95520;
        --success-color: #1cc88a;
        --info-color: #36b9cc;
        --warning-color: #f6c23e;
        --danger-color: #dc3545;
        --dark-text: #231f20;
        --muted-text: #6c757d;
        --border-color: #e9ecef;
        --bg-light: #f8f9fa;
    }

    .activity-log-container {
        background: #f4f6f9;
        min-height: 100vh;
        padding: 20px 0;
    }

    /* Card Styles */
    .activity-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
        overflow: hidden;
        margin-bottom: 24px;
    }

    .activity-card .card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border: none;
        border-bottom: 2px solid var(--border-color);
        padding: 24px 28px;
    }

    .activity-card .card-header h6 {
        font-size: 18px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .activity-card .card-header h6 i {
        color: var(--primary-color);
        font-size: 20px;
    }

    .activity-card .card-body {
        padding: 32px;
    }

    /* Alert Styles */
    .alert {
        border-radius: 8px;
        border: 1px solid;
        padding: 16px 20px;
        margin-bottom: 32px;
        font-size: 14px;
        display: flex;
        align-items: flex-start;
        gap: 12px;
    }

    .alert i:first-child {
        font-size: 20px;
        margin-top: 2px;
        flex-shrink: 0;
    }

    .alert-info {
        background-color: #d1ecf1;
        border-color: #bee5eb;
        color: #0c5460;
    }

    .alert-secondary {
        background-color: #e2e3e5;
        border-color: #d6d8db;
        color: #383d41;
    }

    .alert strong {
        font-weight: 700;
        display: block;
        margin-bottom: 4px;
    }

    .alert-heading {
        font-size: 15px;
        font-weight: 700;
        margin-bottom: 12px;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    /* Timeline Styles */
    .timeline {
        position: relative;
        padding: 32px 0;
        margin-bottom: 32px;
    }

    .timeline-item {
        position: relative;
        padding-left: 80px;
        padding-bottom: 40px;
        transition: all 0.3s ease;
    }

    .timeline-item:last-child {
        padding-bottom: 0;
    }

    .timeline-item:not(:last-child):before {
        content: '';
        position: absolute;
        left: 29px;
        top: 60px;
        width: 2px;
        height: calc(100% - 20px);
        background: linear-gradient(to bottom, var(--border-color) 0%, transparent 100%);
    }

    .timeline-badge {
        position: absolute;
        left: 0;
        top: 0;
        width: 60px;
        height: 60px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 20px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        z-index: 2;
        transition: all 0.3s ease;
    }

    .timeline-badge:after {
        content: '';
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        width: 100%;
        height: 100%;
        border-radius: 50%;
        background: inherit;
        opacity: 0.3;
        z-index: -1;
    }

    .timeline-item:hover .timeline-badge {
        transform: scale(1.1) rotate(5deg);
        box-shadow: 0 6px 16px rgba(0, 0, 0, 0.2);
    }

    .timeline-badge.bg-success {
        background: linear-gradient(135deg, var(--success-color) 0%, #17a673 100%);
    }

    .timeline-badge.bg-primary {
        background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-hover) 100%);
    }

    .timeline-badge.bg-info {
        background: linear-gradient(135deg, var(--info-color) 0%, #2a9faf 100%);
    }

    .timeline-badge.bg-warning {
        background: linear-gradient(135deg, var(--warning-color) 0%, #e0b02e 100%);
    }

    .timeline-badge.bg-danger {
        background: linear-gradient(135deg, var(--danger-color) 0%, #c82333 100%);
    }

    .timeline-content {
        padding: 20px 24px;
        background: #fff;
        border-radius: 12px;
        border: 1px solid var(--border-color);
        border-left: 4px solid var(--border-color);
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        transition: all 0.3s ease;
    }

    .timeline-item:hover .timeline-content {
        background: var(--bg-light);
        border-left-color: var(--primary-color);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        transform: translateX(4px);
    }

    .timeline-content h6 {
        font-size: 16px;
        font-weight: 700;
        color: var(--dark-text);
        margin-bottom: 8px;
    }

    .timeline-content p {
        font-size: 14px;
        color: var(--muted-text);
        margin-bottom: 8px;
        line-height: 1.5;
    }

    .timeline-content small {
        font-size: 13px;
        color: var(--muted-text);
        display: flex;
        align-items: center;
        gap: 6px;
    }

    .timeline-content small i {
        color: var(--primary-color);
    }

    /* Info Card */
    .info-card {
        background: var(--bg-light);
        border: 1px solid var(--border-color);
        border-radius: 12px;
        padding: 24px;
        margin-top: 32px;
    }

    .info-card h6 {
        font-size: 15px;
        font-weight: 700;
        color: var(--dark-text);
        margin-bottom: 16px;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .info-card h6 i {
        color: var(--primary-color);
    }

    .info-card ol {
        margin-bottom: 0;
        padding-left: 20px;
    }

    .info-card ol li {
        font-size: 14px;
        color: var(--muted-text);
        line-height: 1.6;
        margin-bottom: 16px;
    }

    .info-card ol li:last-child {
        margin-bottom: 0;
    }

    .info-card code {
        background: #fff;
        padding: 2px 8px;
        border-radius: 4px;
        color: var(--danger-color);
        font-size: 13px;
        border: 1px solid var(--border-color);
    }

    /* Responsive Design */
    @media (max-width: 992px) {
        .activity-log-container {
            padding: 16px 0;
        }

        .activity-card .card-header,
        .activity-card .card-body {
            padding: 20px;
        }

        .timeline {
            padding: 24px 0;
        }

        .timeline-item {
            padding-left: 70px;
            padding-bottom: 32px;
        }

        .timeline-badge {
            width: 50px;
            height: 50px;
            font-size: 18px;
        }

        .timeline-item:not(:last-child):before {
            left: 24px;
        }
    }

    @media (max-width: 768px) {
        .activity-card .card-header h6 {
            font-size: 16px;
        }

        .timeline-item {
            padding-left: 60px;
        }

        .timeline-badge {
            width: 44px;
            height: 44px;
            font-size: 16px;
        }

        .timeline-item:not(:last-child):before {
            left: 21px;
        }

        .timeline-content {
            padding: 16px 20px;
        }

        .timeline-content h6 {
            font-size: 15px;
        }

        .alert {
            flex-direction: column;
            gap: 8px;
        }

        .info-card {
            padding: 20px;
        }
    }
</style>

<div class="activity-log-container">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12 mb-4">
                <div class="activity-card">
                    <div class="card-header">
                        <h6>
                            <i class="fas fa-history"></i> Activity Log
                        </h6>
                    </div>

                    <div class="card-body">
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i>
                            <div>
                                <strong>Activity Logging Enabled</strong><br>
                                <?php echo isset($message) ? $message : 'Your activities are being logged for security and audit purposes.'; ?>
                            </div>
                        </div>

                        <!-- Timeline -->
                        <div class="timeline">
                            <!-- Recent Activity -->
                            <div class="timeline-item">
                                <div class="timeline-badge bg-success">
                                    <i class="fas fa-sign-in-alt"></i>
                                </div>
                                <div class="timeline-content">
                                    <h6>Logged In</h6>
                                    <p>
                                        Successfully logged into admin panel
                                    </p>
                                    <small>
                                        <i class="far fa-clock"></i> Today at <?php echo date('h:i A'); ?>
                                    </small>
                                </div>
                            </div>

                            <!-- Profile Update -->
                            <div class="timeline-item">
                                <div class="timeline-badge bg-primary">
                                    <i class="fas fa-user-edit"></i>
                                </div>
                                <div class="timeline-content">
                                    <h6>Profile Updated</h6>
                                    <p>
                                        Updated profile information
                                    </p>
                                    <small>
                                        <i class="far fa-clock"></i> <?php echo date('M d, Y'); ?>
                                    </small>
                                </div>
                            </div>

                            <!-- Content Created -->
                            <div class="timeline-item">
                                <div class="timeline-badge bg-info">
                                    <i class="fas fa-plus"></i>
                                </div>
                                <div class="timeline-content">
                                    <h6>Created Content</h6>
                                    <p>
                                        Added new blog post
                                    </p>
                                    <small>
                                        <i class="far fa-clock"></i> <?php echo date('M d, Y', strtotime('-1 day')); ?>
                                    </small>
                                </div>
                            </div>

                            <!-- Settings Changed -->
                            <div class="timeline-item">
                                <div class="timeline-badge bg-warning">
                                    <i class="fas fa-cog"></i>
                                </div>
                                <div class="timeline-content">
                                    <h6>Settings Modified</h6>
                                    <p>
                                        Updated site settings
                                    </p>
                                    <small>
                                        <i class="far fa-clock"></i> <?php echo date('M d, Y', strtotime('-2 days')); ?>
                                    </small>
                                </div>
                            </div>

                            <!-- Password Changed -->
                            <div class="timeline-item">
                                <div class="timeline-badge bg-danger">
                                    <i class="fas fa-key"></i>
                                </div>
                                <div class="timeline-content">
                                    <h6>Security Update</h6>
                                    <p>
                                        Password changed successfully
                                    </p>
                                    <small>
                                        <i class="far fa-clock"></i> <?php echo date('M d, Y', strtotime('-7 days')); ?>
                                    </small>
                                </div>
                            </div>
                        </div>

                        <!-- Note -->
                        <div class="alert alert-secondary">
                            <i class="fas fa-lightbulb"></i>
                            <div>
                                <h6 class="alert-heading">Note</h6>
                                <p class="mb-0">
                                    This is a sample activity log display. In a production environment, activities would be 
                                    logged to a database table and displayed here with pagination. Activities include:
                                    logins, logouts, content creation/editing/deletion, settings changes, and other administrative actions.
                                </p>
                            </div>
                        </div>

                        <!-- Future Implementation Info -->
                        <div class="info-card">
                            <h6>
                                <i class="fas fa-code"></i> To Implement Full Activity Logging:
                            </h6>
                            <ol>
                                <li>
                                    Create an <code>activity_logs</code> table in your database with fields: 
                                    <code>id</code>, <code>admin_id</code>, <code>action</code>, <code>description</code>, 
                                    <code>ip_address</code>, <code>user_agent</code>, <code>created_at</code>
                                </li>
                                <li>
                                    The <code>log_activity()</code> method in Admin_Controller is already set up to log activities
                                </li>
                                <li>
                                    Create an Activity_model to handle database operations
                                </li>
                                <li>
                                    Update this view to fetch and display actual logs from the database with pagination
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>