<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Custom Profile Styles -->
<style>
    :root {
        --primary-color: #f26124;
        --primary-hover: #d95520;
        --success-color: #1cc88a;
        --info-color: #36b9cc;
        --warning-color: #f6c23e;
        --danger-color: #dc3545;
        --dark-text: #231f20;
        --muted-text: #6c757d;
        --border-color: #e9ecef;
        --bg-light: #f8f9fa;
    }

    .profile-container {
        background: #f4f6f9;
        min-height: 100vh;
        padding: 20px 0;
    }

    /* Card Styles */
    .profile-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
        overflow: hidden;
        margin-bottom: 24px;
    }

    .profile-card .card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border: none;
        border-bottom: 2px solid var(--border-color);
        padding: 24px 28px;
    }

    .profile-card .card-header h6 {
        font-size: 18px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .profile-card .card-header h6 i {
        color: var(--primary-color);
        font-size: 20px;
    }

    .profile-card .card-body {
        padding: 32px;
    }

    /* Form Groups */
    .form-group {
        margin-bottom: 28px;
    }

    .form-group label {
        font-size: 14px;
        font-weight: 700;
        color: var(--dark-text);
        margin-bottom: 10px;
        display: block;
    }

    .form-group label .text-danger {
        color: var(--danger-color);
        margin-left: 4px;
    }

    /* Form Controls */
    .form-control {
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 12px 16px;
        font-size: 14px;
        color: #495057;
        background: #fff;
        transition: all 0.3s ease;
    }

    .form-control:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
        outline: none;
    }

    .form-control::placeholder {
        color: #adb5bd;
    }

    /* Form Text */
    .form-text {
        display: block;
        margin-top: 8px;
        font-size: 13px;
        color: var(--muted-text);
        line-height: 1.5;
    }

    /* Form Footer */
    .form-footer {
        border-top: 2px solid var(--border-color);
        padding-top: 24px;
        margin-top: 32px;
        display: flex;
        gap: 12px;
        flex-wrap: wrap;
    }

    /* Buttons */
    .btn {
        border-radius: 8px;
        padding: 11px 24px;
        font-size: 14px;
        font-weight: 600;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        text-decoration: none;
    }

    .btn-lg {
        padding: 13px 28px;
        font-size: 15px;
    }

    .btn-success {
        background: var(--success-color);
        color: #fff;
    }

    .btn-success:hover {
        background: #17a673;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(28, 200, 138, 0.3);
        color: #fff;
        text-decoration: none;
    }

    .btn-warning {
        background: var(--warning-color);
        color: #fff;
    }

    .btn-warning:hover {
        background: #e0b02e;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(246, 194, 62, 0.3);
        color: #fff;
        text-decoration: none;
    }

    .btn-outline-warning {
        background: transparent;
        color: var(--warning-color);
        border: 2px solid var(--warning-color);
    }

    .btn-outline-warning:hover {
        background: var(--warning-color);
        color: #fff;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(246, 194, 62, 0.3);
        text-decoration: none;
    }

    .btn-outline-info {
        background: transparent;
        color: var(--info-color);
        border: 2px solid var(--info-color);
    }

    .btn-outline-info:hover {
        background: var(--info-color);
        color: #fff;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(54, 185, 204, 0.3);
        text-decoration: none;
    }

    .btn-outline-secondary {
        background: transparent;
        color: #6c757d;
        border: 2px solid var(--border-color);
    }

    .btn-outline-secondary:hover {
        background: var(--bg-light);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        color: #6c757d;
        text-decoration: none;
    }

    .btn-block {
        display: flex;
        width: 100%;
    }

    .btn i {
        font-size: 15px;
    }

    /* Sidebar Cards */
    .sidebar-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
        overflow: hidden;
        margin-bottom: 24px;
    }

    .sidebar-card .card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border: none;
        border-bottom: 2px solid var(--border-color);
        padding: 20px 24px;
    }

    .sidebar-card .card-header h6 {
        font-size: 15px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .sidebar-card .card-header h6 i {
        color: var(--primary-color);
        font-size: 16px;
    }

    .sidebar-card .card-body {
        padding: 24px;
    }

    /* Avatar Section */
    .avatar-section {
        text-align: center;
        margin-bottom: 24px;
    }

    .avatar-circle {
        width: 120px;
        height: 120px;
        border-radius: 50%;
        background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-hover) 100%);
        display: inline-flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 4px 12px rgba(242, 97, 36, 0.3);
        transition: all 0.3s ease;
        margin-bottom: 16px;
    }

    .avatar-circle:hover {
        transform: scale(1.05);
        box-shadow: 0 6px 16px rgba(242, 97, 36, 0.4);
    }

    .avatar-circle span {
        color: #fff;
        font-size: 3rem;
        font-weight: 700;
    }

    /* Info Table */
    .info-table {
        margin: 0;
    }

    .info-table tr {
        border-bottom: 1px solid var(--border-color);
    }

    .info-table tr:last-child {
        border-bottom: none;
    }

    .info-table td {
        padding: 12px 0;
        font-size: 14px;
    }

    .info-table td:first-child {
        color: var(--muted-text);
        font-weight: 500;
        width: 40%;
    }

    .info-table td:last-child {
        text-align: right;
        font-weight: 600;
        color: var(--dark-text);
    }

    /* Badges */
    .badge {
        padding: 6px 12px;
        font-size: 11px;
        font-weight: 600;
        border-radius: 6px;
        text-transform: uppercase;
        letter-spacing: 0.3px;
        display: inline-block;
    }

    .badge-success {
        background: var(--success-color);
        color: #fff;
    }

    .badge-secondary {
        background: #6c757d;
        color: #fff;
    }

    .badge-primary {
        background: var(--primary-color);
        color: #fff;
    }

    .badge-info {
        background: var(--info-color);
        color: #fff;
    }

    .badge-danger {
        background: var(--danger-color);
        color: #fff;
    }

    /* Quick Links Section */
    .quick-links .btn {
        margin-bottom: 12px;
    }

    .quick-links .btn:last-child {
        margin-bottom: 0;
    }

    /* Responsive Design */
    @media (max-width: 992px) {
        .profile-container {
            padding: 16px 0;
        }

        .profile-card .card-header,
        .profile-card .card-body {
            padding: 20px;
        }

        .sidebar-card .card-header,
        .sidebar-card .card-body {
            padding: 16px 20px;
        }

        .form-footer {
            flex-direction: column;
        }

        .form-footer .btn {
            width: 100%;
        }

        .avatar-circle {
            width: 100px;
            height: 100px;
        }

        .avatar-circle span {
            font-size: 2.5rem;
        }
    }

    @media (max-width: 768px) {
        .profile-card .card-header h6 {
            font-size: 16px;
        }

        .form-group {
            margin-bottom: 24px;
        }

        .btn-lg {
            padding: 12px 24px;
            font-size: 14px;
        }

        .info-table td {
            font-size: 13px;
            padding: 10px 0;
        }

        .info-table td:first-child {
            width: 50%;
        }
    }
</style>

<div class="profile-container">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-8 mb-4">
                <div class="profile-card">
                    <div class="card-header">
                        <h6>
                            <i class="fas fa-user"></i> Profile Information
                        </h6>
                    </div>

                    <div class="card-body">
                        <?php echo form_open('admin/profile/update', array('id' => 'profileForm')); ?>

                            <!-- Full Name -->
                            <div class="form-group">
                                <label for="full_name">
                                    Full Name <span class="text-danger">*</span>
                                </label>
                                <input type="text" 
                                       name="full_name" 
                                       id="full_name" 
                                       class="form-control" 
                                       value="<?php echo htmlspecialchars($admin->full_name); ?>" 
                                       required
                                       maxlength="150"
                                       placeholder="Enter your full name">
                            </div>

                            <!-- Username -->
                            <div class="form-group">
                                <label for="username">
                                    Username <span class="text-danger">*</span>
                                </label>
                                <input type="text" 
                                       name="username" 
                                       id="username" 
                                       class="form-control" 
                                       value="<?php echo htmlspecialchars($admin->username); ?>" 
                                       required
                                       maxlength="100"
                                       pattern="[a-zA-Z0-9]+"
                                       placeholder="Username">
                                <small class="form-text">
                                    Letters and numbers only, no spaces
                                </small>
                            </div>

                            <!-- Email -->
                            <div class="form-group">
                                <label for="email">
                                    Email Address <span class="text-danger">*</span>
                                </label>
                                <input type="email" 
                                       name="email" 
                                       id="email" 
                                       class="form-control" 
                                       value="<?php echo htmlspecialchars($admin->email); ?>" 
                                       required
                                       maxlength="150"
                                       placeholder="email@example.com">
                            </div>

                            <!-- Submit Button -->
                            <div class="form-footer">
                                <button type="submit" class="btn btn-success btn-lg">
                                    <i class="fas fa-save"></i> Update Profile
                                </button>
                                <a href="<?php echo base_url('admin/profile/change_password'); ?>" class="btn btn-warning btn-lg">
                                    <i class="fas fa-key"></i> Change Password
                                </a>
                            </div>

                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- Account Info -->
                <div class="sidebar-card">
                    <div class="card-header">
                        <h6>
                            <i class="fas fa-info-circle"></i> Account Information
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="avatar-section">
                            <div class="avatar-circle">
                                <span>
                                    <?php echo strtoupper(substr($admin->full_name, 0, 1)); ?>
                                </span>
                            </div>
                        </div>

                        <table class="info-table table table-sm table-borderless">
                            <tr>
                                <td>Role:</td>
                                <td>
                                    <?php
                                    $role_badges = [
                                        'super_admin' => '<span class="badge badge-danger">Super Admin</span>',
                                        'admin' => '<span class="badge badge-primary">Admin</span>',
                                        'editor' => '<span class="badge badge-info">Editor</span>'
                                    ];
                                    echo $role_badges[$admin->role] ?? '<span class="badge badge-secondary">' . ucfirst($admin->role) . '</span>';
                                    ?>
                                </td>
                            </tr>
                            <tr>
                                <td>Status:</td>
                                <td>
                                    <?php if ($admin->status === 'active'): ?>
                                        <span class="badge badge-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge badge-secondary">Inactive</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td>Member Since:</td>
                                <td>
                                    <small><?php echo date('M d, Y', strtotime($admin->created_at)); ?></small>
                                </td>
                            </tr>
                            <tr>
                                <td>Last Login:</td>
                                <td>
                                    <small>
                                        <?php echo !empty($admin->last_login) ? time_ago($admin->last_login) : 'Never'; ?>
                                    </small>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>

                <!-- Quick Links -->
                <div class="sidebar-card">
                    <div class="card-header">
                        <h6>
                            <i class="fas fa-link"></i> Quick Links
                        </h6>
                    </div>
                    <div class="card-body quick-links">
                        <a href="<?php echo base_url('admin/profile/change_password'); ?>" 
                           class="btn btn-outline-warning btn-block">
                            <i class="fas fa-key"></i> Change Password
                        </a>
                        <a href="<?php echo base_url('admin/profile/activity_log'); ?>" 
                           class="btn btn-outline-info btn-block">
                            <i class="fas fa-history"></i> Activity Log
                        </a>
                        <a href="<?php echo base_url('admin/dashboard'); ?>" 
                           class="btn btn-outline-secondary btn-block">
                            <i class="fas fa-tachometer-alt"></i> Dashboard
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript -->
<script>
document.getElementById('profileForm').addEventListener('submit', function(e) {
    const username = document.getElementById('username').value.trim();
    const email = document.getElementById('email').value.trim();

    if (!username.match(/^[a-zA-Z0-9]+$/)) {
        e.preventDefault();
        alert('Username can only contain letters and numbers (no spaces or special characters).');
        return false;
    }

    if (!email) {
        e.preventDefault();
        alert('Please enter a valid email address.');
        return false;
    }

    return true;
});

// Add visual feedback on input focus
document.querySelectorAll('.form-control').forEach(input => {
    input.addEventListener('focus', function() {
        this.parentElement.classList.add('focused');
    });
    
    input.addEventListener('blur', function() {
        this.parentElement.classList.remove('focused');
    });
});
</script>