<style>
    :root {
        --primary-color: #f26124;
        --secondary-color: #231f20;
        --success-green: #28a745;
        --info-blue: #17a2b8;
        --danger-red: #dc3545;
        --warning-yellow: #ffc107;
    }

    body {
        background: #f4f6f9;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    /* Spacing Utilities */
    .mb-0 {
        margin-bottom: 0 !important;
    }

    .mb-2 {
        margin-bottom: 0.5rem !important;
    }

    .mb-3 {
        margin-bottom: 1rem !important;
    }

    .mb-4 {
        margin-bottom: 1.5rem !important;
    }

    .ps-0 {
        padding-left: 0 !important;
    }

    /* Grid */
    .row {
        display: flex;
        flex-wrap: wrap;
        gap: 24px;
    }

    .col-lg-4 {
        flex: 0 0 calc(33.333% - 16px);
    }

    .col-lg-8 {
        flex: 0 0 calc(66.666% - 16px);
    }

    .col-md-6 {
        flex: 0 0 calc(50% - 12px);
    }

    .col-md-12 {
        flex: 0 0 100%;
    }

    .gap-2 {
        gap: 0.5rem;
    }

    .d-grid {
        display: grid;
    }

    /* Text Utilities */
    .text-muted {
        color: #6c757d !important;
    }

    .text-center {
        text-align: center;
    }

    .d-inline-flex {
        display: inline-flex;
    }

    .align-items-center {
        align-items: center;
    }

    .justify-content-center {
        justify-content: center;
    }

    .mx-auto {
        margin-left: auto;
        margin-right: auto;
    }

    h2 {
        font-size: 28px;
        font-weight: 700;
        color: #231f20;
        margin: 8px 0;
    }

    h4 {
        font-size: 20px;
        font-weight: 700;
        color: #231f20;
        margin: 12px 0;
    }

    h5 {
        font-size: 16px;
        font-weight: 700;
        color: #231f20;
        margin: 0;
    }

    p {
        font-size: 14px;
        color: #495057;
        margin: 4px 0 0 0;
    }

    small {
        font-size: 12px;
    }

    strong {
        font-weight: 700;
    }

    em {
        font-style: italic;
    }

    label {
        display: block;
        font-size: 12px;
        color: #6c757d;
        font-weight: 600;
        margin-bottom: 4px;
    }

    code {
        background: #f8f9fa;
        padding: 2px 6px;
        border-radius: 4px;
        color: #495057;
        font-family: 'Courier New', monospace;
        font-size: 12px;
    }

    /* Links */
    a {
        color: var(--primary-color);
        text-decoration: none;
        transition: all 0.2s ease;
    }

    a:hover {
        color: #d95520;
    }

    /* Card Styling */
    .table-card {
        background: #fff;
        border-radius: 12px;
        padding: 28px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid #e9ecef;
        transition: all 0.3s ease;
    }

    .table-card:hover {
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.12);
    }

    /* Images */
    .rounded-circle {
        border-radius: 50%;
        object-fit: cover;
    }

    /* Badges */
    .badge {
        font-size: 11px;
        font-weight: 700;
        padding: 6px 10px;
        border-radius: 12px;
        display: inline-block;
        white-space: nowrap;
    }

    .bg-info {
        background-color: var(--info-blue) !important;
        color: #fff;
    }

    /* Horizontal Rule */
    hr {
        border: none;
        border-top: 1px solid #e9ecef;
        margin: 1.5rem 0;
    }

    /* Alerts */
    .alert {
        padding: 16px;
        border-radius: 6px;
        border: 1px solid #e9ecef;
        margin-bottom: 1rem;
    }

    .alert-light {
        background: #f8f9fa;
        border-color: #e9ecef;
        color: #495057;
    }

    /* Form Controls */
    .form-control {
        display: block;
        width: 100%;
        padding: 10px 12px;
        font-size: 14px;
        color: #495057;
        background-color: #fff;
        border: 1px solid #dee2e6;
        border-radius: 6px;
        transition: all 0.3s ease;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .form-control:focus {
        color: #495057;
        background-color: #fff;
        border-color: var(--primary-color);
        outline: 0;
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
    }

    .form-control::placeholder {
        color: #adb5bd;
    }

    textarea.form-control {
        resize: vertical;
        min-height: 100px;
    }

    /* Buttons */
    .btn {
        font-size: 14px;
        font-weight: 600;
        padding: 10px 16px;
        border-radius: 6px;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-primary {
        background: var(--primary-color);
        color: #fff;
    }

    .btn-primary:hover {
        background: #d95520;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(242, 97, 36, 0.3);
    }

    .btn-success {
        background: var(--success-green);
        color: #fff;
    }

    .btn-success:hover {
        background: #218838;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(40, 167, 69, 0.3);
    }

    .btn-success:disabled {
        opacity: 0.8;
        cursor: not-allowed;
    }

    .btn-danger {
        background: var(--danger-red);
        color: #fff;
    }

    .btn-danger:hover {
        background: #c82333;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(220, 53, 69, 0.3);
    }

    .btn-outline-primary {
        background: transparent;
        color: var(--primary-color);
        border: 1px solid var(--primary-color);
    }

    .btn-outline-primary:hover {
        background: var(--primary-color);
        color: #fff;
        transform: translateY(-1px);
    }

    .btn-outline-secondary {
        background: transparent;
        color: #231f20;
        border: 1px solid #dee2e6;
    }

    .btn-outline-secondary:hover {
        background: #f8f9fa;
        border-color: #231f20;
        transform: translateY(-1px);
    }

    .btn-outline-danger {
        background: transparent;
        color: var(--danger-red);
        border: 1px solid var(--danger-red);
    }

    .btn-outline-danger:hover {
        background: var(--danger-red);
        color: #fff;
        transform: translateY(-1px);
    }

    .btn-link {
        color: var(--primary-color);
        text-decoration: none;
        font-weight: 600;
        font-size: 14px;
        background: none;
        border: none;
        padding: 0;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-link:hover {
        color: #d95520;
        text-decoration: underline;
    }

    .btn-sm {
        padding: 6px 12px;
        font-size: 12px;
    }

    .w-100 {
        width: 100%;
    }

    /* Icons */
    i {
        margin-right: 4px;
    }

    /* Responsive */
    @media (max-width: 992px) {
        .row {
            gap: 16px;
        }

        .col-lg-4 {
            flex: 0 0 100%;
        }

        .col-lg-8 {
            flex: 0 0 100%;
        }
    }

    @media (max-width: 768px) {
        .row {
            gap: 12px;
        }

        .col-md-6 {
            flex: 0 0 100%;
        }

        .table-card {
            padding: 18px;
        }

        h2 {
            font-size: 24px;
        }

        h4 {
            font-size: 18px;
        }

        h5 {
            font-size: 14px;
        }

        .d-grid {
            grid-template-columns: 1fr;
        }

        .btn {
            width: 100%;
            justify-content: center;
        }

        .form-control {
            font-size: 14px;
            padding: 10px;
        }

        .rounded-circle {
            width: 120px !important;
            height: 120px !important;
        }

        .btn-sm {
            width: auto;
        }
    }

    @media (max-width: 576px) {
        .table-card {
            padding: 16px;
        }

        h2 {
            font-size: 20px;
        }

        h4 {
            font-size: 16px;
        }

        h5 {
            font-size: 13px;
        }

        p {
            font-size: 13px;
        }

        small {
            font-size: 11px;
        }

        .form-control {
            padding: 8px 10px;
            font-size: 13px;
        }

        .btn {
            padding: 8px 12px;
            font-size: 12px;
        }

        .rounded-circle {
            width: 100px !important;
            height: 100px !important;
        }

        label {
            font-size: 11px;
        }
    }
</style>

<!-- Page Header -->
<div class="mb-4">
    <a href="<?php echo base_url('/admin/volunteers'); ?>" class="btn btn-link ps-0">
        <i class="fas fa-arrow-left"></i> Back to Volunteers
    </a>
    <h2><?php echo $volunteer->full_name; ?></h2>
    <p class="text-muted mb-0">Volunteer Application Details</p>
</div>

<div class="row">
    <!-- Left Column - Profile & Actions -->
    <div class="col-lg-4 mb-4">
        <!-- Profile Card -->
        <div class="table-card text-center mb-3">
            <?php if($volunteer->profile_photo): ?>
                <img src="<?php echo base_url('uploads/volunteers/' . $volunteer->profile_photo); ?>" 
                     class="rounded-circle mb-3" 
                     width="150" 
                     height="150"
                     style="object-fit: cover; border: 5px solid #f26124;"
                     alt="<?php echo $volunteer->full_name; ?>">
            <?php else: ?>
                <div class="rounded-circle bg-secondary mx-auto mb-3 d-inline-flex align-items-center justify-content-center" 
                     style="width: 150px; height: 150px; color: white; font-size: 48px; border: 5px solid #f26124;">
                    <?php echo strtoupper(substr($volunteer->full_name, 0, 1)); ?>
                </div>
            <?php endif; ?>
            
            <h4><?php echo $volunteer->full_name; ?></h4>
            <p class="text-muted mb-2"><?php echo $volunteer->occupation; ?></p>
            <div class="mb-3">
                <?php echo get_status_badge($volunteer->status); ?>
            </div>
            
            <!-- Quick Actions -->
            <div class="d-grid gap-2">
                <?php if($volunteer->status == 'pending'): ?>
                <a href="<?php echo base_url('/admin/volunteers/approve/' . $volunteer->id); ?>" 
                   class="btn btn-success"
                   onclick="return confirm('Approve this volunteer application? An email will be sent to notify them.');">
                    <i class="fas fa-check"></i> Approve Application
                </a>
                <a href="<?php echo base_url('/admin/volunteers/reject/' . $volunteer->id); ?>" 
                   class="btn btn-danger"
                   onclick="return confirm('Reject this volunteer application?');">
                    <i class="fas fa-times"></i> Reject Application
                </a>
                <?php elseif($volunteer->status == 'approved'): ?>
                <a href="<?php echo base_url('/admin/volunteers/activate/' . $volunteer->id); ?>" 
                   class="btn btn-primary"
                   onclick="return confirm('Activate this volunteer? They will appear on the public volunteers page.');">
                    <i class="fas fa-user-check"></i> Activate (Make Public)
                </a>
                <?php elseif($volunteer->status == 'active'): ?>
                <button class="btn btn-success" disabled>
                    <i class="fas fa-check-circle"></i> Active Volunteer
                </button>
                <?php endif; ?>
                
                <a href="mailto:<?php echo $volunteer->email; ?>" class="btn btn-outline-primary">
                    <i class="fas fa-envelope"></i> Send Email
                </a>
                
                <a href="tel:<?php echo $volunteer->phone; ?>" class="btn btn-outline-secondary">
                    <i class="fas fa-phone"></i> Call
                </a>
            </div>
        </div>
        
        <!-- Application Info -->
        <div class="table-card">
            <h5 class="mb-3"><i class="fas fa-info-circle"></i> Application Info</h5>
            
            <div class="mb-3">
                <label>Application Date</label>
                <strong><?php echo format_datetime($volunteer->application_date); ?></strong><br>
                <small class="text-muted">(<?php echo time_ago($volunteer->application_date); ?>)</small>
            </div>
            
            <?php if($volunteer->approved_at): ?>
            <div class="mb-3">
                <label>Approved Date</label>
                <strong><?php echo format_datetime($volunteer->approved_at); ?></strong>
            </div>
            <?php endif; ?>
            
            <?php if($volunteer->approved_by_name): ?>
            <div class="mb-3">
                <label>Reviewed By</label>
                <strong><?php echo $volunteer->approved_by_name; ?></strong>
            </div>
            <?php endif; ?>
            
            <hr>
            
            <div class="d-grid gap-2">
                <a href="<?php echo base_url('/admin/volunteers/delete/' . $volunteer->id); ?>" 
                   class="btn btn-sm btn-outline-danger"
                   onclick="return confirm('Are you sure you want to delete this volunteer? This action cannot be undone.');">
                    <i class="fas fa-trash"></i> Delete Volunteer
                </a>
            </div>
        </div>
    </div>
    
    <!-- Right Column - Details -->
    <div class="col-lg-8">
        <!-- Personal Information -->
        <div class="table-card mb-3">
            <h5 class="mb-3"><i class="fas fa-user"></i> Personal Information</h5>
            
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label>Full Name</label>
                    <p class="mb-0"><strong><?php echo $volunteer->full_name; ?></strong></p>
                </div>
                
                <div class="col-md-6 mb-3">
                    <label>Email</label>
                    <p class="mb-0">
                        <a href="mailto:<?php echo $volunteer->email; ?>">
                            <?php echo $volunteer->email; ?>
                        </a>
                    </p>
                </div>
                
                <div class="col-md-6 mb-3">
                    <label>Phone</label>
                    <p class="mb-0">
                        <a href="tel:<?php echo $volunteer->phone; ?>">
                            <?php echo $volunteer->phone; ?>
                        </a>
                    </p>
                </div>
                
                <div class="col-md-6 mb-3">
                    <label>Date of Birth</label>
                    <p class="mb-0">
                        <?php echo $volunteer->date_of_birth ? format_date($volunteer->date_of_birth) : '<em class="text-muted">Not provided</em>'; ?>
                    </p>
                </div>
                
                <div class="col-md-12 mb-3">
                    <label>Address</label>
                    <p class="mb-0"><?php echo nl2br($volunteer->address); ?></p>
                </div>
                
                <div class="col-md-6 mb-3">
                    <label>City</label>
                    <p class="mb-0"><?php echo $volunteer->city; ?></p>
                </div>
                
                <div class="col-md-6 mb-3">
                    <label>Country</label>
                    <p class="mb-0"><?php echo $volunteer->country; ?></p>
                </div>
            </div>
        </div>
        
        <!-- Professional Information -->
        <div class="table-card mb-3">
            <h5 class="mb-3"><i class="fas fa-briefcase"></i> Professional Information</h5>
            
            <div class="mb-3">
                <label>Occupation</label>
                <p class="mb-0"><strong><?php echo $volunteer->occupation; ?></strong></p>
            </div>
            
            <div class="mb-3">
                <label>Skills & Expertise</label>
                <p class="mb-0"><?php echo nl2br($volunteer->skills); ?></p>
            </div>
            
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label>Availability</label>
                    <p class="mb-0">
                        <span class="badge bg-info"><?php echo ucfirst($volunteer->availability); ?></span>
                    </p>
                </div>
            </div>
        </div>
        
        <!-- Volunteer Information -->
        <div class="table-card mb-3">
            <h5 class="mb-3"><i class="fas fa-heart"></i> Volunteer Details</h5>
            
            <div class="mb-3">
                <label>Areas of Interest</label>
                <p class="mb-0"><?php echo nl2br($volunteer->areas_of_interest); ?></p>
            </div>
            
            <div class="mb-3">
                <label>Previous Experience</label>
                <p class="mb-0">
                    <?php echo $volunteer->previous_experience ? nl2br($volunteer->previous_experience) : '<em class="text-muted">No previous experience</em>'; ?>
                </p>
            </div>
            
            <div class="mb-3">
                <label>Motivation / Why do you want to volunteer?</label>
                <div class="alert alert-light">
                    <?php echo nl2br($volunteer->motivation); ?>
                </div>
            </div>
        </div>
        
        <!-- Emergency Contact -->
        <div class="table-card mb-3">
            <h5 class="mb-3"><i class="fas fa-phone-alt"></i> Emergency Contact</h5>
            
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label>Contact Name</label>
                    <p class="mb-0">
                        <?php echo $volunteer->emergency_contact_name ?: '<em class="text-muted">Not provided</em>'; ?>
                    </p>
                </div>
                
                <div class="col-md-6 mb-3">
                    <label>Contact Phone</label>
                    <p class="mb-0">
                        <?php echo $volunteer->emergency_contact_phone ?: '<em class="text-muted">Not provided</em>'; ?>
                    </p>
                </div>
            </div>
        </div>
        
        <!-- Admin Notes -->
        <div class="table-card">
            <h5 class="mb-3"><i class="fas fa-sticky-note"></i> Admin Notes</h5>    
         
            <?php echo form_open('/admin/volunteers/update_notes/' . $volunteer->id); ?>

                <div class="mb-3">
                    <textarea class="form-control" 
                              name="notes" 
                              rows="4"
                              placeholder="Add internal notes about this volunteer (not visible to volunteer)..."><?php echo $volunteer->notes; ?></textarea>
                </div>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Save Notes
                </button>
            </form>
        </div>
    </div>
</div>