<?php defined('BASEPATH') OR exit('No direct script access allowed'); 
$is_edit = isset($workshop);
?>

<style>
    :root {
        --primary-color: #f26124;
        --secondary-color: #231f20;
        --success-color: #28a745;
    }

    /* Form Card */
    .form-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid #e9ecef;
        overflow: hidden;
        margin-bottom: 24px;
    }
    
    .form-card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border-bottom: 2px solid #e9ecef;
        padding: 24px 28px;
    }
    
    .form-card-title {
        font-size: 20px;
        font-weight: 700;
        color: var(--secondary-color);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .form-card-title i {
        color: var(--primary-color);
        font-size: 22px;
    }
    
    .form-card-body {
        padding: 32px;
    }
    
    /* Form Group */
    .form-group {
        margin-bottom: 24px;
    }
    
    .form-group:last-of-type {
        margin-bottom: 0;
    }
    
    .form-group label {
        font-size: 14px;
        font-weight: 700;
        color: var(--secondary-color);
        margin-bottom: 10px;
        display: block;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .form-group label .required {
        color: #dc3545;
        margin-left: 4px;
    }
    
    .form-group label small {
        text-transform: none;
        letter-spacing: normal;
        font-weight: 400;
        color: #6c757d;
    }
    
    /* Form Controls */
    .form-control {
        border: 1px solid #e9ecef;
        border-radius: 8px;
        padding: 12px 16px;
        font-size: 15px;
        color: #495057;
        background: #fff;
        transition: all 0.3s ease;
        width: 100%;
    }
    
    .form-control:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
        outline: none;
    }
    
    .form-control.is-invalid {
        border-color: #dc3545;
    }
    
    .form-control::placeholder {
        color: #adb5bd;
    }
    
    /* Textarea */
    textarea.form-control {
        resize: vertical;
        min-height: 100px;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    
    /* Select */
    select.form-control {
        cursor: pointer;
        appearance: none;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 12px center;
        background-size: 16px 12px;
        padding-right: 36px;
    }
    
    /* Form Text */
    .form-text {
        display: flex;
        align-items: center;
        gap: 6px;
        margin-top: 8px;
        font-size: 13px;
        color: #6c757d;
    }
    
    .form-text i {
        color: var(--primary-color);
    }
    
    /* Invalid Feedback */
    .invalid-feedback {
        display: block;
        margin-top: 6px;
        font-size: 13px;
        color: #dc3545;
        font-weight: 600;
    }
    
    /* Row */
    .row {
        margin-left: -12px;
        margin-right: -12px;
    }
    
    .row > [class*="col-"] {
        padding-left: 12px;
        padding-right: 12px;
    }
    
    /* Current Image */
    .current-image-preview {
        margin-bottom: 16px;
        text-align: center;
    }
    
    .current-image-preview img {
        max-height: 200px;
        border-radius: 8px;
        border: 2px solid #e9ecef;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }
    
    .current-image-preview p {
        margin-top: 12px;
        margin-bottom: 0;
        font-size: 13px;
        color: #6c757d;
    }
    
    /* Custom File Input */
    .custom-file {
        position: relative;
        display: block;
        width: 100%;
    }
    
    .custom-file-input {
        width: 100%;
        height: calc(2.25rem + 2px);
        opacity: 0;
        cursor: pointer;
    }
    
    .custom-file-label {
        position: absolute;
        top: 0;
        right: 0;
        left: 0;
        z-index: 1;
        height: calc(2.25rem + 2px);
        padding: 12px 16px;
        font-size: 15px;
        font-weight: 400;
        line-height: 1.5;
        color: #495057;
        background-color: #fff;
        border: 1px solid #e9ecef;
        border-radius: 8px;
        cursor: pointer;
        transition: all 0.3s ease;
    }
    
    .custom-file-label::after {
        position: absolute;
        top: 0;
        right: 0;
        bottom: 0;
        z-index: 3;
        display: block;
        height: calc(2.25rem);
        padding: 12px 16px;
        line-height: 1.5;
        color: #fff;
        content: "Browse";
        background-color: var(--primary-color);
        border-left: inherit;
        border-radius: 0 8px 8px 0;
        font-weight: 600;
    }
    
    .custom-file-input:focus ~ .custom-file-label {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
    }
    
    /* Custom Checkbox */
    .custom-control {
        position: relative;
        display: flex;
        align-items: flex-start;
        padding-left: 28px;
        margin-bottom: 0;
    }
    
    .custom-control-input {
        position: absolute;
        left: 0;
        z-index: -1;
        width: 18px;
        height: 18px;
        opacity: 0;
    }
    
    .custom-control-label {
        position: relative;
        margin-bottom: 0;
        vertical-align: top;
        font-size: 15px;
        font-weight: 600;
        color: var(--secondary-color);
        cursor: pointer;
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .custom-control-label::before {
        position: absolute;
        top: 2px;
        left: -28px;
        display: block;
        width: 18px;
        height: 18px;
        pointer-events: none;
        content: "";
        background-color: #fff;
        border: 2px solid #e9ecef;
        border-radius: 4px;
        transition: all 0.3s ease;
    }
    
    .custom-control-label::after {
        position: absolute;
        top: 2px;
        left: -28px;
        display: block;
        width: 18px;
        height: 18px;
        content: "";
        background: no-repeat 50% / 50% 50%;
        transition: all 0.3s ease;
    }
    
    .custom-control-input:checked ~ .custom-control-label::before {
        color: #fff;
        border-color: var(--primary-color);
        background-color: var(--primary-color);
    }
    
    .custom-control-input:checked ~ .custom-control-label::after {
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8' viewBox='0 0 8 8'%3e%3cpath fill='%23fff' d='M6.564.75l-3.59 3.612-1.538-1.55L0 4.26l2.974 2.99L8 2.193z'/%3e%3c/svg%3e");
    }
    
    .custom-control-input:focus ~ .custom-control-label::before {
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
    }
    
    /* Action Buttons */
    .actions-section {
        margin-top: 32px;
        padding-top: 24px;
        border-top: 2px solid #e9ecef;
        display: flex;
        flex-wrap: wrap;
        gap: 12px;
    }
    
    /* Buttons */
    .btn {
        border-radius: 8px;
        padding: 12px 28px;
        font-size: 15px;
        font-weight: 600;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        text-decoration: none;
    }
    
    .btn-lg {
        padding: 14px 32px;
        font-size: 16px;
    }
    
    .btn-success {
        background: var(--success-color);
        color: #fff;
    }
    
    .btn-success:hover {
        background: #218838;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(40, 167, 69, 0.3);
        color: #fff;
    }
    
    .btn-outline-secondary {
        background: transparent;
        border: 2px solid #6c757d;
        color: #6c757d;
    }
    
    .btn-outline-secondary:hover {
        background: #6c757d;
        color: #fff;
        transform: translateY(-2px);
    }
    
    /* Sidebar Cards */
    .sidebar-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid #e9ecef;
        overflow: hidden;
        margin-bottom: 24px;
    }
    
    .sidebar-card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border-bottom: 2px solid #e9ecef;
        padding: 20px 24px;
    }
    
    .sidebar-card-title {
        font-size: 16px;
        font-weight: 700;
        color: var(--secondary-color);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .sidebar-card-title i {
        color: var(--primary-color);
        font-size: 18px;
    }
    
    .sidebar-card-body {
        padding: 24px;
    }
    
    /* Tips List */
    .tips-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }
    
    .tips-list li {
        display: flex;
        align-items: flex-start;
        gap: 10px;
        margin-bottom: 12px;
        font-size: 14px;
        color: #495057;
    }
    
    .tips-list li:last-child {
        margin-bottom: 0;
    }
    
    .tips-list li i {
        color: var(--success-color);
        margin-top: 2px;
        flex-shrink: 0;
    }
    
    /* Responsive */
    @media (max-width: 768px) {
        .form-card-header {
            padding: 20px;
        }
        
        .form-card-body {
            padding: 24px 20px;
        }
        
        .sidebar-card-header {
            padding: 16px 20px;
        }
        
        .sidebar-card-body {
            padding: 20px;
        }
        
        .actions-section {
            flex-direction: column;
        }
        
        .actions-section .btn {
            width: 100%;
            justify-content: center;
        }
        
        .row {
            margin-left: 0;
            margin-right: 0;
        }
        
        .row > [class*="col-"] {
            padding-left: 0;
            padding-right: 0;
        }
    }
</style>

<div class="row">
    <div class="col-lg-8 mb-4">
        <div class="form-card">
            <div class="form-card-header">
                <h6 class="form-card-title">
                    <i class="fas fa-chalkboard-teacher"></i> 
                    <?php echo $is_edit ? 'Edit Workshop' : 'Add New Workshop'; ?>
                </h6>
            </div>

            <div class="form-card-body">
               <?php echo form_open_multipart(current_url(), array('id' => 'workshopForm')); ?>

                    <!-- Title -->
                    <div class="form-group">
                        <label for="title">
                            Workshop Title <span class="required">*</span>
                        </label>
                        <input type="text" 
                               name="title" 
                               id="title" 
                               class="form-control <?php echo form_error('title') ? 'is-invalid' : ''; ?>" 
                               value="<?php echo set_value('title', $is_edit ? $workshop->title : ''); ?>" 
                               placeholder="e.g., Youth Leadership Training"
                               required>
                        <?php if (form_error('title')): ?>
                            <div class="invalid-feedback"><?php echo form_error('title'); ?></div>
                        <?php endif; ?>
                    </div>

                    <!-- Description -->
                    <div class="form-group">
                        <label for="description">
                            Short Description <span class="required">*</span>
                        </label>
                        <textarea name="description" 
                                  id="description" 
                                  class="form-control <?php echo form_error('description') ? 'is-invalid' : ''; ?>" 
                                  rows="3" 
                                  placeholder="Brief description of the workshop..."
                                  required><?php echo set_value('description', $is_edit ? $workshop->description : ''); ?></textarea>
                        <?php if (form_error('description')): ?>
                            <div class="invalid-feedback"><?php echo form_error('description'); ?></div>
                        <?php endif; ?>
                        <small class="form-text">A brief overview (1-2 sentences)</small>
                    </div>

                    <!-- Full Description -->
                    <div class="form-group">
                        <label for="full_description">
                            Full Description
                        </label>
                        <textarea name="full_description" 
                                  id="full_description" 
                                  class="form-control" 
                                  rows="8" 
                                  placeholder="Detailed information about the workshop..."><?php echo set_value('full_description', $is_edit ? $workshop->full_description : ''); ?></textarea>
                        <small class="form-text">Detailed workshop information, agenda, what participants will learn, etc.</small>
                    </div>

                    <!-- Duration & Target Audience Row -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="duration">
                                    Duration
                                </label>
                                <input type="text" 
                                       name="duration" 
                                       id="duration" 
                                       class="form-control" 
                                       value="<?php echo set_value('duration', $is_edit ? $workshop->duration : ''); ?>"
                                       placeholder="e.g., 2 days, 1 week, 3 hours">
                                <small class="form-text">How long the workshop lasts</small>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="target_audience">
                                    Target Audience
                                </label>
                                <input type="text" 
                                       name="target_audience" 
                                       id="target_audience" 
                                       class="form-control" 
                                       value="<?php echo set_value('target_audience', $is_edit ? $workshop->target_audience : ''); ?>"
                                       placeholder="e.g., Youth ages 15-25">
                            </div>
                        </div>
                    </div>

                    <!-- Objectives -->
                    <div class="form-group">
                        <label for="objectives">
                            Objectives
                        </label>
                        <textarea name="objectives" 
                                  id="objectives" 
                                  class="form-control" 
                                  rows="4" 
                                  placeholder="What will participants learn or achieve?"><?php echo set_value('objectives', $is_edit ? $workshop->objectives : ''); ?></textarea>
                        <small class="form-text">Learning outcomes and goals</small>
                    </div>

                    <!-- Requirements -->
                    <div class="form-group">
                        <label for="requirements">
                            Requirements
                        </label>
                        <textarea name="requirements" 
                                  id="requirements" 
                                  class="form-control" 
                                  rows="3" 
                                  placeholder="Any prerequisites or materials needed..."><?php echo set_value('requirements', $is_edit ? $workshop->requirements : ''); ?></textarea>
                        <small class="form-text">What participants need to bring or know beforehand</small>
                    </div>

                    <!-- Schedule -->
                    <div class="form-group">
                        <label for="schedule">
                            Schedule/Agenda
                        </label>
                        <textarea name="schedule" 
                                  id="schedule" 
                                  class="form-control" 
                                  rows="5" 
                                  placeholder="Daily or session-by-session breakdown..."><?php echo set_value('schedule', $is_edit ? $workshop->schedule : ''); ?></textarea>
                        <small class="form-text">Workshop timeline and activities</small>
                    </div>

                    <!-- Location, Capacity & Price Row -->
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="location">
                                    Location
                                </label>
                                <input type="text" 
                                       name="location" 
                                       id="location" 
                                       class="form-control" 
                                       value="<?php echo set_value('location', $is_edit ? $workshop->location : ''); ?>"
                                       placeholder="e.g., Community Center, Accra">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="capacity">
                                    Capacity
                                </label>
                                <input type="number" 
                                       name="capacity" 
                                       id="capacity" 
                                       class="form-control" 
                                       value="<?php echo set_value('capacity', $is_edit ? $workshop->capacity : ''); ?>"
                                       min="1"
                                       placeholder="e.g., 50">
                                <small class="form-text">Maximum participants</small>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="price">
                                    Price (GHS)
                                </label>
                                <input type="number" 
                                       name="price" 
                                       id="price" 
                                       class="form-control" 
                                       value="<?php echo set_value('price', $is_edit ? $workshop->price : '0.00'); ?>"
                                       step="0.01"
                                       min="0"
                                       placeholder="0.00">
                                <small class="form-text">Leave 0 for free</small>
                            </div>
                        </div>
                    </div>

                    <!-- Facilitator -->
                    <div class="form-group">
                        <label for="facilitator">
                            Facilitator/Instructor
                        </label>
                        <input type="text" 
                               name="facilitator" 
                               id="facilitator" 
                               class="form-control" 
                               value="<?php echo set_value('facilitator', $is_edit ? $workshop->facilitator : ''); ?>"
                               placeholder="e.g., Dr. John Doe">
                        <small class="form-text">Name of workshop leader or instructor</small>
                    </div>

                    <!-- Date Range Row -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="start_date">
                                    Start Date
                                </label>
                                <input type="date" 
                                       name="start_date" 
                                       id="start_date" 
                                       class="form-control" 
                                       value="<?php echo set_value('start_date', $is_edit ? $workshop->start_date : ''); ?>">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="end_date">
                                    End Date <small>(Optional)</small>
                                </label>
                                <input type="date" 
                                       name="end_date" 
                                       id="end_date" 
                                       class="form-control" 
                                       value="<?php echo set_value('end_date', $is_edit ? $workshop->end_date : ''); ?>">
                                <small class="form-text">For multi-day workshops</small>
                            </div>
                        </div>
                    </div>

                    <!-- Display Order -->
                    <div class="form-group">
                        <label for="display_order">
                            Display Order
                        </label>
                        <input type="number" 
                               name="display_order" 
                               id="display_order" 
                               class="form-control" 
                               value="<?php echo set_value('display_order', $is_edit ? $workshop->display_order : '0'); ?>"
                               min="0"
                               placeholder="0">
                        <small class="form-text">Lower numbers appear first (0 = default)</small>
                    </div>

                    <!-- Featured Image -->
                    <div class="form-group">
                        <label for="featured_image">
                            Featured Image
                        </label>

                        <?php if ($is_edit && !empty($workshop->featured_image)): ?>
                            <div class="current-image-preview">
                                <img src="<?php echo base_url('uploads/workshops/' . $workshop->featured_image); ?>" 
                                     alt="Current Image">
                                <p>
                                    Current image: <?php echo $workshop->featured_image; ?>
                                </p>
                            </div>
                        <?php endif; ?>

                        <div class="custom-file">
                            <input type="file" 
                                   name="featured_image" 
                                   id="featured_image" 
                                   class="custom-file-input" 
                                   accept="image/*">
                            <label class="custom-file-label" for="featured_image">Choose file</label>
                        </div>
                        <small class="form-text">
                            <i class="fas fa-info-circle"></i> Recommended size: 1200x600px. Max 2MB. Formats: JPG, PNG
                        </small>
                    </div>

                    <!-- Submit Buttons -->
                    <div class="actions-section">
                        <button type="submit" class="btn btn-success btn-lg">
                            <i class="fas fa-save"></i> 
                            <?php echo $is_edit ? 'Update Workshop' : 'Create Workshop'; ?>
                        </button>

                        <a href="<?php echo base_url('admin/workshops'); ?>" class="btn btn-outline-secondary btn-lg">
                            <i class="fas fa-times"></i> Cancel
                        </a>
                    </div>

                <?php echo form_close(); ?>
            </div>
        </div>
    </div>

    <!-- Sidebar -->
    <div class="col-lg-4">
        <!-- Status & Publishing -->
        <div class="sidebar-card">
            <div class="sidebar-card-header">
                <h6 class="sidebar-card-title">
                    <i class="fas fa-cog"></i> Publishing Options
                </h6>
            </div>
            <div class="sidebar-card-body">
                <!-- Status -->
                <div class="form-group">
                    <label for="status">Status <span class="required">*</span></label>
                    <select name="status" id="status" class="form-control" form="workshopForm" required>
                        <option value="upcoming" <?php echo set_select('status', 'upcoming', $is_edit && $workshop->status === 'upcoming'); ?>>Upcoming</option>
                        <option value="ongoing" <?php echo set_select('status', 'ongoing', $is_edit && $workshop->status === 'ongoing'); ?>>Ongoing</option>
                        <option value="completed" <?php echo set_select('status', 'completed', $is_edit && $workshop->status === 'completed'); ?>>Completed</option>
                        <option value="cancelled" <?php echo set_select('status', 'cancelled', $is_edit && $workshop->status === 'cancelled'); ?>>Cancelled</option>
                    </select>
                </div>

                <!-- Featured -->
                <div class="form-group mb-0">
                    <label class="custom-control custom-checkbox">
                        <input type="checkbox" 
                               name="is_featured" 
                               value="1" 
                               class="custom-control-input"
                               form="workshopForm"
                               <?php echo set_checkbox('is_featured', '1', $is_edit && $workshop->is_featured); ?>>
                        <span class="custom-control-label">
                            <i class="fas fa-star" style="color: #ffc107;"></i> Featured Workshop
                        </span>
                    </label>
                    <small class="form-text">Display on homepage and highlight in listings</small>
                </div>
            </div>
        </div>

        <!-- Tips -->
        <div class="sidebar-card">
            <div class="sidebar-card-header">
                <h6 class="sidebar-card-title">
                    <i class="fas fa-lightbulb"></i> Tips
                </h6>
            </div>
            <div class="sidebar-card-body">
                <ul class="tips-list">
                    <li>
                        <i class="fas fa-check"></i> Use clear, descriptive titles
                    </li>
                    <li>
                        <i class="fas fa-check"></i> Add high-quality images
                    </li>
                    <li>
                        <i class="fas fa-check"></i> Include specific objectives
                    </li>
                    <li>
                        <i class="fas fa-check"></i> Provide detailed schedules
                    </li>
                    <li>
                        <i class="fas fa-check"></i> Specify target audience
                    </li>
                    <li>
                        <i class="fas fa-check"></i> List any requirements clearly
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript -->
<script>
// Update file input label
document.getElementById('featured_image').addEventListener('change', function() {
    const fileName = this.files[0]?.name || 'Choose file';
    this.nextElementSibling.textContent = fileName;
});

// Form validation
document.getElementById('workshopForm').addEventListener('submit', function(e) {
    const startDate = document.getElementById('start_date').value;
    const endDate = document.getElementById('end_date').value;

    if (startDate && endDate && endDate < startDate) {
        e.preventDefault();
        alert('End date cannot be before start date.');
        return false;
    }

    return true;
});
</script>