<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<style>
    :root {
        --primary-color: #f26124;
        --secondary-color: #231f20;
    }

    /* Statistics Cards */
    .stats-container {
        margin-bottom: 32px;
    }
    
    .stat-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid #e9ecef;
        border-left: 4px solid;
        padding: 24px;
        height: 100%;
        transition: all 0.3s ease;
    }
    
    .stat-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.12);
    }
    
    .stat-card.primary {
        border-left-color: var(--primary-color);
    }
    
    .stat-card.warning {
        border-left-color: #ffc107;
    }
    
    .stat-card.success {
        border-left-color: #28a745;
    }
    
    .stat-card.info {
        border-left-color: #17a2b8;
    }
    
    .stat-card-content {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    
    .stat-card-info {
        flex: 1;
    }
    
    .stat-card-label {
        font-size: 11px;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 8px;
        color: #6c757d;
    }
    
    .stat-card.primary .stat-card-label {
        color: var(--primary-color);
    }
    
    .stat-card.warning .stat-card-label {
        color: #ffc107;
    }
    
    .stat-card.success .stat-card-label {
        color: #28a745;
    }
    
    .stat-card.info .stat-card-label {
        color: #17a2b8;
    }
    
    .stat-card-value {
        font-size: 2rem;
        font-weight: 800;
        color: var(--secondary-color);
    }
    
    .stat-card-icon {
        font-size: 3rem;
        color: #e9ecef;
    }
    
    /* Main Card */
    .workshops-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid #e9ecef;
        overflow: hidden;
    }
    
    .workshops-card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border-bottom: 2px solid #e9ecef;
        padding: 24px 28px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 16px;
    }
    
    .workshops-card-title {
        font-size: 20px;
        font-weight: 700;
        color: var(--secondary-color);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .workshops-card-title i {
        color: var(--primary-color);
        font-size: 22px;
    }
    
    .workshops-card-body {
        padding: 28px;
    }
    
    /* Tabs */
    .custom-tabs {
        display: flex;
        gap: 8px;
        margin-bottom: 32px;
        border-bottom: 2px solid #e9ecef;
        flex-wrap: wrap;
    }
    
    .custom-tab {
        padding: 12px 20px;
        text-decoration: none;
        color: #6c757d;
        font-weight: 600;
        font-size: 14px;
        border-bottom: 3px solid transparent;
        margin-bottom: -2px;
        transition: all 0.3s ease;
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .custom-tab:hover {
        color: var(--primary-color);
        background: rgba(242, 97, 36, 0.05);
    }
    
    .custom-tab.active {
        color: var(--primary-color);
        border-bottom-color: var(--primary-color);
    }
    
    .custom-tab .badge {
        padding: 4px 8px;
        border-radius: 4px;
        font-size: 11px;
        font-weight: 700;
    }
    
    .badge.bg-secondary {
        background: #6c757d !important;
        color: #fff;
    }
    
    .badge.bg-info {
        background: #17a2b8 !important;
        color: #fff;
    }
    
    .badge.bg-primary {
        background: var(--primary-color) !important;
        color: #fff;
    }
    
    .badge.bg-success {
        background: #28a745 !important;
        color: #fff;
    }
    
    .badge.bg-danger {
        background: #dc3545 !important;
        color: #fff;
    }
    
    /* Workshop Card */
    .workshop-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid #e9ecef;
        overflow: hidden;
        height: 100%;
        transition: all 0.3s ease;
        display: flex;
        flex-direction: column;
    }
    
    .workshop-card:hover {
        transform: translateY(-6px);
        box-shadow: 0 12px 24px rgba(0, 0, 0, 0.15);
        border-color: var(--primary-color);
    }
    
    /* Workshop Image */
    .workshop-image-wrapper {
        position: relative;
        overflow: hidden;
        height: 220px;
        border-bottom: 3px solid var(--primary-color);
    }
    
    .workshop-card-img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.5s ease;
    }
    
    .workshop-card:hover .workshop-card-img {
        transform: scale(1.1);
    }
    
    .workshop-image-placeholder {
        width: 100%;
        height: 100%;
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        color: #adb5bd;
    }
    
    .workshop-image-placeholder i {
        font-size: 4rem;
        opacity: 0.5;
    }
    
    /* Workshop Body */
    .workshop-card-body {
        padding: 24px;
        flex: 1;
        display: flex;
        flex-direction: column;
    }
    
    /* Status Badges */
    .status-badges {
        margin-bottom: 16px;
        display: flex;
        gap: 8px;
        flex-wrap: wrap;
    }
    
    .status-badge {
        display: inline-flex;
        align-items: center;
        gap: 4px;
        padding: 6px 12px;
        border-radius: 6px;
        font-size: 11px;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .status-badge.badge-warning {
        background: #fff3cd;
        color: #856404;
        border: 1px solid #ffeeba;
    }
    
    .status-badge.badge-success {
        background: #d4edda;
        color: #155724;
        border: 1px solid #c3e6cb;
    }
    
    .status-badge.badge-info {
        background: #d1ecf1;
        color: #0c5460;
        border: 1px solid #bee5eb;
    }
    
    .status-badge.badge-danger {
        background: #f8d7da;
        color: #721c24;
        border: 1px solid #f5c6cb;
    }
    
    .status-badge.badge-primary {
        background: rgba(242, 97, 36, 0.1);
        color: var(--primary-color);
        border: 1px solid rgba(242, 97, 36, 0.3);
    }
    
    /* Workshop Title */
    .workshop-title {
        font-size: 1.25rem;
        font-weight: 700;
        color: var(--secondary-color);
        margin-bottom: 12px;
        line-height: 1.4;
    }
    
    /* Workshop Description */
    .workshop-description {
        font-size: 0.95rem;
        color: #6c757d;
        line-height: 1.6;
        margin-bottom: 16px;
    }
    
    /* Workshop Details */
    .workshop-details {
        margin-bottom: 16px;
        flex: 1;
    }
    
    .workshop-detail-item {
        display: flex;
        align-items: flex-start;
        gap: 8px;
        margin-bottom: 10px;
        font-size: 13px;
        color: #495057;
    }
    
    .workshop-detail-item:last-child {
        margin-bottom: 0;
    }
    
    .workshop-detail-item i {
        color: var(--primary-color);
        margin-top: 2px;
        flex-shrink: 0;
    }
    
    .workshop-detail-item strong {
        font-weight: 700;
        color: var(--secondary-color);
    }
    
    /* Action Buttons */
    .workshop-actions {
        display: flex;
        gap: 0;
    }
    
    .workshop-actions .btn {
        flex: 1;
        border-radius: 0;
        border: none;
        border-right: 1px solid rgba(255, 255, 255, 0.2);
    }
    
    .workshop-actions .btn:first-child {
        border-radius: 6px 0 0 6px;
    }
    
    .workshop-actions .btn:last-child {
        border-radius: 0 6px 6px 0;
        border-right: none;
    }
    
    .btn {
        padding: 10px 16px;
        font-size: 13px;
        font-weight: 600;
        transition: all 0.3s ease;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 6px;
        text-decoration: none;
    }
    
    .btn-sm {
        padding: 8px 12px;
        font-size: 12px;
    }
    
    .btn-primary {
        background: var(--primary-color);
        color: #fff;
    }
    
    .btn-primary:hover {
        background: #d95520;
        color: #fff;
    }
    
    .btn-info {
        background: #17a2b8;
        color: #fff;
    }
    
    .btn-info:hover {
        background: #138496;
        color: #fff;
    }
    
    .btn-danger {
        background: #dc3545;
        color: #fff;
    }
    
    .btn-danger:hover {
        background: #c82333;
        color: #fff;
    }
    
    /* Card Footer */
    .workshop-card-footer {
        background: #f8f9fa;
        border-top: 1px solid #e9ecef;
        padding: 12px 24px;
        font-size: 12px;
        color: #6c757d;
    }
    
    .workshop-card-footer i {
        color: var(--primary-color);
    }
    
    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 80px 20px;
    }
    
    .empty-state i {
        font-size: 5rem;
        color: #dee2e6;
        margin-bottom: 24px;
        opacity: 0.6;
    }
    
    .empty-state h5 {
        font-size: 1.5rem;
        font-weight: 700;
        color: var(--secondary-color);
        margin-bottom: 12px;
    }
    
    .empty-state p {
        font-size: 1rem;
        color: #6c757d;
        margin-bottom: 24px;
    }
    
    /* Responsive */
    @media (max-width: 768px) {
        .workshops-card-header {
            padding: 20px;
        }
        
        .workshops-card-body {
            padding: 20px;
        }
        
        .stat-card {
            margin-bottom: 16px;
        }
        
        .custom-tabs {
            overflow-x: auto;
            flex-wrap: nowrap;
        }
        
        .workshop-image-wrapper {
            height: 180px;
        }
        
        .workshop-card-body {
            padding: 20px;
        }
        
        .workshop-actions {
            flex-direction: column;
            gap: 8px;
        }
        
        .workshop-actions .btn {
            border-radius: 6px !important;
            border-right: none;
        }
    }
</style>

<?php
// Calculate statistics from workshops array
$total = count($workshops);
$upcoming = count(array_filter($workshops, function($w) { return $w->status === 'upcoming'; }));
$ongoing = count(array_filter($workshops, function($w) { return $w->status === 'ongoing'; }));
$completed = count(array_filter($workshops, function($w) { return $w->status === 'completed'; }));
?>

<!-- Statistics Cards -->
<div class="stats-container">
    <div class="row">
        <div class="col-md-3 col-sm-6 mb-3">
            <div class="stat-card primary">
                <div class="stat-card-content">
                    <div class="stat-card-info">
                        <div class="stat-card-label">Total Workshops</div>
                        <div class="stat-card-value"><?php echo $total; ?></div>
                    </div>
                    <div class="stat-card-icon">
                        <i class="fas fa-chalkboard-teacher"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6 mb-3">
            <div class="stat-card warning">
                <div class="stat-card-content">
                    <div class="stat-card-info">
                        <div class="stat-card-label">Upcoming</div>
                        <div class="stat-card-value"><?php echo $upcoming; ?></div>
                    </div>
                    <div class="stat-card-icon">
                        <i class="fas fa-calendar-alt"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6 mb-3">
            <div class="stat-card success">
                <div class="stat-card-content">
                    <div class="stat-card-info">
                        <div class="stat-card-label">Ongoing</div>
                        <div class="stat-card-value"><?php echo $ongoing; ?></div>
                    </div>
                    <div class="stat-card-icon">
                        <i class="fas fa-play-circle"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6 mb-3">
            <div class="stat-card info">
                <div class="stat-card-content">
                    <div class="stat-card-info">
                        <div class="stat-card-label">Completed</div>
                        <div class="stat-card-value"><?php echo $completed; ?></div>
                    </div>
                    <div class="stat-card-icon">
                        <i class="fas fa-check-double"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Main Card -->
<div class="workshops-card">
    <div class="workshops-card-header">
        <h6 class="workshops-card-title">
            <i class="fas fa-chalkboard-teacher"></i> Workshop Programmes
        </h6>
        <div>
            <a href="<?php echo base_url('admin/workshops/add'); ?>" class="btn btn-sm btn-primary">
                <i class="fas fa-plus"></i> Add New Workshop
            </a>
        </div>
    </div>

    <div class="workshops-card-body">
        <!-- Status Filter Tabs -->
        <div class="custom-tabs">
            <a class="custom-tab <?php echo empty($current_status) ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/workshops'); ?>">
                All Workshops <span class="badge bg-secondary"><?php echo $statistics['total'] ?? 0; ?></span>
            </a>
            <a class="custom-tab <?php echo ($current_status === 'upcoming') ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/workshops?status=upcoming'); ?>">
                Upcoming <span class="badge bg-info"><?php echo $statistics['upcoming'] ?? 0; ?></span>
            </a>
            <a class="custom-tab <?php echo ($current_status === 'ongoing') ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/workshops?status=ongoing'); ?>">
                Ongoing <span class="badge bg-primary"><?php echo $statistics['ongoing'] ?? 0; ?></span>
            </a>
            <a class="custom-tab <?php echo ($current_status === 'completed') ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/workshops?status=completed'); ?>">
                Completed <span class="badge bg-success"><?php echo $statistics['completed'] ?? 0; ?></span>
            </a>
            <a class="custom-tab <?php echo ($current_status === 'cancelled') ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/workshops?status=cancelled'); ?>">
                Cancelled <span class="badge bg-danger"><?php echo $statistics['cancelled'] ?? 0; ?></span>
            </a>
        </div>

        <?php if (!empty($workshops)): ?>
            <!-- Workshops Grid -->
            <div class="row">
                <?php foreach ($workshops as $workshop): ?>
                    <div class="col-lg-6 mb-4">
                        <div class="workshop-card">
                            <!-- Workshop Image -->
                            <div class="workshop-image-wrapper">
                                <?php if (!empty($workshop->featured_image)): ?>
                                    <img src="<?php echo base_url('uploads/workshops/' . $workshop->featured_image); ?>" 
                                         class="workshop-card-img" 
                                         alt="<?php echo htmlspecialchars($workshop->title); ?>">
                                <?php else: ?>
                                    <div class="workshop-image-placeholder">
                                        <i class="fas fa-chalkboard-teacher"></i>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <div class="workshop-card-body">
                                <!-- Status Badges -->
                                <div class="status-badges">
                                    <?php
                                    $status_badges = [
                                        'upcoming' => '<span class="status-badge badge-warning">Upcoming</span>',
                                        'ongoing' => '<span class="status-badge badge-success">Ongoing</span>',
                                        'completed' => '<span class="status-badge badge-info">Completed</span>',
                                        'cancelled' => '<span class="status-badge badge-danger">Cancelled</span>'
                                    ];
                                    echo $status_badges[$workshop->status] ?? '<span class="status-badge badge-secondary">' . ucfirst($workshop->status) . '</span>';
                                    ?>

                                    <?php if ($workshop->is_featured): ?>
                                        <span class="status-badge badge-primary">
                                            <i class="fas fa-star"></i> Featured
                                        </span>
                                    <?php endif; ?>
                                </div>

                                <!-- Title -->
                                <h5 class="workshop-title">
                                    <?php echo htmlspecialchars($workshop->title); ?>
                                </h5>

                                <!-- Description -->
                                <p class="workshop-description">
                                    <?php echo htmlspecialchars(character_limiter($workshop->description, 100)); ?>
                                </p>

                                <!-- Workshop Details -->
                                <div class="workshop-details">
                                    <?php if (!empty($workshop->duration)): ?>
                                        <div class="workshop-detail-item">
                                            <i class="far fa-clock"></i>
                                            <span><strong>Duration:</strong> <?php echo htmlspecialchars($workshop->duration); ?></span>
                                        </div>
                                    <?php endif; ?>

                                    <?php if (!empty($workshop->start_date)): ?>
                                        <div class="workshop-detail-item">
                                            <i class="far fa-calendar"></i>
                                            <span>
                                                <strong>Start Date:</strong> 
                                                <?php echo date('M d, Y', strtotime($workshop->start_date)); ?>
                                                <?php if (!empty($workshop->end_date)): ?>
                                                    - <?php echo date('M d, Y', strtotime($workshop->end_date)); ?>
                                                <?php endif; ?>
                                            </span>
                                        </div>
                                    <?php endif; ?>

                                    <?php if (!empty($workshop->location)): ?>
                                        <div class="workshop-detail-item">
                                            <i class="fas fa-map-marker-alt"></i>
                                            <span><strong>Location:</strong> <?php echo htmlspecialchars($workshop->location); ?></span>
                                        </div>
                                    <?php endif; ?>

                                    <?php if (!empty($workshop->capacity)): ?>
                                        <div class="workshop-detail-item">
                                            <i class="fas fa-users"></i>
                                            <span><strong>Capacity:</strong> <?php echo $workshop->capacity; ?> participants</span>
                                        </div>
                                    <?php endif; ?>

                                    <?php if (!empty($workshop->price) && $workshop->price > 0): ?>
                                        <div class="workshop-detail-item">
                                            <i class="fas fa-tag"></i>
                                            <span><strong>Price:</strong> GHS <?php echo number_format($workshop->price, 2); ?></span>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <!-- Action Buttons -->
                                <div class="workshop-actions">
                                    <a href="<?php echo base_url('admin/workshops/edit/' . $workshop->id); ?>" 
                                       class="btn btn-sm btn-primary">
                                        <i class="fas fa-edit"></i> Edit
                                    </a>
                                    <a href="<?php echo base_url('workshops/view/' . $workshop->slug); ?>" 
                                       class="btn btn-sm btn-info" 
                                       target="_blank">
                                        <i class="fas fa-eye"></i> View
                                    </a>
                                    <a href="<?php echo base_url('admin/workshops/delete/' . $workshop->id); ?>" 
                                       class="btn btn-sm btn-danger"
                                       onclick="return confirm('Are you sure you want to delete this workshop?');">
                                        <i class="fas fa-trash"></i> Delete
                                    </a>
                                </div>
                            </div>

                            <!-- Card Footer -->
                            <div class="workshop-card-footer">
                                <i class="far fa-clock"></i> 
                                <?php if (isset($workshop->created_at)): ?>
                                    Created <?php echo time_ago($workshop->created_at); ?>
                                <?php else: ?>
                                    Workshop #<?php echo $workshop->id; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

            <!-- Pagination -->
            <?php if (isset($pagination) && !empty($pagination)): ?>
                <div class="mt-4">
                    <?php echo $pagination; ?>
                </div>
            <?php endif; ?>

        <?php else: ?>
            <!-- Empty State -->
            <div class="empty-state">
                <i class="fas fa-chalkboard-teacher"></i>
                <h5>No Workshops Found</h5>
                <p>
                    <?php if ($current_status): ?>
                        No workshops with status "<?php echo ucfirst($current_status); ?>".
                    <?php else: ?>
                        You haven't created any workshop programmes yet.
                    <?php endif; ?>
                </p>
                <a href="<?php echo base_url('admin/workshops/add'); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Create Your First Workshop
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>