<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>404 - Page Not Found</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, #f26124 0%, #231f20 100%);
            color: white;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .error-container {
            text-align: center;
            padding: 40px;
        }
        .error-code {
            font-size: 120px;
            font-weight: bold;
            margin: 0;
            text-shadow: 3px 3px 6px rgba(0,0,0,0.3);
        }
        .error-message {
            font-size: 24px;
            margin: 20px 0;
        }
        .btn-home {
            background: white;
            color: #f26124;
            padding: 12px 30px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: bold;
            display: inline-block;
            margin-top: 20px;
            transition: all 0.3s;
        }
        .btn-home:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 20px rgba(255,255,255,0.3);
            color: #f26124;
        }
    </style>
</head>
<body>
    <div class="error-container">
        <i class="fas fa-exclamation-triangle fa-5x mb-4" style="opacity: 0.8;"></i>
        <h1 class="error-code">404</h1>
        <p class="error-message">Oops! Page Not Found</p>
        <p style="opacity: 0.9;">The page you're looking for doesn't exist or has been moved.</p>
        <a href="<?php echo base_url('index.php'); ?>" class="btn-home">
            <i class="fas fa-home"></i> Go to Homepage
        </a>
        
        <?php if(!empty($recent_posts) || !empty($featured_workshops)): ?>
        <div class="mt-5" style="max-width: 600px; margin: 40px auto;">
            <p style="opacity: 0.8;">Maybe you were looking for:</p>
            <div class="list-group">
                <?php if(!empty($recent_posts)): ?>
                    <?php foreach(array_slice($recent_posts, 0, 3) as $post): ?>
                    <a href="<?php echo base_url('index.php/blog/' . $post->slug); ?>" 
                       class="list-group-item list-group-item-action">
                        <i class="fas fa-newspaper"></i> <?php echo $post->title; ?>
                    </a>
                    <?php endforeach; ?>
                <?php endif; ?>
                
                <?php if(!empty($featured_workshops)): ?>
                    <?php foreach($featured_workshops as $workshop): ?>
                    <a href="<?php echo base_url('index.php/workshops/' . $workshop->slug); ?>" 
                       class="list-group-item list-group-item-action">
                        <i class="fas fa-chalkboard-teacher"></i> <?php echo $workshop->title; ?>
                    </a>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</body>
</html>