<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Blog Hero Banner -->
<section class="blog-hero">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <nav aria-label="breadcrumb" class="mb-3">
                    <ol class="breadcrumb breadcrumb-custom">
                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Blog</li>
                    </ol>
                </nav>
                <span class="section-badge mb-3">
                    <i class="fas fa-blog me-2"></i>Our Blog
                </span>
                <h1 class="display-5 fw-bold text-white mb-3">Latest News & Stories</h1>
                <p class="lead text-white-50 mb-0">Stay updated with our community activities, workshop updates, and success stories from The Skills Atelier.</p>
            </div>
            <div class="col-lg-4 text-lg-end mt-4 mt-lg-0">
                <div class="hero-stats">
                    <div class="stat-item">
                        <i class="fas fa-newspaper"></i>
                        <span><?php echo count($posts); ?>+ Articles</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Categories Bar -->
<section class="categories-bar">
    <div class="container">
        <div class="categories-scroll">
            <a href="<?php echo base_url('blog'); ?>" class="category-chip active">
                <i class="fas fa-th-large me-2"></i>All Posts
            </a>
            <?php if (!empty($categories)): ?>
                <?php foreach ($categories as $cat): ?>
                    <a href="<?php echo base_url('blog/category/' . $cat->slug); ?>" class="category-chip">
                        <i class="fas fa-folder me-2"></i><?php echo htmlspecialchars($cat->name); ?>
                    </a>
                <?php endforeach; ?>
            <?php else: ?>
                <a href="<?php echo base_url('blog/category/announcements'); ?>" class="category-chip">
                    <i class="fas fa-bullhorn me-2"></i>Announcements
                </a>
                <a href="<?php echo base_url('blog/category/workshop-updates'); ?>" class="category-chip">
                    <i class="fas fa-chalkboard-teacher me-2"></i>Workshop Updates
                </a>
                <a href="<?php echo base_url('blog/category/success-stories'); ?>" class="category-chip">
                    <i class="fas fa-trophy me-2"></i>Success Stories
                </a>
            <?php endif; ?>
        </div>
    </div>
</section>

<!-- Blog Posts Section -->
<section class="py-5 blog-posts-section">
    <div class="container">
        <?php if (!empty($posts)): ?>
            
            <!-- Featured Post (First Post) -->
            <?php $featured_post = $posts[0]; ?>
            <div class="featured-post mb-5">
                <div class="row align-items-center">
                    <div class="col-lg-7 mb-4 mb-lg-0">
                        <div class="featured-image">
                            <a href="<?php echo base_url('blog/view/' . $featured_post->slug); ?>">
                                <?php if (!empty($featured_post->featured_image)): ?>
                                    <img src="<?php echo base_url('uploads/blog/' . $featured_post->featured_image); ?>" 
                                         alt="<?php echo htmlspecialchars($featured_post->title); ?>"
                                         class="img-fluid rounded-4">
                                <?php else: ?>
                                    <div class="placeholder-img rounded-4">
                                        <i class="fas fa-newspaper fa-4x"></i>
                                    </div>
                                <?php endif; ?>
                            </a>
                            <div class="featured-badge">
                                <i class="fas fa-star me-1"></i>Featured
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5">
                        <div class="featured-content">
                            <?php if (!empty($featured_post->category_name)): ?>
                                <a href="<?php echo base_url('blog/category/' . $featured_post->category_slug); ?>" 
                                   class="category-tag">
                                    <?php echo htmlspecialchars($featured_post->category_name); ?>
                                </a>
                            <?php endif; ?>
                            
                            <h2 class="featured-title">
                                <a href="<?php echo base_url('blog/view/' . $featured_post->slug); ?>">
                                    <?php echo htmlspecialchars($featured_post->title); ?>
                                </a>
                            </h2>
                            
                            <p class="featured-excerpt">
                                <?php echo htmlspecialchars(character_limiter($featured_post->excerpt, 200)); ?>
                            </p>
                            
                            <div class="featured-meta">
                                <div class="author-info">
                                    <div class="author-avatar">
                                        <?php echo strtoupper(substr($featured_post->author_name ?? 'A', 0, 1)); ?>
                                    </div>
                                    <div class="author-details">
                                        <span class="author-name"><?php echo htmlspecialchars($featured_post->author_name ?? 'Admin'); ?></span>
                                        <span class="post-date"><?php echo date('M d, Y', strtotime($featured_post->published_at)); ?></span>
                                    </div>
                                </div>
                                <div class="post-stats">
                                    <span><i class="far fa-eye"></i> <?php echo number_format($featured_post->views_count ?? 0); ?></span>
                                </div>
                            </div>
                            
                            <a href="<?php echo base_url('blog/view/' . $featured_post->slug); ?>" class="btn btn-primary mt-3">
                                Read Article <i class="fas fa-arrow-right ms-2"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Section Divider -->
            <div class="section-divider mb-5">
                <span>More Articles</span>
            </div>
            
            <!-- Posts Grid -->
            <div class="row">
                <?php foreach (array_slice($posts, 1) as $index => $post): ?>
                    <div class="col-lg-4 col-md-6 mb-4">
                        <article class="blog-card h-100">
                            <!-- Featured Image -->
                            <div class="blog-image">
                                <a href="<?php echo base_url('blog/view/' . $post->slug); ?>">
                                    <?php if (!empty($post->featured_image)): ?>
                                        <img src="<?php echo base_url('uploads/blog/' . $post->featured_image); ?>" 
                                             alt="<?php echo htmlspecialchars($post->title); ?>">
                                    <?php else: ?>
                                        <div class="placeholder-img">
                                            <i class="fas fa-newspaper fa-3x"></i>
                                        </div>
                                    <?php endif; ?>
                                </a>
                                <?php if (!empty($post->category_name)): ?>
                                    <a href="<?php echo base_url('blog/category/' . $post->category_slug); ?>" 
                                       class="blog-category-tag">
                                        <?php echo htmlspecialchars($post->category_name); ?>
                                    </a>
                                <?php endif; ?>
                            </div>
                            
                            <!-- Blog Content -->
                            <div class="blog-body">
                                <!-- Meta Info -->
                                <div class="blog-meta">
                                    <span class="meta-item">
                                        <i class="far fa-calendar-alt"></i>
                                        <?php echo date('M d, Y', strtotime($post->published_at)); ?>
                                    </span>
                                    <span class="meta-item">
                                        <i class="far fa-eye"></i>
                                        <?php echo number_format($post->views_count ?? 0); ?>
                                    </span>
                                </div>
                                
                                <!-- Title -->
                                <h5 class="blog-title">
                                    <a href="<?php echo base_url('blog/view/' . $post->slug); ?>">
                                        <?php echo htmlspecialchars($post->title); ?>
                                    </a>
                                </h5>
                                
                                <!-- Excerpt -->
                                <p class="blog-excerpt">
                                    <?php echo htmlspecialchars(character_limiter($post->excerpt, 100)); ?>
                                </p>
                                
                                <!-- Author & Read More -->
                                <div class="blog-footer">
                                    <div class="author-info">
                                        <div class="author-avatar small">
                                            <?php echo strtoupper(substr($post->author_name ?? 'A', 0, 1)); ?>
                                        </div>
                                        <span class="author-name"><?php echo htmlspecialchars($post->author_name ?? 'Admin'); ?></span>
                                    </div>
                                    <a href="<?php echo base_url('blog/view/' . $post->slug); ?>" class="read-more-btn">
                                        Read <i class="fas fa-arrow-right ms-1"></i>
                                    </a>
                                </div>
                            </div>
                        </article>
                    </div>
                <?php endforeach; ?>
            </div>
            
            <!-- Pagination -->
            <?php if (!empty($pagination)): ?>
                <div class="pagination-wrapper mt-5">
                    <nav aria-label="Blog pagination">
                        <?php echo $pagination; ?>
                    </nav>
                </div>
            <?php endif; ?>
            
        <?php else: ?>
            <!-- Empty State -->
            <div class="empty-state">
                <div class="empty-icon">
                    <i class="fas fa-newspaper"></i>
                </div>
                <h3 class="fw-bold mb-3">No Blog Posts Yet</h3>
                <p class="text-muted mb-4">We're working on creating amazing content for you.<br>Check back soon for updates and stories from our community!</p>
                <div class="d-flex gap-3 justify-content-center flex-wrap">
                    <a href="<?php echo base_url(); ?>" class="btn btn-primary">
                        <i class="fas fa-home me-2"></i>Back to Home
                    </a>
                    <a href="<?php echo base_url('workshops'); ?>" class="btn btn-outline-primary">
                        <i class="fas fa-chalkboard-teacher me-2"></i>View Workshops
                    </a>
                </div>
            </div>
        <?php endif; ?>
    </div>
</section>

<!-- Newsletter Section -->
<!--<section class="py-5 newsletter-section">
    <div class="container">
        <div class="newsletter-card">
            <div class="row align-items-center">
                <div class="col-lg-5 mb-4 mb-lg-0 text-center text-lg-start">
                    <div class="newsletter-icon">
                        <i class="fas fa-envelope-open-text"></i>
                    </div>
                </div>
                <div class="col-lg-7">
                    <h3 class="fw-bold text-white mb-2">Never Miss an Update</h3>
                    <p class="text-white-50 mb-4">Subscribe to our newsletter and get the latest articles, workshop updates, and success stories delivered directly to your inbox.</p>
                    <form action="<?php echo base_url('newsletter/subscribe'); ?>" method="post" class="newsletter-form">
                        <div class="input-group">
                            <input type="email" name="email" class="form-control" placeholder="Enter your email address" required>
                            <button type="submit" class="btn btn-light">
                                Subscribe <i class="fas fa-paper-plane ms-2"></i>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section> -->

<style>
/* =========================================
   THE SKILLS ATELIER - BLOG LISTING STYLES
   Primary: #f26124 (Orange)
   Secondary: #8105bf (Purple)
   ========================================= */

:root {
    --tsa-primary: #f26124;
    --tsa-primary-dark: #d94f15;
    --tsa-secondary: #8105bf;
    --tsa-secondary-dark: #6a049e;
    --tsa-light: #fff8f5;
    --tsa-cream: #f7e1b0;
    --tsa-gradient: linear-gradient(135deg, #f26124, #8105bf);
    --tsa-gradient-reverse: linear-gradient(135deg, #8105bf, #f26124);
}

/* =========================================
   BLOG HERO SECTION
   ========================================= */
.blog-hero {
    background: var(--tsa-gradient);
    padding: 80px 0 60px;
    position: relative;
    overflow: hidden;
}

.blog-hero::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E") repeat;
}

.breadcrumb-custom {
    background: transparent;
    padding: 0;
    margin: 0;
}

.breadcrumb-custom .breadcrumb-item a {
    color: rgba(255,255,255,0.7);
    text-decoration: none;
    transition: color 0.3s ease;
}

.breadcrumb-custom .breadcrumb-item a:hover {
    color: white;
}

.breadcrumb-custom .breadcrumb-item.active {
    color: white;
}

.breadcrumb-custom .breadcrumb-item + .breadcrumb-item::before {
    color: rgba(255,255,255,0.5);
}

.section-badge {
    display: inline-block;
    background: rgba(255,255,255,0.2);
    backdrop-filter: blur(10px);
    color: white;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.hero-stats {
    display: inline-flex;
    flex-direction: column;
    gap: 0.75rem;
}

.hero-stats .stat-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    background: rgba(255,255,255,0.15);
    backdrop-filter: blur(10px);
    padding: 1rem 1.5rem;
    border-radius: 15px;
    color: white;
    font-weight: 600;
    border: 1px solid rgba(255,255,255,0.2);
}

.hero-stats .stat-item i {
    font-size: 1.5rem;
    opacity: 0.9;
}

/* =========================================
   CATEGORIES BAR
   ========================================= */
.categories-bar {
    background: white;
    padding: 1rem 0;
    box-shadow: 0 5px 20px rgba(0,0,0,0.08);
    position: sticky;
    top: 0;
    z-index: 100;
}

.categories-scroll {
    display: flex;
    gap: 0.75rem;
    overflow-x: auto;
    padding-bottom: 0.5rem;
    scrollbar-width: thin;
    scrollbar-color: var(--tsa-primary) #f0f0f0;
}

.categories-scroll::-webkit-scrollbar {
    height: 4px;
}

.categories-scroll::-webkit-scrollbar-track {
    background: #f0f0f0;
    border-radius: 10px;
}

.categories-scroll::-webkit-scrollbar-thumb {
    background: var(--tsa-primary);
    border-radius: 10px;
}

.category-chip {
    display: inline-flex;
    align-items: center;
    padding: 0.6rem 1.25rem;
    background: var(--tsa-light);
    border: 2px solid transparent;
    border-radius: 50px;
    color: #555;
    font-weight: 500;
    font-size: 0.9rem;
    text-decoration: none;
    white-space: nowrap;
    transition: all 0.3s ease;
}

.category-chip:hover,
.category-chip.active {
    background: var(--tsa-primary);
    color: white;
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(242, 97, 36, 0.3);
}

.category-chip i {
    font-size: 0.85rem;
}

/* =========================================
   BLOG POSTS SECTION
   ========================================= */
.blog-posts-section {
    background: linear-gradient(180deg, #fff 0%, var(--tsa-light) 100%);
}

/* Featured Post */
.featured-post {
    background: white;
    border-radius: 25px;
    padding: 2rem;
    box-shadow: 0 15px 50px rgba(0,0,0,0.1);
    border: 1px solid rgba(0,0,0,0.05);
}

.featured-image {
    position: relative;
    border-radius: 20px;
    overflow: hidden;
}

.featured-image img {
    width: 100%;
    height: 350px;
    object-fit: cover;
    transition: transform 0.5s ease;
}

.featured-post:hover .featured-image img {
    transform: scale(1.05);
}

.featured-image .placeholder-img {
    width: 100%;
    height: 350px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #f5f5f5, #e0e0e0);
    color: #ccc;
}

.featured-badge {
    position: absolute;
    top: 20px;
    left: 20px;
    background: var(--tsa-gradient);
    color: white;
    padding: 0.5rem 1.25rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    box-shadow: 0 5px 15px rgba(242, 97, 36, 0.4);
}

.featured-content .category-tag {
    display: inline-block;
    background: var(--tsa-light);
    color: var(--tsa-primary);
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.8rem;
    font-weight: 600;
    text-decoration: none;
    margin-bottom: 1rem;
    transition: all 0.3s ease;
}

.featured-content .category-tag:hover {
    background: var(--tsa-primary);
    color: white;
}

.featured-title {
    font-weight: 700;
    font-size: 1.75rem;
    margin-bottom: 1rem;
    line-height: 1.3;
}

.featured-title a {
    color: #333;
    text-decoration: none;
    transition: color 0.3s ease;
}

.featured-title a:hover {
    color: var(--tsa-primary);
}

.featured-excerpt {
    color: #666;
    font-size: 1rem;
    line-height: 1.7;
    margin-bottom: 1.5rem;
}

.featured-meta {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding-top: 1rem;
    border-top: 1px solid #f0f0f0;
}

.author-info {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.author-avatar {
    width: 45px;
    height: 45px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: 700;
    font-size: 1rem;
}

.author-avatar.small {
    width: 32px;
    height: 32px;
    font-size: 0.8rem;
}

.author-details {
    display: flex;
    flex-direction: column;
}

.author-name {
    font-weight: 600;
    font-size: 0.9rem;
    color: #333;
}

.post-date {
    font-size: 0.8rem;
    color: #999;
}

.post-stats {
    display: flex;
    gap: 1rem;
    color: #888;
    font-size: 0.9rem;
}

.post-stats i {
    margin-right: 0.3rem;
}

/* Section Divider */
.section-divider {
    display: flex;
    align-items: center;
    text-align: center;
}

.section-divider::before,
.section-divider::after {
    content: '';
    flex: 1;
    border-bottom: 2px solid #f0f0f0;
}

.section-divider span {
    padding: 0 1.5rem;
    font-weight: 600;
    color: #999;
    text-transform: uppercase;
    font-size: 0.85rem;
    letter-spacing: 1px;
}

/* Blog Card Styles */
.blog-card {
    background: white;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 10px 40px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
    border: 1px solid rgba(0,0,0,0.05);
}

.blog-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 20px 50px rgba(0,0,0,0.15);
}

/* Blog Image */
.blog-image {
    position: relative;
    height: 200px;
    overflow: hidden;
}

.blog-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.5s ease;
}

.blog-card:hover .blog-image img {
    transform: scale(1.1);
}

.blog-image .placeholder-img {
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #f5f5f5, #e0e0e0);
    color: #ccc;
}

.blog-category-tag {
    position: absolute;
    bottom: 15px;
    left: 15px;
    background: var(--tsa-primary);
    color: white;
    padding: 0.35rem 1rem;
    border-radius: 50px;
    font-size: 0.75rem;
    font-weight: 600;
    text-decoration: none;
    text-transform: uppercase;
    transition: all 0.3s ease;
}

.blog-category-tag:hover {
    background: var(--tsa-primary-dark);
    color: white;
    transform: translateY(-2px);
}

/* Blog Body */
.blog-body {
    padding: 1.5rem;
}

.blog-meta {
    display: flex;
    gap: 1rem;
    margin-bottom: 0.75rem;
}

.blog-meta .meta-item {
    font-size: 0.8rem;
    color: #888;
}

.blog-meta .meta-item i {
    margin-right: 0.3rem;
    color: var(--tsa-primary);
}

.blog-title {
    font-weight: 700;
    margin-bottom: 0.75rem;
    line-height: 1.4;
    font-size: 1.1rem;
}

.blog-title a {
    color: #333;
    text-decoration: none;
    transition: color 0.3s ease;
}

.blog-title a:hover {
    color: var(--tsa-primary);
}

.blog-excerpt {
    color: #666;
    font-size: 0.9rem;
    margin-bottom: 1rem;
    line-height: 1.6;
}

/* Blog Footer */
.blog-footer {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding-top: 1rem;
    border-top: 1px solid #f0f0f0;
}

.blog-footer .author-info {
    gap: 0.5rem;
}

.blog-footer .author-name {
    font-size: 0.85rem;
}

.read-more-btn {
    display: inline-flex;
    align-items: center;
    color: var(--tsa-primary);
    font-weight: 600;
    font-size: 0.85rem;
    text-decoration: none;
    padding: 0.4rem 0.8rem;
    border-radius: 50px;
    transition: all 0.3s ease;
}

.read-more-btn:hover {
    background: var(--tsa-primary);
    color: white;
}

.read-more-btn i {
    transition: transform 0.3s ease;
}

.read-more-btn:hover i {
    transform: translateX(5px);
}

/* =========================================
   PAGINATION STYLES
   ========================================= */
.pagination-wrapper {
    display: flex;
    justify-content: center;
}

.pagination {
    gap: 0.5rem;
}

.pagination .page-item .page-link {
    border: none;
    border-radius: 10px;
    padding: 0.6rem 1rem;
    color: #666;
    font-weight: 500;
    transition: all 0.3s ease;
}

.pagination .page-item .page-link:hover {
    background: var(--tsa-light);
    color: var(--tsa-primary);
}

.pagination .page-item.active .page-link {
    background: var(--tsa-gradient);
    color: white;
    box-shadow: 0 5px 15px rgba(242, 97, 36, 0.3);
}

.pagination .page-item.disabled .page-link {
    background: transparent;
    color: #ccc;
}

/* =========================================
   EMPTY STATE
   ========================================= */
.empty-state {
    text-align: center;
    padding: 5rem 2rem;
}

.empty-icon {
    width: 120px;
    height: 120px;
    background: var(--tsa-light);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 2rem;
}

.empty-icon i {
    font-size: 3rem;
    color: var(--tsa-primary);
    opacity: 0.5;
}

/* =========================================
   NEWSLETTER SECTION
   ========================================= */
.newsletter-section {
    background: linear-gradient(135deg, #1a1a2e, #16213e);
}

.newsletter-card {
    background: rgba(255,255,255,0.05);
    backdrop-filter: blur(10px);
    border-radius: 25px;
    padding: 3rem;
    border: 1px solid rgba(255,255,255,0.1);
}

.newsletter-icon {
    width: 100px;
    height: 100px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    font-size: 2.5rem;
    color: white;
    box-shadow: 0 10px 30px rgba(242, 97, 36, 0.4);
}

.newsletter-form .form-control {
    border: none;
    border-radius: 50px 0 0 50px;
    padding: 1rem 1.5rem;
    font-size: 1rem;
}

.newsletter-form .form-control:focus {
    box-shadow: none;
}

.newsletter-form .btn {
    border-radius: 0 50px 50px 0;
    padding: 1rem 2rem;
    font-weight: 600;
}

.newsletter-form .btn:hover {
    background: var(--tsa-cream);
}

/* =========================================
   BUTTON STYLES
   ========================================= */
.btn-primary {
    background: var(--tsa-gradient);
    border: none;
    font-weight: 600;
    padding: 0.75rem 1.5rem;
    border-radius: 50px;
    transition: all 0.3s ease;
}

.btn-primary:hover {
    background: var(--tsa-gradient-reverse);
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(242, 97, 36, 0.4);
}

.btn-outline-primary {
    border: 2px solid var(--tsa-primary);
    color: var(--tsa-primary);
    font-weight: 600;
    padding: 0.75rem 1.5rem;
    border-radius: 50px;
    transition: all 0.3s ease;
    background: transparent;
}

.btn-outline-primary:hover {
    background: var(--tsa-primary);
    border-color: var(--tsa-primary);
    color: white;
    transform: translateY(-2px);
}

/* =========================================
   RESPONSIVE STYLES
   ========================================= */
@media (max-width: 991px) {
    .blog-hero {
        padding: 60px 0 50px;
    }
    
    .blog-hero h1 {
        font-size: 2rem;
    }
    
    .featured-post {
        padding: 1.5rem;
    }
    
    .featured-image img,
    .featured-image .placeholder-img {
        height: 280px;
    }
    
    .featured-title {
        font-size: 1.5rem;
    }
    
    .newsletter-card {
        padding: 2rem;
    }
    
    .newsletter-icon {
        width: 80px;
        height: 80px;
        font-size: 2rem;
    }
}

@media (max-width: 768px) {
    .blog-hero {
        padding: 50px 0 40px;
        text-align: center;
    }
    
    .blog-hero h1 {
        font-size: 1.75rem;
    }
    
    .hero-stats {
        margin-top: 1.5rem;
    }
    
    .categories-bar {
        position: relative;
    }
    
    .featured-post {
        padding: 1rem;
    }
    
    .featured-image img,
    .featured-image .placeholder-img {
        height: 220px;
    }
    
    .featured-title {
        font-size: 1.25rem;
    }
    
    .featured-meta {
        flex-direction: column;
        align-items: flex-start;
        gap: 1rem;
    }
    
    .blog-footer {
        flex-direction: column;
        gap: 1rem;
        align-items: flex-start;
    }
    
    .read-more-btn {
        width: 100%;
        justify-content: center;
    }
    
    .newsletter-form .input-group {
        flex-direction: column;
    }
    
    .newsletter-form .form-control {
        border-radius: 50px;
        margin-bottom: 1rem;
    }
    
    .newsletter-form .btn {
        border-radius: 50px;
        width: 100%;
    }
}

/* =========================================
   ANIMATIONS
   ========================================= */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.featured-post {
    animation: fadeInUp 0.6s ease forwards;
}

.blog-card {
    animation: fadeInUp 0.5s ease forwards;
    opacity: 0;
}

.blog-card:nth-child(1) { animation-delay: 0.1s; }
.blog-card:nth-child(2) { animation-delay: 0.2s; }
.blog-card:nth-child(3) { animation-delay: 0.3s; }
.blog-card:nth-child(4) { animation-delay: 0.4s; }
.blog-card:nth-child(5) { animation-delay: 0.5s; }
.blog-card:nth-child(6) { animation-delay: 0.6s; }
.blog-card:nth-child(7) { animation-delay: 0.7s; }
.blog-card:nth-child(8) { animation-delay: 0.8s; }
.blog-card:nth-child(9) { animation-delay: 0.9s; }
</style>