<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Article Hero -->
<section class="article-hero">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                <!-- Breadcrumb -->
                <nav aria-label="breadcrumb" class="mb-4">
                    <ol class="breadcrumb breadcrumb-custom">
                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo base_url('blog'); ?>">Blog</a></li>
                        <?php if (!empty($post->category_name)): ?>
                            <li class="breadcrumb-item">
                                <a href="<?php echo base_url('blog/category/' . $post->category_slug); ?>">
                                    <?php echo htmlspecialchars($post->category_name); ?>
                                </a>
                            </li>
                        <?php endif; ?>
                        <li class="breadcrumb-item active" aria-current="page">Article</li>
                    </ol>
                </nav>
                
                <!-- Category Badge -->
                <?php if (!empty($post->category_name)): ?>
                    <a href="<?php echo base_url('blog/category/' . $post->category_slug); ?>" class="category-badge">
                        <i class="fas fa-folder me-2"></i><?php echo htmlspecialchars($post->category_name); ?>
                    </a>
                <?php endif; ?>
                
                <!-- Title -->
                <h1 class="article-title"><?php echo htmlspecialchars($post->title); ?></h1>
                
                <!-- Meta Info -->
                <div class="article-meta">
                    <div class="meta-author">
                        <div class="author-avatar">
                            <?php echo strtoupper(substr($post->author_name ?? 'A', 0, 1)); ?>
                        </div>
                        <div class="author-info">
                            <span class="author-name"><?php echo htmlspecialchars($post->author_name ?? 'Admin'); ?></span>
                            <span class="author-role">Author</span>
                        </div>
                    </div>
                    <div class="meta-stats">
                        <span class="stat-item">
                            <i class="far fa-calendar-alt"></i>
                            <?php echo date('F d, Y', strtotime($post->published_at)); ?>
                        </span>
                        <span class="stat-item">
                            <i class="far fa-eye"></i>
                            <?php echo number_format($post->views_count ?? 0); ?> views
                        </span>
                        <span class="stat-item">
                            <i class="far fa-clock"></i>
                            <?php 
                            $word_count = str_word_count(strip_tags($post->content));
                            $read_time = ceil($word_count / 200);
                            echo $read_time . ' min read';
                            ?>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Featured Image -->
<?php if (!empty($post->featured_image)): ?>
<section class="featured-image-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                <div class="featured-image-wrapper">
                    <img src="<?php echo base_url('uploads/blog/' . $post->featured_image); ?>" 
                         alt="<?php echo htmlspecialchars($post->title); ?>"
                         class="featured-image">
                </div>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Article Content -->
<section class="py-5 article-content-section">
    <div class="container">
        <div class="row">
            <!-- Main Content -->
            <div class="col-lg-8">
                <article class="article-card">
                    <!-- Article Body -->
                    <div class="article-body">
                        <div class="post-content">
                            <?php echo $post->content; ?>
                        </div>
                    </div>
                    
                    <!-- Tags -->
                    <?php if (!empty($post->tags)): ?>
                        <div class="article-tags">
                            <h6 class="tags-title"><i class="fas fa-tags me-2"></i>Tags</h6>
                            <div class="tags-list">
                                <?php 
                                $tags = explode(',', $post->tags);
                                foreach ($tags as $tag): 
                                ?>
                                    <span class="tag-item">
                                        <?php echo trim(htmlspecialchars($tag)); ?>
                                    </span>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Share Section -->
                    <div class="article-share">
                        <h6 class="share-title"><i class="fas fa-share-alt me-2"></i>Share this article</h6>
                        <div class="share-buttons">
                            <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo current_url(); ?>" 
                               target="_blank" 
                               class="share-btn facebook"
                               title="Share on Facebook">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                            <a href="https://twitter.com/intent/tweet?url=<?php echo current_url(); ?>&text=<?php echo urlencode($post->title); ?>" 
                               target="_blank" 
                               class="share-btn twitter"
                               title="Share on Twitter">
                                <i class="fab fa-twitter"></i>
                            </a>
                            <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo current_url(); ?>" 
                               target="_blank" 
                               class="share-btn linkedin"
                               title="Share on LinkedIn">
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                            <a href="https://wa.me/?text=<?php echo urlencode($post->title . ' ' . current_url()); ?>" 
                               target="_blank" 
                               class="share-btn whatsapp"
                               title="Share on WhatsApp">
                                <i class="fab fa-whatsapp"></i>
                            </a>
                            <button class="share-btn copy-link" onclick="copyArticleLink()" title="Copy Link">
                                <i class="fas fa-link"></i>
                            </button>
                        </div>
                        <div class="copy-notification" id="copyNotification">
                            <i class="fas fa-check me-2"></i>Link copied to clipboard!
                        </div>
                    </div>
                    
                    <!-- Author Box -->
                    <div class="author-box">
                        <div class="author-avatar-large">
                            <?php echo strtoupper(substr($post->author_name ?? 'A', 0, 1)); ?>
                        </div>
                        <div class="author-content">
                            <span class="author-label">Written by</span>
                            <h5 class="author-name"><?php echo htmlspecialchars($post->author_name ?? 'Admin'); ?></h5>
                            <p class="author-bio">Contributing author at The Skills Atelier. Passionate about education, language learning, and community development in Ghana.</p>
                        </div>
                    </div>
                </article>
                
                <!-- Post Navigation -->
                <div class="post-navigation">
                    <a href="<?php echo base_url('blog'); ?>" class="nav-btn prev">
                        <i class="fas fa-arrow-left"></i>
                        <span>Back to Blog</span>
                    </a>
                    <?php if (!empty($post->category_slug)): ?>
                        <a href="<?php echo base_url('blog/category/' . $post->category_slug); ?>" class="nav-btn next">
                            <span>More in <?php echo htmlspecialchars($post->category_name); ?></span>
                            <i class="fas fa-arrow-right"></i>
                        </a>
                    <?php endif; ?>
                </div>
                
                <!-- Related Posts -->
                <?php if (!empty($related_posts)): ?>
                    <div class="related-posts">
                        <h3 class="section-title">
                            <span class="title-icon"><i class="fas fa-newspaper"></i></span>
                            Related Articles
                        </h3>
                        <div class="row">
                            <?php foreach ($related_posts as $related): ?>
                                <div class="col-md-4 mb-4">
                                    <div class="related-card">
                                        <a href="<?php echo base_url('blog/view/' . $related->slug); ?>" class="related-image">
                                            <?php if (!empty($related->featured_image)): ?>
                                                <img src="<?php echo base_url('uploads/blog/' . $related->featured_image); ?>" 
                                                     alt="<?php echo htmlspecialchars($related->title); ?>">
                                            <?php else: ?>
                                                <div class="placeholder-img">
                                                    <i class="fas fa-newspaper fa-2x"></i>
                                                </div>
                                            <?php endif; ?>
                                        </a>
                                        <div class="related-content">
                                            <h6 class="related-title">
                                                <a href="<?php echo base_url('blog/view/' . $related->slug); ?>">
                                                    <?php echo htmlspecialchars(character_limiter($related->title, 50)); ?>
                                                </a>
                                            </h6>
                                            <span class="related-date">
                                                <i class="far fa-calendar-alt me-1"></i>
                                                <?php echo date('M d, Y', strtotime($related->published_at)); ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            
            <!-- Sidebar -->
            <div class="col-lg-4">
                <aside class="sidebar">
                    <!-- Back to Blog Widget -->
                    <div class="sidebar-widget back-widget">
                        <a href="<?php echo base_url('blog'); ?>" class="back-btn">
                            <i class="fas fa-arrow-left me-2"></i>Back to All Articles
                        </a>
                    </div>
                    
                    <!-- CTA Widget -->
                    <div class="sidebar-widget cta-widget">
                        <div class="cta-icon">
                            <i class="fas fa-hands-helping"></i>
                        </div>
                        <h5 class="cta-title">Get Involved</h5>
                        <p class="cta-text">Join our community and help us make a difference in children's education!</p>
                        <a href="<?php echo base_url('volunteer/apply'); ?>" class="btn btn-light w-100 mb-2">
                            <i class="fas fa-hand-holding-heart me-2"></i>Volunteer With Us
                        </a>
                        <a href="<?php echo base_url('donate'); ?>" class="btn btn-outline-light w-100">
                            <i class="fas fa-heart me-2"></i>Support Our Mission
                        </a>
                    </div>
                    
                    <!-- French Workshop Widget -->
                    <div class="sidebar-widget workshop-widget">
                        <div class="workshop-badge">🇫🇷 Flagship Programme</div>
                        <h5 class="widget-title">French Workshop for Kids</h5>
                        <p class="widget-text">Fun, immersive French learning for children aged 6-12 in East Legon, Accra.</p>
                        <ul class="workshop-features">
                            <li><i class="fas fa-check"></i> Interactive Games</li>
                            <li><i class="fas fa-check"></i> Music & Songs</li>
                            <li><i class="fas fa-check"></i> Cultural Events</li>
                        </ul>
                        <a href="<?php echo base_url('french-workshop/register'); ?>" class="btn btn-primary w-100">
                            <i class="fas fa-user-plus me-2"></i>Register Now
                        </a>
                    </div>
                    
                    <!-- Explore More Widget -->
                    <div class="sidebar-widget explore-widget">
                        <h5 class="widget-title"><i class="fas fa-compass me-2"></i>Explore More</h5>
                        <ul class="explore-list">
                            <li>
                                <a href="<?php echo base_url('workshops'); ?>">
                                    <i class="fas fa-chalkboard-teacher"></i>
                                    <span>Our Workshops</span>
                                    <i class="fas fa-chevron-right arrow"></i>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo base_url('about'); ?>">
                                    <i class="fas fa-info-circle"></i>
                                    <span>About Us</span>
                                    <i class="fas fa-chevron-right arrow"></i>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo base_url('partners'); ?>">
                                    <i class="fas fa-handshake"></i>
                                    <span>Our Partners</span>
                                    <i class="fas fa-chevron-right arrow"></i>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo base_url('gallery'); ?>">
                                    <i class="fas fa-images"></i>
                                    <span>Gallery</span>
                                    <i class="fas fa-chevron-right arrow"></i>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo base_url('contact'); ?>">
                                    <i class="fas fa-envelope"></i>
                                    <span>Contact Us</span>
                                    <i class="fas fa-chevron-right arrow"></i>
                                </a>
                            </li>
                        </ul>
                    </div>
                    
                    <!-- Social Widget -->
                    <div class="sidebar-widget social-widget">
                        <h5 class="widget-title"><i class="fas fa-share-alt me-2"></i>Follow Us</h5>
                        <div class="social-links">
                            <a href="https://web.facebook.com/p/The-skills-Atelier-61577905511642/?_rdc=1&_rdr#" class="social-link facebook" title="Facebook">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                            <a href="https://instagram.com/theskillsatelier" target="_blank" class="social-link instagram" title="Instagram">
                                <i class="fab fa-instagram"></i>
                            </a>
                            <a href="#" class="social-link twitter" title="Twitter">
                                <i class="fab fa-twitter"></i>
                            </a>
                            <a href="https://wa.me/233500557751" target="_blank" class="social-link whatsapp" title="WhatsApp">
                                <i class="fab fa-whatsapp"></i>
                            </a>
                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </div>
</section>

<!-- Newsletter Section -->
<section class="py-5 newsletter-section">
    <div class="container">
        <div class="newsletter-card">
            <div class="row align-items-center">
                <div class="col-lg-6 mb-4 mb-lg-0">
                    <h3 class="fw-bold text-white mb-2">
                        <i class="fas fa-envelope-open-text me-2"></i>Enjoyed This Article?
                    </h3>
                    <p class="text-white-50 mb-0">Subscribe to get more stories, workshop updates, and learning tips delivered to your inbox.</p>
                </div>
                <div class="col-lg-6">
                    <form action="<?php echo base_url('newsletter/subscribe'); ?>" method="post" class="newsletter-form">
                        <div class="input-group">
                            <input type="email" name="email" class="form-control" placeholder="Enter your email address" required>
                            <button type="submit" class="btn btn-light">
                                Subscribe <i class="fas fa-paper-plane ms-2"></i>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
/* =========================================
   THE SKILLS ATELIER - BLOG POST VIEW STYLES
   Primary: #f26124 (Orange)
   Secondary: #8105bf (Purple)
   ========================================= */

:root {
    --tsa-primary: #f26124;
    --tsa-primary-dark: #d94f15;
    --tsa-secondary: #8105bf;
    --tsa-secondary-dark: #6a049e;
    --tsa-light: #fff8f5;
    --tsa-cream: #f7e1b0;
    --tsa-gradient: linear-gradient(135deg, #f26124, #8105bf);
    --tsa-gradient-reverse: linear-gradient(135deg, #8105bf, #f26124);
}

/* =========================================
   ARTICLE HERO
   ========================================= */
.article-hero {
    background: var(--tsa-gradient);
    padding: 100px 0 60px;
    position: relative;
    overflow: hidden;
}

.article-hero::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E") repeat;
}

.breadcrumb-custom {
    background: transparent;
    padding: 0;
    margin: 0;
}

.breadcrumb-custom .breadcrumb-item a {
    color: rgba(255,255,255,0.7);
    text-decoration: none;
    transition: color 0.3s ease;
    font-size: 0.9rem;
}

.breadcrumb-custom .breadcrumb-item a:hover {
    color: white;
}

.breadcrumb-custom .breadcrumb-item.active {
    color: rgba(255,255,255,0.9);
    font-size: 0.9rem;
}

.breadcrumb-custom .breadcrumb-item + .breadcrumb-item::before {
    color: rgba(255,255,255,0.5);
}

.category-badge {
    display: inline-block;
    background: rgba(255,255,255,0.2);
    backdrop-filter: blur(10px);
    color: white;
    padding: 0.5rem 1.25rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    text-decoration: none;
    margin-bottom: 1.5rem;
    transition: all 0.3s ease;
}

.category-badge:hover {
    background: white;
    color: var(--tsa-primary);
}

.article-title {
    color: white;
    font-size: 2.75rem;
    font-weight: 700;
    line-height: 1.2;
    margin-bottom: 2rem;
    text-shadow: 2px 2px 4px rgba(0,0,0,0.1);
}

.article-meta {
    display: flex;
    flex-wrap: wrap;
    align-items: center;
    justify-content: space-between;
    gap: 1.5rem;
}

.meta-author {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.meta-author .author-avatar {
    width: 55px;
    height: 55px;
    background: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--tsa-primary);
    font-weight: 700;
    font-size: 1.3rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.2);
}

.meta-author .author-info {
    display: flex;
    flex-direction: column;
}

.meta-author .author-name {
    color: white;
    font-weight: 600;
    font-size: 1.1rem;
}

.meta-author .author-role {
    color: rgba(255,255,255,0.7);
    font-size: 0.85rem;
}

.meta-stats {
    display: flex;
    gap: 1.5rem;
}

.meta-stats .stat-item {
    color: rgba(255,255,255,0.85);
    font-size: 0.9rem;
}

.meta-stats .stat-item i {
    margin-right: 0.4rem;
}

/* =========================================
   FEATURED IMAGE
   ========================================= */
.featured-image-section {
    margin-top: -40px;
    position: relative;
    z-index: 10;
}

.featured-image-wrapper {
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 20px 60px rgba(0,0,0,0.2);
}

.featured-image {
    width: 100%;
    max-height: 500px;
    object-fit: cover;
    display: block;
}

/* =========================================
   ARTICLE CONTENT SECTION
   ========================================= */
.article-content-section {
    background: linear-gradient(180deg, #fff 0%, var(--tsa-light) 100%);
}

.article-card {
    background: white;
    border-radius: 20px;
    box-shadow: 0 10px 40px rgba(0,0,0,0.08);
    overflow: hidden;
}

.article-body {
    padding: 2.5rem;
}

/* Post Content Styles */
.post-content {
    font-size: 1.15rem;
    line-height: 1.9;
    color: #444;
}

.post-content p {
    margin-bottom: 1.75rem;
}

.post-content img {
    max-width: 100%;
    height: auto;
    border-radius: 15px;
    margin: 2rem 0;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.post-content h2 {
    font-size: 1.9rem;
    font-weight: 700;
    margin-top: 2.5rem;
    margin-bottom: 1.25rem;
    color: var(--tsa-primary);
    position: relative;
    padding-left: 1rem;
}

.post-content h2::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    bottom: 0;
    width: 4px;
    background: var(--tsa-gradient);
    border-radius: 2px;
}

.post-content h3 {
    font-size: 1.5rem;
    font-weight: 600;
    margin-top: 2rem;
    margin-bottom: 1rem;
    color: #333;
}

.post-content h4 {
    font-size: 1.25rem;
    font-weight: 600;
    margin-top: 1.5rem;
    margin-bottom: 0.75rem;
    color: #444;
}

.post-content ul, 
.post-content ol {
    margin-bottom: 1.75rem;
    padding-left: 1.5rem;
}

.post-content li {
    margin-bottom: 0.75rem;
    padding-left: 0.5rem;
}

.post-content ul li::marker {
    color: var(--tsa-primary);
}

.post-content blockquote {
    border-left: 4px solid var(--tsa-primary);
    background: var(--tsa-light);
    padding: 1.5rem 2rem;
    margin: 2rem 0;
    font-style: italic;
    color: #555;
    border-radius: 0 15px 15px 0;
}

.post-content a {
    color: var(--tsa-primary);
    text-decoration: underline;
    transition: color 0.3s ease;
}

.post-content a:hover {
    color: var(--tsa-secondary);
}

.post-content strong {
    color: #333;
}

/* Tags Section */
.article-tags {
    padding: 2rem 2.5rem;
    border-top: 1px solid #f0f0f0;
}

.tags-title {
    font-weight: 600;
    color: #333;
    margin-bottom: 1rem;
}

.tags-list {
    display: flex;
    flex-wrap: wrap;
    gap: 0.75rem;
}

.tag-item {
    display: inline-block;
    background: var(--tsa-light);
    color: var(--tsa-primary);
    padding: 0.5rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 500;
    transition: all 0.3s ease;
}

.tag-item:hover {
    background: var(--tsa-primary);
    color: white;
}

/* Share Section */
.article-share {
    padding: 2rem 2.5rem;
    border-top: 1px solid #f0f0f0;
    background: #fafafa;
}

.share-title {
    font-weight: 600;
    color: #333;
    margin-bottom: 1rem;
}

.share-buttons {
    display: flex;
    gap: 0.75rem;
    flex-wrap: wrap;
}

.share-btn {
    width: 45px;
    height: 45px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1rem;
    text-decoration: none;
    transition: all 0.3s ease;
    border: none;
    cursor: pointer;
}

.share-btn:hover {
    transform: translateY(-3px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.2);
}

.share-btn.facebook { background: #1877f2; }
.share-btn.twitter { background: #1da1f2; }
.share-btn.linkedin { background: #0077b5; }
.share-btn.whatsapp { background: #25d366; }
.share-btn.copy-link { background: var(--tsa-gradient); }

.share-btn.facebook:hover { background: #0d65d9; color: white; }
.share-btn.twitter:hover { background: #0c8de4; color: white; }
.share-btn.linkedin:hover { background: #006097; color: white; }
.share-btn.whatsapp:hover { background: #1da851; color: white; }

.copy-notification {
    display: none;
    margin-top: 1rem;
    padding: 0.75rem 1.25rem;
    background: #28a745;
    color: white;
    border-radius: 10px;
    font-size: 0.9rem;
    animation: fadeIn 0.3s ease;
}

.copy-notification.show {
    display: inline-block;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(-10px); }
    to { opacity: 1; transform: translateY(0); }
}

/* Author Box */
.author-box {
    display: flex;
    align-items: center;
    gap: 1.5rem;
    padding: 2rem 2.5rem;
    border-top: 1px solid #f0f0f0;
    background: linear-gradient(135deg, var(--tsa-light) 0%, #fff 100%);
}

.author-avatar-large {
    width: 80px;
    height: 80px;
    min-width: 80px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: 700;
    font-size: 2rem;
    box-shadow: 0 10px 25px rgba(242, 97, 36, 0.3);
}

.author-content .author-label {
    display: block;
    font-size: 0.8rem;
    color: #999;
    text-transform: uppercase;
    letter-spacing: 1px;
    margin-bottom: 0.25rem;
}

.author-content .author-name {
    font-weight: 700;
    color: #333;
    margin-bottom: 0.5rem;
}

.author-content .author-bio {
    color: #666;
    font-size: 0.95rem;
    margin: 0;
    line-height: 1.6;
}

/* =========================================
   POST NAVIGATION
   ========================================= */
.post-navigation {
    display: flex;
    justify-content: space-between;
    gap: 1rem;
    margin: 2rem 0;
}

.nav-btn {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 1rem 1.5rem;
    background: white;
    border-radius: 15px;
    text-decoration: none;
    color: #333;
    font-weight: 500;
    box-shadow: 0 5px 20px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
}

.nav-btn:hover {
    background: var(--tsa-primary);
    color: white;
    transform: translateY(-3px);
    box-shadow: 0 10px 25px rgba(242, 97, 36, 0.3);
}

.nav-btn i {
    font-size: 0.9rem;
}

/* =========================================
   RELATED POSTS
   ========================================= */
.related-posts {
    margin-top: 3rem;
}

.section-title {
    display: flex;
    align-items: center;
    gap: 1rem;
    font-weight: 700;
    margin-bottom: 1.5rem;
}

.title-icon {
    width: 50px;
    height: 50px;
    background: var(--tsa-gradient);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.2rem;
}

.related-card {
    background: white;
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
    height: 100%;
}

.related-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 40px rgba(0,0,0,0.12);
}

.related-image {
    display: block;
    height: 150px;
    overflow: hidden;
}

.related-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.5s ease;
}

.related-card:hover .related-image img {
    transform: scale(1.1);
}

.related-image .placeholder-img {
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #f5f5f5, #e0e0e0);
    color: #ccc;
}

.related-content {
    padding: 1.25rem;
}

.related-title {
    font-weight: 600;
    margin-bottom: 0.5rem;
    line-height: 1.4;
}

.related-title a {
    color: #333;
    text-decoration: none;
    transition: color 0.3s ease;
}

.related-title a:hover {
    color: var(--tsa-primary);
}

.related-date {
    font-size: 0.8rem;
    color: #999;
}

/* =========================================
   SIDEBAR
   ========================================= */
.sidebar {
    position: sticky;
    top: 100px;
}

.sidebar-widget {
    background: white;
    border-radius: 20px;
    padding: 1.5rem;
    margin-bottom: 1.5rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
}

/* Back Widget */
.back-widget {
    padding: 1rem;
}

.back-btn {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 100%;
    padding: 1rem;
    background: var(--tsa-light);
    border-radius: 12px;
    color: var(--tsa-primary);
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s ease;
}

.back-btn:hover {
    background: var(--tsa-primary);
    color: white;
}

/* CTA Widget */
.cta-widget {
    background: var(--tsa-gradient);
    text-align: center;
    padding: 2rem;
}

.cta-icon {
    width: 70px;
    height: 70px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1.25rem;
    color: white;
    font-size: 1.8rem;
}

.cta-title {
    color: white;
    font-weight: 700;
    margin-bottom: 0.75rem;
}

.cta-text {
    color: rgba(255,255,255,0.85);
    font-size: 0.95rem;
    margin-bottom: 1.5rem;
}

.cta-widget .btn-light {
    font-weight: 600;
}

.cta-widget .btn-light:hover {
    background: var(--tsa-cream);
}

.cta-widget .btn-outline-light {
    border-width: 2px;
    font-weight: 600;
}

/* Workshop Widget */
.workshop-widget {
    border: 2px solid var(--tsa-primary);
    border-radius: 20px;
}

.workshop-badge {
    display: inline-block;
    background: var(--tsa-cream);
    color: var(--tsa-primary-dark);
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.8rem;
    font-weight: 600;
    margin-bottom: 1rem;
}

.widget-title {
    font-weight: 700;
    color: #333;
    margin-bottom: 0.75rem;
}

.widget-text {
    color: #666;
    font-size: 0.95rem;
    margin-bottom: 1rem;
}

.workshop-features {
    list-style: none;
    padding: 0;
    margin: 0 0 1.25rem;
}

.workshop-features li {
    padding: 0.5rem 0;
    color: #555;
    font-size: 0.9rem;
}

.workshop-features li i {
    color: var(--tsa-primary);
    margin-right: 0.5rem;
}

/* Explore Widget */
.explore-widget .widget-title {
    padding-bottom: 1rem;
    border-bottom: 2px solid #f0f0f0;
    margin-bottom: 1rem;
}

.explore-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.explore-list li {
    margin-bottom: 0.5rem;
}

.explore-list li:last-child {
    margin-bottom: 0;
}

.explore-list a {
    display: flex;
    align-items: center;
    padding: 0.85rem 1rem;
    background: var(--tsa-light);
    border-radius: 12px;
    color: #555;
    text-decoration: none;
    transition: all 0.3s ease;
}

.explore-list a:hover {
    background: var(--tsa-primary);
    color: white;
    transform: translateX(5px);
}

.explore-list a i:first-child {
    width: 20px;
    margin-right: 0.75rem;
    color: var(--tsa-primary);
}

.explore-list a:hover i:first-child {
    color: white;
}

.explore-list a span {
    flex: 1;
    font-weight: 500;
}

.explore-list a .arrow {
    font-size: 0.75rem;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.explore-list a:hover .arrow {
    opacity: 1;
}

/* Social Widget */
.social-widget .widget-title {
    margin-bottom: 1.25rem;
}

.social-links {
    display: flex;
    gap: 0.75rem;
}

.social-link {
    width: 45px;
    height: 45px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.1rem;
    text-decoration: none;
    transition: all 0.3s ease;
}

.social-link:hover {
    transform: translateY(-3px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.2);
}

.social-link.facebook { background: #1877f2; }
.social-link.instagram { background: linear-gradient(45deg, #f09433, #e6683c, #dc2743, #cc2366, #bc1888); }
.social-link.twitter { background: #1da1f2; }
.social-link.whatsapp { background: #25d366; }

/* =========================================
   NEWSLETTER SECTION
   ========================================= */
.newsletter-section {
    background: linear-gradient(135deg, #1a1a2e, #16213e);
}

.newsletter-card {
    background: rgba(255,255,255,0.05);
    backdrop-filter: blur(10px);
    border-radius: 20px;
    padding: 2.5rem;
    border: 1px solid rgba(255,255,255,0.1);
}

.newsletter-form .form-control {
    border: none;
    border-radius: 50px 0 0 50px;
    padding: 1rem 1.5rem;
    font-size: 1rem;
}

.newsletter-form .form-control:focus {
    box-shadow: none;
}

.newsletter-form .btn {
    border-radius: 0 50px 50px 0;
    padding: 1rem 2rem;
    font-weight: 600;
}

.newsletter-form .btn:hover {
    background: var(--tsa-cream);
}

/* =========================================
   BUTTON STYLES
   ========================================= */
.btn-primary {
    background: var(--tsa-gradient);
    border: none;
    font-weight: 600;
    padding: 0.75rem 1.5rem;
    border-radius: 50px;
    transition: all 0.3s ease;
}

.btn-primary:hover {
    background: var(--tsa-gradient-reverse);
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(242, 97, 36, 0.4);
}

/* =========================================
   RESPONSIVE STYLES
   ========================================= */
@media (max-width: 991px) {
    .article-hero {
        padding: 80px 0 50px;
    }
    
    .article-title {
        font-size: 2rem;
    }
    
    .article-meta {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .sidebar {
        position: relative;
        top: 0;
        margin-top: 2rem;
    }
}

@media (max-width: 768px) {
    .article-hero {
        padding: 70px 0 40px;
    }
    
    .article-title {
        font-size: 1.75rem;
    }
    
    .meta-stats {
        flex-wrap: wrap;
        gap: 1rem;
    }
    
    .featured-image {
        max-height: 300px;
    }
    
    .article-body {
        padding: 1.5rem;
    }
    
    .article-tags,
    .article-share,
    .author-box {
        padding: 1.5rem;
    }
    
    .author-box {
        flex-direction: column;
        text-align: center;
    }
    
    .post-navigation {
        flex-direction: column;
    }
    
    .nav-btn {
        justify-content: center;
    }
    
    .newsletter-form .input-group {
        flex-direction: column;
    }
    
    .newsletter-form .form-control {
        border-radius: 50px;
        margin-bottom: 1rem;
    }
    
    .newsletter-form .btn {
        border-radius: 50px;
        width: 100%;
    }
    
    .post-content {
        font-size: 1.05rem;
    }
    
    .post-content h2 {
        font-size: 1.5rem;
    }
    
    .post-content h3 {
        font-size: 1.25rem;
    }
}
</style>

<script>
// Copy Article Link Function
function copyArticleLink() {
    const url = window.location.href;
    navigator.clipboard.writeText(url).then(function() {
        const notification = document.getElementById('copyNotification');
        notification.classList.add('show');
        
        setTimeout(function() {
            notification.classList.remove('show');
        }, 3000);
    }).catch(function(err) {
        console.error('Failed to copy: ', err);
        // Fallback for older browsers
        const textArea = document.createElement('textarea');
        textArea.value = url;
        document.body.appendChild(textArea);
        textArea.select();
        document.execCommand('copy');
        document.body.removeChild(textArea);
        
        const notification = document.getElementById('copyNotification');
        notification.classList.add('show');
        
        setTimeout(function() {
            notification.classList.remove('show');
        }, 3000);
    });
}
</script>