<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Registration Hero Banner -->
<section class="registration-hero">
    <div class="container">
        <div class="row align-items-center justify-content-center">
            <div class="col-lg-8 text-center">
                <div class="hero-flag">
                    <span class="flag-emoji">🇫🇷</span>
                </div>
                <span class="section-badge mb-3">
                    <i class="fas fa-user-graduate me-2"></i>Adult Programme
                </span>
                <h1 class="display-5 fw-bold text-white mb-3">Adult French Registration</h1>
                <p class="lead text-white-50 mb-0">Take your French skills to the next level with our immersive adult learning programme tailored to your schedule and goals.</p>
            </div>
        </div>
    </div>
</section>

<!-- Flash Messages -->
<div class="container mt-n4 position-relative" style="z-index: 10;">
    <?php if($this->session->flashdata('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show alert-custom" role="alert">
            <div class="alert-icon">
                <i class="fas fa-exclamation-circle"></i>
            </div>
            <div class="alert-content">
                <strong>Oops!</strong> <?= $this->session->flashdata('error') ?>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if($this->session->flashdata('success')): ?>
        <div class="alert alert-success alert-dismissible fade show alert-custom" role="alert">
            <div class="alert-icon">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="alert-content">
                <strong>Success!</strong> <?= $this->session->flashdata('success') ?>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
</div>

<!-- Main Registration Section -->
<section class="py-5 registration-section">
    <div class="container">
        <div class="row">
            <!-- Registration Form -->
            <div class="col-lg-8">
                <div class="registration-card">
                    <!-- Form Header -->
                    <div class="form-header adult">
                        <div class="header-decoration">
                            <div class="deco-line"></div>
                            <div class="deco-line"></div>
                            <div class="deco-line"></div>
                        </div>
                        <div class="header-content">
                            <div class="header-icon">
                                <i class="fas fa-user-tie"></i>
                            </div>
                            <h2 class="form-title">Adult Learner Registration</h2>
                            <p class="form-subtitle">Start your French learning journey today</p>
                        </div>
                    </div>
                    
                    <!-- Progress Indicator -->
                    <div class="form-progress">
                        <div class="progress-step active" data-step="1">
                            <span class="step-number">1</span>
                            <span class="step-label">Personal</span>
                        </div>
                        <div class="progress-line"></div>
                        <div class="progress-step" data-step="2">
                            <span class="step-number">2</span>
                            <span class="step-label">Contact</span>
                        </div>
                        <div class="progress-line"></div>
                        <div class="progress-step" data-step="3">
                            <span class="step-number">3</span>
                            <span class="step-label">Preferences</span>
                        </div>
                    </div>
                    
                    <?= form_open('adult_registration/submit', ['class' => 'registration-form needs-validation', 'id' => 'registrationForm', 'novalidate' => 'novalidate']) ?>
                        <?php echo form_hidden($this->security->get_csrf_token_name(), $this->security->get_csrf_hash()); ?>
                        
                        <!-- Section 1: Personal Information -->
                        <div class="form-section" id="section-1">
                            <div class="section-header">
                                <div class="section-icon">
                                    <i class="fas fa-user"></i>
                                </div>
                                <div>
                                    <h4 class="section-title">Personal Information</h4>
                                    <p class="section-subtitle">Tell us about yourself</p>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <div class="form-group-custom">
                                        <label class="form-label">First Name <span class="text-danger">*</span></label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-user"></i>
                                            <input type="text" name="first_name" class="form-control" 
                                                   value="<?= set_value('first_name') ?>" 
                                                   placeholder="Your first name" required>
                                        </div>
                                        <?= form_error('first_name', '<small class="text-danger">', '</small>') ?>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <div class="form-group-custom">
                                        <label class="form-label">Surname <span class="text-danger">*</span></label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-user"></i>
                                            <input type="text" name="surname" class="form-control" 
                                                   value="<?= set_value('surname') ?>" 
                                                   placeholder="Your surname" required>
                                        </div>
                                        <?= form_error('surname', '<small class="text-danger">', '</small>') ?>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-4 mb-4">
                                    <div class="form-group-custom">
                                        <label class="form-label">Age <span class="text-danger">*</span></label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-calendar-alt"></i>
                                            <input type="number" name="age" class="form-control" 
                                                   value="<?= set_value('age') ?>" 
                                                   min="18" max="120" placeholder="Age" required>
                                        </div>
                                        <?= form_error('age', '<small class="text-danger">', '</small>') ?>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-4">
                                    <div class="form-group-custom">
                                        <label class="form-label">Gender <span class="text-danger">*</span></label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-venus-mars"></i>
                                            <select name="gender" class="form-control" required>
                                                <option value="">Select Gender</option>
                                                <option value="Male" <?= set_select('gender', 'Male') ?>>Male</option>
                                                <option value="Female" <?= set_select('gender', 'Female') ?>>Female</option>
                                                <option value="Other" <?= set_select('gender', 'Other') ?>>Other</option>
                                            </select>
                                        </div>
                                        <?= form_error('gender', '<small class="text-danger">', '</small>') ?>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-4">
                                    <div class="form-group-custom">
                                        <label class="form-label">French Level <span class="text-danger">*</span></label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-signal"></i>
                                            <select name="french_level" class="form-control" required>
                                                <option value="">Select Level</option>
                                                <option value="Beginner" <?= set_select('french_level', 'Beginner') ?>>Beginner</option>
                                                <option value="BeginnerPlus" <?= set_select('french_level', 'BeginnerPlus') ?>>Beginner Plus</option>
                                                <option value="Intermediate" <?= set_select('french_level', 'Intermediate') ?>>Intermediate</option>
                                                <option value="Almost advanced" <?= set_select('french_level', 'Almost advanced') ?>>Almost Advanced</option>
                                            </select>
                                        </div>
                                        <?= form_error('french_level', '<small class="text-danger">', '</small>') ?>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- French Level Visual Selector -->
                            <div class="level-selector mb-4">
                                <label class="form-label mb-3">Select your current French proficiency:</label>
                                <div class="level-options adult">
                                    <label class="level-option">
                                        <input type="radio" name="french_level_visual" value="Beginner">
                                        <span class="level-card">
                                            <span class="level-icon"><i class="fas fa-seedling"></i></span>
                                            <span class="level-name">Beginner</span>
                                            <span class="level-desc">New to French</span>
                                        </span>
                                    </label>
                                    <label class="level-option">
                                        <input type="radio" name="french_level_visual" value="BeginnerPlus">
                                        <span class="level-card">
                                            <span class="level-icon"><i class="fas fa-leaf"></i></span>
                                            <span class="level-name">Beginner+</span>
                                            <span class="level-desc">Basic knowledge</span>
                                        </span>
                                    </label>
                                    <label class="level-option">
                                        <input type="radio" name="french_level_visual" value="Intermediate">
                                        <span class="level-card">
                                            <span class="level-icon"><i class="fas fa-tree"></i></span>
                                            <span class="level-name">Intermediate</span>
                                            <span class="level-desc">Can converse</span>
                                        </span>
                                    </label>
                                    <label class="level-option">
                                        <input type="radio" name="french_level_visual" value="Almost advanced">
                                        <span class="level-card">
                                            <span class="level-icon"><i class="fas fa-crown"></i></span>
                                            <span class="level-name">Advanced</span>
                                            <span class="level-desc">Near fluent</span>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Section 2: Contact Information -->
                        <div class="form-section" id="section-2">
                            <div class="section-header">
                                <div class="section-icon">
                                    <i class="fas fa-address-card"></i>
                                </div>
                                <div>
                                    <h4 class="section-title">Contact Information</h4>
                                    <p class="section-subtitle">How can we reach you?</p>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <div class="form-group-custom">
                                        <label class="form-label">Email Address <span class="text-danger">*</span></label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-envelope"></i>
                                            <input type="email" name="email" class="form-control" 
                                                   value="<?= set_value('email') ?>" 
                                                   placeholder="your@email.com" required>
                                        </div>
                                        <?= form_error('email', '<small class="text-danger">', '</small>') ?>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <div class="form-group-custom">
                                        <label class="form-label">Contact Number <span class="text-danger">*</span></label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-phone"></i>
                                            <input type="tel" name="contact_number" class="form-control" 
                                                   value="<?= set_value('contact_number') ?>" 
                                                   placeholder="+233 XX XXX XXXX" required>
                                        </div>
                                        <?= form_error('contact_number', '<small class="text-danger">', '</small>') ?>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <div class="form-group-custom">
                                        <label class="form-label">Home Location <span class="text-danger">*</span></label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-map-marker-alt"></i>
                                            <input type="text" name="home_location" class="form-control" 
                                                   value="<?= set_value('home_location') ?>" 
                                                   placeholder="e.g., East Legon, Accra" required>
                                        </div>
                                        <?= form_error('home_location', '<small class="text-danger">', '</small>') ?>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <div class="form-group-custom">
                                        <label class="form-label">Field of Work</label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-briefcase"></i>
                                            <input type="text" name="field_of_work" class="form-control" 
                                                   value="<?= set_value('field_of_work') ?>" 
                                                   placeholder="e.g., Finance, Healthcare, IT">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Section 3: Learning Preferences -->
                        <div class="form-section" id="section-3">
                            <div class="section-header">
                                <div class="section-icon">
                                    <i class="fas fa-cogs"></i>
                                </div>
                                <div>
                                    <h4 class="section-title">Learning Preferences</h4>
                                    <p class="section-subtitle">Help us customize your learning experience</p>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <div class="form-group-custom">
                                        <label class="form-label">Favorite French Activity</label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-heart"></i>
                                            <input type="text" name="favorite_french_activity" class="form-control" 
                                                   value="<?= set_value('favorite_french_activity') ?>" 
                                                   placeholder="e.g., Conversations, Reading, Films">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <div class="form-group-custom">
                                        <label class="form-label">Area of Improvement</label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-chart-line"></i>
                                            <input type="text" name="area_of_improvement" class="form-control" 
                                                   value="<?= set_value('area_of_improvement') ?>" 
                                                   placeholder="e.g., Speaking, Grammar, Vocabulary">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Learning Goals -->
                            <div class="learning-goals mb-4">
                                <label class="form-label mb-3">Why do you want to learn French?</label>
                                <div class="goals-grid">
                                    <label class="goal-option">
                                        <input type="checkbox" name="goals[]" value="career">
                                        <span class="goal-card">
                                            <i class="fas fa-briefcase"></i>
                                            <span>Career Growth</span>
                                        </span>
                                    </label>
                                    <label class="goal-option">
                                        <input type="checkbox" name="goals[]" value="travel">
                                        <span class="goal-card">
                                            <i class="fas fa-plane"></i>
                                            <span>Travel</span>
                                        </span>
                                    </label>
                                    <label class="goal-option">
                                        <input type="checkbox" name="goals[]" value="culture">
                                        <span class="goal-card">
                                            <i class="fas fa-theater-masks"></i>
                                            <span>Culture</span>
                                        </span>
                                    </label>
                                    <label class="goal-option">
                                        <input type="checkbox" name="goals[]" value="education">
                                        <span class="goal-card">
                                            <i class="fas fa-graduation-cap"></i>
                                            <span>Education</span>
                                        </span>
                                    </label>
                                    <label class="goal-option">
                                        <input type="checkbox" name="goals[]" value="relocation">
                                        <span class="goal-card">
                                            <i class="fas fa-globe-africa"></i>
                                            <span>Relocation</span>
                                        </span>
                                    </label>
                                    <label class="goal-option">
                                        <input type="checkbox" name="goals[]" value="personal">
                                        <span class="goal-card">
                                            <i class="fas fa-heart"></i>
                                            <span>Personal</span>
                                        </span>
                                    </label>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <div class="form-group-custom">
                                        <label class="form-label">Preferred Lesson Times</label>
                                        <div class="input-wrapper textarea">
                                            <i class="fas fa-clock"></i>
                                            <textarea name="preferred_lesson_times" class="form-control" rows="3" 
                                                      placeholder="e.g., Weekday evenings after 6pm, Saturday mornings"><?= set_value('preferred_lesson_times') ?></textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <div class="form-group-custom">
                                        <label class="form-label">Learning Considerations</label>
                                        <div class="input-wrapper textarea">
                                            <i class="fas fa-info-circle"></i>
                                            <textarea name="learning_difficulties" class="form-control" rows="3" 
                                                      placeholder="Any learning preferences or needs we should know about?"><?= set_value('learning_difficulties') ?></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Submit Section -->
                        <div class="form-section submit-section">
                            <div class="consent-box">
                                <label class="custom-checkbox">
                                    <input type="checkbox" name="consent" required>
                                    <span class="checkmark"></span>
                                    <span class="checkbox-label">
                                        I agree to receive communications from The Skills Atelier regarding the French Workshop programme and consent to the processing of my personal information.
                                    </span>
                                </label>
                            </div>
                            
                            <button type="submit" class="btn btn-submit">
                                <span class="btn-content">
                                    <i class="fas fa-paper-plane me-2"></i>
                                    <span class="btn-text">Submit Registration</span>
                                </span>
                                <span class="btn-loading" style="display: none;">
                                    <i class="fas fa-spinner fa-spin me-2"></i>Submitting...
                                </span>
                            </button>
                            
                            <p class="submit-note">
                                <i class="fas fa-lock me-1"></i>
                                Your information is secure. We'll contact you within 24-48 hours.
                            </p>
                        </div>
                    <?= form_close() ?>
                </div>
            </div>
            
            <!-- Sidebar -->
            <div class="col-lg-4">
                <aside class="sidebar">
                    <!-- Programme Info Widget -->
                    <div class="sidebar-widget programme-widget">
                        <div class="widget-header">
                            <span class="flag-badge">🇫🇷</span>
                            <div>
                                <h5>Adult French Programme</h5>
                                <span class="badge-coming">Coming 2026</span>
                            </div>
                        </div>
                        <p class="programme-desc">
                            Our adult programme is designed for professionals and individuals who want to learn French at their own pace with flexible scheduling.
                        </p>
                        <div class="programme-features">
                            <div class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Flexible scheduling</span>
                            </div>
                            <div class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Small group classes</span>
                            </div>
                            <div class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Business French options</span>
                            </div>
                            <div class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <span>One-on-one tutoring</span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- What You'll Learn Widget -->
                    <div class="sidebar-widget learn-widget">
                        <h5 class="widget-title"><i class="fas fa-lightbulb me-2"></i>What You'll Gain</h5>
                        <ul class="learn-list">
                            <li><i class="fas fa-check-circle"></i> Professional French communication</li>
                            <li><i class="fas fa-check-circle"></i> Conversational fluency</li>
                            <li><i class="fas fa-check-circle"></i> Reading & comprehension skills</li>
                            <li><i class="fas fa-check-circle"></i> Cultural understanding</li>
                            <li><i class="fas fa-check-circle"></i> Business vocabulary</li>
                            <li><i class="fas fa-check-circle"></i> Exam preparation (DELF/DALF)</li>
                        </ul>
                    </div>
                    
                    <!-- Class Formats Widget -->
                    <div class="sidebar-widget format-widget">
                        <h5 class="widget-title"><i class="fas fa-chalkboard-teacher me-2"></i>Class Formats</h5>
                        <div class="format-grid">
                            <div class="format-item">
                                <div class="format-icon">
                                    <i class="fas fa-users"></i>
                                </div>
                                <div class="format-content">
                                    <h6>Group Classes</h6>
                                    <p>4-8 learners per group</p>
                                </div>
                            </div>
                            <div class="format-item">
                                <div class="format-icon">
                                    <i class="fas fa-user"></i>
                                </div>
                                <div class="format-content">
                                    <h6>Private Sessions</h6>
                                    <p>One-on-one tutoring</p>
                                </div>
                            </div>
                            <div class="format-item">
                                <div class="format-icon">
                                    <i class="fas fa-laptop"></i>
                                </div>
                                <div class="format-content">
                                    <h6>Online Classes</h6>
                                    <p>Learn from anywhere</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Contact Widget -->
                    <div class="sidebar-widget contact-widget">
                        <div class="contact-icon">
                            <i class="fas fa-comments"></i>
                        </div>
                        <h5>Have Questions?</h5>
                        <p>Interested in our adult programme? Let's discuss how we can help you achieve your French learning goals.</p>
                        <a href="https://wa.me/233500557751?text=Hi!%20I'm%20interested%20in%20the%20Adult%20French%20Programme" 
                           target="_blank" 
                           class="btn btn-whatsapp w-100">
                            <i class="fab fa-whatsapp me-2"></i>Chat on WhatsApp
                        </a>
                    </div>
                    
                    <!-- Early Bird Widget -->
                    <div class="sidebar-widget earlybird-widget">
                        <div class="earlybird-content">
                            <span class="earlybird-badge">🎉 Early Bird</span>
                            <h5>Register Your Interest</h5>
                            <p>Be among the first to know when our adult programme launches. Early registrations get special pricing!</p>
                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </div>
</section>

<style>
/* =========================================
   THE SKILLS ATELIER - ADULT REGISTRATION STYLES
   Primary: #f26124 (Orange)
   Secondary: #8105bf (Purple)
   ========================================= */

:root {
    --tsa-primary: #f26124;
    --tsa-primary-dark: #d94f15;
    --tsa-secondary: #8105bf;
    --tsa-secondary-dark: #6a049e;
    --tsa-light: #fff8f5;
    --tsa-cream: #f7e1b0;
    --tsa-gradient: linear-gradient(135deg, #f26124, #8105bf);
    --tsa-gradient-reverse: linear-gradient(135deg, #8105bf, #f26124);
}

/* =========================================
   REGISTRATION HERO
   ========================================= */
.registration-hero {
    background: var(--tsa-gradient-reverse);
    padding: 100px 0 80px;
    position: relative;
    overflow: hidden;
}

.registration-hero::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E") repeat;
}

.hero-flag {
    width: 80px;
    height: 80px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1.5rem;
    backdrop-filter: blur(10px);
}

.flag-emoji {
    font-size: 2.5rem;
}

.section-badge {
    display: inline-block;
    background: rgba(255,255,255,0.2);
    backdrop-filter: blur(10px);
    color: white;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
}

/* =========================================
   ALERT STYLES
   ========================================= */
.alert-custom {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem 1.5rem;
    border-radius: 15px;
    border: none;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    max-width: 600px;
    margin: 0 auto;
}

.alert-icon {
    width: 45px;
    height: 45px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
}

.alert-success .alert-icon { background: rgba(40, 167, 69, 0.2); color: #28a745; }
.alert-danger .alert-icon { background: rgba(220, 53, 69, 0.2); color: #dc3545; }

/* =========================================
   REGISTRATION SECTION
   ========================================= */
.registration-section {
    background: linear-gradient(180deg, #f5f0fa 0%, #fff 100%);
}

.registration-card {
    background: white;
    border-radius: 25px;
    box-shadow: 0 20px 60px rgba(0,0,0,0.1);
    overflow: hidden;
}

/* Form Header - Adult Theme */
.form-header.adult {
    background: var(--tsa-gradient-reverse);
    padding: 2.5rem;
    position: relative;
    overflow: hidden;
}

.header-decoration {
    position: absolute;
    bottom: 0;
    right: 0;
    display: flex;
    gap: 0.25rem;
    padding: 0.5rem;
}

.deco-line {
    width: 4px;
    height: 30px;
    background: rgba(255,255,255,0.2);
    border-radius: 2px;
}

.deco-line:nth-child(1) { height: 20px; }
.deco-line:nth-child(2) { height: 35px; }
.deco-line:nth-child(3) { height: 25px; }

.header-content {
    text-align: center;
    position: relative;
    z-index: 1;
}

.header-icon {
    width: 70px;
    height: 70px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
    font-size: 1.8rem;
    color: white;
}

.form-title {
    color: white;
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.form-subtitle {
    color: rgba(255,255,255,0.85);
    margin: 0;
}

/* Form Progress */
.form-progress {
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 1.5rem 2rem;
    background: #fafafa;
    border-bottom: 1px solid #f0f0f0;
}

.progress-step {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 0.5rem;
}

.step-number {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #e9ecef;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #adb5bd;
    font-weight: 700;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.progress-step.active .step-number {
    background: var(--tsa-gradient-reverse);
    color: white;
    box-shadow: 0 5px 20px rgba(129, 5, 191, 0.4);
}

.step-label {
    font-size: 0.8rem;
    font-weight: 600;
    color: #adb5bd;
}

.progress-step.active .step-label {
    color: var(--tsa-secondary);
}

.progress-line {
    width: 60px;
    height: 3px;
    background: #e9ecef;
    margin: 0 1rem;
    margin-bottom: 1.5rem;
    border-radius: 3px;
}

/* Form Sections */
.form-section {
    padding: 2rem 2.5rem;
    border-bottom: 1px solid #f0f0f0;
}

.section-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 2rem;
}

.section-icon {
    width: 55px;
    height: 55px;
    background: var(--tsa-gradient-reverse);
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.3rem;
}

.section-title {
    font-weight: 700;
    margin-bottom: 0.25rem;
    color: #333;
}

.section-subtitle {
    color: #888;
    font-size: 0.9rem;
    margin: 0;
}

/* Form Inputs */
.form-group-custom {
    margin-bottom: 0;
}

.form-label {
    font-weight: 600;
    color: #333;
    margin-bottom: 0.5rem;
    font-size: 0.95rem;
}

.input-wrapper {
    position: relative;
}

.input-wrapper i {
    position: absolute;
    left: 1rem;
    top: 50%;
    transform: translateY(-50%);
    color: #adb5bd;
    font-size: 1rem;
    z-index: 1;
    transition: color 0.3s ease;
}

.input-wrapper.textarea i {
    top: 1.25rem;
    transform: none;
}

.input-wrapper .form-control {
    padding-left: 3rem;
    border: 2px solid #e9ecef;
    border-radius: 12px;
    height: auto;
    padding-top: 0.875rem;
    padding-bottom: 0.875rem;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.input-wrapper .form-control:focus {
    border-color: var(--tsa-secondary);
    box-shadow: 0 0 0 4px rgba(129, 5, 191, 0.1);
}

.input-wrapper:focus-within i {
    color: var(--tsa-secondary);
}

.input-wrapper textarea.form-control {
    min-height: 100px;
}

.input-wrapper select.form-control {
    appearance: none;
    background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='%23adb5bd' viewBox='0 0 16 16'%3E%3Cpath d='M7.247 11.14L2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z'/%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: right 1rem center;
    padding-right: 2.5rem;
}

/* Level Selector - Adult Theme */
.level-selector {
    background: #f8f5fa;
    padding: 1.5rem;
    border-radius: 15px;
}

.level-options.adult {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 1rem;
}

.level-option {
    cursor: pointer;
}

.level-option input {
    display: none;
}

.level-card {
    display: flex;
    flex-direction: column;
    align-items: center;
    padding: 1.25rem 0.75rem;
    background: white;
    border: 2px solid #e9ecef;
    border-radius: 15px;
    text-align: center;
    transition: all 0.3s ease;
}

.level-option input:checked + .level-card {
    background: linear-gradient(135deg, rgba(129, 5, 191, 0.1), rgba(242, 97, 36, 0.1));
    border-color: var(--tsa-secondary);
    box-shadow: 0 5px 20px rgba(129, 5, 191, 0.15);
}

.level-icon {
    width: 50px;
    height: 50px;
    background: var(--tsa-gradient-reverse);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 0.75rem;
    font-size: 1.2rem;
    color: white;
}

.level-name {
    font-weight: 700;
    color: #333;
    font-size: 0.9rem;
}

.level-desc {
    font-size: 0.75rem;
    color: #888;
}

/* Learning Goals */
.learning-goals {
    background: #f8f5fa;
    padding: 1.5rem;
    border-radius: 15px;
}

.goals-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 1rem;
}

.goal-option {
    cursor: pointer;
}

.goal-option input {
    display: none;
}

.goal-card {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 0.5rem;
    padding: 1rem;
    background: white;
    border: 2px solid #e9ecef;
    border-radius: 12px;
    text-align: center;
    transition: all 0.3s ease;
}

.goal-option input:checked + .goal-card {
    background: var(--tsa-secondary);
    border-color: var(--tsa-secondary);
    color: white;
}

.goal-card i {
    font-size: 1.5rem;
    color: var(--tsa-secondary);
    transition: color 0.3s ease;
}

.goal-option input:checked + .goal-card i {
    color: white;
}

.goal-card span {
    font-size: 0.85rem;
    font-weight: 600;
}

/* Consent Box */
.consent-box {
    background: #f8f5fa;
    padding: 1.5rem;
    border-radius: 15px;
    margin-bottom: 1.5rem;
}

.custom-checkbox {
    display: flex;
    align-items: flex-start;
    gap: 0.75rem;
    cursor: pointer;
}

.custom-checkbox input {
    display: none;
}

.checkmark {
    width: 24px;
    height: 24px;
    min-width: 24px;
    border: 2px solid #e9ecef;
    border-radius: 6px;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
    margin-top: 2px;
}

.custom-checkbox input:checked + .checkmark {
    background: var(--tsa-gradient-reverse);
    border-color: var(--tsa-secondary);
}

.custom-checkbox input:checked + .checkmark::after {
    content: '\f00c';
    font-family: 'Font Awesome 5 Free';
    font-weight: 900;
    color: white;
    font-size: 0.75rem;
}

.checkbox-label {
    color: #555;
    font-size: 0.9rem;
    line-height: 1.5;
}

/* Submit Section */
.submit-section {
    text-align: center;
    border-bottom: none;
}

.btn-submit {
    background: var(--tsa-gradient-reverse);
    border: none;
    color: white;
    font-weight: 600;
    font-size: 1.1rem;
    padding: 1rem 3rem;
    border-radius: 50px;
    transition: all 0.3s ease;
    box-shadow: 0 10px 30px rgba(129, 5, 191, 0.3);
    display: inline-flex;
    align-items: center;
}

.btn-submit:hover {
    background: var(--tsa-gradient);
    transform: translateY(-3px);
    box-shadow: 0 15px 40px rgba(129, 5, 191, 0.4);
    color: white;
}

.submit-note {
    margin-top: 1.5rem;
    color: #888;
    font-size: 0.85rem;
}

.submit-note i {
    color: #28a745;
}

/* =========================================
   SIDEBAR
   ========================================= */
.sidebar {
    position: sticky;
    top: 100px;
}

.sidebar-widget {
    background: white;
    border-radius: 20px;
    padding: 1.5rem;
    margin-bottom: 1.5rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
}

.widget-title {
    font-weight: 700;
    color: #333;
    margin-bottom: 1rem;
    padding-bottom: 0.75rem;
    border-bottom: 2px solid #f0f0f0;
}

/* Programme Widget */
.programme-widget {
    border: 2px solid var(--tsa-secondary);
}

.widget-header {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    margin-bottom: 1rem;
    padding-bottom: 1rem;
    border-bottom: 2px solid #f0f0f0;
}

.flag-badge {
    font-size: 2rem;
}

.widget-header h5 {
    font-weight: 700;
    margin: 0;
    color: #333;
}

.badge-coming {
    display: inline-block;
    background: var(--tsa-gradient-reverse);
    color: white;
    padding: 0.2rem 0.6rem;
    border-radius: 50px;
    font-size: 0.7rem;
    font-weight: 600;
}

.programme-desc {
    color: #666;
    font-size: 0.9rem;
    margin-bottom: 1rem;
    line-height: 1.6;
}

.programme-features {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.feature-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    font-size: 0.9rem;
    color: #555;
}

.feature-item i {
    color: var(--tsa-secondary);
}

/* Learn Widget */
.learn-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.learn-list li {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 0.75rem 0;
    border-bottom: 1px solid #f0f0f0;
    font-size: 0.9rem;
    color: #555;
}

.learn-list li:last-child {
    border-bottom: none;
    padding-bottom: 0;
}

.learn-list li i {
    color: var(--tsa-secondary);
    font-size: 0.9rem;
}

/* Format Widget */
.format-grid {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.format-item {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem;
    background: #f8f5fa;
    border-radius: 12px;
    transition: all 0.3s ease;
}

.format-item:hover {
    background: var(--tsa-secondary);
    color: white;
}

.format-icon {
    width: 45px;
    height: 45px;
    background: var(--tsa-gradient-reverse);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.1rem;
}

.format-content h6 {
    font-weight: 600;
    margin: 0 0 0.25rem;
    color: inherit;
}

.format-content p {
    font-size: 0.8rem;
    color: #888;
    margin: 0;
    transition: color 0.3s ease;
}

.format-item:hover .format-content p {
    color: rgba(255,255,255,0.8);
}

/* Contact Widget */
.contact-widget {
    background: var(--tsa-gradient-reverse);
    text-align: center;
    padding: 2rem;
}

.contact-widget .contact-icon {
    width: 60px;
    height: 60px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
    font-size: 1.5rem;
    color: white;
}

.contact-widget h5 {
    color: white;
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.contact-widget p {
    color: rgba(255,255,255,0.85);
    font-size: 0.9rem;
    margin-bottom: 1rem;
}

.btn-whatsapp {
    background: white;
    color: #25d366;
    font-weight: 600;
    padding: 0.875rem 1.5rem;
    border-radius: 50px;
    border: none;
    transition: all 0.3s ease;
}

.btn-whatsapp:hover {
    background: #25d366;
    color: white;
    transform: translateY(-2px);
}

/* Early Bird Widget */
.earlybird-widget {
    background: linear-gradient(135deg, var(--tsa-cream), #fff);
    border: 2px dashed var(--tsa-primary);
}

.earlybird-content {
    text-align: center;
}

.earlybird-badge {
    display: inline-block;
    background: var(--tsa-gradient);
    color: white;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    margin-bottom: 1rem;
}

.earlybird-widget h5 {
    font-weight: 700;
    color: #333;
    margin-bottom: 0.5rem;
}

.earlybird-widget p {
    color: #666;
    font-size: 0.9rem;
    margin: 0;
    line-height: 1.6;
}

/* =========================================
   RESPONSIVE STYLES
   ========================================= */
@media (max-width: 991px) {
    .registration-hero {
        padding: 80px 0 60px;
    }
    
    .registration-hero h1 {
        font-size: 2rem;
    }
    
    .sidebar {
        position: relative;
        top: 0;
        margin-top: 2rem;
    }
    
    .level-options.adult {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .goals-grid {
        grid-template-columns: repeat(3, 1fr);
    }
}

@media (max-width: 768px) {
    .registration-hero {
        padding: 70px 0 50px;
    }
    
    .registration-hero h1 {
        font-size: 1.75rem;
    }
    
    .form-progress {
        display: none;
    }
    
    .form-header,
    .form-section {
        padding: 1.5rem;
    }
    
    .section-header {
        flex-direction: column;
        text-align: center;
    }
    
    .level-options.adult {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .goals-grid {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .btn-submit {
        width: 100%;
        justify-content: center;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Form validation
    var forms = document.getElementsByClassName('needs-validation');
    Array.prototype.filter.call(forms, function(form) {
        form.addEventListener('submit', function(event) {
            if (form.checkValidity() === false) {
                event.preventDefault();
                event.stopPropagation();
            } else {
                // Show loading state
                var submitBtn = form.querySelector('.btn-submit');
                var btnContent = submitBtn.querySelector('.btn-content');
                var btnLoading = submitBtn.querySelector('.btn-loading');
                
                btnContent.style.display = 'none';
                btnLoading.style.display = 'inline-flex';
                submitBtn.disabled = true;
            }
            form.classList.add('was-validated');
        }, false);
    });
    
    // Level selector sync with dropdown
    var levelOptions = document.querySelectorAll('input[name="french_level_visual"]');
    var levelSelect = document.querySelector('select[name="french_level"]');
    
    levelOptions.forEach(function(option) {
        option.addEventListener('change', function() {
            levelSelect.value = this.value;
        });
    });
    
    // Update visual selector when dropdown changes
    levelSelect.addEventListener('change', function() {
        var value = this.value;
        levelOptions.forEach(function(option) {
            if (option.value === value) {
                option.checked = true;
            } else {
                option.checked = false;
            }
        });
    });
    
    // Update progress steps on scroll
    var sections = document.querySelectorAll('.form-section');
    var steps = document.querySelectorAll('.progress-step');
    
    function updateProgress() {
        var currentSection = 0;
        sections.forEach(function(section, index) {
            var rect = section.getBoundingClientRect();
            if (rect.top < window.innerHeight / 2) {
                currentSection = index;
            }
        });
        
        steps.forEach(function(step, index) {
            if (index <= currentSection) {
                step.classList.add('active');
            } else {
                step.classList.remove('active');
            }
        });
    }
    
    window.addEventListener('scroll', updateProgress);
    updateProgress();
});
</script>