<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Hero Carousel -->
<?php if (!empty($carousel_items)): ?>
<div id="heroCarousel" class="carousel slide carousel-fade" data-bs-ride="carousel">
    <div class="carousel-indicators">
        <?php foreach ($carousel_items as $index => $item): ?>
            <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="<?php echo $index; ?>" 
                    <?php echo ($index === 0) ? 'class="active" aria-current="true"' : ''; ?>></button>
        <?php endforeach; ?>
    </div>
    
    <div class="carousel-inner">
        <?php foreach ($carousel_items as $index => $item): ?>
            <div class="carousel-item <?php echo ($index === 0) ? 'active' : ''; ?>">
                <?php if ($item->media_type === 'image' && !empty($item->media_path)): ?>
                    <img src="<?php echo base_url('uploads/carousel/' . $item->media_path); ?>" 
                         class="d-block w-100" 
                         alt="<?php echo htmlspecialchars($item->title); ?>"
                         style="height: 600px; object-fit: cover;">
                <?php elseif ($item->media_type === 'video' && !empty($item->media_path)): ?>
                    <video class="d-block w-100" autoplay muted loop style="height: 600px; object-fit: cover;">
                        <source src="<?php echo base_url('uploads/carousel/' . $item->media_path); ?>" type="video/mp4">
                    </video>
                <?php endif; ?>
                
                <div class="carousel-caption">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-8 mx-auto text-center">
                                <h1 class="display-4 fw-bold mb-3" style="text-shadow: 2px 2px 4px rgba(0,0,0,0.5);">
                                    <?php echo htmlspecialchars($item->title); ?>
                                </h1>
                                <?php if (!empty($item->subtitle)): ?>
                                    <p class="lead mb-4" style="text-shadow: 1px 1px 2px rgba(0,0,0,0.5);">
                                        <?php echo htmlspecialchars($item->subtitle); ?>
                                    </p>
                                <?php endif; ?>
                                <?php if (!empty($item->description)): ?>
                                    <p class="mb-4" style="text-shadow: 1px 1px 2px rgba(0,0,0,0.5);">
                                        <?php echo htmlspecialchars($item->description); ?>
                                    </p>
                                <?php endif; ?>
                                <?php if (!empty($item->link_url)): ?>
                                    <a href="<?php echo $item->link_url; ?>" class="btn btn-primary btn-lg">
                                        <?php echo htmlspecialchars($item->link_text ?: 'Learn More'); ?> 
                                        <i class="fas fa-arrow-right ms-2"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
    
    <button class="carousel-control-prev" type="button" data-bs-target="#heroCarousel" data-bs-slide="prev">
        <span class="carousel-control-prev-icon"></span>
    </button>
    <button class="carousel-control-next" type="button" data-bs-target="#heroCarousel" data-bs-slide="next">
        <span class="carousel-control-next-icon"></span>
    </button>
</div>
<?php endif; ?>

<!-- Statistics Section -->
<section class="py-5" style="background: linear-gradient(135deg, #f26124, #8105bf);">
    <div class="container">
        <div class="row text-center text-white">
            <div class="col-md-3 col-6 mb-3">
                <div class="stat-item">
                    <h2 class="display-4 fw-bold mb-0"><?php echo number_format($statistics['volunteers'] ?? 0); ?>+</h2>
                    <p class="lead mb-0">Volunteers</p>
                </div>
            </div>
            <div class="col-md-3 col-6 mb-3">
                <div class="stat-item">
                    <h2 class="display-4 fw-bold mb-0"><?php echo number_format($statistics['workshops'] ?? 0); ?>+</h2>
                    <p class="lead mb-0">Workshops</p>
                </div>
            </div>
            <div class="col-md-3 col-6 mb-3">
                <div class="stat-item">
                    <h2 class="display-4 fw-bold mb-0"><?php echo number_format($statistics['partners'] ?? 0); ?>+</h2>
                    <p class="lead mb-0">Partners</p>
                </div>
            </div>
            <div class="col-md-3 col-6 mb-3">
                <div class="stat-item">
                    <h2 class="display-4 fw-bold mb-0"><?php echo number_format($statistics['blog_posts'] ?? 0); ?>+</h2>
                    <p class="lead mb-0">Articles</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Featured Workshops -->
<?php if (!empty($featured_workshops)): ?>
<section class="py-5">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="fw-bold">Featured Workshops</h2>
            <p class="lead text-muted">Empowering Communities Through Education</p>
        </div>
        
        <div class="row">
            <?php foreach ($featured_workshops as $workshop): ?>
                <div class="col-md-4 mb-4">
                    <div class="card h-100 shadow-sm border-0">
                        <?php if (!empty($workshop->featured_image)): ?>
                            <img src="<?php echo base_url('uploads/workshops/' . $workshop->featured_image); ?>" 
                                 class="card-img-top" 
                                 alt="<?php echo htmlspecialchars($workshop->title); ?>"
                                 style="height: 200px; object-fit: cover;">
                        <?php else: ?>
                            <div class="card-img-top bg-light d-flex align-items-center justify-content-center" 
                                 style="height: 200px;">
                                <i class="fas fa-chalkboard-teacher fa-3x text-muted"></i>
                            </div>
                        <?php endif; ?>
                        
                        <div class="card-body">
                            <span class="badge bg-primary mb-2">
                                <?php echo ucfirst($workshop->status); ?>
                            </span>
                            <h5 class="card-title fw-bold"><?php echo htmlspecialchars($workshop->title); ?></h5>
                            <p class="card-text text-muted">
                                <?php echo htmlspecialchars(character_limiter($workshop->description, 100)); ?>
                            </p>
                            
                            <?php if (!empty($workshop->duration)): ?>
                                <p class="mb-1">
                                    <i class="far fa-clock text-primary"></i>
                                    <small><?php echo htmlspecialchars($workshop->duration); ?></small>
                                </p>
                            <?php endif; ?>
                            
                            <?php if (!empty($workshop->location)): ?>
                                <p class="mb-3">
                                    <i class="fas fa-map-marker-alt text-primary"></i>
                                    <small><?php echo htmlspecialchars($workshop->location); ?></small>
                                </p>
                            <?php endif; ?>
                            
                            <a href="<?php echo base_url('workshops/view/' . $workshop->slug); ?>" 
                               class="btn btn-outline-primary w-100">
                                Learn More <i class="fas fa-arrow-right ms-2"></i>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        
        <div class="text-center mt-4">
            <a href="<?php echo base_url('workshops'); ?>" class="btn btn-primary btn-lg">
                View All Workshops <i class="fas fa-arrow-right ms-2"></i>
            </a>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Call to Action -->
<section class="py-5" style="background-color: #f7e1b0;">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8 mb-3 mb-lg-0">
                <h3 class="fw-bold mb-2">Ready to Make a Difference?</h3>
                <p class="lead mb-0">Join our volunteer team or book a free consultation session with our experts.</p>
            </div>
            <div class="col-lg-4 text-lg-end">
                <a href="<?php echo base_url('volunteer/apply'); ?>" class="btn btn-primary btn-lg me-2 mb-2">
                    <i class="fas fa-hands-helping"></i> Volunteer
                </a>
                <a href="<?php echo base_url('consultation'); ?>" class="btn btn-outline-primary btn-lg mb-2">
                    <i class="fas fa-calendar-check"></i> Book Consultation
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Latest Blog Posts -->
<?php if (!empty($latest_posts)): ?>
<section class="py-5 bg-light">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="fw-bold">Latest News & Stories</h2>
            <p class="lead text-muted">Stay updated with our community activities</p>
        </div>
        
        <div class="row">
            <?php foreach (array_slice($latest_posts, 0, 3) as $post): ?>
                <div class="col-md-4 mb-4">
                    <article class="card h-100 shadow-sm border-0">
                        <?php if (!empty($post->featured_image)): ?>
                            <img src="<?php echo base_url('uploads/blog/' . $post->featured_image); ?>" 
                                 class="card-img-top" 
                                 alt="<?php echo htmlspecialchars($post->title); ?>"
                                 style="height: 200px; object-fit: cover;">
                        <?php else: ?>
                            <div class="card-img-top bg-light d-flex align-items-center justify-content-center" 
                                 style="height: 200px;">
                                <i class="fas fa-newspaper fa-3x text-muted"></i>
                            </div>
                        <?php endif; ?>
                        
                        <div class="card-body">
                            <?php if (!empty($post->category_name)): ?>
                                <span class="badge bg-primary mb-2"><?php echo htmlspecialchars($post->category_name); ?></span>
                            <?php endif; ?>
                            
                            <h5 class="card-title fw-bold">
                                <a href="<?php echo base_url('blog/view/' . $post->slug); ?>" 
                                   class="text-decoration-none text-dark">
                                    <?php echo htmlspecialchars($post->title); ?>
                                </a>
                            </h5>
                            
                            <p class="card-text text-muted">
                                <?php echo htmlspecialchars(character_limiter($post->excerpt, 120)); ?>
                            </p>
                            
                            <div class="d-flex justify-content-between align-items-center">
                                <small class="text-muted">
                                    <i class="far fa-calendar"></i> 
                                    <?php echo date('M d, Y', strtotime($post->published_at)); ?>
                                </small>
                                <a href="<?php echo base_url('blog/view/' . $post->slug); ?>" class="btn btn-sm btn-outline-primary">
                                    Read More
                                </a>
                            </div>
                        </div>
                    </article>
                </div>
            <?php endforeach; ?>
        </div>
        
        <div class="text-center mt-4">
            <a href="<?php echo base_url('blog'); ?>" class="btn btn-primary btn-lg">
                View All Articles <i class="fas fa-arrow-right ms-2"></i>
            </a>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Partners Section -->
<?php if (!empty($partners)): ?>
<section class="py-5">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="fw-bold">Our Partners</h2>
            <p class="lead text-muted">Trusted organizations supporting our mission</p>
        </div>
        
        <div class="row align-items-center justify-content-center">
            <?php foreach (array_slice($partners, 0, 6) as $partner): ?>
                <div class="col-lg-2 col-md-3 col-4 text-center mb-4">
                    <?php if (!empty($partner->logo)): ?>
                        <img src="<?php echo base_url('uploads/partners/' . $partner->logo); ?>" 
                             alt="<?php echo htmlspecialchars($partner->name); ?>"
                             class="img-fluid partner-logo"
                             style="max-height: 80px; opacity: 0.7; transition: opacity 0.3s;"
                             onmouseover="this.style.opacity='1'" 
                             onmouseout="this.style.opacity='0.7'">
                    <?php else: ?>
                        <div class="text-muted">
                            <i class="fas fa-building fa-2x"></i>
                            <p class="small mt-2 mb-0"><?php echo htmlspecialchars($partner->name); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
        
        <?php if (count($partners) > 6): ?>
            <div class="text-center mt-4">
                <a href="<?php echo base_url('partners'); ?>" class="btn btn-outline-primary">
                    View All Partners <i class="fas fa-arrow-right ms-2"></i>
                </a>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php endif; ?>

<style>
.carousel-item {
    position: relative;
}

.carousel-caption {
    position: absolute;
    bottom: 50%;
    transform: translateY(50%);
    left: 0;
    right: 0;
}

.stat-item {
    padding: 1rem;
}

@media (max-width: 768px) {
    .carousel-caption h1 {
        font-size: 1.5rem;
    }
    
    .carousel-caption .lead {
        font-size: 1rem;
    }
    
    .stat-item h2 {
        font-size: 2rem;
    }
}
</style>