<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    
    <!-- SEO Meta Tags -->
    <title><?php echo isset($meta_title) ? $meta_title . ' - ' : ''; ?><?php echo $site_settings['site_name'] ?? 'The Skills Atelier'; ?></title>
    <meta name="description" content="<?php echo $meta_description ?? 'The Skills Atelier - Transforming how language and vital skills are taught in Ghana'; ?>">
    <meta name="keywords" content="<?php echo $meta_keywords ?? 'French lessons, language learning, Ghana, kids education, workshops'; ?>">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="<?php echo $meta_title ?? $site_settings['site_name'] ?? 'The Skills Atelier'; ?>">
    <meta property="og:description" content="<?php echo $meta_description ?? ''; ?>">
    <?php if (isset($meta_image)): ?>
        <meta property="og:image" content="<?php echo $meta_image; ?>">
    <?php endif; ?>
    
    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo $meta_title ?? $site_settings['site_name'] ?? 'The Skills Atelier'; ?>">
    <meta name="twitter:description" content="<?php echo $meta_description ?? ''; ?>">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo base_url('assets/images/favicon.ico'); ?>">
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Custom CSS -->
    <style>
        /* =========================================
           THE SKILLS ATELIER - MAIN LAYOUT STYLES
           Primary: #f26124 (Orange)
           Secondary: #8105bf (Purple)
           ========================================= */
        
        :root {
            --tsa-primary: #f26124;
            --tsa-primary-dark: #d94f15;
            --tsa-secondary: #8105bf;
            --tsa-secondary-dark: #6a049e;
            --tsa-dark: #231f20;
            --tsa-light: #fff8f5;
            --tsa-cream: #f7e1b0;
            --tsa-gradient: linear-gradient(135deg, #f26124, #8105bf);
            --tsa-gradient-reverse: linear-gradient(135deg, #8105bf, #f26124);
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            color: var(--tsa-dark);
            line-height: 1.6;
            overflow-x: hidden;
        }
        
        /* =========================================
           TOP BAR
           ========================================= */
        .top-bar {
            background: var(--tsa-gradient);
            padding: 0.5rem 0;
            font-size: 0.85rem;
        }
        
        .top-bar-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .top-bar-left {
            display: flex;
            align-items: center;
            gap: 1.5rem;
        }
        
        .top-bar-item {
            color: rgba(255,255,255,0.9);
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 0.4rem;
            transition: color 0.3s ease;
        }
        
        .top-bar-item:hover {
            color: white;
        }
        
        .top-bar-item i {
            font-size: 0.8rem;
        }
        
        .top-bar-right {
            display: flex;
            align-items: center;
            gap: 1rem;
        }
        
        .top-bar-social {
            display: flex;
            gap: 0.75rem;
        }
        
        .top-bar-social a {
            color: rgba(255,255,255,0.9);
            font-size: 0.9rem;
            transition: all 0.3s ease;
        }
        
        .top-bar-social a:hover {
            color: white;
            transform: scale(1.1);
        }
        
        /* =========================================
           NAVBAR
           ========================================= */
        .navbar {
            background: white;
            box-shadow: 0 5px 30px rgba(0,0,0,0.1);
            padding: 0.75rem 0;
            transition: all 0.3s ease;
        }
        
        .navbar.scrolled {
            padding: 0.5rem 0;
            box-shadow: 0 5px 30px rgba(0,0,0,0.15);
        }
        
        .navbar-brand {
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .navbar-brand img {
            height: 50px;
            transition: height 0.3s ease;
        }
        
        .navbar.scrolled .navbar-brand img {
            height: 40px;
        }
        
        .brand-text {
            display: flex;
            flex-direction: column;
            line-height: 1.2;
        }
        
        .brand-name {
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--tsa-primary);
        }
        
        .brand-tagline {
            font-size: 0.7rem;
            color: #888;
            font-weight: 500;
        }
        
        .navbar-nav {
            gap: 0.25rem;
        }
        
        .nav-item {
            position: relative;
        }
        
        .nav-link {
            color: var(--tsa-dark) !important;
            font-weight: 500;
            padding: 0.75rem 1rem !important;
            transition: all 0.3s ease;
            position: relative;
        }
        
        .nav-link::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 0;
            height: 3px;
            background: var(--tsa-gradient);
            border-radius: 3px;
            transition: width 0.3s ease;
        }
        
        .nav-link:hover::after,
        .nav-link.active::after {
            width: calc(100% - 2rem);
        }
        
        .nav-link:hover,
        .nav-link.active {
            color: var(--tsa-primary) !important;
        }
        
        /* Dropdown Styling */
        .nav-item.dropdown {
            position: relative;
        }
        
        /* Invisible bridge to prevent gap issues */
        .nav-item.dropdown::after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 0;
            right: 0;
            height: 15px;
            background: transparent;
        }
        
        .dropdown-menu {
            border: none;
            box-shadow: 0 15px 50px rgba(0,0,0,0.15);
            border-radius: 15px;
            padding: 0.75rem;
            min-width: 280px;
            margin-top: 0 !important;
            padding-top: 1rem;
            animation: fadeInDown 0.3s ease;
            transition: opacity 0.3s ease, visibility 0.3s ease;
        }
        
        /* Extend hover area at the top of dropdown */
        .dropdown-menu::before {
            content: '';
            position: absolute;
            top: -15px;
            left: 0;
            right: 0;
            height: 20px;
            background: transparent;
        }
        
        @keyframes fadeInDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .dropdown-item {
            padding: 0.75rem 1rem;
            border-radius: 10px;
            font-weight: 500;
            color: var(--tsa-dark);
            display: flex;
            align-items: center;
            gap: 0.75rem;
            transition: all 0.3s ease;
        }
        
        .dropdown-item:hover {
            background: var(--tsa-light);
            color: var(--tsa-primary);
            transform: translateX(5px);
        }
        
        .dropdown-item i {
            width: 35px;
            height: 35px;
            background: var(--tsa-gradient);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 0.9rem;
        }
        
        .dropdown-item-content {
            display: flex;
            flex-direction: column;
        }
        
        .dropdown-item-title {
            font-weight: 600;
            font-size: 0.95rem;
        }
        
        .dropdown-item-desc {
            font-size: 0.75rem;
            color: #888;
            font-weight: 400;
        }
        
        .dropdown-toggle::after {
            border: none;
            content: '\f107';
            font-family: 'Font Awesome 6 Free';
            font-weight: 900;
            font-size: 0.75rem;
            margin-left: 0.5rem;
            transition: transform 0.3s ease;
        }
        
        .dropdown:hover .dropdown-toggle::after {
            transform: rotate(180deg);
        }
        
        /* Navbar Buttons */
        .navbar-cta {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            margin-left: 1rem;
        }
        
        .btn-nav-outline {
            background: transparent;
            color: var(--tsa-primary);
            border: 2px solid var(--tsa-primary);
            font-weight: 600;
            padding: 0.5rem 1.25rem;
            border-radius: 50px;
            transition: all 0.3s ease;
            text-decoration: none;
            font-size: 0.9rem;
        }
        
        .btn-nav-outline:hover {
            background: var(--tsa-primary);
            color: white;
            transform: translateY(-2px);
        }
        
        .btn-nav-primary {
            background: var(--tsa-gradient);
            color: white;
            border: none;
            font-weight: 600;
            padding: 0.6rem 1.5rem;
            border-radius: 50px;
            transition: all 0.3s ease;
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            font-size: 0.9rem;
            box-shadow: 0 5px 20px rgba(242, 97, 36, 0.3);
        }
        
        .btn-nav-primary:hover {
            background: var(--tsa-gradient-reverse);
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(242, 97, 36, 0.4);
        }
        
        /* Mobile Toggle */
        .navbar-toggler {
            border: none;
            padding: 0.5rem;
            background: var(--tsa-light);
            border-radius: 10px;
        }
        
        .navbar-toggler:focus {
            box-shadow: none;
        }
        
        .navbar-toggler-icon {
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3E%3Cpath stroke='%23f26124' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3E%3C/svg%3E");
        }
        
        /* =========================================
           GLOBAL BUTTON STYLES
           ========================================= */
        .btn-primary {
            background: var(--tsa-gradient);
            border: none;
            font-weight: 600;
            padding: 0.75rem 1.75rem;
            border-radius: 50px;
            transition: all 0.3s ease;
            box-shadow: 0 5px 20px rgba(242, 97, 36, 0.3);
        }
        
        .btn-primary:hover {
            background: var(--tsa-gradient-reverse);
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(242, 97, 36, 0.4);
        }
        
        .btn-outline-primary {
            color: var(--tsa-primary);
            border: 2px solid var(--tsa-primary);
            font-weight: 600;
            padding: 0.75rem 1.75rem;
            border-radius: 50px;
            transition: all 0.3s ease;
            background: transparent;
        }
        
        .btn-outline-primary:hover {
            background: var(--tsa-primary);
            border-color: var(--tsa-primary);
            color: white;
            transform: translateY(-2px);
        }
        
        /* =========================================
           FLASH MESSAGES
           ========================================= */
        .flash-message {
            position: fixed;
            top: 120px;
            right: 20px;
            z-index: 9999;
            min-width: 320px;
            max-width: 450px;
            animation: slideInRight 0.4s ease-out;
        }
        
        @keyframes slideInRight {
            from {
                transform: translateX(400px);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }
        
        .flash-message .alert {
            border: none;
            border-radius: 15px;
            padding: 1rem 1.5rem;
            display: flex;
            align-items: center;
            gap: 1rem;
            box-shadow: 0 10px 40px rgba(0,0,0,0.15);
        }
        
        .flash-message .alert i {
            font-size: 1.25rem;
        }
        
        .flash-message .alert-success {
            background: linear-gradient(135deg, #d4edda, #c3e6cb);
            color: #155724;
        }
        
        .flash-message .alert-danger {
            background: linear-gradient(135deg, #f8d7da, #f5c6cb);
            color: #721c24;
        }
        
        .flash-message .alert-warning {
            background: linear-gradient(135deg, #fff3cd, #ffeeba);
            color: #856404;
        }
        
        .flash-message .alert-info {
            background: linear-gradient(135deg, #d1ecf1, #bee5eb);
            color: #0c5460;
        }
        
        /* =========================================
           FOOTER
           ========================================= */
        footer {
            background: var(--tsa-dark);
            color: white;
            padding-top: 0;
            margin-top: 0;
        }
        
        .footer-top {
            background: var(--tsa-gradient);
            padding: 3rem 0;
            margin-bottom: 3rem;
            position: relative;
            overflow: hidden;
        }
        
        .footer-top::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E") repeat;
        }
        
        .footer-cta {
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-wrap: wrap;
            gap: 2rem;
            position: relative;
            z-index: 1;
        }
        
        .footer-cta-content h3 {
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        
        .footer-cta-content p {
            opacity: 0.9;
            margin: 0;
        }
        
        .footer-cta-buttons {
            display: flex;
            gap: 1rem;
            flex-wrap: wrap;
        }
        
        .btn-footer {
            background: white;
            color: var(--tsa-primary);
            font-weight: 600;
            padding: 0.875rem 2rem;
            border-radius: 50px;
            text-decoration: none;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .btn-footer:hover {
            background: var(--tsa-cream);
            color: var(--tsa-primary-dark);
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
        }
        
        .btn-footer-outline {
            background: transparent;
            color: white;
            border: 2px solid white;
            font-weight: 600;
            padding: 0.875rem 2rem;
            border-radius: 50px;
            text-decoration: none;
            transition: all 0.3s ease;
        }
        
        .btn-footer-outline:hover {
            background: white;
            color: var(--tsa-primary);
        }
        
        .footer-main {
            padding: 3rem 0;
        }
        
        .footer-brand {
            margin-bottom: 1.5rem;
        }
        
        .footer-brand img {
            height: 50px;
            margin-bottom: 1rem;
        }
        
        .footer-brand p {
            color: rgba(255,255,255,0.7);
            font-size: 0.95rem;
            line-height: 1.7;
        }
        
        .footer-social {
            display: flex;
            gap: 0.75rem;
            margin-top: 1.5rem;
        }
        
        .footer-social a {
            width: 45px;
            height: 45px;
            background: rgba(255,255,255,0.1);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.1rem;
            transition: all 0.3s ease;
        }
        
        .footer-social a:hover {
            background: var(--tsa-primary);
            transform: translateY(-3px);
        }
        
        .footer-title {
            color: white;
            font-weight: 700;
            margin-bottom: 1.5rem;
            font-size: 1.1rem;
            position: relative;
            padding-bottom: 0.75rem;
        }
        
        .footer-title::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 40px;
            height: 3px;
            background: var(--tsa-gradient);
            border-radius: 3px;
        }
        
        .footer-links {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        
        .footer-links li {
            margin-bottom: 0.75rem;
        }
        
        .footer-links a {
            color: rgba(255,255,255,0.7);
            text-decoration: none;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .footer-links a::before {
            content: '';
            width: 6px;
            height: 6px;
            background: var(--tsa-primary);
            border-radius: 50%;
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .footer-links a:hover {
            color: white;
            transform: translateX(10px);
        }
        
        .footer-links a:hover::before {
            opacity: 1;
        }
        
        .footer-contact-item {
            display: flex;
            align-items: flex-start;
            gap: 1rem;
            margin-bottom: 1.25rem;
        }
        
        .footer-contact-icon {
            width: 40px;
            height: 40px;
            min-width: 40px;
            background: rgba(255,255,255,0.1);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--tsa-primary);
        }
        
        .footer-contact-content {
            display: flex;
            flex-direction: column;
        }
        
        .footer-contact-content span {
            color: rgba(255,255,255,0.5);
            font-size: 0.8rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .footer-contact-content a,
        .footer-contact-content p {
            color: rgba(255,255,255,0.9);
            text-decoration: none;
            margin: 0;
            transition: color 0.3s ease;
        }
        
        .footer-contact-content a:hover {
            color: var(--tsa-primary);
        }
        
        .footer-bottom {
            border-top: 1px solid rgba(255,255,255,0.1);
            padding: 1.5rem 0;
        }
        
        .footer-bottom-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 1rem;
        }
        
        .footer-copyright {
            color: rgba(255,255,255,0.6);
            font-size: 0.9rem;
        }
        
        .footer-legal {
            display: flex;
            gap: 1.5rem;
        }
        
        .footer-legal a {
            color: rgba(255,255,255,0.6);
            text-decoration: none;
            font-size: 0.9rem;
            transition: color 0.3s ease;
        }
        
        .footer-legal a:hover {
            color: var(--tsa-primary);
        }
        
        /* =========================================
           UTILITIES
           ========================================= */
        .text-primary {
            color: var(--tsa-primary) !important;
        }
        
        .bg-primary {
            background-color: var(--tsa-primary) !important;
        }
        
        .bg-light-primary {
            background-color: var(--tsa-light) !important;
        }
        
        /* =========================================
           RESPONSIVE
           ========================================= */
        @media (max-width: 991px) {
            .top-bar {
                display: none;
            }
            
            .navbar-brand img {
                height: 40px;
            }
            
            .brand-text {
                display: none;
            }
            
            .navbar-collapse {
                background: white;
                padding: 1rem;
                border-radius: 15px;
                margin-top: 1rem;
                box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            }
            
            .navbar-nav {
                gap: 0;
            }
            
            .nav-link::after {
                display: none;
            }
            
            .dropdown-menu {
                box-shadow: none;
                padding: 0.5rem 0 0.5rem 1rem;
                margin: 0;
            }
            
            .navbar-cta {
                margin: 1rem 0 0;
                flex-direction: column;
                width: 100%;
            }
            
            .navbar-cta .btn-nav-outline,
            .navbar-cta .btn-nav-primary {
                width: 100%;
                justify-content: center;
            }
            
            .footer-cta {
                text-align: center;
                justify-content: center;
            }
            
            .footer-cta-buttons {
                justify-content: center;
            }
            
            .footer-bottom-content {
                flex-direction: column;
                text-align: center;
            }
        }
        
        @media (max-width: 768px) {
            .flash-message {
                right: 10px;
                left: 10px;
                min-width: auto;
                max-width: none;
            }
            
            .footer-title::after {
                left: 50%;
                transform: translateX(-50%);
            }
            
            .footer-links a::before {
                display: none;
            }
            
            .footer-links a:hover {
                transform: none;
            }
        }
    </style>
</head>
<body>
    
    <!-- Top Bar -->
    <div class="top-bar">
        <div class="container">
            <div class="top-bar-content">
                <div class="top-bar-left">
                    <a href="mailto:<?php echo $site_settings['site_email'] ?? 'info@theskillsatelier.com'; ?>" class="top-bar-item">
                        <i class="fas fa-envelope"></i>
                        <span><?php echo $site_settings['site_email'] ?? 'info@theskillsatelier.com'; ?></span>
                    </a>
                    <a href="tel:<?php echo $site_settings['site_phone'] ?? '+233500557751'; ?>" class="top-bar-item">
                        <i class="fas fa-phone"></i>
                        <span><?php echo $site_settings['site_phone'] ?? '+233 50 055 7751'; ?></span>
                    </a>
                </div>
                <div class="top-bar-right">
                    <div class="top-bar-social">
                        <a href="<?php echo $site_settings['facebook_url'] ?? '#'; ?>" target="_blank" title="Facebook">
                            <i class="fab fa-facebook-f"></i>
                        </a>
                        <a href="<?php echo $site_settings['instagram_url'] ?? 'https://instagram.com/theskillsatelier'; ?>" target="_blank" title="Instagram">
                            <i class="fab fa-instagram"></i>
                        </a>
                        <a href="<?php echo $site_settings['twitter_url'] ?? '#'; ?>" target="_blank" title="Twitter">
                            <i class="fab fa-twitter"></i>
                        </a>
                        <a href="https://wa.me/233500557751" target="_blank" title="WhatsApp">
                            <i class="fab fa-whatsapp"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-light sticky-top" id="mainNavbar">
        <div class="container">
            <a class="navbar-brand" href="<?php echo base_url(); ?>">
                <img src="<?php echo base_url('assets/images/logo.png'); ?>" alt="The Skills Atelier Logo">
                
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <!-- Home -->
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($this->uri->segment(1) == '' || $this->uri->segment(1) == 'home') ? 'active' : ''; ?>" 
                           href="<?php echo base_url(); ?>">Home</a>
                    </li>
                    
                    <!-- About -->
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($this->uri->segment(1) == 'about') ? 'active' : ''; ?>" 
                           href="<?php echo base_url('about'); ?>">About</a>
                    </li>
                    
                    <!-- Workshops -->
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($this->uri->segment(1) == 'workshops') ? 'active' : ''; ?>" 
                           href="<?php echo base_url('workshops'); ?>">Workshops</a>
                    </li>
                    
                    <!-- Registration Dropdown -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle <?php echo ($this->uri->segment(1) == 'kid_registration' || $this->uri->segment(1) == 'adult_registration') ? 'active' : ''; ?>" 
                           href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            Registration
                        </a>
                        <ul class="dropdown-menu">
                            <li>
                                <a class="dropdown-item" href="<?php echo base_url('kid_registration'); ?>">
                                    <i class="fas fa-child"></i>
                                    <div class="dropdown-item-content">
                                        <span class="dropdown-item-title">Kids Registration</span>
                                        <span class="dropdown-item-desc">French Workshop for ages 6-12</span>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?php echo base_url('adult_registration'); ?>">
                                    <i class="fas fa-user-graduate"></i>
                                    <div class="dropdown-item-content">
                                        <span class="dropdown-item-title">Adult Registration</span>
                                        <span class="dropdown-item-desc">French Programme for adults</span>
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </li>
                    
                    <!-- Consultation -->
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($this->uri->segment(1) == 'consultation') ? 'active' : ''; ?>" 
                           href="<?php echo base_url('consultation'); ?>">Consultation</a>
                    </li>
                    
                    <!-- Media -->
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($this->uri->segment(1) == 'media') ? 'active' : ''; ?>" 
                           href="<?php echo base_url('media'); ?>">Media</a>
                    </li>
                    
                    <!-- Blog -->
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($this->uri->segment(1) == 'blog') ? 'active' : ''; ?>" 
                           href="<?php echo base_url('blog'); ?>">Blog</a>
                    </li>
                    
                    <!-- Contact -->
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($this->uri->segment(1) == 'contact') ? 'active' : ''; ?>" 
                           href="<?php echo base_url('contact'); ?>">Contact</a>
                    </li>
					
                    <!-- Volunteer -->
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($this->uri->segment(1) == 'volunteer') ? 'active' : ''; ?>" 
                           href="<?php echo base_url('volunteer/apply'); ?>">Volunteer</a>
                    </li>
					
                </ul>
                
                <!-- CTA Buttons -->
                <div class="navbar-cta">
                    
                    <a href="<?php echo base_url('donate'); ?>" class="btn-nav-primary">
                        <i class="fas fa-heart"></i> Donate
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Flash Messages -->
    <?php if ($this->session->flashdata('success')): ?>
        <div class="flash-message">
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle"></i>
                <span><?php echo $this->session->flashdata('success'); ?></span>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        </div>
    <?php endif; ?>
    
    <?php if ($this->session->flashdata('error')): ?>
        <div class="flash-message">
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle"></i>
                <span><?php echo $this->session->flashdata('error'); ?></span>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        </div>
    <?php endif; ?>
    
    <?php if ($this->session->flashdata('warning')): ?>
        <div class="flash-message">
            <div class="alert alert-warning alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-triangle"></i>
                <span><?php echo $this->session->flashdata('warning'); ?></span>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        </div>
    <?php endif; ?>
    
    <?php if ($this->session->flashdata('info')): ?>
        <div class="flash-message">
            <div class="alert alert-info alert-dismissible fade show" role="alert">
                <i class="fas fa-info-circle"></i>
                <span><?php echo $this->session->flashdata('info'); ?></span>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        </div>
    <?php endif; ?>

    <!-- Main Content -->
    <main>
        <?php echo $content_for_layout; ?>
    </main>

    <!-- Footer -->
    <footer>
        <!-- Footer CTA -->
        <div class="footer-top">
            <div class="container">
                <div class="footer-cta">
                    <div class="footer-cta-content">
                        <h3>Ready to Start Your Learning Journey?</h3>
                        <p>Join our community and discover the joy of learning new skills.</p>
                    </div>
                    <div class="footer-cta-buttons">
                        <a href="<?php echo base_url('kid_registration'); ?>" class="btn-footer">
                            <i class="fas fa-user-plus"></i> Register Now
                        </a>
                        <a href="<?php echo base_url('contact'); ?>" class="btn-footer-outline">
                            Contact Us
                        </a>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Footer Main -->
        <div class="footer-main">
            <div class="container">
                <div class="row">
                    <!-- Brand Column -->
                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="footer-brand">
                            <img src="<?php echo base_url('assets/images/logo2.png'); ?>" alt="The Skills Atelier">
                            <p><?php echo $site_settings['about_description'] ?? 'The Skills Atelier is transforming how language and vital skills are taught in Ghana, starting with children through immersive, fun learning experiences.'; ?></p>
                        </div>
                        <div class="footer-social">
                            <a href="<?php echo $site_settings['facebook_url'] ?? '#'; ?>" target="_blank" title="Facebook">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                            <a href="<?php echo $site_settings['instagram_url'] ?? 'https://instagram.com/theskillsatelier'; ?>" target="_blank" title="Instagram">
                                <i class="fab fa-instagram"></i>
                            </a>
                            <a href="<?php echo $site_settings['twitter_url'] ?? '#'; ?>" target="_blank" title="Twitter">
                                <i class="fab fa-twitter"></i>
                            </a>
                            <a href="<?php echo $site_settings['linkedin_url'] ?? '#'; ?>" target="_blank" title="LinkedIn">
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                            <a href="https://wa.me/233500557751" target="_blank" title="WhatsApp">
                                <i class="fab fa-whatsapp"></i>
                            </a>
                        </div>
                    </div>
                    
                    <!-- Quick Links -->
                    <div class="col-lg-2 col-md-6 mb-4">
                        <h5 class="footer-title">Quick Links</h5>
                        <ul class="footer-links">
                            <li><a href="<?php echo base_url(); ?>">Home</a></li>
                            <li><a href="<?php echo base_url('about'); ?>">About Us</a></li>
                            <li><a href="<?php echo base_url('workshops'); ?>">Workshops</a></li>
                            <li><a href="<?php echo base_url('blog'); ?>">Blog</a></li>
                            <li><a href="<?php echo base_url('media'); ?>">Media Gallery</a></li>
                            <li><a href="<?php echo base_url('volunteers'); ?>">Our Volunteers</a></li>
                        </ul>
                    </div>
                    
                    <!-- Programmes -->
                    <div class="col-lg-3 col-md-6 mb-4">
                        <h5 class="footer-title">Programmes</h5>
                        <ul class="footer-links">
                            <li><a href="<?php echo base_url('kid_registration'); ?>">Kids French Workshop</a></li>
                            <li><a href="<?php echo base_url('adult_registration'); ?>">Adult French Classes</a></li>
                            <li><a href="<?php echo base_url('consultation'); ?>">Free Consultation</a></li>
                            <li><a href="<?php echo base_url('volunteer/apply'); ?>">Become a Volunteer</a></li>
                            <li><a href="<?php echo base_url('donate'); ?>">Support Us</a></li>
                        </ul>
                    </div>
                    
                    <!-- Contact Info -->
                    <div class="col-lg-3 col-md-6 mb-4">
                        <h5 class="footer-title">Contact Us</h5>
                        
                        <div class="footer-contact-item">
                            <div class="footer-contact-icon">
                                <i class="fas fa-map-marker-alt"></i>
                            </div>
                            <div class="footer-contact-content">
                                <span>Location</span>
                                <p><?php echo $site_settings['site_address'] ?? 'East Legon, Accra, Ghana'; ?></p>
                            </div>
                        </div>
                        
                        <div class="footer-contact-item">
                            <div class="footer-contact-icon">
                                <i class="fas fa-envelope"></i>
                            </div>
                            <div class="footer-contact-content">
                                <span>Email</span>
                                <a href="mailto:<?php echo $site_settings['site_email'] ?? 'info@theskillsatelier.com'; ?>">
                                    <?php echo $site_settings['site_email'] ?? 'info@theskillsatelier.com'; ?>
                                </a>
                            </div>
                        </div>
                        
                        <div class="footer-contact-item">
                            <div class="footer-contact-icon">
                                <i class="fas fa-phone"></i>
                            </div>
                            <div class="footer-contact-content">
                                <span>Phone</span>
                                <a href="tel:<?php echo $site_settings['site_phone'] ?? '+233500557751'; ?>">
                                    <?php echo $site_settings['site_phone'] ?? '+233 50 055 7751'; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Footer Bottom -->
        <div class="footer-bottom">
            <div class="container">
                <div class="footer-bottom-content">
                    <p class="footer-copyright">
                        &copy; <?php echo date('Y'); ?> <?php echo $site_settings['site_name'] ?? 'The Skills Atelier'; ?>. All Rights Reserved.
                    </p>
                    <div class="footer-legal">
                        <a href="<?php echo base_url('privacy'); ?>">Privacy Policy</a>
                        <a href="<?php echo base_url('terms'); ?>">Terms & Conditions</a>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap 5 JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Auto-hide flash messages after 5 seconds
            setTimeout(function() {
                var alerts = document.querySelectorAll('.flash-message .alert');
                alerts.forEach(function(alert) {
                    var bsAlert = new bootstrap.Alert(alert);
                    bsAlert.close();
                });
            }, 5000);
            
            // Navbar scroll effect
            var navbar = document.getElementById('mainNavbar');
            window.addEventListener('scroll', function() {
                if (window.scrollY > 50) {
                    navbar.classList.add('scrolled');
                } else {
                    navbar.classList.remove('scrolled');
                }
            });
            
            // Dropdown hover effect for desktop with delay
            if (window.innerWidth >= 992) {
                var dropdowns = document.querySelectorAll('.nav-item.dropdown');
                var closeTimeout;
                
                dropdowns.forEach(function(dropdown) {
                    var dropdownMenu = dropdown.querySelector('.dropdown-menu');
                    var dropdownToggle = dropdown.querySelector('.dropdown-toggle');
                    
                    // Open dropdown on mouseenter
                    dropdown.addEventListener('mouseenter', function() {
                        // Clear any pending close timeout
                        if (closeTimeout) {
                            clearTimeout(closeTimeout);
                            closeTimeout = null;
                        }
                        
                        // Close other open dropdowns first
                        dropdowns.forEach(function(otherDropdown) {
                            if (otherDropdown !== dropdown) {
                                var otherMenu = otherDropdown.querySelector('.dropdown-menu');
                                var otherToggle = otherDropdown.querySelector('.dropdown-toggle');
                                otherMenu.classList.remove('show');
                                otherToggle.setAttribute('aria-expanded', 'false');
                            }
                        });
                        
                        // Open this dropdown
                        dropdownMenu.classList.add('show');
                        dropdownToggle.setAttribute('aria-expanded', 'true');
                    });
                    
                    // Close dropdown on mouseleave with delay
                    dropdown.addEventListener('mouseleave', function() {
                        var currentDropdown = this;
                        var currentMenu = dropdownMenu;
                        var currentToggle = dropdownToggle;
                        
                        // Add a 300ms delay before closing
                        closeTimeout = setTimeout(function() {
                            currentMenu.classList.remove('show');
                            currentToggle.setAttribute('aria-expanded', 'false');
                        }, 300);
                    });
                    
                    // Keep dropdown open when hovering over the menu itself
                    dropdownMenu.addEventListener('mouseenter', function() {
                        if (closeTimeout) {
                            clearTimeout(closeTimeout);
                            closeTimeout = null;
                        }
                    });
                    
                    dropdownMenu.addEventListener('mouseleave', function() {
                        var currentMenu = this;
                        var currentToggle = dropdownToggle;
                        
                        closeTimeout = setTimeout(function() {
                            currentMenu.classList.remove('show');
                            currentToggle.setAttribute('aria-expanded', 'false');
                        }, 300);
                    });
                });
            }
        });
    </script>
</body>
</html>