<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<?php 
// Construct full path for the file
$file_path = base_url('uploads/media/' . $media_item->file_path);

// Determine file extension for documents
$ext = pathinfo($media_item->file_path, PATHINFO_EXTENSION);
$icon_class = 'fa-file';
if($ext == 'pdf') $icon_class = 'fa-file-pdf';
elseif(in_array($ext, ['doc', 'docx'])) $icon_class = 'fa-file-word';
elseif(in_array($ext, ['xls', 'xlsx'])) $icon_class = 'fa-file-excel';
elseif(in_array($ext, ['ppt', 'pptx'])) $icon_class = 'fa-file-powerpoint';
?>

<!-- Media Hero Banner -->
<section class="media-hero">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <nav aria-label="breadcrumb" class="mb-3">
                    <ol class="breadcrumb breadcrumb-custom">
                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo base_url('media'); ?>">Media Gallery</a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?= htmlspecialchars($media_item->title) ?></li>
                    </ol>
                </nav>
                
                <!-- Type Badge -->
                <span class="type-badge-hero <?= $media_item->file_type ?>">
                    <?php if($media_item->file_type == 'image'): ?>
                        <i class="fas fa-image me-2"></i>Image
                    <?php elseif($media_item->file_type == 'video'): ?>
                        <i class="fas fa-video me-2"></i>Video
                    <?php else: ?>
                        <i class="fas fa-file me-2"></i>Document
                    <?php endif; ?>
                </span>
                
                <h1 class="display-6 fw-bold text-white mb-3"><?= htmlspecialchars($media_item->title) ?></h1>
                
                <div class="media-meta-hero">
                    <span class="meta-item">
                        <i class="fas fa-folder"></i>
                        <?= htmlspecialchars($media_item->category_name ?? 'Uncategorized') ?>
                    </span>
                    <span class="meta-divider">•</span>
                    <span class="meta-item">
                        <i class="fas fa-calendar"></i>
                        <?= date('F d, Y', strtotime($media_item->created_at)) ?>
                    </span>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Main Media Section -->
<section class="py-5 media-view-section">
    <div class="container">
        <div class="row">
            <!-- Media Content -->
            <div class="col-lg-8 mb-4">
                <!-- Media Display Card -->
                <div class="media-display-card">
                    <div class="media-container">
                        <?php if($media_item->file_type == 'image'): ?>
                            <div class="image-wrapper">
                                <img src="<?= $file_path ?>" 
                                     alt="<?= htmlspecialchars($media_item->title) ?>"
                                     id="mainImage">
                                <button class="btn-fullscreen" onclick="openFullscreen()">
                                    <i class="fas fa-expand"></i>
                                </button>
                            </div>
                        <?php elseif($media_item->file_type == 'video'): ?>
                            <div class="video-wrapper">
                                <video controls id="mainVideo">
                                    <source src="<?= $file_path ?>" type="video/mp4">
                                    Your browser does not support the video tag.
                                </video>
                            </div>
                        <?php else: ?>
                            <div class="document-wrapper">
                                <div class="document-icon">
                                    <i class="fas <?= $icon_class ?>"></i>
                                </div>
                                <div class="document-info">
                                    <h4><?= htmlspecialchars($media_item->title) ?></h4>
                                    <span class="doc-type"><?= strtoupper($ext) ?> Document</span>
                                </div>
                                <a href="<?= $file_path ?>" download class="btn btn-download-doc">
                                    <i class="fas fa-download me-2"></i>Download File
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Media Details Card -->
                <div class="media-details-card">
                    <div class="details-header">
                        <h3><?= htmlspecialchars($media_item->title) ?></h3>
                        <div class="details-meta">
                            <span class="category-tag">
                                <i class="fas fa-folder me-1"></i>
                                <?= htmlspecialchars($media_item->category_name ?? 'Uncategorized') ?>
                            </span>
                            <span class="type-tag <?= $media_item->file_type ?>">
                                <?= ucfirst($media_item->file_type) ?>
                            </span>
                            <span class="date-tag">
                                <i class="fas fa-calendar me-1"></i>
                                <?= date('M d, Y', strtotime($media_item->created_at)) ?>
                            </span>
                        </div>
                    </div>
                    
                    <?php if(!empty($media_item->description)): ?>
                        <div class="details-description">
                            <h5><i class="fas fa-align-left me-2"></i>Description</h5>
                            <p><?= nl2br(htmlspecialchars($media_item->description)) ?></p>
                        </div>
                    <?php endif; ?>
                    
                    <?php if(!empty($media_item->tags)): ?>
                        <div class="details-tags">
                            <h5><i class="fas fa-tags me-2"></i>Tags</h5>
                            <div class="tags-list">
                                <?php $tags = explode(',', $media_item->tags); ?>
                                <?php foreach($tags as $tag): ?>
                                    <a href="<?php echo base_url('media?tag=' . urlencode(trim($tag))); ?>" class="tag-pill">
                                        <?= trim(htmlspecialchars($tag)) ?>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Action Buttons -->
                    <div class="details-actions">
                        <a href="<?php echo base_url('media'); ?>" class="btn btn-back">
                            <i class="fas fa-arrow-left me-2"></i>Back to Gallery
                        </a>
                        <?php if($media_item->file_type != 'document'): ?>
                            <a href="<?= $file_path ?>" class="btn btn-download" download>
                                <i class="fas fa-download me-2"></i>Download
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Share Section -->
                <div class="share-card">
                    <h5><i class="fas fa-share-alt me-2"></i>Share This</h5>
                    <div class="share-buttons">
                        <a href="https://www.facebook.com/sharer/sharer.php?u=<?= urlencode(current_url()) ?>" 
                           target="_blank" class="share-btn facebook">
                            <i class="fab fa-facebook-f"></i>
                        </a>
                        <a href="https://twitter.com/intent/tweet?url=<?= urlencode(current_url()) ?>&text=<?= urlencode($media_item->title) ?>" 
                           target="_blank" class="share-btn twitter">
                            <i class="fab fa-twitter"></i>
                        </a>
                        <a href="https://wa.me/?text=<?= urlencode($media_item->title . ' - ' . current_url()) ?>" 
                           target="_blank" class="share-btn whatsapp">
                            <i class="fab fa-whatsapp"></i>
                        </a>
                        <button class="share-btn copy" onclick="copyLink()">
                            <i class="fas fa-link"></i>
                        </button>
                    </div>
                </div>
            </div>
            
            <!-- Sidebar -->
            <div class="col-lg-4">
                <aside class="sidebar">
                    <!-- Media Info Widget -->
                    <div class="sidebar-widget info-widget">
                        <h5 class="widget-title"><i class="fas fa-info-circle me-2"></i>Media Info</h5>
                        <div class="info-list">
                            <div class="info-item">
                                <span class="info-label">Type</span>
                                <span class="info-value"><?= ucfirst($media_item->file_type) ?></span>
                            </div>
                            <div class="info-item">
                                <span class="info-label">Category</span>
                                <span class="info-value"><?= htmlspecialchars($media_item->category_name ?? 'Uncategorized') ?></span>
                            </div>
                            <div class="info-item">
                                <span class="info-label">Uploaded</span>
                                <span class="info-value"><?= date('M d, Y', strtotime($media_item->created_at)) ?></span>
                            </div>
                            <?php if($media_item->file_type != 'document'): ?>
                            <div class="info-item">
                                <span class="info-label">Format</span>
                                <span class="info-value"><?= strtoupper($ext) ?></span>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <!-- Quick Actions Widget -->
                    <div class="sidebar-widget actions-widget">
                        <h5 class="widget-title"><i class="fas fa-bolt me-2"></i>Quick Actions</h5>
                        <div class="quick-actions">
                            <a href="<?php echo base_url('media'); ?>" class="action-btn">
                                <i class="fas fa-th-large"></i>
                                <span>View Gallery</span>
                            </a>
                            <a href="<?php echo base_url('media?category=' . ($media_item->category_id ?? '')); ?>" class="action-btn">
                                <i class="fas fa-folder"></i>
                                <span>More in Category</span>
                            </a>
                            <?php if($media_item->file_type != 'document'): ?>
                            <a href="<?= $file_path ?>" download class="action-btn">
                                <i class="fas fa-download"></i>
                                <span>Download</span>
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <!-- CTA Widget -->
                    <div class="sidebar-widget cta-widget">
                        <div class="cta-icon">
                            <i class="fas fa-camera"></i>
                        </div>
                        <h5>Want More Photos?</h5>
                        <p>Follow us on Instagram for daily updates and behind-the-scenes content!</p>
                        <a href="https://instagram.com/theskillsatelier" target="_blank" class="btn btn-instagram">
                            <i class="fab fa-instagram me-2"></i>@theskillsatelier
                        </a>
                    </div>
                </aside>
            </div>
        </div>
        
        <!-- Related Media Section -->
        <?php if(!empty($related_media)): ?>
        <div class="related-section">
            <div class="section-header">
                <h3><i class="fas fa-images me-2"></i>Related Media</h3>
                <a href="<?php echo base_url('media?category=' . ($media_item->category_id ?? '')); ?>" class="view-all">
                    View All <i class="fas fa-arrow-right ms-1"></i>
                </a>
            </div>
            
            <div class="related-grid">
                <?php foreach($related_media as $related): ?>
                    <?php $related_path = base_url('uploads/media/' . $related->file_path); ?>
                    <a href="<?= site_url('media/view/' . $related->id) ?>" class="related-card">
                        <div class="related-thumbnail">
                            <?php if($related->file_type == 'image'): ?>
                                <img src="<?= $related_path ?>" alt="<?= htmlspecialchars($related->title) ?>">
                            <?php elseif($related->file_type == 'video'): ?>
                                <video>
                                    <source src="<?= $related_path ?>" type="video/mp4">
                                </video>
                                <div class="play-overlay">
                                    <i class="fas fa-play"></i>
                                </div>
                            <?php else: ?>
                                <?php 
                                $rel_ext = pathinfo($related->file_path, PATHINFO_EXTENSION);
                                $rel_icon = 'fa-file';
                                if($rel_ext == 'pdf') $rel_icon = 'fa-file-pdf';
                                elseif(in_array($rel_ext, ['doc', 'docx'])) $rel_icon = 'fa-file-word';
                                ?>
                                <div class="doc-thumbnail">
                                    <i class="fas <?= $rel_icon ?>"></i>
                                </div>
                            <?php endif; ?>
                            
                            <span class="related-type-badge <?= $related->file_type ?>">
                                <?php if($related->file_type == 'image'): ?>
                                    <i class="fas fa-image"></i>
                                <?php elseif($related->file_type == 'video'): ?>
                                    <i class="fas fa-video"></i>
                                <?php else: ?>
                                    <i class="fas fa-file"></i>
                                <?php endif; ?>
                            </span>
                        </div>
                        <div class="related-info">
                            <h6><?= htmlspecialchars($related->title) ?></h6>
                        </div>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</section>

<!-- Fullscreen Lightbox -->
<div class="lightbox" id="lightbox">
    <button class="lightbox-close" onclick="closeFullscreen()">
        <i class="fas fa-times"></i>
    </button>
    <div class="lightbox-content">
        <img id="lightbox-image" src="<?= $file_path ?>" alt="<?= htmlspecialchars($media_item->title) ?>">
    </div>
</div>

<!-- Copy Toast -->
<div class="copy-toast" id="copyToast">
    <i class="fas fa-check-circle"></i>
    <span>Link copied to clipboard!</span>
</div>

<style>
/* =========================================
   THE SKILLS ATELIER - MEDIA VIEW STYLES
   Primary: #f26124 (Orange)
   Secondary: #8105bf (Purple)
   ========================================= */

:root {
    --tsa-primary: #f26124;
    --tsa-primary-dark: #d94f15;
    --tsa-secondary: #8105bf;
    --tsa-secondary-dark: #6a049e;
    --tsa-light: #fff8f5;
    --tsa-cream: #f7e1b0;
    --tsa-gradient: linear-gradient(135deg, #f26124, #8105bf);
    --tsa-gradient-reverse: linear-gradient(135deg, #8105bf, #f26124);
}

/* =========================================
   MEDIA HERO
   ========================================= */
.media-hero {
    background: var(--tsa-gradient);
    padding: 100px 0 60px;
    position: relative;
    overflow: hidden;
}

.media-hero::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E") repeat;
}

.breadcrumb-custom {
    background: transparent;
    padding: 0;
    margin: 0;
}

.breadcrumb-custom .breadcrumb-item a {
    color: rgba(255,255,255,0.7);
    text-decoration: none;
    transition: color 0.3s ease;
}

.breadcrumb-custom .breadcrumb-item a:hover {
    color: white;
}

.breadcrumb-custom .breadcrumb-item.active {
    color: white;
    max-width: 200px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.breadcrumb-custom .breadcrumb-item + .breadcrumb-item::before {
    color: rgba(255,255,255,0.5);
}

.type-badge-hero {
    display: inline-flex;
    align-items: center;
    padding: 0.5rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    margin-bottom: 1rem;
}

.type-badge-hero.image {
    background: rgba(242, 97, 36, 0.3);
    color: white;
}

.type-badge-hero.video {
    background: rgba(231, 76, 60, 0.3);
    color: white;
}

.type-badge-hero.document {
    background: rgba(129, 5, 191, 0.3);
    color: white;
}

.media-meta-hero {
    display: flex;
    align-items: center;
    gap: 1rem;
    flex-wrap: wrap;
}

.meta-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    color: rgba(255,255,255,0.8);
    font-size: 0.95rem;
}

.meta-item i {
    font-size: 0.85rem;
}

.meta-divider {
    color: rgba(255,255,255,0.4);
}

/* =========================================
   MEDIA VIEW SECTION
   ========================================= */
.media-view-section {
    background: linear-gradient(180deg, #fff 0%, var(--tsa-light) 100%);
}

/* Media Display Card */
.media-display-card {
    background: white;
    border-radius: 25px;
    box-shadow: 0 20px 60px rgba(0,0,0,0.1);
    overflow: hidden;
    margin-bottom: 2rem;
}

.media-container {
    position: relative;
}

/* Image Wrapper */
.image-wrapper {
    position: relative;
}

.image-wrapper img {
    width: 100%;
    max-height: 500px;
    object-fit: contain;
    background: #f8f9fa;
}

.btn-fullscreen {
    position: absolute;
    bottom: 1rem;
    right: 1rem;
    width: 50px;
    height: 50px;
    background: rgba(0,0,0,0.6);
    border: none;
    border-radius: 12px;
    color: white;
    font-size: 1.2rem;
    cursor: pointer;
    transition: all 0.3s ease;
    backdrop-filter: blur(10px);
}

.btn-fullscreen:hover {
    background: var(--tsa-primary);
    transform: scale(1.1);
}

/* Video Wrapper */
.video-wrapper video {
    width: 100%;
    max-height: 500px;
    background: #000;
}

/* Document Wrapper */
.document-wrapper {
    padding: 4rem 2rem;
    text-align: center;
    background: linear-gradient(135deg, #f8f9fa, #e9ecef);
}

.document-icon {
    width: 120px;
    height: 120px;
    background: var(--tsa-gradient);
    border-radius: 30px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1.5rem;
    font-size: 3rem;
    color: white;
    box-shadow: 0 15px 40px rgba(242, 97, 36, 0.3);
}

.document-info h4 {
    font-weight: 700;
    color: #333;
    margin-bottom: 0.5rem;
}

.doc-type {
    color: #888;
    font-size: 0.9rem;
    display: block;
    margin-bottom: 1.5rem;
}

.btn-download-doc {
    background: var(--tsa-gradient);
    color: white;
    font-weight: 600;
    padding: 1rem 2rem;
    border-radius: 50px;
    border: none;
    transition: all 0.3s ease;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
}

.btn-download-doc:hover {
    background: var(--tsa-gradient-reverse);
    color: white;
    transform: translateY(-3px);
    box-shadow: 0 10px 30px rgba(242, 97, 36, 0.4);
}

/* Media Details Card */
.media-details-card {
    background: white;
    border-radius: 25px;
    box-shadow: 0 10px 40px rgba(0,0,0,0.08);
    padding: 2rem;
    margin-bottom: 1.5rem;
}

.details-header {
    padding-bottom: 1.5rem;
    border-bottom: 2px solid #f0f0f0;
    margin-bottom: 1.5rem;
}

.details-header h3 {
    font-weight: 700;
    color: #333;
    margin-bottom: 1rem;
}

.details-meta {
    display: flex;
    align-items: center;
    gap: 1rem;
    flex-wrap: wrap;
}

.category-tag {
    display: inline-flex;
    align-items: center;
    background: var(--tsa-light);
    color: var(--tsa-primary);
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 500;
}

.type-tag {
    display: inline-block;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    color: white;
}

.type-tag.image { background: var(--tsa-primary); }
.type-tag.video { background: #e74c3c; }
.type-tag.document { background: var(--tsa-secondary); }

.date-tag {
    color: #888;
    font-size: 0.85rem;
}

.details-description {
    margin-bottom: 1.5rem;
}

.details-description h5,
.details-tags h5 {
    font-weight: 700;
    color: #333;
    margin-bottom: 0.75rem;
    font-size: 1rem;
}

.details-description p {
    color: #555;
    line-height: 1.8;
}

.details-tags {
    margin-bottom: 1.5rem;
}

.tags-list {
    display: flex;
    flex-wrap: wrap;
    gap: 0.5rem;
}

.tag-pill {
    display: inline-block;
    background: #f8f9fa;
    color: var(--tsa-secondary);
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 500;
    text-decoration: none;
    transition: all 0.3s ease;
}

.tag-pill:hover {
    background: var(--tsa-secondary);
    color: white;
}

.details-actions {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
    padding-top: 1.5rem;
    border-top: 2px solid #f0f0f0;
}

.btn-back {
    background: white;
    color: var(--tsa-primary);
    font-weight: 600;
    padding: 0.875rem 1.5rem;
    border-radius: 50px;
    border: 2px solid var(--tsa-primary);
    transition: all 0.3s ease;
    text-decoration: none;
}

.btn-back:hover {
    background: var(--tsa-primary);
    color: white;
}

.btn-download {
    background: var(--tsa-gradient);
    color: white;
    font-weight: 600;
    padding: 0.875rem 1.5rem;
    border-radius: 50px;
    border: none;
    transition: all 0.3s ease;
    text-decoration: none;
}

.btn-download:hover {
    background: var(--tsa-gradient-reverse);
    color: white;
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(242, 97, 36, 0.3);
}

/* Share Card */
.share-card {
    background: white;
    border-radius: 20px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
    padding: 1.5rem;
}

.share-card h5 {
    font-weight: 700;
    color: #333;
    margin-bottom: 1rem;
}

.share-buttons {
    display: flex;
    gap: 0.75rem;
}

.share-btn {
    width: 50px;
    height: 50px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.2rem;
    text-decoration: none;
    border: none;
    cursor: pointer;
    transition: all 0.3s ease;
}

.share-btn:hover {
    transform: translateY(-3px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.2);
}

.share-btn.facebook { background: #1877f2; }
.share-btn.twitter { background: #1da1f2; }
.share-btn.whatsapp { background: #25D366; }
.share-btn.copy { background: var(--tsa-gradient); }

/* =========================================
   SIDEBAR
   ========================================= */
.sidebar {
    position: sticky;
    top: 100px;
}

.sidebar-widget {
    background: white;
    border-radius: 20px;
    padding: 1.5rem;
    margin-bottom: 1.5rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
}

.widget-title {
    font-weight: 700;
    color: #333;
    margin-bottom: 1rem;
    padding-bottom: 0.75rem;
    border-bottom: 2px solid #f0f0f0;
}

/* Info Widget */
.info-list {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.info-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0.75rem;
    background: #f8f9fa;
    border-radius: 10px;
}

.info-label {
    color: #888;
    font-size: 0.85rem;
}

.info-value {
    font-weight: 600;
    color: #333;
}

/* Actions Widget */
.quick-actions {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.action-btn {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem;
    background: #f8f9fa;
    border-radius: 12px;
    text-decoration: none;
    transition: all 0.3s ease;
}

.action-btn:hover {
    background: var(--tsa-light);
    transform: translateX(5px);
}

.action-btn i {
    width: 40px;
    height: 40px;
    background: var(--tsa-gradient);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1rem;
}

.action-btn span {
    color: #333;
    font-weight: 600;
}

/* CTA Widget */
.cta-widget {
    background: linear-gradient(135deg, #833ab4, #fd1d1d, #fcb045);
    text-align: center;
    padding: 2rem;
}

.cta-icon {
    width: 60px;
    height: 60px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
    font-size: 1.5rem;
    color: white;
}

.cta-widget h5 {
    color: white;
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.cta-widget p {
    color: rgba(255,255,255,0.9);
    font-size: 0.9rem;
    margin-bottom: 1rem;
}

.btn-instagram {
    background: white;
    color: #833ab4;
    font-weight: 600;
    padding: 0.875rem 1.5rem;
    border-radius: 50px;
    border: none;
    transition: all 0.3s ease;
    text-decoration: none;
    display: inline-block;
}

.btn-instagram:hover {
    background: rgba(255,255,255,0.9);
    color: #833ab4;
    transform: translateY(-2px);
}

/* =========================================
   RELATED MEDIA SECTION
   ========================================= */
.related-section {
    margin-top: 3rem;
}

.section-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1.5rem;
}

.section-header h3 {
    font-weight: 700;
    color: #333;
    margin: 0;
}

.view-all {
    color: var(--tsa-primary);
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s ease;
}

.view-all:hover {
    color: var(--tsa-secondary);
}

.related-grid {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 1.5rem;
}

.related-card {
    background: white;
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
    text-decoration: none;
    transition: all 0.3s ease;
}

.related-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 40px rgba(0,0,0,0.15);
}

.related-thumbnail {
    position: relative;
    height: 150px;
    overflow: hidden;
}

.related-thumbnail img,
.related-thumbnail video {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.3s ease;
}

.related-card:hover .related-thumbnail img,
.related-card:hover .related-thumbnail video {
    transform: scale(1.1);
}

.doc-thumbnail {
    width: 100%;
    height: 100%;
    background: linear-gradient(135deg, #f8f9fa, #e9ecef);
    display: flex;
    align-items: center;
    justify-content: center;
}

.doc-thumbnail i {
    font-size: 2.5rem;
    color: var(--tsa-secondary);
}

.play-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0,0,0,0.4);
    display: flex;
    align-items: center;
    justify-content: center;
}

.play-overlay i {
    width: 40px;
    height: 40px;
    background: var(--tsa-primary);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 0.9rem;
    padding-left: 3px;
}

.related-type-badge {
    position: absolute;
    top: 0.75rem;
    left: 0.75rem;
    width: 30px;
    height: 30px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 0.8rem;
}

.related-type-badge.image { background: var(--tsa-primary); }
.related-type-badge.video { background: #e74c3c; }
.related-type-badge.document { background: var(--tsa-secondary); }

.related-info {
    padding: 1rem;
}

.related-info h6 {
    font-weight: 600;
    color: #333;
    margin: 0;
    font-size: 0.9rem;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

/* =========================================
   LIGHTBOX
   ========================================= */
.lightbox {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0,0,0,0.95);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 9999;
    opacity: 0;
    visibility: hidden;
    transition: all 0.3s ease;
}

.lightbox.active {
    opacity: 1;
    visibility: visible;
}

.lightbox-close {
    position: absolute;
    top: 2rem;
    right: 2rem;
    width: 50px;
    height: 50px;
    background: rgba(255,255,255,0.1);
    border: none;
    border-radius: 50%;
    color: white;
    font-size: 1.5rem;
    cursor: pointer;
    transition: all 0.3s ease;
}

.lightbox-close:hover {
    background: var(--tsa-primary);
    transform: rotate(90deg);
}

.lightbox-content img {
    max-width: 90%;
    max-height: 90vh;
    border-radius: 10px;
    box-shadow: 0 20px 60px rgba(0,0,0,0.5);
}

/* =========================================
   COPY TOAST
   ========================================= */
.copy-toast {
    position: fixed;
    bottom: 30px;
    left: 50%;
    transform: translateX(-50%) translateY(100px);
    background: #333;
    color: white;
    padding: 1rem 2rem;
    border-radius: 50px;
    display: flex;
    align-items: center;
    gap: 0.75rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.3);
    z-index: 9999;
    opacity: 0;
    transition: all 0.3s ease;
}

.copy-toast.show {
    transform: translateX(-50%) translateY(0);
    opacity: 1;
}

.copy-toast i {
    color: #28a745;
    font-size: 1.2rem;
}

/* =========================================
   RESPONSIVE STYLES
   ========================================= */
@media (max-width: 991px) {
    .media-hero {
        padding: 80px 0 50px;
    }
    
    .media-hero h1 {
        font-size: 1.75rem;
    }
    
    .sidebar {
        position: relative;
        top: 0;
        margin-top: 2rem;
    }
    
    .related-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 768px) {
    .media-hero {
        padding: 70px 0 40px;
    }
    
    .media-hero h1 {
        font-size: 1.5rem;
    }
    
    .media-details-card {
        padding: 1.5rem;
    }
    
    .details-actions {
        flex-direction: column;
    }
    
    .details-actions .btn {
        width: 100%;
        text-align: center;
        justify-content: center;
    }
    
    .related-grid {
        grid-template-columns: 1fr;
    }
    
    .section-header {
        flex-direction: column;
        gap: 1rem;
        text-align: center;
    }
}
</style>

<script>
// Fullscreen lightbox
function openFullscreen() {
    document.getElementById('lightbox').classList.add('active');
    document.body.style.overflow = 'hidden';
}

function closeFullscreen() {
    document.getElementById('lightbox').classList.remove('active');
    document.body.style.overflow = '';
}

// Close on escape key
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeFullscreen();
    }
});

// Close on background click
document.getElementById('lightbox').addEventListener('click', function(e) {
    if (e.target === this) {
        closeFullscreen();
    }
});

// Copy link function
function copyLink() {
    var url = window.location.href;
    
    if (navigator.clipboard && navigator.clipboard.writeText) {
        navigator.clipboard.writeText(url).then(function() {
            showCopyToast();
        }).catch(function() {
            fallbackCopy(url);
        });
    } else {
        fallbackCopy(url);
    }
}

function fallbackCopy(text) {
    var textArea = document.createElement('textarea');
    textArea.value = text;
    textArea.style.position = 'fixed';
    textArea.style.left = '-9999px';
    document.body.appendChild(textArea);
    textArea.select();
    try {
        document.execCommand('copy');
        showCopyToast();
    } catch (err) {
        console.error('Copy failed', err);
    }
    document.body.removeChild(textArea);
}

function showCopyToast() {
    var toast = document.getElementById('copyToast');
    toast.classList.add('show');
    setTimeout(function() {
        toast.classList.remove('show');
    }, 2500);
}
</script>