<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Media Hero Banner -->
<section class="media-hero">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <nav aria-label="breadcrumb" class="mb-3">
                    <ol class="breadcrumb breadcrumb-custom">
                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Media Gallery</li>
                    </ol>
                </nav>
                <span class="section-badge mb-3">
                    <i class="fas fa-photo-video me-2"></i>Our Gallery
                </span>
                <h1 class="display-5 fw-bold text-white mb-3">Media Gallery</h1>
                <p class="lead text-white-50 mb-0">Explore photos, videos, and documents from our workshops, events, and community activities.</p>
            </div>
            <div class="col-lg-4 text-lg-end mt-4 mt-lg-0">
                <div class="media-stats">
                    <div class="stat-pill">
                        <i class="fas fa-images"></i>
                        <span><?php echo count($media_items ?? []); ?> Items</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Main Media Section -->
<section class="py-5 media-section">
    <div class="container">
        <div class="row">
            <!-- Sidebar Filters -->
            <div class="col-lg-3 mb-4">
                <aside class="filter-sidebar">
                    <!-- Filter Card -->
                    <div class="filter-card">
                        <div class="filter-header">
                            <div class="filter-icon">
                                <i class="fas fa-filter"></i>
                            </div>
                            <h5>Filter Media</h5>
                        </div>
                        
                        <?= form_open('media', ['method' => 'get', 'class' => 'filter-form']) ?>
                            <!-- Category Filter -->
                            <div class="filter-group">
                                <label class="filter-label">
                                    <i class="fas fa-folder me-2"></i>Category
                                </label>
                                <div class="select-wrapper">
                                    <select name="category" class="form-control">
                                        <option value="">All Categories</option>
                                        <?php foreach($categories as $category): ?>
                                            <option value="<?= $category->id ?>" 
                                                <?= $selected_category == $category->id ? 'selected' : '' ?>>
                                                <?= $category->name ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>

                            <!-- Type Filter -->
                            <div class="filter-group">
                                <label class="filter-label">
                                    <i class="fas fa-file-alt me-2"></i>Media Type
                                </label>
                                <div class="type-options">
                                    <label class="type-option">
                                        <input type="radio" name="type" value="" <?= empty($selected_type) ? 'checked' : '' ?>>
                                        <span class="type-card">
                                            <i class="fas fa-th-large"></i>
                                            <span>All</span>
                                        </span>
                                    </label>
                                    <label class="type-option">
                                        <input type="radio" name="type" value="image" <?= $selected_type == 'image' ? 'checked' : '' ?>>
                                        <span class="type-card">
                                            <i class="fas fa-image"></i>
                                            <span>Images</span>
                                        </span>
                                    </label>
                                    <label class="type-option">
                                        <input type="radio" name="type" value="video" <?= $selected_type == 'video' ? 'checked' : '' ?>>
                                        <span class="type-card">
                                            <i class="fas fa-video"></i>
                                            <span>Videos</span>
                                        </span>
                                    </label>
                                    <label class="type-option">
                                        <input type="radio" name="type" value="document" <?= $selected_type == 'document' ? 'checked' : '' ?>>
                                        <span class="type-card">
                                            <i class="fas fa-file-pdf"></i>
                                            <span>Docs</span>
                                        </span>
                                    </label>
                                </div>
                            </div>

                            <button type="submit" class="btn btn-filter">
                                <i class="fas fa-search me-2"></i>Apply Filters
                            </button>
                            
                            <?php if(!empty($selected_category) || !empty($selected_type)): ?>
                                <a href="<?php echo base_url('media'); ?>" class="btn btn-clear">
                                    <i class="fas fa-times me-2"></i>Clear Filters
                                </a>
                            <?php endif; ?>
                        <?= form_close() ?>
                    </div>
                    
                    <!-- Categories Quick Links -->
                    <div class="sidebar-widget categories-widget">
                        <h5 class="widget-title"><i class="fas fa-tags me-2"></i>Categories</h5>
                        <div class="category-list">
                            <?php if(!empty($categories)): ?>
                                <?php foreach($categories as $category): ?>
                                    <a href="<?php echo base_url('media?category=' . $category->id); ?>" 
                                       class="category-link <?php echo $selected_category == $category->id ? 'active' : ''; ?>">
                                        <span class="category-name"><?= $category->name ?></span>
                                        <span class="category-count"><?= $category->media_count ?? 0 ?></span>
                                    </a>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <p class="text-muted small">No categories available</p>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <!-- Follow Us Widget -->
                    <div class="sidebar-widget social-widget">
                        <h5 class="widget-title"><i class="fas fa-share-alt me-2"></i>Follow Us</h5>
                        <p class="social-text">See more of our activities on social media</p>
                        <div class="social-links">
                            <a href="https://instagram.com/theskillsatelier" target="_blank" class="social-link instagram">
                                <i class="fab fa-instagram"></i>
                            </a>
                            <a href="https://web.facebook.com/p/The-skills-Atelier-61577905511642/?_rdc=1&_rdr#" class="social-link facebook">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                            <a href="#" class="social-link youtube">
                                <i class="fab fa-youtube"></i>
                            </a>
                        </div>
                    </div>
                </aside>
            </div>

            <!-- Media Grid -->
            <div class="col-lg-9">
                <?php if(!empty($selected_category) || !empty($selected_type)): ?>
                    <div class="active-filters mb-4">
                        <span class="filters-label">Active Filters:</span>
                        <?php if(!empty($selected_category)): ?>
                            <?php 
                            $cat_name = '';
                            foreach($categories as $cat) {
                                if($cat->id == $selected_category) {
                                    $cat_name = $cat->name;
                                    break;
                                }
                            }
                            ?>
                            <span class="filter-tag">
                                <i class="fas fa-folder me-1"></i><?= $cat_name ?>
                                <a href="<?php echo base_url('media' . (!empty($selected_type) ? '?type=' . $selected_type : '')); ?>">
                                    <i class="fas fa-times"></i>
                                </a>
                            </span>
                        <?php endif; ?>
                        <?php if(!empty($selected_type)): ?>
                            <span class="filter-tag">
                                <i class="fas fa-file me-1"></i><?= ucfirst($selected_type) ?>s
                                <a href="<?php echo base_url('media' . (!empty($selected_category) ? '?category=' . $selected_category : '')); ?>">
                                    <i class="fas fa-times"></i>
                                </a>
                            </span>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
                
                <?php if(empty($media_items)): ?>
                    <!-- Empty State -->
                    <div class="empty-state">
                        <div class="empty-icon">
                            <i class="fas fa-photo-video"></i>
                        </div>
                        <h3>No Media Found</h3>
                        <p>We couldn't find any media items matching your criteria.</p>
                        <div class="empty-actions">
                            <a href="<?php echo base_url('media'); ?>" class="btn btn-primary-custom">
                                <i class="fas fa-th-large me-2"></i>View All Media
                            </a>
                            <a href="<?php echo base_url(); ?>" class="btn btn-outline-custom">
                                <i class="fas fa-home me-2"></i>Go Home
                            </a>
                        </div>
                    </div>
                <?php else: ?>
                    <!-- Media Grid -->
                    <div class="media-grid">
                        <?php foreach($media_items as $index => $media): ?>
                            <?php 
                            // Construct full path for the file
                            $file_path = base_url('uploads/media/' . $media->file_path);
                            ?>
                            <div class="media-card" style="animation-delay: <?= $index * 0.1 ?>s;">
                                <div class="media-thumbnail">
                                    <?php if($media->file_type == 'image'): ?>
                                        <img src="<?= $file_path ?>" alt="<?= htmlspecialchars($media->title) ?>">
                                        <div class="media-overlay">
                                            <button class="btn-preview" onclick="openLightbox('<?= $file_path ?>', '<?= htmlspecialchars($media->title) ?>')">
                                                <i class="fas fa-expand"></i>
                                            </button>
                                        </div>
                                    <?php elseif($media->file_type == 'video'): ?>
                                        <video>
                                            <source src="<?= $file_path ?>" type="video/mp4">
                                        </video>
                                        <div class="media-overlay video">
                                            <div class="play-button">
                                                <i class="fas fa-play"></i>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <div class="document-preview">
                                            <?php 
                                            $ext = pathinfo($media->file_path, PATHINFO_EXTENSION);
                                            $icon_class = 'fa-file';
                                            if($ext == 'pdf') $icon_class = 'fa-file-pdf';
                                            elseif(in_array($ext, ['doc', 'docx'])) $icon_class = 'fa-file-word';
                                            elseif(in_array($ext, ['xls', 'xlsx'])) $icon_class = 'fa-file-excel';
                                            elseif(in_array($ext, ['ppt', 'pptx'])) $icon_class = 'fa-file-powerpoint';
                                            ?>
                                            <i class="fas <?= $icon_class ?>"></i>
                                            <span class="doc-ext"><?= strtoupper($ext) ?></span>
                                        </div>
                                        <div class="media-overlay document">
                                            <button class="btn-download">
                                                <i class="fas fa-download"></i>
                                            </button>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <!-- Type Badge -->
                                    <span class="type-badge <?= $media->file_type ?>">
                                        <?php if($media->file_type == 'image'): ?>
                                            <i class="fas fa-image"></i>
                                        <?php elseif($media->file_type == 'video'): ?>
                                            <i class="fas fa-video"></i>
                                        <?php else: ?>
                                            <i class="fas fa-file"></i>
                                        <?php endif; ?>
                                    </span>
                                </div>
                                
                                <div class="media-info">
                                    <h5 class="media-title"><?= htmlspecialchars($media->title) ?></h5>
                                    <div class="media-meta">
                                        <span class="meta-category">
                                            <i class="fas fa-folder"></i>
                                            <?= htmlspecialchars($media->category_name ?? 'Uncategorized') ?>
                                        </span>
                                        <span class="meta-type">
                                            <?= ucfirst($media->file_type) ?>
                                        </span>
                                    </div>
                                    <a href="<?= site_url('media/view/' . $media->id) ?>" class="btn btn-view">
                                        <span>View Details</span>
                                        <i class="fas fa-arrow-right"></i>
                                    </a>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    
                    <!-- Pagination would go here if needed -->
                    
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<!-- Lightbox Modal -->
<div class="lightbox" id="lightbox">
    <button class="lightbox-close" onclick="closeLightbox()">
        <i class="fas fa-times"></i>
    </button>
    <div class="lightbox-content">
        <img id="lightbox-image" src="" alt="">
        <p id="lightbox-caption"></p>
    </div>
</div>

<style>
/* =========================================
   THE SKILLS ATELIER - MEDIA GALLERY STYLES
   Primary: #f26124 (Orange)
   Secondary: #8105bf (Purple)
   ========================================= */

:root {
    --tsa-primary: #f26124;
    --tsa-primary-dark: #d94f15;
    --tsa-secondary: #8105bf;
    --tsa-secondary-dark: #6a049e;
    --tsa-light: #fff8f5;
    --tsa-cream: #f7e1b0;
    --tsa-gradient: linear-gradient(135deg, #f26124, #8105bf);
    --tsa-gradient-reverse: linear-gradient(135deg, #8105bf, #f26124);
}

/* =========================================
   MEDIA HERO
   ========================================= */
.media-hero {
    background: var(--tsa-gradient);
    padding: 100px 0 60px;
    position: relative;
    overflow: hidden;
}

.media-hero::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E") repeat;
}

.breadcrumb-custom {
    background: transparent;
    padding: 0;
    margin: 0;
}

.breadcrumb-custom .breadcrumb-item a {
    color: rgba(255,255,255,0.7);
    text-decoration: none;
    transition: color 0.3s ease;
}

.breadcrumb-custom .breadcrumb-item a:hover {
    color: white;
}

.breadcrumb-custom .breadcrumb-item.active {
    color: white;
}

.breadcrumb-custom .breadcrumb-item + .breadcrumb-item::before {
    color: rgba(255,255,255,0.5);
}

.section-badge {
    display: inline-block;
    background: rgba(255,255,255,0.2);
    backdrop-filter: blur(10px);
    color: white;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.stat-pill {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    background: rgba(255,255,255,0.2);
    backdrop-filter: blur(10px);
    color: white;
    padding: 0.75rem 1.5rem;
    border-radius: 50px;
    font-weight: 600;
}

.stat-pill i {
    font-size: 1.2rem;
}

/* =========================================
   MEDIA SECTION
   ========================================= */
.media-section {
    background: linear-gradient(180deg, #fff 0%, var(--tsa-light) 100%);
}

/* =========================================
   FILTER SIDEBAR
   ========================================= */
.filter-sidebar {
    position: sticky;
    top: 100px;
}

.filter-card {
    background: white;
    border-radius: 20px;
    box-shadow: 0 10px 40px rgba(0,0,0,0.08);
    overflow: hidden;
    margin-bottom: 1.5rem;
}

.filter-header {
    background: var(--tsa-gradient);
    padding: 1.25rem 1.5rem;
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.filter-icon {
    width: 45px;
    height: 45px;
    background: rgba(255,255,255,0.2);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.1rem;
}

.filter-header h5 {
    color: white;
    font-weight: 700;
    margin: 0;
}

.filter-form {
    padding: 1.5rem;
}

.filter-group {
    margin-bottom: 1.5rem;
}

.filter-label {
    display: block;
    font-weight: 600;
    color: #333;
    margin-bottom: 0.75rem;
    font-size: 0.95rem;
}

.select-wrapper {
    position: relative;
}

.select-wrapper select {
    width: 100%;
    padding: 0.875rem 1rem;
    border: 2px solid #e9ecef;
    border-radius: 12px;
    font-size: 1rem;
    appearance: none;
    background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='%23adb5bd' viewBox='0 0 16 16'%3E%3Cpath d='M7.247 11.14L2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z'/%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: right 1rem center;
    transition: all 0.3s ease;
}

.select-wrapper select:focus {
    border-color: var(--tsa-primary);
    box-shadow: 0 0 0 4px rgba(242, 97, 36, 0.1);
    outline: none;
}

/* Type Options */
.type-options {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 0.75rem;
}

.type-option {
    cursor: pointer;
}

.type-option input {
    display: none;
}

.type-option .type-card {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 0.4rem;
    padding: 1rem 0.5rem;
    background: #f8f9fa;
    border: 2px solid #e9ecef;
    border-radius: 12px;
    text-align: center;
    transition: all 0.3s ease;
}

.type-option input:checked + .type-card {
    background: var(--tsa-light);
    border-color: var(--tsa-primary);
    box-shadow: 0 5px 15px rgba(242, 97, 36, 0.15);
}

.type-option .type-card i {
    font-size: 1.25rem;
    color: #adb5bd;
    transition: color 0.3s ease;
}

.type-option input:checked + .type-card i {
    color: var(--tsa-primary);
}

.type-option .type-card span {
    font-size: 0.8rem;
    font-weight: 600;
    color: #555;
}

.btn-filter {
    width: 100%;
    background: var(--tsa-gradient);
    color: white;
    font-weight: 600;
    padding: 0.875rem;
    border-radius: 50px;
    border: none;
    transition: all 0.3s ease;
    margin-bottom: 0.75rem;
}

.btn-filter:hover {
    background: var(--tsa-gradient-reverse);
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(242, 97, 36, 0.3);
    color: white;
}

.btn-clear {
    width: 100%;
    background: #f8f9fa;
    color: #666;
    font-weight: 600;
    padding: 0.875rem;
    border-radius: 50px;
    border: none;
    transition: all 0.3s ease;
    text-decoration: none;
    display: block;
    text-align: center;
}

.btn-clear:hover {
    background: #e9ecef;
    color: #333;
}

/* Sidebar Widgets */
.sidebar-widget {
    background: white;
    border-radius: 20px;
    padding: 1.5rem;
    margin-bottom: 1.5rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
}

.widget-title {
    font-weight: 700;
    color: #333;
    margin-bottom: 1rem;
    padding-bottom: 0.75rem;
    border-bottom: 2px solid #f0f0f0;
}

/* Category List */
.category-list {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.category-link {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0.75rem 1rem;
    background: #f8f9fa;
    border-radius: 10px;
    text-decoration: none;
    transition: all 0.3s ease;
}

.category-link:hover,
.category-link.active {
    background: var(--tsa-light);
    transform: translateX(5px);
}

.category-link.active {
    border-left: 3px solid var(--tsa-primary);
}

.category-name {
    color: #333;
    font-weight: 500;
}

.category-count {
    background: var(--tsa-gradient);
    color: white;
    padding: 0.2rem 0.6rem;
    border-radius: 50px;
    font-size: 0.75rem;
    font-weight: 600;
}

/* Social Widget */
.social-text {
    color: #666;
    font-size: 0.9rem;
    margin-bottom: 1rem;
}

.social-links {
    display: flex;
    gap: 0.75rem;
}

.social-link {
    width: 45px;
    height: 45px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.1rem;
    text-decoration: none;
    transition: all 0.3s ease;
}

.social-link:hover {
    transform: translateY(-3px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.2);
}

.social-link.instagram { background: linear-gradient(45deg, #f09433, #e6683c, #dc2743, #cc2366, #bc1888); }
.social-link.facebook { background: #1877f2; }
.social-link.youtube { background: #ff0000; }

/* =========================================
   ACTIVE FILTERS
   ========================================= */
.active-filters {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    flex-wrap: wrap;
}

.filters-label {
    font-weight: 600;
    color: #555;
}

.filter-tag {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    background: var(--tsa-light);
    color: var(--tsa-primary);
    padding: 0.5rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 500;
}

.filter-tag a {
    color: var(--tsa-primary);
    opacity: 0.7;
    transition: opacity 0.3s ease;
}

.filter-tag a:hover {
    opacity: 1;
}

/* =========================================
   MEDIA GRID
   ========================================= */
.media-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 1.5rem;
}

.media-card {
    background: white;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
    transition: all 0.4s ease;
    animation: fadeInUp 0.5s ease forwards;
    opacity: 0;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.media-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 20px 50px rgba(0,0,0,0.15);
}

/* Media Thumbnail */
.media-thumbnail {
    position: relative;
    height: 200px;
    overflow: hidden;
}

.media-thumbnail img,
.media-thumbnail video {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.5s ease;
}

.media-card:hover .media-thumbnail img,
.media-card:hover .media-thumbnail video {
    transform: scale(1.1);
}

.document-preview {
    width: 100%;
    height: 100%;
    background: linear-gradient(135deg, #f8f9fa, #e9ecef);
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
}

.document-preview i {
    font-size: 3.5rem;
    color: var(--tsa-primary);
}

.doc-ext {
    font-weight: 700;
    color: #888;
    font-size: 0.85rem;
}

/* Media Overlay */
.media-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(to top, rgba(0,0,0,0.7) 0%, transparent 50%);
    display: flex;
    align-items: center;
    justify-content: center;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.media-card:hover .media-overlay {
    opacity: 1;
}

.media-overlay.video {
    background: rgba(0,0,0,0.4);
    opacity: 1;
}

.play-button {
    width: 60px;
    height: 60px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.25rem;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 5px 20px rgba(0,0,0,0.3);
}

.play-button:hover {
    transform: scale(1.1);
}

.play-button i {
    margin-left: 4px;
}

.btn-preview,
.btn-download {
    width: 50px;
    height: 50px;
    background: white;
    border: none;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--tsa-primary);
    font-size: 1.1rem;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 5px 20px rgba(0,0,0,0.2);
}

.btn-preview:hover,
.btn-download:hover {
    background: var(--tsa-gradient);
    color: white;
    transform: scale(1.1);
}

/* Type Badge */
.type-badge {
    position: absolute;
    top: 1rem;
    left: 1rem;
    width: 35px;
    height: 35px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 0.9rem;
    z-index: 2;
}

.type-badge.image {
    background: var(--tsa-primary);
}

.type-badge.video {
    background: #e74c3c;
}

.type-badge.document {
    background: var(--tsa-secondary);
}

/* Media Info */
.media-info {
    padding: 1.25rem;
}

.media-title {
    font-weight: 700;
    color: #333;
    margin-bottom: 0.5rem;
    font-size: 1rem;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.media-meta {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 1rem;
}

.meta-category {
    display: flex;
    align-items: center;
    gap: 0.4rem;
    font-size: 0.8rem;
    color: #888;
}

.meta-category i {
    color: var(--tsa-primary);
}

.meta-type {
    font-size: 0.75rem;
    font-weight: 600;
    color: white;
    background: var(--tsa-secondary);
    padding: 0.25rem 0.6rem;
    border-radius: 50px;
}

.btn-view {
    display: flex;
    align-items: center;
    justify-content: space-between;
    width: 100%;
    background: var(--tsa-light);
    color: var(--tsa-primary);
    font-weight: 600;
    padding: 0.75rem 1rem;
    border-radius: 10px;
    border: none;
    text-decoration: none;
    transition: all 0.3s ease;
}

.btn-view:hover {
    background: var(--tsa-gradient);
    color: white;
}

.btn-view i {
    transition: transform 0.3s ease;
}

.btn-view:hover i {
    transform: translateX(5px);
}

/* =========================================
   EMPTY STATE
   ========================================= */
.empty-state {
    text-align: center;
    padding: 5rem 2rem;
    background: white;
    border-radius: 25px;
    box-shadow: 0 10px 40px rgba(0,0,0,0.08);
}

.empty-icon {
    width: 120px;
    height: 120px;
    background: var(--tsa-light);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1.5rem;
}

.empty-icon i {
    font-size: 3.5rem;
    color: var(--tsa-primary);
    opacity: 0.5;
}

.empty-state h3 {
    font-weight: 700;
    color: #333;
    margin-bottom: 0.5rem;
}

.empty-state p {
    color: #888;
    margin-bottom: 1.5rem;
}

.empty-actions {
    display: flex;
    gap: 1rem;
    justify-content: center;
    flex-wrap: wrap;
}

.btn-primary-custom {
    background: var(--tsa-gradient);
    color: white;
    font-weight: 600;
    padding: 0.875rem 1.5rem;
    border-radius: 50px;
    border: none;
    transition: all 0.3s ease;
    text-decoration: none;
}

.btn-primary-custom:hover {
    background: var(--tsa-gradient-reverse);
    color: white;
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(242, 97, 36, 0.3);
}

.btn-outline-custom {
    background: white;
    color: var(--tsa-primary);
    font-weight: 600;
    padding: 0.875rem 1.5rem;
    border-radius: 50px;
    border: 2px solid var(--tsa-primary);
    transition: all 0.3s ease;
    text-decoration: none;
}

.btn-outline-custom:hover {
    background: var(--tsa-primary);
    color: white;
}

/* =========================================
   LIGHTBOX
   ========================================= */
.lightbox {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0,0,0,0.95);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 9999;
    opacity: 0;
    visibility: hidden;
    transition: all 0.3s ease;
}

.lightbox.active {
    opacity: 1;
    visibility: visible;
}

.lightbox-close {
    position: absolute;
    top: 2rem;
    right: 2rem;
    width: 50px;
    height: 50px;
    background: rgba(255,255,255,0.1);
    border: none;
    border-radius: 50%;
    color: white;
    font-size: 1.5rem;
    cursor: pointer;
    transition: all 0.3s ease;
}

.lightbox-close:hover {
    background: var(--tsa-primary);
    transform: rotate(90deg);
}

.lightbox-content {
    max-width: 90%;
    max-height: 90%;
    text-align: center;
}

.lightbox-content img {
    max-width: 100%;
    max-height: 80vh;
    border-radius: 10px;
    box-shadow: 0 20px 60px rgba(0,0,0,0.5);
}

#lightbox-caption {
    color: white;
    margin-top: 1rem;
    font-size: 1.1rem;
}

/* =========================================
   RESPONSIVE STYLES
   ========================================= */
@media (max-width: 991px) {
    .media-hero {
        padding: 80px 0 50px;
    }
    
    .media-hero h1 {
        font-size: 2rem;
    }
    
    .filter-sidebar {
        position: relative;
        top: 0;
        margin-bottom: 2rem;
    }
    
    .media-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 768px) {
    .media-hero {
        padding: 70px 0 40px;
        text-align: center;
    }
    
    .media-hero h1 {
        font-size: 1.75rem;
    }
    
    .stat-pill {
        margin-top: 1rem;
    }
    
    .media-grid {
        grid-template-columns: 1fr;
    }
    
    .type-options {
        grid-template-columns: repeat(4, 1fr);
    }
    
    .type-option .type-card {
        padding: 0.75rem 0.25rem;
    }
    
    .type-option .type-card span {
        font-size: 0.7rem;
    }
    
    .empty-actions {
        flex-direction: column;
    }
    
    .empty-actions .btn {
        width: 100%;
    }
}
</style>

<script>
// Lightbox functionality
function openLightbox(imageSrc, caption) {
    var lightbox = document.getElementById('lightbox');
    var lightboxImage = document.getElementById('lightbox-image');
    var lightboxCaption = document.getElementById('lightbox-caption');
    
    lightboxImage.src = imageSrc;
    lightboxCaption.textContent = caption;
    lightbox.classList.add('active');
    document.body.style.overflow = 'hidden';
}

function closeLightbox() {
    var lightbox = document.getElementById('lightbox');
    lightbox.classList.remove('active');
    document.body.style.overflow = '';
}

// Close lightbox on escape key
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeLightbox();
    }
});

// Close lightbox on background click
document.getElementById('lightbox').addEventListener('click', function(e) {
    if (e.target === this) {
        closeLightbox();
    }
});
</script>