<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Privacy Hero Banner -->
<section class="privacy-hero">
    <div class="container">
        <div class="row align-items-center justify-content-center">
            <div class="col-lg-8 text-center">
                <nav aria-label="breadcrumb" class="mb-3">
                    <ol class="breadcrumb breadcrumb-custom justify-content-center">
                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Privacy Policy</li>
                    </ol>
                </nav>
                <div class="hero-icon">
                    <i class="fas fa-user-shield"></i>
                </div>
                <span class="section-badge mb-3">
                    <i class="fas fa-lock me-2"></i>Your Privacy Matters
                </span>
                <h1 class="display-5 fw-bold text-white mb-3">Privacy Policy</h1>
                <p class="lead text-white-50 mb-0">Learn how we collect, use, and protect your personal information.</p>
            </div>
        </div>
    </div>
</section>

<!-- Privacy Content Section -->
<section class="py-5 privacy-section">
    <div class="container">
        <div class="row">
            <!-- Main Content -->
            <div class="col-lg-8 mb-4">
                <!-- Last Updated Badge -->
                <div class="update-badge">
                    <i class="fas fa-calendar-check"></i>
                    <span>Last updated: <?php echo date('F d, Y'); ?></span>
                </div>
                
                <!-- Privacy Card -->
                <div class="privacy-card">
                    <!-- Introduction -->
                    <div class="intro-section">
                        <div class="intro-icon">
                            <i class="fas fa-shield-alt"></i>
                        </div>
                        <div class="intro-content">
                            <h5>Our Commitment to Privacy</h5>
                            <p>At <?php echo $site_settings['site_name'] ?? 'The Skills Atelier'; ?>, we take your privacy seriously. This policy outlines how we handle your personal information with care and transparency.</p>
                        </div>
                    </div>
                    
                    <!-- Privacy Sections -->
                    <div class="privacy-content">
                        <!-- Section 1 -->
                        <div class="privacy-section-item" id="section-1">
                            <div class="section-header">
                                <div class="section-icon">
                                    <i class="fas fa-database"></i>
                                </div>
                                <div class="section-title">
                                    <span class="section-number">01</span>
                                    <h4>Information We Collect</h4>
                                </div>
                            </div>
                            <div class="section-body">
                                <p>We collect information you provide directly to us when you register for programs, volunteer, donate, or contact us. This may include:</p>
                                
                                <div class="info-grid">
                                    <div class="info-item">
                                        <i class="fas fa-user"></i>
                                        <span>Full Name</span>
                                    </div>
                                    <div class="info-item">
                                        <i class="fas fa-envelope"></i>
                                        <span>Email Address</span>
                                    </div>
                                    <div class="info-item">
                                        <i class="fas fa-phone"></i>
                                        <span>Phone Number</span>
                                    </div>
                                    <div class="info-item">
                                        <i class="fas fa-map-marker-alt"></i>
                                        <span>Location</span>
                                    </div>
                                    <div class="info-item">
                                        <i class="fas fa-child"></i>
                                        <span>Child Information</span>
                                    </div>
                                    <div class="info-item">
                                        <i class="fas fa-school"></i>
                                        <span>School Details</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Section 2 -->
                        <div class="privacy-section-item" id="section-2">
                            <div class="section-header">
                                <div class="section-icon">
                                    <i class="fas fa-cogs"></i>
                                </div>
                                <div class="section-title">
                                    <span class="section-number">02</span>
                                    <h4>How We Use Your Information</h4>
                                </div>
                            </div>
                            <div class="section-body">
                                <p>We use the information we collect to provide you with the best possible experience:</p>
                                
                                <div class="usage-list">
                                    <div class="usage-item">
                                        <div class="usage-icon">
                                            <i class="fas fa-check"></i>
                                        </div>
                                        <div class="usage-content">
                                            <h6>Process Your Requests</h6>
                                            <p>Handle registrations, applications, and inquiries</p>
                                        </div>
                                    </div>
                                    <div class="usage-item">
                                        <div class="usage-icon">
                                            <i class="fas fa-check"></i>
                                        </div>
                                        <div class="usage-content">
                                            <h6>Send Updates</h6>
                                            <p>Keep you informed about our programs and activities</p>
                                        </div>
                                    </div>
                                    <div class="usage-item">
                                        <div class="usage-icon">
                                            <i class="fas fa-check"></i>
                                        </div>
                                        <div class="usage-content">
                                            <h6>Improve Services</h6>
                                            <p>Enhance our offerings based on your feedback</p>
                                        </div>
                                    </div>
                                    <div class="usage-item">
                                        <div class="usage-icon">
                                            <i class="fas fa-check"></i>
                                        </div>
                                        <div class="usage-content">
                                            <h6>Legal Compliance</h6>
                                            <p>Fulfill our legal and regulatory obligations</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Section 3 -->
                        <div class="privacy-section-item" id="section-3">
                            <div class="section-header">
                                <div class="section-icon">
                                    <i class="fas fa-share-alt"></i>
                                </div>
                                <div class="section-title">
                                    <span class="section-number">03</span>
                                    <h4>Information Sharing</h4>
                                </div>
                            </div>
                            <div class="section-body">
                                <div class="promise-box">
                                    <div class="promise-icon">
                                        <i class="fas fa-hand-holding-heart"></i>
                                    </div>
                                    <div class="promise-content">
                                        <h6>Our Promise</h6>
                                        <p>We do <strong>not</strong> sell, trade, or rent your personal information to third parties.</p>
                                    </div>
                                </div>
                                
                                <p class="mt-3">We may share your information with trusted partners who assist us in operating our website and conducting our activities, as long as those parties agree to keep this information confidential. These partners include:</p>
                                
                                <div class="partner-tags">
                                    <span class="partner-tag"><i class="fas fa-server"></i> Hosting Providers</span>
                                    <span class="partner-tag"><i class="fas fa-credit-card"></i> Payment Processors</span>
                                    <span class="partner-tag"><i class="fas fa-envelope"></i> Email Services</span>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Section 4 -->
                        <div class="privacy-section-item" id="section-4">
                            <div class="section-header">
                                <div class="section-icon">
                                    <i class="fas fa-lock"></i>
                                </div>
                                <div class="section-title">
                                    <span class="section-number">04</span>
                                    <h4>Data Security</h4>
                                </div>
                            </div>
                            <div class="section-body">
                                <p>We implement appropriate security measures to protect your personal information:</p>
                                
                                <div class="security-features">
                                    <div class="security-item">
                                        <div class="security-icon">
                                            <i class="fas fa-shield-alt"></i>
                                        </div>
                                        <span>SSL Encryption</span>
                                    </div>
                                    <div class="security-item">
                                        <div class="security-icon">
                                            <i class="fas fa-database"></i>
                                        </div>
                                        <span>Secure Storage</span>
                                    </div>
                                    <div class="security-item">
                                        <div class="security-icon">
                                            <i class="fas fa-user-lock"></i>
                                        </div>
                                        <span>Access Controls</span>
                                    </div>
                                    <div class="security-item">
                                        <div class="security-icon">
                                            <i class="fas fa-sync-alt"></i>
                                        </div>
                                        <span>Regular Updates</span>
                                    </div>
                                </div>
                                
                                <div class="notice-box">
                                    <i class="fas fa-info-circle"></i>
                                    <p>However, no method of transmission over the Internet is 100% secure. While we strive to protect your data, we cannot guarantee absolute security.</p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Section 5 -->
                        <div class="privacy-section-item" id="section-5">
                            <div class="section-header">
                                <div class="section-icon">
                                    <i class="fas fa-user-check"></i>
                                </div>
                                <div class="section-title">
                                    <span class="section-number">05</span>
                                    <h4>Your Rights</h4>
                                </div>
                            </div>
                            <div class="section-body">
                                <p>You have the following rights regarding your personal data:</p>
                                
                                <div class="rights-grid">
                                    <div class="right-card">
                                        <div class="right-icon">
                                            <i class="fas fa-eye"></i>
                                        </div>
                                        <h6>Access</h6>
                                        <p>View your personal data we hold</p>
                                    </div>
                                    <div class="right-card">
                                        <div class="right-icon">
                                            <i class="fas fa-edit"></i>
                                        </div>
                                        <h6>Correct</h6>
                                        <p>Fix any inaccurate information</p>
                                    </div>
                                    <div class="right-card">
                                        <div class="right-icon">
                                            <i class="fas fa-trash-alt"></i>
                                        </div>
                                        <h6>Delete</h6>
                                        <p>Request removal of your data</p>
                                    </div>
                                    <div class="right-card">
                                        <div class="right-icon">
                                            <i class="fas fa-ban"></i>
                                        </div>
                                        <h6>Opt-Out</h6>
                                        <p>Unsubscribe from marketing</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Section 6 -->
                        <div class="privacy-section-item" id="section-6">
                            <div class="section-header">
                                <div class="section-icon">
                                    <i class="fas fa-headset"></i>
                                </div>
                                <div class="section-title">
                                    <span class="section-number">06</span>
                                    <h4>Contact Us</h4>
                                </div>
                            </div>
                            <div class="section-body">
                                <p>If you have questions about this Privacy Policy or wish to exercise your rights, please contact us:</p>
                                
                                <div class="contact-options">
                                    <?php if (!empty($site_settings['site_email'])): ?>
                                    <a href="mailto:<?php echo $site_settings['site_email']; ?>" class="contact-option">
                                        <div class="option-icon email">
                                            <i class="fas fa-envelope"></i>
                                        </div>
                                        <div class="option-content">
                                            <span>Email Us</span>
                                            <p><?php echo $site_settings['site_email']; ?></p>
                                        </div>
                                        <i class="fas fa-arrow-right"></i>
                                    </a>
                                    <?php endif; ?>
                                    
                                    <?php if (!empty($site_settings['site_phone'])): ?>
                                    <a href="tel:<?php echo $site_settings['site_phone']; ?>" class="contact-option">
                                        <div class="option-icon phone">
                                            <i class="fas fa-phone"></i>
                                        </div>
                                        <div class="option-content">
                                            <span>Call Us</span>
                                            <p><?php echo $site_settings['site_phone']; ?></p>
                                        </div>
                                        <i class="fas fa-arrow-right"></i>
                                    </a>
                                    <?php endif; ?>
                                    
                                    <a href="https://wa.me/233500557751" target="_blank" class="contact-option">
                                        <div class="option-icon whatsapp">
                                            <i class="fab fa-whatsapp"></i>
                                        </div>
                                        <div class="option-content">
                                            <span>WhatsApp</span>
                                            <p>+233 50 055 7751</p>
                                        </div>
                                        <i class="fas fa-arrow-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Sidebar -->
            <div class="col-lg-4">
                <aside class="sidebar">
                    <!-- Quick Navigation -->
                    <div class="sidebar-widget nav-widget">
                        <h5 class="widget-title"><i class="fas fa-list me-2"></i>Quick Navigation</h5>
                        <div class="nav-links">
                            <a href="#section-1" class="nav-link-item">
                                <span class="nav-number">01</span>
                                <span>Information We Collect</span>
                            </a>
                            <a href="#section-2" class="nav-link-item">
                                <span class="nav-number">02</span>
                                <span>How We Use Your Information</span>
                            </a>
                            <a href="#section-3" class="nav-link-item">
                                <span class="nav-number">03</span>
                                <span>Information Sharing</span>
                            </a>
                            <a href="#section-4" class="nav-link-item">
                                <span class="nav-number">04</span>
                                <span>Data Security</span>
                            </a>
                            <a href="#section-5" class="nav-link-item">
                                <span class="nav-number">05</span>
                                <span>Your Rights</span>
                            </a>
                            <a href="#section-6" class="nav-link-item">
                                <span class="nav-number">06</span>
                                <span>Contact Us</span>
                            </a>
                        </div>
                    </div>
                    
                    <!-- Trust Badges -->
                    <div class="sidebar-widget trust-widget">
                        <h5 class="widget-title"><i class="fas fa-shield-alt me-2"></i>Your Data is Safe</h5>
                        <div class="trust-items">
                            <div class="trust-item">
                                <i class="fas fa-check-circle"></i>
                                <span>SSL Secured</span>
                            </div>
                            <div class="trust-item">
                                <i class="fas fa-check-circle"></i>
                                <span>No Data Selling</span>
                            </div>
                            <div class="trust-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Encrypted Storage</span>
                            </div>
                            <div class="trust-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Regular Audits</span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Related Links -->
                    <div class="sidebar-widget links-widget">
                        <h5 class="widget-title"><i class="fas fa-link me-2"></i>Related Pages</h5>
                        <a href="<?php echo base_url('terms'); ?>" class="related-link">
                            <i class="fas fa-file-contract"></i>
                            <span>Terms & Conditions</span>
                        </a>
                        <a href="<?php echo base_url('contact'); ?>" class="related-link">
                            <i class="fas fa-envelope"></i>
                            <span>Contact Us</span>
                        </a>
                        <a href="<?php echo base_url('about'); ?>" class="related-link">
                            <i class="fas fa-info-circle"></i>
                            <span>About Us</span>
                        </a>
                    </div>
                    
                    <!-- Questions Widget -->
                    <div class="sidebar-widget question-widget">
                        <div class="question-icon">
                            <i class="fas fa-question-circle"></i>
                        </div>
                        <h5>Have Questions?</h5>
                        <p>We're here to help with any privacy concerns you may have.</p>
                        <a href="<?php echo base_url('contact'); ?>" class="btn btn-question">
                            <i class="fas fa-envelope me-2"></i>Get in Touch
                        </a>
                    </div>
                </aside>
            </div>
        </div>
    </div>
</section>

<style>
/* =========================================
   THE SKILLS ATELIER - PRIVACY PAGE STYLES
   Primary: #f26124 (Orange)
   Secondary: #8105bf (Purple)
   ========================================= */

:root {
    --tsa-primary: #f26124;
    --tsa-primary-dark: #d94f15;
    --tsa-secondary: #8105bf;
    --tsa-secondary-dark: #6a049e;
    --tsa-light: #fff8f5;
    --tsa-cream: #f7e1b0;
    --tsa-gradient: linear-gradient(135deg, #f26124, #8105bf);
    --tsa-gradient-reverse: linear-gradient(135deg, #8105bf, #f26124);
}

/* =========================================
   PRIVACY HERO
   ========================================= */
.privacy-hero {
    background: var(--tsa-gradient-reverse);
    padding: 100px 0 80px;
    position: relative;
    overflow: hidden;
}

.privacy-hero::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E") repeat;
}

.hero-icon {
    width: 90px;
    height: 90px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1.5rem;
    backdrop-filter: blur(10px);
}

.hero-icon i {
    font-size: 2.5rem;
    color: white;
}

.breadcrumb-custom {
    background: transparent;
    padding: 0;
    margin: 0;
}

.breadcrumb-custom .breadcrumb-item a {
    color: rgba(255,255,255,0.7);
    text-decoration: none;
}

.breadcrumb-custom .breadcrumb-item a:hover {
    color: white;
}

.breadcrumb-custom .breadcrumb-item.active {
    color: white;
}

.breadcrumb-custom .breadcrumb-item + .breadcrumb-item::before {
    color: rgba(255,255,255,0.5);
}

.section-badge {
    display: inline-block;
    background: rgba(255,255,255,0.2);
    backdrop-filter: blur(10px);
    color: white;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
}

/* =========================================
   PRIVACY SECTION
   ========================================= */
.privacy-section {
    background: linear-gradient(180deg, #fff 0%, var(--tsa-light) 100%);
}

.update-badge {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    background: white;
    padding: 0.75rem 1.25rem;
    border-radius: 50px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
    font-size: 0.9rem;
    color: #666;
}

.update-badge i {
    color: var(--tsa-secondary);
}

/* Privacy Card */
.privacy-card {
    background: white;
    border-radius: 25px;
    box-shadow: 0 20px 60px rgba(0,0,0,0.1);
    overflow: hidden;
}

/* Intro Section */
.intro-section {
    background: var(--tsa-gradient-reverse);
    padding: 2rem;
    display: flex;
    align-items: center;
    gap: 1.5rem;
}

.intro-icon {
    width: 70px;
    height: 70px;
    min-width: 70px;
    background: rgba(255,255,255,0.2);
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.75rem;
    color: white;
}

.intro-content h5 {
    color: white;
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.intro-content p {
    color: rgba(255,255,255,0.9);
    margin: 0;
    font-size: 0.95rem;
}

/* Privacy Content */
.privacy-content {
    padding: 2rem;
}

.privacy-section-item {
    margin-bottom: 2.5rem;
    padding-bottom: 2.5rem;
    border-bottom: 1px solid #f0f0f0;
}

.privacy-section-item:last-child {
    margin-bottom: 0;
    padding-bottom: 0;
    border-bottom: none;
}

.section-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 1.25rem;
}

.section-icon {
    width: 55px;
    height: 55px;
    min-width: 55px;
    background: var(--tsa-gradient-reverse);
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.25rem;
}

.section-title {
    display: flex;
    flex-direction: column;
}

.section-number {
    font-size: 0.75rem;
    font-weight: 700;
    color: var(--tsa-secondary);
    text-transform: uppercase;
    letter-spacing: 1px;
}

.section-title h4 {
    font-weight: 700;
    color: #333;
    margin: 0;
}

.section-body {
    padding-left: 71px;
}

.section-body p {
    color: #555;
    line-height: 1.8;
}

/* Info Grid */
.info-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 1rem;
    margin-top: 1.25rem;
}

.info-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 1rem;
    background: #f8f9fa;
    border-radius: 12px;
    transition: all 0.3s ease;
}

.info-item:hover {
    background: var(--tsa-light);
    transform: translateY(-2px);
}

.info-item i {
    width: 40px;
    height: 40px;
    background: var(--tsa-gradient-reverse);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 0.9rem;
}

.info-item span {
    font-weight: 500;
    color: #333;
    font-size: 0.9rem;
}

/* Usage List */
.usage-list {
    display: flex;
    flex-direction: column;
    gap: 1rem;
    margin-top: 1rem;
}

.usage-item {
    display: flex;
    align-items: flex-start;
    gap: 1rem;
    padding: 1rem 1.25rem;
    background: #f8f9fa;
    border-radius: 12px;
    transition: all 0.3s ease;
}

.usage-item:hover {
    background: var(--tsa-light);
    transform: translateX(5px);
}

.usage-icon {
    width: 35px;
    height: 35px;
    min-width: 35px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 0.85rem;
}

.usage-content h6 {
    font-weight: 600;
    color: #333;
    margin-bottom: 0.25rem;
}

.usage-content p {
    color: #666;
    font-size: 0.9rem;
    margin: 0;
}

/* Promise Box */
.promise-box {
    display: flex;
    align-items: center;
    gap: 1.25rem;
    background: linear-gradient(135deg, rgba(129, 5, 191, 0.1), rgba(242, 97, 36, 0.1));
    padding: 1.5rem;
    border-radius: 15px;
    border-left: 4px solid var(--tsa-secondary);
}

.promise-icon {
    width: 60px;
    height: 60px;
    min-width: 60px;
    background: var(--tsa-gradient-reverse);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.5rem;
}

.promise-content h6 {
    font-weight: 700;
    color: var(--tsa-secondary);
    margin-bottom: 0.25rem;
}

.promise-content p {
    margin: 0;
    color: #555;
}

/* Partner Tags */
.partner-tags {
    display: flex;
    flex-wrap: wrap;
    gap: 0.75rem;
    margin-top: 1rem;
}

.partner-tag {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.5rem 1rem;
    background: #f8f9fa;
    border-radius: 50px;
    font-size: 0.85rem;
    color: #555;
}

.partner-tag i {
    color: var(--tsa-secondary);
}

/* Security Features */
.security-features {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 1rem;
    margin: 1.25rem 0;
}

.security-item {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1.25rem;
    background: #f8f9fa;
    border-radius: 15px;
    transition: all 0.3s ease;
}

.security-item:hover {
    background: var(--tsa-light);
    box-shadow: 0 5px 20px rgba(0,0,0,0.08);
}

.security-icon {
    width: 50px;
    height: 50px;
    min-width: 50px;
    background: var(--tsa-gradient-reverse);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.1rem;
}

.security-item span {
    font-weight: 600;
    color: #333;
}

/* Notice Box */
.notice-box {
    display: flex;
    align-items: flex-start;
    gap: 1rem;
    background: #fff3cd;
    padding: 1rem 1.25rem;
    border-radius: 12px;
    border-left: 4px solid #ffc107;
}

.notice-box i {
    color: #856404;
    font-size: 1.25rem;
    margin-top: 0.2rem;
}

.notice-box p {
    margin: 0;
    color: #856404;
    font-size: 0.9rem;
}

/* Rights Grid */
.rights-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 1rem;
    margin-top: 1.25rem;
}

.right-card {
    text-align: center;
    padding: 1.5rem;
    background: #f8f9fa;
    border-radius: 15px;
    transition: all 0.3s ease;
}

.right-card:hover {
    background: var(--tsa-light);
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.right-icon {
    width: 60px;
    height: 60px;
    background: var(--tsa-gradient-reverse);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
    color: white;
    font-size: 1.25rem;
}

.right-card h6 {
    font-weight: 700;
    color: #333;
    margin-bottom: 0.5rem;
}

.right-card p {
    color: #666;
    font-size: 0.85rem;
    margin: 0;
}

/* Contact Options */
.contact-options {
    display: flex;
    flex-direction: column;
    gap: 1rem;
    margin-top: 1.25rem;
}

.contact-option {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem 1.25rem;
    background: #f8f9fa;
    border-radius: 15px;
    text-decoration: none;
    transition: all 0.3s ease;
}

.contact-option:hover {
    background: var(--tsa-light);
    transform: translateX(10px);
}

.option-icon {
    width: 50px;
    height: 50px;
    min-width: 50px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.2rem;
}

.option-icon.email { background: var(--tsa-primary); }
.option-icon.phone { background: var(--tsa-secondary); }
.option-icon.whatsapp { background: #25D366; }

.option-content {
    flex: 1;
}

.option-content span {
    font-size: 0.75rem;
    color: #888;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.option-content p {
    font-weight: 600;
    color: #333;
    margin: 0;
}

.contact-option > .fa-arrow-right {
    color: #ccc;
    transition: all 0.3s ease;
}

.contact-option:hover > .fa-arrow-right {
    color: var(--tsa-primary);
    transform: translateX(5px);
}

/* =========================================
   SIDEBAR
   ========================================= */
.sidebar {
    position: sticky;
    top: 100px;
}

.sidebar-widget {
    background: white;
    border-radius: 20px;
    padding: 1.5rem;
    margin-bottom: 1.5rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
}

.widget-title {
    font-weight: 700;
    color: #333;
    margin-bottom: 1rem;
    padding-bottom: 0.75rem;
    border-bottom: 2px solid #f0f0f0;
}

/* Nav Widget */
.nav-links {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.nav-link-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 0.75rem 1rem;
    background: #f8f9fa;
    border-radius: 10px;
    text-decoration: none;
    transition: all 0.3s ease;
}

.nav-link-item:hover {
    background: var(--tsa-light);
    transform: translateX(5px);
}

.nav-number {
    width: 30px;
    height: 30px;
    min-width: 30px;
    background: var(--tsa-gradient-reverse);
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: 700;
    font-size: 0.75rem;
}

.nav-link-item span:last-child {
    color: #333;
    font-weight: 500;
    font-size: 0.85rem;
}

/* Trust Widget */
.trust-items {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.trust-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.trust-item i {
    color: #28a745;
    font-size: 1rem;
}

.trust-item span {
    color: #333;
    font-weight: 500;
}

/* Links Widget */
.related-link {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 0.875rem 1rem;
    background: #f8f9fa;
    border-radius: 10px;
    text-decoration: none;
    margin-bottom: 0.5rem;
    transition: all 0.3s ease;
}

.related-link:last-child {
    margin-bottom: 0;
}

.related-link:hover {
    background: var(--tsa-light);
    transform: translateX(5px);
}

.related-link i {
    width: 35px;
    height: 35px;
    background: var(--tsa-gradient-reverse);
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 0.85rem;
}

.related-link span {
    color: #333;
    font-weight: 500;
}

/* Question Widget */
.question-widget {
    background: var(--tsa-gradient-reverse);
    text-align: center;
    padding: 2rem;
}

.question-icon {
    width: 60px;
    height: 60px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
    font-size: 1.5rem;
    color: white;
}

.question-widget h5 {
    color: white;
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.question-widget p {
    color: rgba(255,255,255,0.9);
    font-size: 0.9rem;
    margin-bottom: 1rem;
}

.btn-question {
    background: white;
    color: var(--tsa-secondary);
    font-weight: 600;
    padding: 0.875rem 1.5rem;
    border-radius: 50px;
    border: none;
    transition: all 0.3s ease;
    text-decoration: none;
    display: inline-block;
}

.btn-question:hover {
    background: rgba(255,255,255,0.9);
    color: var(--tsa-secondary);
    transform: translateY(-2px);
}

/* =========================================
   RESPONSIVE STYLES
   ========================================= */
@media (max-width: 991px) {
    .privacy-hero {
        padding: 80px 0 60px;
    }
    
    .privacy-hero h1 {
        font-size: 2rem;
    }
    
    .sidebar {
        position: relative;
        top: 0;
        margin-top: 2rem;
    }
    
    .info-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 768px) {
    .privacy-hero {
        padding: 70px 0 50px;
    }
    
    .privacy-hero h1 {
        font-size: 1.75rem;
    }
    
    .hero-icon {
        width: 70px;
        height: 70px;
    }
    
    .hero-icon i {
        font-size: 2rem;
    }
    
    .intro-section {
        flex-direction: column;
        text-align: center;
    }
    
    .privacy-content {
        padding: 1.5rem;
    }
    
    .section-body {
        padding-left: 0;
        margin-top: 1rem;
    }
    
    .info-grid,
    .security-features,
    .rights-grid {
        grid-template-columns: 1fr;
    }
}
</style>

<script>
// Smooth scroll to sections
document.querySelectorAll('.nav-link-item, a[href^="#section"]').forEach(function(link) {
    link.addEventListener('click', function(e) {
        e.preventDefault();
        var targetId = this.getAttribute('href');
        var targetElement = document.querySelector(targetId);
        
        if (targetElement) {
            var headerOffset = 100;
            var elementPosition = targetElement.getBoundingClientRect().top;
            var offsetPosition = elementPosition + window.pageYOffset - headerOffset;
            
            window.scrollTo({
                top: offsetPosition,
                behavior: 'smooth'
            });
        }
    });
});
</script>