<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Terms Hero Banner -->
<section class="terms-hero">
    <div class="container">
        <div class="row align-items-center justify-content-center">
            <div class="col-lg-8 text-center">
                <nav aria-label="breadcrumb" class="mb-3">
                    <ol class="breadcrumb breadcrumb-custom justify-content-center">
                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Terms & Conditions</li>
                    </ol>
                </nav>
                <div class="hero-icon">
                    <i class="fas fa-file-contract"></i>
                </div>
                <span class="section-badge mb-3">
                    <i class="fas fa-gavel me-2"></i>Legal
                </span>
                <h1 class="display-5 fw-bold text-white mb-3">Terms & Conditions</h1>
                <p class="lead text-white-50 mb-0">Please read these terms carefully before using our services.</p>
            </div>
        </div>
    </div>
</section>

<!-- Terms Content Section -->
<section class="py-5 terms-section">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <!-- Last Updated Badge -->
                <div class="update-badge">
                    <i class="fas fa-clock"></i>
                    <span>Last updated: <?php echo date('F d, Y'); ?></span>
                </div>
                
                <!-- Terms Card -->
                <div class="terms-card">
                    <!-- Table of Contents -->
                    <div class="toc-section">
                        <h5><i class="fas fa-list me-2"></i>Table of Contents</h5>
                        <div class="toc-grid">
                            <a href="#section-1" class="toc-item">
                                <span class="toc-number">01</span>
                                <span class="toc-title">Acceptance of Terms</span>
                            </a>
                            <a href="#section-2" class="toc-item">
                                <span class="toc-number">02</span>
                                <span class="toc-title">Use License</span>
                            </a>
                            <a href="#section-3" class="toc-item">
                                <span class="toc-number">03</span>
                                <span class="toc-title">Disclaimer</span>
                            </a>
                            <a href="#section-4" class="toc-item">
                                <span class="toc-number">04</span>
                                <span class="toc-title">Limitations</span>
                            </a>
                            <a href="#section-5" class="toc-item">
                                <span class="toc-number">05</span>
                                <span class="toc-title">Accuracy of Materials</span>
                            </a>
                            <a href="#section-6" class="toc-item">
                                <span class="toc-number">06</span>
                                <span class="toc-title">Links</span>
                            </a>
                            <a href="#section-7" class="toc-item">
                                <span class="toc-number">07</span>
                                <span class="toc-title">Modifications</span>
                            </a>
                            <a href="#section-8" class="toc-item">
                                <span class="toc-number">08</span>
                                <span class="toc-title">Contact Information</span>
                            </a>
                        </div>
                    </div>
                    
                    <!-- Terms Content -->
                    <div class="terms-content">
                        <!-- Section 1 -->
                        <div class="terms-section-item" id="section-1">
                            <div class="section-header">
                                <span class="section-number">01</span>
                                <h4>Acceptance of Terms</h4>
                            </div>
                            <div class="section-body">
                                <p>By accessing and using this website, you accept and agree to be bound by the terms and provisions of this agreement. If you do not agree to these terms, please do not use our services.</p>
                                <div class="highlight-box">
                                    <i class="fas fa-info-circle"></i>
                                    <p>Your continued use of the website following any changes constitutes acceptance of those changes.</p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Section 2 -->
                        <div class="terms-section-item" id="section-2">
                            <div class="section-header">
                                <span class="section-number">02</span>
                                <h4>Use License</h4>
                            </div>
                            <div class="section-body">
                                <p>Permission is granted to temporarily access the materials on <?php echo $site_settings['site_name'] ?? 'The Skills Atelier'; ?>'s website for personal, non-commercial viewing only. This is the grant of a license, not a transfer of title, and under this license you may not:</p>
                                <ul class="terms-list">
                                    <li><i class="fas fa-times-circle"></i>Modify or copy the materials</li>
                                    <li><i class="fas fa-times-circle"></i>Use the materials for any commercial purpose</li>
                                    <li><i class="fas fa-times-circle"></i>Attempt to decompile or reverse engineer any software</li>
                                    <li><i class="fas fa-times-circle"></i>Remove any copyright or proprietary notations</li>
                                    <li><i class="fas fa-times-circle"></i>Transfer the materials to another person</li>
                                </ul>
                            </div>
                        </div>
                        
                        <!-- Section 3 -->
                        <div class="terms-section-item" id="section-3">
                            <div class="section-header">
                                <span class="section-number">03</span>
                                <h4>Disclaimer</h4>
                            </div>
                            <div class="section-body">
                                <p>The materials on this website are provided on an 'as is' basis. <?php echo $site_settings['site_name'] ?? 'The Skills Atelier'; ?> makes no warranties, expressed or implied, and hereby disclaims and negates all other warranties including, without limitation:</p>
                                <ul class="terms-list check">
                                    <li><i class="fas fa-exclamation-triangle"></i>Implied warranties or conditions of merchantability</li>
                                    <li><i class="fas fa-exclamation-triangle"></i>Fitness for a particular purpose</li>
                                    <li><i class="fas fa-exclamation-triangle"></i>Non-infringement of intellectual property</li>
                                    <li><i class="fas fa-exclamation-triangle"></i>Other violation of rights</li>
                                </ul>
                            </div>
                        </div>
                        
                        <!-- Section 4 -->
                        <div class="terms-section-item" id="section-4">
                            <div class="section-header">
                                <span class="section-number">04</span>
                                <h4>Limitations</h4>
                            </div>
                            <div class="section-body">
                                <p>In no event shall <?php echo $site_settings['site_name'] ?? 'The Skills Atelier'; ?> or its suppliers be liable for any damages (including, without limitation, damages for loss of data or profit, or due to business interruption) arising out of the use or inability to use the materials on this website, even if we have been notified orally or in writing of the possibility of such damage.</p>
                                <div class="highlight-box warning">
                                    <i class="fas fa-shield-alt"></i>
                                    <p>Because some jurisdictions do not allow limitations on implied warranties, or limitations of liability for consequential or incidental damages, these limitations may not apply to you.</p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Section 5 -->
                        <div class="terms-section-item" id="section-5">
                            <div class="section-header">
                                <span class="section-number">05</span>
                                <h4>Accuracy of Materials</h4>
                            </div>
                            <div class="section-body">
                                <p>The materials appearing on this website could include technical, typographical, or photographic errors. <?php echo $site_settings['site_name'] ?? 'The Skills Atelier'; ?> does not warrant that any of the materials on its website are accurate, complete, or current. We may make changes to the materials contained on its website at any time without notice. However, we do not make any commitment to update the materials.</p>
                            </div>
                        </div>
                        
                        <!-- Section 6 -->
                        <div class="terms-section-item" id="section-6">
                            <div class="section-header">
                                <span class="section-number">06</span>
                                <h4>Links</h4>
                            </div>
                            <div class="section-body">
                                <p><?php echo $site_settings['site_name'] ?? 'The Skills Atelier'; ?> has not reviewed all of the sites linked to its website and is not responsible for the contents of any such linked site. The inclusion of any link does not imply endorsement by us. Use of any such linked website is at the user's own risk.</p>
                                <div class="highlight-box">
                                    <i class="fas fa-external-link-alt"></i>
                                    <p>We encourage you to review the terms and privacy policies of any third-party websites you visit.</p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Section 7 -->
                        <div class="terms-section-item" id="section-7">
                            <div class="section-header">
                                <span class="section-number">07</span>
                                <h4>Modifications</h4>
                            </div>
                            <div class="section-body">
                                <p><?php echo $site_settings['site_name'] ?? 'The Skills Atelier'; ?> may revise these terms of service for its website at any time without notice. By using this website you are agreeing to be bound by the then current version of these terms of service.</p>
                                <div class="revision-notice">
                                    <div class="revision-icon">
                                        <i class="fas fa-sync-alt"></i>
                                    </div>
                                    <div class="revision-content">
                                        <h6>Regular Reviews</h6>
                                        <p>We recommend reviewing this page periodically for any changes.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Section 8 -->
                        <div class="terms-section-item" id="section-8">
                            <div class="section-header">
                                <span class="section-number">08</span>
                                <h4>Contact Information</h4>
                            </div>
                            <div class="section-body">
                                <p>If you have any questions about these Terms & Conditions, please contact us:</p>
                                
                                <div class="contact-cards">
                                    <?php if (!empty($site_settings['site_email'])): ?>
                                    <div class="contact-card">
                                        <div class="contact-icon">
                                            <i class="fas fa-envelope"></i>
                                        </div>
                                        <div class="contact-info">
                                            <span>Email Us</span>
                                            <a href="mailto:<?php echo $site_settings['site_email']; ?>"><?php echo $site_settings['site_email']; ?></a>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if (!empty($site_settings['site_phone'])): ?>
                                    <div class="contact-card">
                                        <div class="contact-icon">
                                            <i class="fas fa-phone"></i>
                                        </div>
                                        <div class="contact-info">
                                            <span>Call Us</span>
                                            <a href="tel:<?php echo $site_settings['site_phone']; ?>"><?php echo $site_settings['site_phone']; ?></a>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if (!empty($site_settings['site_address'])): ?>
                                    <div class="contact-card">
                                        <div class="contact-icon">
                                            <i class="fas fa-map-marker-alt"></i>
                                        </div>
                                        <div class="contact-info">
                                            <span>Visit Us</span>
                                            <p><?php echo nl2br($site_settings['site_address']); ?></p>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Related Links -->
                <div class="related-links">
                    <h5>Related Pages</h5>
                    <div class="links-grid">
                        <a href="<?php echo base_url('privacy'); ?>" class="link-card">
                            <i class="fas fa-user-shield"></i>
                            <span>Privacy Policy</span>
                        </a>
                        <a href="<?php echo base_url('contact'); ?>" class="link-card">
                            <i class="fas fa-envelope"></i>
                            <span>Contact Us</span>
                        </a>
                        <a href="<?php echo base_url('about'); ?>" class="link-card">
                            <i class="fas fa-info-circle"></i>
                            <span>About Us</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
/* =========================================
   THE SKILLS ATELIER - TERMS PAGE STYLES
   Primary: #f26124 (Orange)
   Secondary: #8105bf (Purple)
   ========================================= */

:root {
    --tsa-primary: #f26124;
    --tsa-primary-dark: #d94f15;
    --tsa-secondary: #8105bf;
    --tsa-secondary-dark: #6a049e;
    --tsa-light: #fff8f5;
    --tsa-cream: #f7e1b0;
    --tsa-gradient: linear-gradient(135deg, #f26124, #8105bf);
    --tsa-gradient-reverse: linear-gradient(135deg, #8105bf, #f26124);
}

/* =========================================
   TERMS HERO
   ========================================= */
.terms-hero {
    background: var(--tsa-gradient);
    padding: 100px 0 80px;
    position: relative;
    overflow: hidden;
}

.terms-hero::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E") repeat;
}

.hero-icon {
    width: 90px;
    height: 90px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1.5rem;
    backdrop-filter: blur(10px);
}

.hero-icon i {
    font-size: 2.5rem;
    color: white;
}

.breadcrumb-custom {
    background: transparent;
    padding: 0;
    margin: 0;
}

.breadcrumb-custom .breadcrumb-item a {
    color: rgba(255,255,255,0.7);
    text-decoration: none;
    transition: color 0.3s ease;
}

.breadcrumb-custom .breadcrumb-item a:hover {
    color: white;
}

.breadcrumb-custom .breadcrumb-item.active {
    color: white;
}

.breadcrumb-custom .breadcrumb-item + .breadcrumb-item::before {
    color: rgba(255,255,255,0.5);
}

.section-badge {
    display: inline-block;
    background: rgba(255,255,255,0.2);
    backdrop-filter: blur(10px);
    color: white;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
}

/* =========================================
   TERMS SECTION
   ========================================= */
.terms-section {
    background: linear-gradient(180deg, #fff 0%, var(--tsa-light) 100%);
}

.update-badge {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    background: white;
    padding: 0.75rem 1.25rem;
    border-radius: 50px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
    font-size: 0.9rem;
    color: #666;
}

.update-badge i {
    color: var(--tsa-primary);
}

/* Terms Card */
.terms-card {
    background: white;
    border-radius: 25px;
    box-shadow: 0 20px 60px rgba(0,0,0,0.1);
    overflow: hidden;
}

/* Table of Contents */
.toc-section {
    background: linear-gradient(135deg, var(--tsa-light), #fff);
    padding: 2rem;
    border-bottom: 2px solid #f0f0f0;
}

.toc-section h5 {
    font-weight: 700;
    color: #333;
    margin-bottom: 1.25rem;
}

.toc-grid {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 1rem;
}

.toc-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 0.875rem 1rem;
    background: white;
    border-radius: 12px;
    text-decoration: none;
    transition: all 0.3s ease;
    border: 2px solid transparent;
}

.toc-item:hover {
    border-color: var(--tsa-primary);
    transform: translateY(-3px);
    box-shadow: 0 5px 20px rgba(242, 97, 36, 0.15);
}

.toc-number {
    width: 35px;
    height: 35px;
    min-width: 35px;
    background: var(--tsa-gradient);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: 700;
    font-size: 0.85rem;
}

.toc-title {
    font-weight: 500;
    color: #333;
    font-size: 0.9rem;
}

/* Terms Content */
.terms-content {
    padding: 2rem;
}

.terms-section-item {
    margin-bottom: 2.5rem;
    padding-bottom: 2.5rem;
    border-bottom: 1px solid #f0f0f0;
}

.terms-section-item:last-child {
    margin-bottom: 0;
    padding-bottom: 0;
    border-bottom: none;
}

.section-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 1.25rem;
}

.section-number {
    width: 50px;
    height: 50px;
    min-width: 50px;
    background: var(--tsa-gradient);
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: 700;
    font-size: 1.1rem;
}

.section-header h4 {
    font-weight: 700;
    color: #333;
    margin: 0;
}

.section-body {
    padding-left: 66px;
}

.section-body p {
    color: #555;
    line-height: 1.8;
    margin-bottom: 1rem;
}

.section-body p:last-child {
    margin-bottom: 0;
}

/* Terms List */
.terms-list {
    list-style: none;
    padding: 0;
    margin: 1rem 0;
}

.terms-list li {
    display: flex;
    align-items: flex-start;
    gap: 0.75rem;
    padding: 0.75rem 1rem;
    background: #f8f9fa;
    border-radius: 10px;
    margin-bottom: 0.5rem;
    color: #555;
}

.terms-list li i {
    color: #dc3545;
    margin-top: 0.2rem;
}

.terms-list.check li i {
    color: var(--tsa-primary);
}

/* Highlight Box */
.highlight-box {
    display: flex;
    align-items: flex-start;
    gap: 1rem;
    background: linear-gradient(135deg, rgba(242, 97, 36, 0.1), rgba(129, 5, 191, 0.1));
    padding: 1.25rem 1.5rem;
    border-radius: 15px;
    border-left: 4px solid var(--tsa-primary);
    margin-top: 1rem;
}

.highlight-box.warning {
    background: linear-gradient(135deg, rgba(255, 193, 7, 0.1), rgba(255, 193, 7, 0.05));
    border-left-color: #ffc107;
}

.highlight-box i {
    font-size: 1.25rem;
    color: var(--tsa-primary);
    margin-top: 0.2rem;
}

.highlight-box.warning i {
    color: #ffc107;
}

.highlight-box p {
    margin: 0;
    color: #555;
    font-size: 0.95rem;
}

/* Revision Notice */
.revision-notice {
    display: flex;
    align-items: center;
    gap: 1rem;
    background: var(--tsa-light);
    padding: 1.25rem 1.5rem;
    border-radius: 15px;
    margin-top: 1rem;
}

.revision-icon {
    width: 50px;
    height: 50px;
    min-width: 50px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.25rem;
}

.revision-content h6 {
    font-weight: 600;
    color: #333;
    margin-bottom: 0.25rem;
}

.revision-content p {
    margin: 0;
    color: #666;
    font-size: 0.9rem;
}

/* Contact Cards */
.contact-cards {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1rem;
    margin-top: 1.5rem;
}

.contact-card {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1.25rem;
    background: #f8f9fa;
    border-radius: 15px;
    transition: all 0.3s ease;
}

.contact-card:hover {
    background: var(--tsa-light);
    transform: translateY(-3px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.contact-card .contact-icon {
    width: 50px;
    height: 50px;
    min-width: 50px;
    background: var(--tsa-gradient);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.2rem;
}

.contact-card .contact-info {
    display: flex;
    flex-direction: column;
}

.contact-card .contact-info span {
    font-size: 0.75rem;
    color: #888;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.contact-card .contact-info a,
.contact-card .contact-info p {
    font-weight: 600;
    color: #333;
    text-decoration: none;
    margin: 0;
    font-size: 0.95rem;
    transition: color 0.3s ease;
}

.contact-card .contact-info a:hover {
    color: var(--tsa-primary);
}

/* Related Links */
.related-links {
    margin-top: 2.5rem;
}

.related-links h5 {
    font-weight: 700;
    color: #333;
    margin-bottom: 1.25rem;
}

.links-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 1rem;
}

.link-card {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1.25rem 1.5rem;
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.08);
    text-decoration: none;
    transition: all 0.3s ease;
}

.link-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 40px rgba(0,0,0,0.12);
}

.link-card i {
    width: 45px;
    height: 45px;
    background: var(--tsa-gradient);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.1rem;
}

.link-card span {
    font-weight: 600;
    color: #333;
}

/* =========================================
   RESPONSIVE STYLES
   ========================================= */
@media (max-width: 991px) {
    .terms-hero {
        padding: 80px 0 60px;
    }
    
    .terms-hero h1 {
        font-size: 2rem;
    }
    
    .toc-grid {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .links-grid {
        grid-template-columns: repeat(3, 1fr);
    }
}

@media (max-width: 768px) {
    .terms-hero {
        padding: 70px 0 50px;
    }
    
    .terms-hero h1 {
        font-size: 1.75rem;
    }
    
    .hero-icon {
        width: 70px;
        height: 70px;
    }
    
    .hero-icon i {
        font-size: 2rem;
    }
    
    .toc-grid {
        grid-template-columns: 1fr;
    }
    
    .toc-section,
    .terms-content {
        padding: 1.5rem;
    }
    
    .section-body {
        padding-left: 0;
        margin-top: 1rem;
    }
    
    .section-header {
        flex-direction: column;
        align-items: flex-start;
        text-align: left;
    }
    
    .contact-cards {
        grid-template-columns: 1fr;
    }
    
    .links-grid {
        grid-template-columns: 1fr;
    }
}
</style>

<script>
// Smooth scroll to sections
document.querySelectorAll('.toc-item').forEach(function(link) {
    link.addEventListener('click', function(e) {
        e.preventDefault();
        var targetId = this.getAttribute('href');
        var targetElement = document.querySelector(targetId);
        
        if (targetElement) {
            var headerOffset = 100;
            var elementPosition = targetElement.getBoundingClientRect().top;
            var offsetPosition = elementPosition + window.pageYOffset - headerOffset;
            
            window.scrollTo({
                top: offsetPosition,
                behavior: 'smooth'
            });
        }
    });
});
</script>