<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="container py-5">
    <div class="text-center mb-5">
        <h2 class="fw-bold">Thank You to Our Partners</h2>
        <p class="lead text-muted">Working together to create lasting change in our community</p>
    </div>
    
    <?php 
    $type_labels = [
        'corporate' => 'Corporate Partners',
        'ngo' => 'NGO Partners',
        'government' => 'Government Agencies',
        'academic' => 'Academic Institutions',
        'individual' => 'Individual Sponsors'
    ];
    ?>
    
    <?php foreach ($partners_by_type as $type => $partners_list): ?>
        <?php if (!empty($partners_list)): ?>
            <section class="mb-5">
                <h3 class="fw-bold mb-4 text-primary"><?php echo $type_labels[$type]; ?></h3>
                <div class="row align-items-center">
                    <?php foreach ($partners_list as $partner): ?>
                        <div class="col-lg-3 col-md-4 col-6 mb-4 text-center">
                            <div class="partner-logo-wrapper p-3">
                                <?php if (!empty($partner->logo)): ?>
                                    <img src="<?php echo base_url('uploads/partners/' . $partner->logo); ?>" 
                                         alt="<?php echo htmlspecialchars($partner->name); ?>"
                                         class="img-fluid partner-logo"
                                         style="max-height: 100px; opacity: 0.7;">
                                <?php else: ?>
                                    <div class="text-center">
                                        <i class="fas fa-building fa-3x text-muted mb-2"></i>
                                        <p class="small fw-bold mb-0"><?php echo htmlspecialchars($partner->name); ?></p>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if (!empty($partner->website)): ?>
                                    <div class="mt-2">
                                        <a href="<?php echo htmlspecialchars($partner->website); ?>" 
                                           target="_blank" 
                                           rel="noopener"
                                           class="btn btn-sm btn-outline-primary">
                                            Visit Website
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </section>
        <?php endif; ?>
    <?php endforeach; ?>
    
    <?php if ($total_partners == 0): ?>
        <div class="text-center py-5">
            <i class="fas fa-handshake fa-4x text-muted mb-3"></i>
            <h4 class="text-muted">No Partners Yet</h4>
            <p class="text-muted">We're always looking for partners to support our mission.</p>
        </div>
    <?php endif; ?>
    
    <div class="text-center mt-5 p-5 bg-light rounded">
        <h3 class="fw-bold mb-3">Become a Partner</h3>
        <p class="lead text-muted mb-4">Interested in partnering with us?</p>
        <a href="<?php echo base_url('contact'); ?>" class="btn btn-primary btn-lg">
            <i class="fas fa-envelope"></i> Get in Touch
        </a>
    </div>
</div>

<style>
.partner-logo {
    transition: opacity 0.3s;
}
.partner-logo:hover {
    opacity: 1 !important;
}
</style>