<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Volunteer Hero Banner -->
<section class="volunteer-hero">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8 mx-auto text-center">
                <div class="hero-icon">
                    <i class="fas fa-hands-helping"></i>
                </div>
                <span class="section-badge mb-3">
                    <i class="fas fa-heart me-2"></i>Join Our Team
                </span>
                <h1 class="display-5 fw-bold text-white mb-3">Volunteer With Us</h1>
                <p class="lead text-white-50 mb-0">Make a difference in children's lives by sharing your time, skills, and passion for education.</p>
            </div>
        </div>
    </div>
</section>

<!-- Flash Messages -->
<div class="container mt-n4 position-relative" style="z-index: 10;">
    <?php if ($this->session->flashdata('success')): ?>
        <div class="alert alert-success alert-dismissible fade show alert-custom" role="alert">
            <div class="alert-icon">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="alert-content">
                <strong>Success!</strong> <?php echo $this->session->flashdata('success'); ?>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if ($this->session->flashdata('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show alert-custom" role="alert">
            <div class="alert-icon">
                <i class="fas fa-exclamation-circle"></i>
            </div>
            <div class="alert-content">
                <strong>Error!</strong> <?php echo $this->session->flashdata('error'); ?>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if ($this->session->flashdata('warning')): ?>
        <div class="alert alert-warning alert-dismissible fade show alert-custom" role="alert">
            <div class="alert-icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <div class="alert-content">
                <strong>Warning!</strong> <?php echo $this->session->flashdata('warning'); ?>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if ($this->session->flashdata('info')): ?>
        <div class="alert alert-info alert-dismissible fade show alert-custom" role="alert">
            <div class="alert-icon">
                <i class="fas fa-info-circle"></i>
            </div>
            <div class="alert-content">
                <strong>Info:</strong> <?php echo $this->session->flashdata('info'); ?>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
</div>

<!-- Main Application Section -->
<section class="py-5 application-section">
    <div class="container">
        <div class="row">
            <!-- Application Form -->
            <div class="col-lg-8">
                <div class="application-card">
                    <!-- Form Header -->
                    <div class="form-header">
                        <h2 class="form-title">Volunteer Application Form</h2>
                        <p class="form-subtitle">Fill out the form below to join our volunteer team. Fields marked with <span class="text-danger">*</span> are required.</p>
                    </div>
                    
                    <!-- Progress Steps -->
                    <div class="progress-steps">
                        <div class="step active" data-step="1">
                            <div class="step-icon">
                                <i class="fas fa-user"></i>
                            </div>
                            <span class="step-label">Personal</span>
                        </div>
                        <div class="step-line"></div>
                        <div class="step" data-step="2">
                            <div class="step-icon">
                                <i class="fas fa-briefcase"></i>
                            </div>
                            <span class="step-label">Professional</span>
                        </div>
                        <div class="step-line"></div>
                        <div class="step" data-step="3">
                            <div class="step-icon">
                                <i class="fas fa-phone-alt"></i>
                            </div>
                            <span class="step-label">Emergency</span>
                        </div>
                    </div>
                    
                    <?php echo form_open_multipart('volunteer/submit', array('id' => 'volunteerForm', 'class' => 'volunteer-form')); ?>
                        
                        <!-- Section 1: Personal Information -->
                        <div class="form-section" id="section-1">
                            <div class="section-header">
                                <div class="section-icon">
                                    <i class="fas fa-user"></i>
                                </div>
                                <div>
                                    <h4 class="section-title">Personal Information</h4>
                                    <p class="section-subtitle">Tell us about yourself</p>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <div class="form-floating-custom">
                                        <label class="form-label">Full Name <span class="text-danger">*</span></label>
                                        <div class="input-icon-wrapper">
                                            <i class="fas fa-user"></i>
                                            <input type="text" class="form-control" name="full_name" 
                                                   value="<?php echo set_value('full_name'); ?>" 
                                                   placeholder="Enter your full name" required>
                                        </div>
                                        <?php echo form_error('full_name', '<small class="text-danger">', '</small>'); ?>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <div class="form-floating-custom">
                                        <label class="form-label">Email Address <span class="text-danger">*</span></label>
                                        <div class="input-icon-wrapper">
                                            <i class="fas fa-envelope"></i>
                                            <input type="email" class="form-control" name="email" 
                                                   value="<?php echo set_value('email'); ?>" 
                                                   placeholder="your@email.com" required>
                                        </div>
                                        <?php echo form_error('email', '<small class="text-danger">', '</small>'); ?>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <div class="form-floating-custom">
                                        <label class="form-label">Phone Number <span class="text-danger">*</span></label>
                                        <div class="input-icon-wrapper">
                                            <i class="fas fa-phone"></i>
                                            <input type="tel" class="form-control" name="phone" 
                                                   value="<?php echo set_value('phone'); ?>" 
                                                   placeholder="+233 XX XXX XXXX" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <div class="form-floating-custom">
                                        <label class="form-label">Date of Birth</label>
                                        <div class="input-icon-wrapper">
                                            <i class="fas fa-calendar"></i>
                                            <input type="date" class="form-control" name="date_of_birth" 
                                                   value="<?php echo set_value('date_of_birth'); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-4">
                                <div class="form-floating-custom">
                                    <label class="form-label">Address <span class="text-danger">*</span></label>
                                    <div class="input-icon-wrapper textarea">
                                        <i class="fas fa-map-marker-alt"></i>
                                        <textarea class="form-control" name="address" rows="2" 
                                                  placeholder="Enter your full address" required><?php echo set_value('address'); ?></textarea>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <div class="form-floating-custom">
                                        <label class="form-label">City <span class="text-danger">*</span></label>
                                        <div class="input-icon-wrapper">
                                            <i class="fas fa-city"></i>
                                            <input type="text" class="form-control" name="city" 
                                                   value="<?php echo set_value('city'); ?>" 
                                                   placeholder="e.g., Accra" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <div class="form-floating-custom">
                                        <label class="form-label">Country</label>
                                        <div class="input-icon-wrapper">
                                            <i class="fas fa-globe-africa"></i>
                                            <input type="text" class="form-control" name="country" 
                                                   value="<?php echo set_value('country', 'Ghana'); ?>" 
                                                   placeholder="Ghana">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Section 2: Professional Information -->
                        <div class="form-section" id="section-2">
                            <div class="section-header">
                                <div class="section-icon">
                                    <i class="fas fa-briefcase"></i>
                                </div>
                                <div>
                                    <h4 class="section-title">Professional Information</h4>
                                    <p class="section-subtitle">Your skills and experience</p>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <div class="form-floating-custom">
                                        <label class="form-label">Occupation <span class="text-danger">*</span></label>
                                        <div class="input-icon-wrapper">
                                            <i class="fas fa-briefcase"></i>
                                            <input type="text" class="form-control" name="occupation" 
                                                   value="<?php echo set_value('occupation'); ?>" 
                                                   placeholder="e.g., Teacher, Engineer" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <div class="form-floating-custom">
                                        <label class="form-label">Skills <span class="text-danger">*</span></label>
                                        <div class="input-icon-wrapper">
                                            <i class="fas fa-star"></i>
                                            <input type="text" class="form-control" name="skills" 
                                                   value="<?php echo set_value('skills'); ?>" 
                                                   placeholder="e.g., Teaching, Event Planning" required>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-4">
                                <div class="form-floating-custom">
                                    <label class="form-label">Availability <span class="text-danger">*</span></label>
                                    <div class="availability-options">
                                        <label class="availability-option">
                                            <input type="radio" name="availability" value="weekdays" 
                                                   <?php echo set_radio('availability', 'weekdays'); ?> required>
                                            <span class="option-card">
                                                <i class="fas fa-building"></i>
                                                <span class="option-label">Weekdays</span>
                                                <span class="option-desc">Mon - Fri</span>
                                            </span>
                                        </label>
                                        <label class="availability-option">
                                            <input type="radio" name="availability" value="weekends" 
                                                   <?php echo set_radio('availability', 'weekends'); ?>>
                                            <span class="option-card">
                                                <i class="fas fa-sun"></i>
                                                <span class="option-label">Weekends</span>
                                                <span class="option-desc">Sat - Sun</span>
                                            </span>
                                        </label>
                                        <label class="availability-option">
                                            <input type="radio" name="availability" value="both" 
                                                   <?php echo set_radio('availability', 'both'); ?>>
                                            <span class="option-card">
                                                <i class="fas fa-calendar-week"></i>
                                                <span class="option-label">Both</span>
                                                <span class="option-desc">Any day</span>
                                            </span>
                                        </label>
                                        <label class="availability-option">
                                            <input type="radio" name="availability" value="flexible" 
                                                   <?php echo set_radio('availability', 'flexible'); ?>>
                                            <span class="option-card">
                                                <i class="fas fa-clock"></i>
                                                <span class="option-label">Flexible</span>
                                                <span class="option-desc">As needed</span>
                                            </span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-4">
                                <div class="form-floating-custom">
                                    <label class="form-label">Areas of Interest <span class="text-danger">*</span></label>
                                    <div class="input-icon-wrapper textarea">
                                        <i class="fas fa-heart"></i>
                                        <textarea class="form-control" name="areas_of_interest" rows="3" 
                                                  placeholder="What areas would you like to volunteer in? (e.g., Teaching French, Event coordination, Administrative support)" required><?php echo set_value('areas_of_interest'); ?></textarea>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-4">
                                <div class="form-floating-custom">
                                    <label class="form-label">Previous Volunteer Experience</label>
                                    <div class="input-icon-wrapper textarea">
                                        <i class="fas fa-history"></i>
                                        <textarea class="form-control" name="previous_experience" rows="3" 
                                                  placeholder="Tell us about any previous volunteer work you've done (optional)"><?php echo set_value('previous_experience'); ?></textarea>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-4">
                                <div class="form-floating-custom">
                                    <label class="form-label">Why do you want to volunteer? <span class="text-danger">*</span></label>
                                    <div class="input-icon-wrapper textarea">
                                        <i class="fas fa-comment-dots"></i>
                                        <textarea class="form-control" name="motivation" rows="4" 
                                                  placeholder="Share your motivation for wanting to volunteer with The Skills Atelier" required><?php echo set_value('motivation'); ?></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Section 3: Emergency Contact -->
                        <div class="form-section" id="section-3">
                            <div class="section-header">
                                <div class="section-icon emergency">
                                    <i class="fas fa-phone-alt"></i>
                                </div>
                                <div>
                                    <h4 class="section-title">Emergency Contact</h4>
                                    <p class="section-subtitle">Someone we can contact in case of emergency</p>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <div class="form-floating-custom">
                                        <label class="form-label">Contact Name <span class="text-danger">*</span></label>
                                        <div class="input-icon-wrapper">
                                            <i class="fas fa-user-friends"></i>
                                            <input type="text" class="form-control" name="emergency_contact_name" 
                                                   value="<?php echo set_value('emergency_contact_name'); ?>" 
                                                   placeholder="Full name of emergency contact" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <div class="form-floating-custom">
                                        <label class="form-label">Contact Phone <span class="text-danger">*</span></label>
                                        <div class="input-icon-wrapper">
                                            <i class="fas fa-phone"></i>
                                            <input type="tel" class="form-control" name="emergency_contact_phone" 
                                                   value="<?php echo set_value('emergency_contact_phone'); ?>" 
                                                   placeholder="+233 XX XXX XXXX" required>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-4">
                                <div class="form-floating-custom">
                                    <label class="form-label">Profile Photo <span class="text-muted">(Optional)</span></label>
                                    <div class="file-upload-wrapper">
                                        <div class="file-upload-area" id="fileUploadArea">
                                            <input type="file" class="file-input" name="profile_photo" 
                                                   id="profilePhoto" accept="image/*">
                                            <div class="upload-content">
                                                <div class="upload-icon">
                                                    <i class="fas fa-cloud-upload-alt"></i>
                                                </div>
                                                <p class="upload-text">
                                                    <span class="upload-link">Click to upload</span> or drag and drop
                                                </p>
                                                <p class="upload-hint">JPG, PNG - Max 2MB</p>
                                            </div>
                                            <div class="upload-preview" id="uploadPreview" style="display: none;">
                                                <img src="" alt="Preview" id="previewImage">
                                                <button type="button" class="remove-image" id="removeImage">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Terms & Submit -->
                        <div class="form-section submit-section">
                            <div class="terms-checkbox">
                                <label class="custom-checkbox">
                                    <input type="checkbox" name="terms" required>
                                    <span class="checkmark"></span>
                                    <span class="checkbox-label">
                                        I agree to the <a href="<?php echo base_url('terms'); ?>" target="_blank">Terms of Service</a> 
                                        and <a href="<?php echo base_url('privacy'); ?>" target="_blank">Privacy Policy</a>
                                    </span>
                                </label>
                            </div>
                            
                            <button type="submit" class="btn btn-submit">
                                <span class="btn-text">
                                    <i class="fas fa-paper-plane me-2"></i>Submit Application
                                </span>
                                <span class="btn-loading" style="display: none;">
                                    <i class="fas fa-spinner fa-spin me-2"></i>Submitting...
                                </span>
                            </button>
                            
                            <p class="submit-note">
                                <i class="fas fa-shield-alt me-1"></i>
                                Your information is secure and will only be used for volunteer coordination.
                            </p>
                        </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
            
            <!-- Sidebar -->
            <div class="col-lg-4">
                <aside class="sidebar">
                    <!-- Why Volunteer Widget -->
                    <div class="sidebar-widget why-widget">
                        <h5 class="widget-title"><i class="fas fa-question-circle me-2"></i>Why Volunteer?</h5>
                        <ul class="why-list">
                            <li>
                                <div class="why-icon"><i class="fas fa-heart"></i></div>
                                <div class="why-content">
                                    <h6>Make an Impact</h6>
                                    <p>Help children discover the joy of learning French</p>
                                </div>
                            </li>
                            <li>
                                <div class="why-icon"><i class="fas fa-users"></i></div>
                                <div class="why-content">
                                    <h6>Join a Community</h6>
                                    <p>Connect with like-minded passionate individuals</p>
                                </div>
                            </li>
                            <li>
                                <div class="why-icon"><i class="fas fa-graduation-cap"></i></div>
                                <div class="why-content">
                                    <h6>Grow Your Skills</h6>
                                    <p>Develop teaching and leadership abilities</p>
                                </div>
                            </li>
                            <li>
                                <div class="why-icon"><i class="fas fa-certificate"></i></div>
                                <div class="why-content">
                                    <h6>Get Recognized</h6>
                                    <p>Receive certificates and recommendations</p>
                                </div>
                            </li>
                        </ul>
                    </div>
                    
                    <!-- Volunteer Roles Widget -->
                    <div class="sidebar-widget roles-widget">
                        <h5 class="widget-title"><i class="fas fa-tasks me-2"></i>Volunteer Roles</h5>
                        <div class="roles-list">
                            <div class="role-item">
                                <i class="fas fa-chalkboard-teacher"></i>
                                <span>Teaching Assistant</span>
                            </div>
                            <div class="role-item">
                                <i class="fas fa-calendar-check"></i>
                                <span>Event Coordinator</span>
                            </div>
                            <div class="role-item">
                                <i class="fas fa-camera"></i>
                                <span>Photography/Media</span>
                            </div>
                            <div class="role-item">
                                <i class="fas fa-bullhorn"></i>
                                <span>Marketing & Outreach</span>
                            </div>
                            <div class="role-item">
                                <i class="fas fa-laptop"></i>
                                <span>Administrative Support</span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Contact Widget -->
                    <div class="sidebar-widget contact-widget">
                        <div class="contact-icon">
                            <i class="fas fa-headset"></i>
                        </div>
                        <h5 class="widget-title">Have Questions?</h5>
                        <p>We're here to help! Reach out to us for more information about volunteering.</p>
                        <a href="https://wa.me/233500557751?text=Hi!%20I%20have%20questions%20about%20volunteering" 
                           target="_blank" 
                           class="btn btn-whatsapp w-100">
                            <i class="fab fa-whatsapp me-2"></i>Chat on WhatsApp
                        </a>
                    </div>
                    
                    <!-- Current Volunteers Widget -->
                    <div class="sidebar-widget stats-widget">
                        <div class="stats-grid">
                            <div class="stat-item">
                                <span class="stat-number">10+</span>
                                <span class="stat-label">Active Volunteers</span>
                            </div>
                            <div class="stat-item">
                                <span class="stat-number">50+</span>
                                <span class="stat-label">Kids Helped</span>
                            </div>
                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </div>
</section>

<style>
/* =========================================
   THE SKILLS ATELIER - VOLUNTEER PAGE STYLES
   Primary: #f26124 (Orange)
   Secondary: #8105bf (Purple)
   ========================================= */

:root {
    --tsa-primary: #f26124;
    --tsa-primary-dark: #d94f15;
    --tsa-secondary: #8105bf;
    --tsa-secondary-dark: #6a049e;
    --tsa-light: #fff8f5;
    --tsa-cream: #f7e1b0;
    --tsa-gradient: linear-gradient(135deg, #f26124, #8105bf);
    --tsa-gradient-reverse: linear-gradient(135deg, #8105bf, #f26124);
}

/* =========================================
   VOLUNTEER HERO
   ========================================= */
.volunteer-hero {
    background: var(--tsa-gradient);
    padding: 100px 0 80px;
    position: relative;
    overflow: hidden;
}

.volunteer-hero::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E") repeat;
}

.hero-icon {
    width: 100px;
    height: 100px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1.5rem;
    font-size: 2.5rem;
    color: white;
    backdrop-filter: blur(10px);
}

.section-badge {
    display: inline-block;
    background: rgba(255,255,255,0.2);
    backdrop-filter: blur(10px);
    color: white;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
}

/* =========================================
   ALERT CUSTOM STYLES
   ========================================= */
.alert-custom {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem 1.5rem;
    border-radius: 15px;
    border: none;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.alert-icon {
    width: 45px;
    height: 45px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
}

.alert-success .alert-icon { background: rgba(40, 167, 69, 0.2); color: #28a745; }
.alert-danger .alert-icon { background: rgba(220, 53, 69, 0.2); color: #dc3545; }
.alert-warning .alert-icon { background: rgba(255, 193, 7, 0.2); color: #856404; }
.alert-info .alert-icon { background: rgba(23, 162, 184, 0.2); color: #17a2b8; }

/* =========================================
   APPLICATION SECTION
   ========================================= */
.application-section {
    background: linear-gradient(180deg, var(--tsa-light) 0%, #fff 100%);
}

.application-card {
    background: white;
    border-radius: 25px;
    box-shadow: 0 20px 60px rgba(0,0,0,0.1);
    overflow: hidden;
}

/* Form Header */
.form-header {
    background: var(--tsa-gradient);
    padding: 2rem 2.5rem;
    color: white;
    text-align: center;
}

.form-title {
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.form-subtitle {
    opacity: 0.9;
    margin: 0;
}

/* Progress Steps */
.progress-steps {
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 2rem;
    background: #fafafa;
    border-bottom: 1px solid #f0f0f0;
}

.step {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 0.5rem;
}

.step-icon {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    background: #e9ecef;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #adb5bd;
    font-size: 1.1rem;
    transition: all 0.3s ease;
}

.step.active .step-icon {
    background: var(--tsa-gradient);
    color: white;
    box-shadow: 0 5px 20px rgba(242, 97, 36, 0.4);
}

.step-label {
    font-size: 0.85rem;
    font-weight: 600;
    color: #adb5bd;
}

.step.active .step-label {
    color: var(--tsa-primary);
}

.step-line {
    width: 80px;
    height: 3px;
    background: #e9ecef;
    margin: 0 1rem;
    margin-bottom: 1.5rem;
    border-radius: 3px;
}

/* Form Sections */
.form-section {
    padding: 2rem 2.5rem;
    border-bottom: 1px solid #f0f0f0;
}

.section-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 2rem;
}

.section-icon {
    width: 55px;
    height: 55px;
    background: var(--tsa-gradient);
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.3rem;
}

.section-icon.emergency {
    background: linear-gradient(135deg, #dc3545, #c82333);
}

.section-title {
    font-weight: 700;
    margin-bottom: 0.25rem;
    color: #333;
}

.section-subtitle {
    color: #888;
    font-size: 0.9rem;
    margin: 0;
}

/* Form Inputs */
.form-floating-custom {
    margin-bottom: 0;
}

.form-label {
    font-weight: 600;
    color: #333;
    margin-bottom: 0.5rem;
    font-size: 0.95rem;
}

.input-icon-wrapper {
    position: relative;
}

.input-icon-wrapper i {
    position: absolute;
    left: 1rem;
    top: 50%;
    transform: translateY(-50%);
    color: #adb5bd;
    font-size: 1rem;
    z-index: 1;
    transition: color 0.3s ease;
}

.input-icon-wrapper.textarea i {
    top: 1.25rem;
    transform: none;
}

.input-icon-wrapper .form-control {
    padding-left: 3rem;
    border: 2px solid #e9ecef;
    border-radius: 12px;
    height: auto;
    padding-top: 0.875rem;
    padding-bottom: 0.875rem;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.input-icon-wrapper .form-control:focus {
    border-color: var(--tsa-primary);
    box-shadow: 0 0 0 4px rgba(242, 97, 36, 0.1);
}

.input-icon-wrapper .form-control:focus + i,
.input-icon-wrapper:focus-within i {
    color: var(--tsa-primary);
}

.input-icon-wrapper textarea.form-control {
    min-height: 100px;
}

/* Availability Options */
.availability-options {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 1rem;
}

.availability-option {
    cursor: pointer;
}

.availability-option input {
    display: none;
}

.option-card {
    display: flex;
    flex-direction: column;
    align-items: center;
    padding: 1.25rem 1rem;
    background: #f8f9fa;
    border: 2px solid #e9ecef;
    border-radius: 15px;
    text-align: center;
    transition: all 0.3s ease;
}

.availability-option input:checked + .option-card {
    background: var(--tsa-light);
    border-color: var(--tsa-primary);
    box-shadow: 0 5px 20px rgba(242, 97, 36, 0.15);
}

.option-card i {
    font-size: 1.5rem;
    color: #adb5bd;
    margin-bottom: 0.5rem;
    transition: color 0.3s ease;
}

.availability-option input:checked + .option-card i {
    color: var(--tsa-primary);
}

.option-label {
    font-weight: 600;
    color: #333;
    font-size: 0.9rem;
}

.option-desc {
    font-size: 0.75rem;
    color: #888;
}

/* File Upload */
.file-upload-area {
    position: relative;
    border: 2px dashed #e9ecef;
    border-radius: 15px;
    padding: 2rem;
    text-align: center;
    transition: all 0.3s ease;
    cursor: pointer;
}

.file-upload-area:hover,
.file-upload-area.dragover {
    border-color: var(--tsa-primary);
    background: var(--tsa-light);
}

.file-input {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    opacity: 0;
    cursor: pointer;
}

.upload-icon {
    width: 70px;
    height: 70px;
    background: var(--tsa-light);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
    font-size: 1.8rem;
    color: var(--tsa-primary);
}

.upload-text {
    color: #666;
    margin-bottom: 0.5rem;
}

.upload-link {
    color: var(--tsa-primary);
    font-weight: 600;
}

.upload-hint {
    font-size: 0.85rem;
    color: #adb5bd;
    margin: 0;
}

.upload-preview {
    position: relative;
    display: inline-block;
}

.upload-preview img {
    width: 150px;
    height: 150px;
    object-fit: cover;
    border-radius: 15px;
}

.remove-image {
    position: absolute;
    top: -10px;
    right: -10px;
    width: 30px;
    height: 30px;
    background: #dc3545;
    border: none;
    border-radius: 50%;
    color: white;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
}

/* Terms Checkbox */
.terms-checkbox {
    margin-bottom: 1.5rem;
}

.custom-checkbox {
    display: flex;
    align-items: flex-start;
    gap: 0.75rem;
    cursor: pointer;
}

.custom-checkbox input {
    display: none;
}

.checkmark {
    width: 24px;
    height: 24px;
    min-width: 24px;
    border: 2px solid #e9ecef;
    border-radius: 6px;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
}

.custom-checkbox input:checked + .checkmark {
    background: var(--tsa-gradient);
    border-color: var(--tsa-primary);
}

.custom-checkbox input:checked + .checkmark::after {
    content: '\f00c';
    font-family: 'Font Awesome 5 Free';
    font-weight: 900;
    color: white;
    font-size: 0.8rem;
}

.checkbox-label {
    color: #666;
    font-size: 0.95rem;
    line-height: 1.5;
}

.checkbox-label a {
    color: var(--tsa-primary);
    font-weight: 600;
}

/* Submit Button */
.submit-section {
    text-align: center;
    border-bottom: none;
}

.btn-submit {
    background: var(--tsa-gradient);
    border: none;
    color: white;
    font-weight: 600;
    font-size: 1.1rem;
    padding: 1rem 3rem;
    border-radius: 50px;
    transition: all 0.3s ease;
    box-shadow: 0 10px 30px rgba(242, 97, 36, 0.3);
}

.btn-submit:hover {
    background: var(--tsa-gradient-reverse);
    transform: translateY(-3px);
    box-shadow: 0 15px 40px rgba(242, 97, 36, 0.4);
    color: white;
}

.submit-note {
    margin-top: 1.5rem;
    color: #888;
    font-size: 0.85rem;
}

.submit-note i {
    color: #28a745;
}

/* =========================================
   SIDEBAR
   ========================================= */
.sidebar {
    position: sticky;
    top: 100px;
}

.sidebar-widget {
    background: white;
    border-radius: 20px;
    padding: 1.5rem;
    margin-bottom: 1.5rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
}

.widget-title {
    font-weight: 700;
    color: #333;
    margin-bottom: 1.25rem;
    padding-bottom: 0.75rem;
    border-bottom: 2px solid #f0f0f0;
}

/* Why Volunteer Widget */
.why-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.why-list li {
    display: flex;
    gap: 1rem;
    padding: 1rem 0;
    border-bottom: 1px solid #f0f0f0;
}

.why-list li:last-child {
    border-bottom: none;
    padding-bottom: 0;
}

.why-icon {
    width: 45px;
    height: 45px;
    min-width: 45px;
    background: var(--tsa-light);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--tsa-primary);
    font-size: 1.1rem;
}

.why-content h6 {
    font-weight: 600;
    margin-bottom: 0.25rem;
    color: #333;
}

.why-content p {
    font-size: 0.85rem;
    color: #888;
    margin: 0;
}

/* Roles Widget */
.roles-list {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.role-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 0.75rem 1rem;
    background: var(--tsa-light);
    border-radius: 10px;
    font-size: 0.9rem;
    font-weight: 500;
    color: #555;
    transition: all 0.3s ease;
}

.role-item:hover {
    background: var(--tsa-primary);
    color: white;
    transform: translateX(5px);
}

.role-item i {
    color: var(--tsa-primary);
    width: 20px;
}

.role-item:hover i {
    color: white;
}

/* Contact Widget */
.contact-widget {
    background: var(--tsa-gradient);
    text-align: center;
    padding: 2rem;
}

.contact-widget .contact-icon {
    width: 70px;
    height: 70px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
    font-size: 1.8rem;
    color: white;
}

.contact-widget .widget-title {
    color: white;
    border-bottom: none;
    padding-bottom: 0;
    margin-bottom: 0.5rem;
}

.contact-widget p {
    color: rgba(255,255,255,0.85);
    font-size: 0.95rem;
    margin-bottom: 1.25rem;
}

.btn-whatsapp {
    background: white;
    color: #25d366;
    font-weight: 600;
    padding: 0.875rem 1.5rem;
    border-radius: 50px;
    border: none;
    transition: all 0.3s ease;
}

.btn-whatsapp:hover {
    background: #25d366;
    color: white;
    transform: translateY(-2px);
}

/* Stats Widget */
.stats-widget {
    background: var(--tsa-light);
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 1rem;
}

.stats-widget .stat-item {
    text-align: center;
    padding: 1rem;
    background: white;
    border-radius: 12px;
}

.stats-widget .stat-number {
    display: block;
    font-size: 2rem;
    font-weight: 700;
    color: var(--tsa-primary);
}

.stats-widget .stat-label {
    font-size: 0.8rem;
    color: #888;
}

/* =========================================
   RESPONSIVE STYLES
   ========================================= */
@media (max-width: 991px) {
    .volunteer-hero {
        padding: 80px 0 60px;
    }
    
    .sidebar {
        position: relative;
        top: 0;
        margin-top: 2rem;
    }
    
    .availability-options {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 768px) {
    .volunteer-hero {
        padding: 70px 0 50px;
    }
    
    .volunteer-hero h1 {
        font-size: 1.75rem;
    }
    
    .hero-icon {
        width: 80px;
        height: 80px;
        font-size: 2rem;
    }
    
    .progress-steps {
        display: none;
    }
    
    .form-header,
    .form-section {
        padding: 1.5rem;
    }
    
    .section-header {
        flex-direction: column;
        text-align: center;
    }
    
    .availability-options {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .option-card {
        padding: 1rem;
    }
    
    .btn-submit {
        width: 100%;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // File Upload Preview
    const fileInput = document.getElementById('profilePhoto');
    const uploadArea = document.getElementById('fileUploadArea');
    const uploadContent = uploadArea.querySelector('.upload-content');
    const uploadPreview = document.getElementById('uploadPreview');
    const previewImage = document.getElementById('previewImage');
    const removeBtn = document.getElementById('removeImage');
    
    fileInput.addEventListener('change', function(e) {
        if (this.files && this.files[0]) {
            const reader = new FileReader();
            reader.onload = function(e) {
                previewImage.src = e.target.result;
                uploadContent.style.display = 'none';
                uploadPreview.style.display = 'inline-block';
            };
            reader.readAsDataURL(this.files[0]);
        }
    });
    
    removeBtn.addEventListener('click', function(e) {
        e.preventDefault();
        e.stopPropagation();
        fileInput.value = '';
        uploadContent.style.display = 'block';
        uploadPreview.style.display = 'none';
    });
    
    // Drag and Drop
    uploadArea.addEventListener('dragover', function(e) {
        e.preventDefault();
        this.classList.add('dragover');
    });
    
    uploadArea.addEventListener('dragleave', function(e) {
        e.preventDefault();
        this.classList.remove('dragover');
    });
    
    uploadArea.addEventListener('drop', function(e) {
        e.preventDefault();
        this.classList.remove('dragover');
        if (e.dataTransfer.files.length) {
            fileInput.files = e.dataTransfer.files;
            const event = new Event('change');
            fileInput.dispatchEvent(event);
        }
    });
    
    // Form Submit Loading State
    const form = document.getElementById('volunteerForm');
    const submitBtn = form.querySelector('.btn-submit');
    const btnText = submitBtn.querySelector('.btn-text');
    const btnLoading = submitBtn.querySelector('.btn-loading');
    
    form.addEventListener('submit', function() {
        btnText.style.display = 'none';
        btnLoading.style.display = 'inline-block';
        submitBtn.disabled = true;
    });
    
    // Update Progress Steps on Scroll
    const sections = document.querySelectorAll('.form-section');
    const steps = document.querySelectorAll('.step');
    
    function updateProgress() {
        let currentSection = 0;
        sections.forEach((section, index) => {
            const rect = section.getBoundingClientRect();
            if (rect.top < window.innerHeight / 2) {
                currentSection = index;
            }
        });
        
        steps.forEach((step, index) => {
            if (index <= currentSection) {
                step.classList.add('active');
            } else {
                step.classList.remove('active');
            }
        });
    }
    
    window.addEventListener('scroll', updateProgress);
    updateProgress();
});
</script>