<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Workshops Hero Banner -->
<section class="workshops-hero">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <nav aria-label="breadcrumb" class="mb-3">
                    <ol class="breadcrumb breadcrumb-custom">
                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Workshops</li>
                    </ol>
                </nav>
                <span class="section-badge mb-3">
                    <i class="fas fa-chalkboard-teacher me-2"></i>Our Programmes
                </span>
                <h1 class="display-5 fw-bold text-white mb-3">Workshop Programmes</h1>
                <p class="lead text-white-50 mb-0">Discover our immersive learning experiences designed to nurture curiosity, build confidence, and develop essential skills for life.</p>
            </div>
            <div class="col-lg-4 text-lg-end mt-4 mt-lg-0">
                <div class="hero-cta">
                    <a href="<?php echo base_url('kid_registration'); ?>" class="btn btn-light btn-lg">
                        <i class="fas fa-user-plus me-2"></i>Register Now
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Workshop Stats Bar -->
<section class="workshop-stats-bar">
    <div class="container">
        <div class="stats-wrapper">
            <div class="stat-box">
                <div class="stat-icon upcoming">
                    <i class="fas fa-calendar-alt"></i>
                </div>
                <div class="stat-content">
                    <span class="stat-number"><?php echo count($upcoming_workshops ?? []); ?></span>
                    <span class="stat-label">Upcoming</span>
                </div>
            </div>
            <div class="stat-box">
                <div class="stat-icon ongoing">
                    <i class="fas fa-play-circle"></i>
                </div>
                <div class="stat-content">
                    <span class="stat-number"><?php echo count($ongoing_workshops ?? []); ?></span>
                    <span class="stat-label">Ongoing</span>
                </div>
            </div>
            <div class="stat-box">
                <div class="stat-icon completed">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="stat-content">
                    <span class="stat-number"><?php echo count($completed_workshops ?? []); ?></span>
                    <span class="stat-label">Completed</span>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Main Workshops Content -->
<section class="py-5 workshops-content-section">
    <div class="container">
        
        <!-- Upcoming Workshops -->
        <?php if (!empty($upcoming_workshops)): ?>
            <div class="workshop-section mb-5">
                <div class="section-header">
                    <div class="section-title-wrapper">
                        <div class="section-icon upcoming">
                            <i class="fas fa-calendar-alt"></i>
                        </div>
                        <div>
                            <h2 class="section-title">Upcoming Workshops</h2>
                            <p class="section-subtitle">Register now to secure your spot</p>
                        </div>
                    </div>
                    <div class="section-badge-count">
                        <span class="badge bg-warning text-dark"><?php echo count($upcoming_workshops); ?> Programme<?php echo count($upcoming_workshops) > 1 ? 's' : ''; ?></span>
                    </div>
                </div>
                
                <div class="row">
                    <?php foreach ($upcoming_workshops as $index => $workshop): ?>
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="workshop-card upcoming h-100 <?php echo ($workshop->is_featured) ? 'featured' : ''; ?>">
                                <!-- Workshop Image -->
                                <div class="workshop-image">
                                    <?php if (!empty($workshop->featured_image)): ?>
                                        <img src="<?php echo base_url('uploads/workshops/' . $workshop->featured_image); ?>" 
                                             alt="<?php echo htmlspecialchars($workshop->title); ?>">
                                    <?php else: ?>
                                        <div class="placeholder-img">
                                            <i class="fas fa-chalkboard-teacher fa-3x"></i>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <div class="workshop-badges">
                                        <span class="status-badge upcoming">Upcoming</span>
                                        <?php if ($workshop->is_featured): ?>
                                            <span class="featured-badge"><i class="fas fa-star me-1"></i>Featured</span>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <?php if (!empty($workshop->start_date)): ?>
                                        <div class="date-badge">
                                            <span class="day"><?php echo date('d', strtotime($workshop->start_date)); ?></span>
                                            <span class="month"><?php echo date('M', strtotime($workshop->start_date)); ?></span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                
                                <!-- Workshop Content -->
                                <div class="workshop-body">
                                    <h5 class="workshop-title">
                                        <?php echo htmlspecialchars($workshop->title); ?>
                                    </h5>
                                    
                                    <p class="workshop-description">
                                        <?php echo htmlspecialchars(character_limiter($workshop->description, 100)); ?>
                                    </p>
                                    
                                    <div class="workshop-meta">
                                        <?php if (!empty($workshop->duration)): ?>
                                            <div class="meta-item">
                                                <i class="far fa-clock"></i>
                                                <span><?php echo htmlspecialchars($workshop->duration); ?></span>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <?php if (!empty($workshop->target_audience)): ?>
                                            <div class="meta-item">
                                                <i class="fas fa-users"></i>
                                                <span><?php echo htmlspecialchars($workshop->target_audience); ?></span>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <?php if (!empty($workshop->location)): ?>
                                            <div class="meta-item">
                                                <i class="fas fa-map-marker-alt"></i>
                                                <span><?php echo htmlspecialchars($workshop->location); ?></span>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <?php if (!empty($workshop->price) && $workshop->price > 0): ?>
                                            <div class="meta-item price">
                                                <i class="fas fa-tag"></i>
                                                <span>GH₵ <?php echo number_format($workshop->price, 2); ?></span>
                                            </div>
                                        <?php else: ?>
                                            <div class="meta-item price free">
                                                <i class="fas fa-gift"></i>
                                                <span>Free</span>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <div class="workshop-actions">
                                        <a href="<?php echo base_url('workshops/view/' . $workshop->slug); ?>" 
                                           class="btn btn-primary w-100">
                                            View Details <i class="fas fa-arrow-right ms-2"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
        
        <!-- Ongoing Workshops -->
        <?php if (!empty($ongoing_workshops)): ?>
            <div class="workshop-section mb-5">
                <div class="section-header">
                    <div class="section-title-wrapper">
                        <div class="section-icon ongoing">
                            <i class="fas fa-play-circle"></i>
                        </div>
                        <div>
                            <h2 class="section-title">Ongoing Workshops</h2>
                            <p class="section-subtitle">Currently in progress</p>
                        </div>
                    </div>
                    <div class="section-badge-count">
                        <span class="badge bg-success"><?php echo count($ongoing_workshops); ?> Active</span>
                    </div>
                </div>
                
                <div class="row">
                    <?php foreach ($ongoing_workshops as $workshop): ?>
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="workshop-card ongoing h-100">
                                <!-- Workshop Image -->
                                <div class="workshop-image">
                                    <?php if (!empty($workshop->featured_image)): ?>
                                        <img src="<?php echo base_url('uploads/workshops/' . $workshop->featured_image); ?>" 
                                             alt="<?php echo htmlspecialchars($workshop->title); ?>">
                                    <?php else: ?>
                                        <div class="placeholder-img">
                                            <i class="fas fa-chalkboard-teacher fa-3x"></i>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <div class="workshop-badges">
                                        <span class="status-badge ongoing">
                                            <span class="pulse"></span>Ongoing
                                        </span>
                                    </div>
                                    
                                    <div class="progress-overlay">
                                        <span>In Progress</span>
                                    </div>
                                </div>
                                
                                <!-- Workshop Content -->
                                <div class="workshop-body">
                                    <h5 class="workshop-title">
                                        <?php echo htmlspecialchars($workshop->title); ?>
                                    </h5>
                                    
                                    <p class="workshop-description">
                                        <?php echo htmlspecialchars(character_limiter($workshop->description, 100)); ?>
                                    </p>
                                    
                                    <div class="workshop-meta">
                                        <?php if (!empty($workshop->duration)): ?>
                                            <div class="meta-item">
                                                <i class="far fa-clock"></i>
                                                <span><?php echo htmlspecialchars($workshop->duration); ?></span>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <?php if (!empty($workshop->target_audience)): ?>
                                            <div class="meta-item">
                                                <i class="fas fa-users"></i>
                                                <span><?php echo htmlspecialchars($workshop->target_audience); ?></span>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <?php if (!empty($workshop->location)): ?>
                                            <div class="meta-item">
                                                <i class="fas fa-map-marker-alt"></i>
                                                <span><?php echo htmlspecialchars($workshop->location); ?></span>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <div class="workshop-actions">
                                        <a href="<?php echo base_url('workshops/view/' . $workshop->slug); ?>" 
                                           class="btn btn-outline-success w-100">
                                            View Details <i class="fas fa-arrow-right ms-2"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
        
        <!-- Completed Workshops -->
        <?php if (!empty($completed_workshops)): ?>
            <div class="workshop-section mb-5">
                <div class="section-header">
                    <div class="section-title-wrapper">
                        <div class="section-icon completed">
                            <i class="fas fa-check-circle"></i>
                        </div>
                        <div>
                            <h2 class="section-title">Completed Workshops</h2>
                            <p class="section-subtitle">Past programmes and achievements</p>
                        </div>
                    </div>
                    <div class="section-badge-count">
                        <span class="badge bg-secondary"><?php echo count($completed_workshops); ?> Completed</span>
                    </div>
                </div>
                
                <div class="row">
                    <?php foreach ($completed_workshops as $workshop): ?>
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="workshop-card completed h-100">
                                <!-- Workshop Image -->
                                <div class="workshop-image">
                                    <?php if (!empty($workshop->featured_image)): ?>
                                        <img src="<?php echo base_url('uploads/workshops/' . $workshop->featured_image); ?>" 
                                             alt="<?php echo htmlspecialchars($workshop->title); ?>">
                                    <?php else: ?>
                                        <div class="placeholder-img">
                                            <i class="fas fa-chalkboard-teacher fa-3x"></i>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <div class="workshop-badges">
                                        <span class="status-badge completed">
                                            <i class="fas fa-check me-1"></i>Completed
                                        </span>
                                    </div>
                                    
                                    <div class="completed-overlay">
                                        <i class="fas fa-medal fa-2x"></i>
                                    </div>
                                </div>
                                
                                <!-- Workshop Content -->
                                <div class="workshop-body">
                                    <h5 class="workshop-title">
                                        <?php echo htmlspecialchars($workshop->title); ?>
                                    </h5>
                                    
                                    <p class="workshop-description">
                                        <?php echo htmlspecialchars(character_limiter($workshop->description, 100)); ?>
                                    </p>
                                    
                                    <div class="workshop-meta">
                                        <?php if (!empty($workshop->duration)): ?>
                                            <div class="meta-item">
                                                <i class="far fa-clock"></i>
                                                <span><?php echo htmlspecialchars($workshop->duration); ?></span>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <?php if (!empty($workshop->location)): ?>
                                            <div class="meta-item">
                                                <i class="fas fa-map-marker-alt"></i>
                                                <span><?php echo htmlspecialchars($workshop->location); ?></span>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <?php if (!empty($workshop->end_date)): ?>
                                            <div class="meta-item">
                                                <i class="far fa-calendar-check"></i>
                                                <span>Ended <?php echo date('M d, Y', strtotime($workshop->end_date)); ?></span>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <div class="workshop-actions">
                                        <a href="<?php echo base_url('workshops/view/' . $workshop->slug); ?>" 
                                           class="btn btn-outline-secondary w-100">
                                            View Details <i class="fas fa-arrow-right ms-2"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
        
        <!-- Empty State -->
        <?php if (empty($upcoming_workshops) && empty($ongoing_workshops) && empty($completed_workshops)): ?>
            <div class="empty-state">
                <div class="empty-icon">
                    <i class="fas fa-chalkboard-teacher"></i>
                </div>
                <h3 class="fw-bold mb-3">No Workshops Available</h3>
                <p class="text-muted mb-4">We're preparing exciting workshop programmes for you.<br>Check back soon or subscribe to be notified!</p>
                <div class="d-flex gap-3 justify-content-center flex-wrap">
                    <a href="<?php echo base_url(); ?>" class="btn btn-primary">
                        <i class="fas fa-home me-2"></i>Back to Home
                    </a>
                    <a href="<?php echo base_url('contact'); ?>" class="btn btn-outline-primary">
                        <i class="fas fa-envelope me-2"></i>Contact Us
                    </a>
                </div>
            </div>
        <?php endif; ?>
        
    </div>
</section>

<!-- Programme Types Section -->
<section class="py-5 bg-light programme-types-section">
    <div class="container">
        <div class="text-center mb-5">
            <span class="section-badge-alt">What We Offer</span>
            <h2 class="fw-bold mt-3">Our Programme Areas</h2>
            <p class="lead text-muted">Skills development beyond language</p>
        </div>
        
        <div class="row">
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="programme-type-card">
                    <div class="programme-type-icon">
                        <i class="fas fa-language"></i>
                    </div>
                    <h5 class="fw-bold">Languages</h5>
                    <p class="text-muted mb-0">French, Spanish & more immersive workshops</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="programme-type-card">
                    <div class="programme-type-icon">
                        <i class="fas fa-utensils"></i>
                    </div>
                    <h5 class="fw-bold">Culinary</h5>
                    <p class="text-muted mb-0">Cooking classes with cultural immersion</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="programme-type-card">
                    <div class="programme-type-icon">
                        <i class="fas fa-laptop-code"></i>
                    </div>
                    <h5 class="fw-bold">Tech Skills</h5>
                    <p class="text-muted mb-0">Software development & digital literacy</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="programme-type-card">
                    <div class="programme-type-icon">
                        <i class="fas fa-camera"></i>
                    </div>
                    <h5 class="fw-bold">Arts & Photography</h5>
                    <p class="text-muted mb-0">Creative expression & visual arts</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-5 cta-section">
    <div class="container">
        <div class="cta-card">
            <div class="row align-items-center">
                <div class="col-lg-8 mb-4 mb-lg-0">
                    <h3 class="fw-bold text-white mb-2">Ready to Start Learning?</h3>
                    <p class="lead text-white-50 mb-0">Register for our French Workshop or contact us for more information about upcoming programmes.</p>
                </div>
                <div class="col-lg-4 text-lg-end">
                    <div class="d-flex gap-2 flex-wrap justify-content-lg-end">
                        <a href="<?php echo base_url('kid_registration'); ?>" class="btn btn-light btn-lg">
                            <i class="fas fa-user-plus me-2"></i>Register
                        </a>
                        <a href="https://wa.me/233500557751" target="_blank" class="btn btn-outline-light btn-lg">
                            <i class="fab fa-whatsapp me-2"></i>WhatsApp
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
/* =========================================
   THE SKILLS ATELIER - WORKSHOPS LISTING STYLES
   Primary: #f26124 (Orange)
   Secondary: #8105bf (Purple)
   ========================================= */

:root {
    --tsa-primary: #f26124;
    --tsa-primary-dark: #d94f15;
    --tsa-secondary: #8105bf;
    --tsa-secondary-dark: #6a049e;
    --tsa-light: #fff8f5;
    --tsa-cream: #f7e1b0;
    --tsa-gradient: linear-gradient(135deg, #f26124, #8105bf);
    --tsa-gradient-reverse: linear-gradient(135deg, #8105bf, #f26124);
    --status-upcoming: #ffc107;
    --status-ongoing: #28a745;
    --status-completed: #6c757d;
}

/* =========================================
   WORKSHOPS HERO
   ========================================= */
.workshops-hero {
    background: var(--tsa-gradient);
    padding: 100px 0 60px;
    position: relative;
    overflow: hidden;
}

.workshops-hero::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E") repeat;
}

.breadcrumb-custom {
    background: transparent;
    padding: 0;
    margin: 0;
}

.breadcrumb-custom .breadcrumb-item a {
    color: rgba(255,255,255,0.7);
    text-decoration: none;
    transition: color 0.3s ease;
}

.breadcrumb-custom .breadcrumb-item a:hover {
    color: white;
}

.breadcrumb-custom .breadcrumb-item.active {
    color: white;
}

.breadcrumb-custom .breadcrumb-item + .breadcrumb-item::before {
    color: rgba(255,255,255,0.5);
}

.section-badge {
    display: inline-block;
    background: rgba(255,255,255,0.2);
    backdrop-filter: blur(10px);
    color: white;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.section-badge-alt {
    display: inline-block;
    background: var(--tsa-gradient);
    color: white;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.hero-cta .btn-light {
    font-weight: 600;
    padding: 1rem 2rem;
    border-radius: 50px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.2);
}

.hero-cta .btn-light:hover {
    transform: translateY(-3px);
    box-shadow: 0 15px 40px rgba(0,0,0,0.3);
}

/* =========================================
   WORKSHOP STATS BAR
   ========================================= */
.workshop-stats-bar {
    background: white;
    padding: 1.5rem 0;
    box-shadow: 0 5px 30px rgba(0,0,0,0.1);
    margin-top: -30px;
    position: relative;
    z-index: 10;
    border-radius: 20px;
    margin-left: 2rem;
    margin-right: 2rem;
}

.stats-wrapper {
    display: flex;
    justify-content: center;
    gap: 3rem;
    flex-wrap: wrap;
}

.stat-box {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.stat-icon {
    width: 55px;
    height: 55px;
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.3rem;
    color: white;
}

.stat-icon.upcoming { background: var(--status-upcoming); color: #333; }
.stat-icon.ongoing { background: var(--status-ongoing); }
.stat-icon.completed { background: var(--status-completed); }

.stat-content {
    display: flex;
    flex-direction: column;
}

.stat-number {
    font-size: 1.75rem;
    font-weight: 700;
    color: #333;
    line-height: 1;
}

.stat-label {
    font-size: 0.85rem;
    color: #888;
}

/* =========================================
   WORKSHOPS CONTENT SECTION
   ========================================= */
.workshops-content-section {
    background: linear-gradient(180deg, #fff 0%, var(--tsa-light) 100%);
}

/* Section Header */
.section-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 2rem;
    padding-bottom: 1rem;
    border-bottom: 2px solid #f0f0f0;
}

.section-title-wrapper {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.section-icon {
    width: 55px;
    height: 55px;
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.4rem;
    color: white;
}

.section-icon.upcoming { background: var(--status-upcoming); color: #333; }
.section-icon.ongoing { background: var(--status-ongoing); }
.section-icon.completed { background: var(--status-completed); }

.section-title {
    font-weight: 700;
    margin-bottom: 0.25rem;
    color: #333;
}

.section-subtitle {
    color: #888;
    font-size: 0.9rem;
    margin: 0;
}

/* =========================================
   WORKSHOP CARDS
   ========================================= */
.workshop-card {
    background: white;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 10px 40px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
    border: 2px solid transparent;
}

.workshop-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 20px 50px rgba(0,0,0,0.15);
}

.workshop-card.featured {
    border-color: var(--tsa-primary);
    box-shadow: 0 10px 40px rgba(242, 97, 36, 0.15);
}

.workshop-card.upcoming:hover {
    border-color: var(--status-upcoming);
}

.workshop-card.ongoing:hover {
    border-color: var(--status-ongoing);
}

.workshop-card.completed:hover {
    border-color: var(--status-completed);
}

/* Workshop Image */
.workshop-image {
    position: relative;
    height: 220px;
    overflow: hidden;
}

.workshop-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.5s ease;
}

.workshop-card:hover .workshop-image img {
    transform: scale(1.1);
}

.workshop-image .placeholder-img {
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #f5f5f5, #e0e0e0);
    color: #ccc;
}

/* Workshop Badges */
.workshop-badges {
    position: absolute;
    top: 15px;
    left: 15px;
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.status-badge {
    display: inline-flex;
    align-items: center;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.75rem;
    font-weight: 600;
    text-transform: uppercase;
}

.status-badge.upcoming {
    background: var(--status-upcoming);
    color: #333;
}

.status-badge.ongoing {
    background: var(--status-ongoing);
    color: white;
}

.status-badge.completed {
    background: var(--status-completed);
    color: white;
}

.featured-badge {
    background: var(--tsa-gradient);
    color: white;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.75rem;
    font-weight: 600;
}

/* Date Badge */
.date-badge {
    position: absolute;
    top: 15px;
    right: 15px;
    background: white;
    padding: 0.75rem;
    border-radius: 12px;
    text-align: center;
    box-shadow: 0 5px 15px rgba(0,0,0,0.15);
}

.date-badge .day {
    display: block;
    font-size: 1.5rem;
    font-weight: 700;
    color: var(--tsa-primary);
    line-height: 1;
}

.date-badge .month {
    display: block;
    font-size: 0.75rem;
    color: #666;
    text-transform: uppercase;
}

/* Progress Overlay (Ongoing) */
.progress-overlay {
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    background: linear-gradient(transparent, rgba(40, 167, 69, 0.9));
    padding: 2rem 1rem 1rem;
    color: white;
    font-weight: 600;
    font-size: 0.85rem;
    text-align: center;
}

/* Completed Overlay */
.completed-overlay {
    position: absolute;
    bottom: 15px;
    right: 15px;
    width: 50px;
    height: 50px;
    background: var(--status-completed);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
}

.workshop-card.completed .workshop-image img {
    filter: grayscale(30%);
}

/* Pulse Animation for Ongoing */
.pulse {
    display: inline-block;
    width: 8px;
    height: 8px;
    background: white;
    border-radius: 50%;
    margin-right: 0.5rem;
    animation: pulse 1.5s infinite;
}

@keyframes pulse {
    0% { transform: scale(1); opacity: 1; }
    50% { transform: scale(1.3); opacity: 0.7; }
    100% { transform: scale(1); opacity: 1; }
}

/* Workshop Body */
.workshop-body {
    padding: 1.5rem;
}

.workshop-title {
    font-weight: 700;
    margin-bottom: 0.75rem;
    color: #333;
    line-height: 1.4;
}

.workshop-description {
    color: #666;
    font-size: 0.95rem;
    margin-bottom: 1rem;
    line-height: 1.6;
}

/* Workshop Meta */
.workshop-meta {
    border-top: 1px solid #f0f0f0;
    padding-top: 1rem;
    margin-bottom: 1rem;
}

.meta-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-size: 0.85rem;
    color: #666;
    margin-bottom: 0.5rem;
}

.meta-item:last-child {
    margin-bottom: 0;
}

.meta-item i {
    width: 18px;
    color: var(--tsa-primary);
}

.meta-item.price {
    font-weight: 600;
    color: var(--tsa-primary);
}

.meta-item.price.free {
    color: var(--status-ongoing);
}

/* Workshop Actions */
.workshop-actions {
    margin-top: 1rem;
}

/* =========================================
   EMPTY STATE
   ========================================= */
.empty-state {
    text-align: center;
    padding: 5rem 2rem;
}

.empty-icon {
    width: 120px;
    height: 120px;
    background: var(--tsa-light);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 2rem;
}

.empty-icon i {
    font-size: 3rem;
    color: var(--tsa-primary);
    opacity: 0.5;
}

/* =========================================
   PROGRAMME TYPES SECTION
   ========================================= */
.programme-types-section {
    background: #f8f9fa;
}

.programme-type-card {
    background: white;
    padding: 2rem;
    border-radius: 20px;
    text-align: center;
    box-shadow: 0 10px 40px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
    height: 100%;
    border: 2px solid transparent;
}

.programme-type-card:hover {
    transform: translateY(-10px);
    border-color: var(--tsa-primary);
    box-shadow: 0 20px 50px rgba(242, 97, 36, 0.15);
}

.programme-type-icon {
    width: 80px;
    height: 80px;
    background: var(--tsa-gradient);
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1.5rem;
    color: white;
    font-size: 2rem;
}

/* =========================================
   CTA SECTION
   ========================================= */
.cta-section {
    background: var(--tsa-gradient);
}

.cta-card {
    background: rgba(255,255,255,0.1);
    backdrop-filter: blur(10px);
    border-radius: 20px;
    padding: 2.5rem;
    border: 1px solid rgba(255,255,255,0.2);
}

.cta-section .btn-light {
    background: white;
    color: var(--tsa-primary);
    font-weight: 600;
    border-radius: 50px;
}

.cta-section .btn-light:hover {
    background: var(--tsa-cream);
    transform: translateY(-2px);
}

.cta-section .btn-outline-light {
    border: 2px solid white;
    color: white;
    font-weight: 600;
    border-radius: 50px;
}

.cta-section .btn-outline-light:hover {
    background: white;
    color: var(--tsa-primary);
}

/* =========================================
   BUTTON STYLES
   ========================================= */
.btn-primary {
    background: var(--tsa-gradient);
    border: none;
    font-weight: 600;
    padding: 0.75rem 1.5rem;
    border-radius: 50px;
    transition: all 0.3s ease;
}

.btn-primary:hover {
    background: var(--tsa-gradient-reverse);
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(242, 97, 36, 0.4);
}

.btn-outline-primary {
    border: 2px solid var(--tsa-primary);
    color: var(--tsa-primary);
    font-weight: 600;
    padding: 0.75rem 1.5rem;
    border-radius: 50px;
    transition: all 0.3s ease;
    background: transparent;
}

.btn-outline-primary:hover {
    background: var(--tsa-primary);
    border-color: var(--tsa-primary);
    color: white;
    transform: translateY(-2px);
}

.btn-outline-success {
    border: 2px solid var(--status-ongoing);
    color: var(--status-ongoing);
    font-weight: 600;
    padding: 0.75rem 1.5rem;
    border-radius: 50px;
    transition: all 0.3s ease;
    background: transparent;
}

.btn-outline-success:hover {
    background: var(--status-ongoing);
    border-color: var(--status-ongoing);
    color: white;
    transform: translateY(-2px);
}

.btn-outline-secondary {
    border: 2px solid var(--status-completed);
    color: var(--status-completed);
    font-weight: 600;
    padding: 0.75rem 1.5rem;
    border-radius: 50px;
    transition: all 0.3s ease;
    background: transparent;
}

.btn-outline-secondary:hover {
    background: var(--status-completed);
    border-color: var(--status-completed);
    color: white;
    transform: translateY(-2px);
}

/* =========================================
   RESPONSIVE STYLES
   ========================================= */
@media (max-width: 991px) {
    .workshops-hero {
        padding: 80px 0 50px;
    }
    
    .workshops-hero h1 {
        font-size: 2rem;
    }
    
    .workshop-stats-bar {
        margin-left: 1rem;
        margin-right: 1rem;
    }
    
    .stats-wrapper {
        gap: 2rem;
    }
    
    .section-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 1rem;
    }
}

@media (max-width: 768px) {
    .workshops-hero {
        padding: 70px 0 40px;
        text-align: center;
    }
    
    .workshops-hero h1 {
        font-size: 1.75rem;
    }
    
    .hero-cta {
        margin-top: 1.5rem;
    }
    
    .workshop-stats-bar {
        margin-top: -20px;
        padding: 1rem;
        border-radius: 15px;
    }
    
    .stats-wrapper {
        gap: 1.5rem;
    }
    
    .stat-icon {
        width: 45px;
        height: 45px;
        font-size: 1.1rem;
    }
    
    .stat-number {
        font-size: 1.5rem;
    }
    
    .section-title-wrapper {
        flex-direction: column;
        align-items: flex-start;
        text-align: left;
    }
    
    .section-icon {
        width: 45px;
        height: 45px;
        font-size: 1.1rem;
    }
    
    .cta-card {
        padding: 1.5rem;
        text-align: center;
    }
    
    .cta-card .d-flex {
        justify-content: center !important;
    }
}

/* =========================================
   ANIMATIONS
   ========================================= */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.workshop-card {
    animation: fadeInUp 0.5s ease forwards;
    opacity: 0;
}

.workshop-card:nth-child(1) { animation-delay: 0.1s; }
.workshop-card:nth-child(2) { animation-delay: 0.2s; }
.workshop-card:nth-child(3) { animation-delay: 0.3s; }
.workshop-card:nth-child(4) { animation-delay: 0.4s; }
.workshop-card:nth-child(5) { animation-delay: 0.5s; }
.workshop-card:nth-child(6) { animation-delay: 0.6s; }
</style>